/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
var TugboatUI = {};

/*
 * UI.Select Menu.
 * 
 */
TugboatUI.SelectMenu = Class.create();
TugboatUI.SelectMenu.presentId = 0;
TugboatUI.SelectMenu.UL_ID_PREFIX           = 'TGB_MENU_UL_';
TugboatUI.SelectMenu.HTML_ID_LIST_CONTAINER = 'LCONTAINER_';
TugboatUI.SelectMenu.HTML_ID_LIST_MENU      = 'MENU_';
TugboatUI.SelectMenu.HTML_ID_LIST_VALUE     = 'VALUE_';
TugboatUI.SelectMenu.HTML_ID_LIST_ITEM      = 'ITEM_';
TugboatUI.SelectMenu.NULL_LABEL             = '--------';
TugboatUI.SelectMenu.selectMenuStack = [];

TugboatUI.SelectMenu.prototype = {
  containerId   : null,
  selectedValue : 0,
  list          : [],
  isOpendList   : 0,
  instanceId    : 0,
  onSelected    : null,
  alreadyInit   : false,
  parentElement : null,
  isParentWindow: false,
  
  /**
   * initialize.
   * @param {Object} containerId
   * @param {Object} list
   */
  initialize: function(containerId, list, option) {
    this.instanceId = ++TugboatUI.SelectMenu.presentId;
    this.containerId = containerId;
    this.list = list;
    var selectMenuCId = TugboatUI.SelectMenu.selectMenuStack.find(
      function(s) {
        return s == containerId;
      }
    );
    if (selectMenuCId) {
      return false;
    }
    if (option && option.onSelected && typeof(option.onSelected) == 'function') {
      this.onSelected = option.onSelected;
    }
    if (option && option.parentElement && typeof(option.parentElement) == 'string') {
      this.parentElement = option.parentElement;
    }
    if (option && option.isParentWindow && typeof(option.isParentWindow) == 'boolean') {
      this.isParentWindow = option.isParentWindow;
    }
    TugboatUI.SelectMenu.selectMenuStack.push(containerId);
    var selector = this;
    
    this.setListItems(this.list);
    this.alreadyInit = true;
    return false;
  },

  /**
   * get select value.
   */
  getSelectValue : function() {
    return this.selectedValue;
  },
  
  /**
   * create list items.
   */
  setListItems : function(list) {
    this.list = list;
    var listContainerId = 
      TugboatUI.SelectMenu.UL_ID_PREFIX 
    + TugboatUI.SelectMenu.HTML_ID_LIST_CONTAINER + this.instanceId;
    var selectValueId = 
      TugboatUI.SelectMenu.UL_ID_PREFIX 
    + TugboatUI.SelectMenu.HTML_ID_LIST_VALUE + this.instanceId;
    var listItemId = 
      TugboatUI.SelectMenu.UL_ID_PREFIX 
    + TugboatUI.SelectMenu.HTML_ID_LIST_ITEM + this.instanceId + '_';
    
    var selector = this;
    var container = $(this.containerId);
    container.innerHTML = '';

    var span1 = 
      SPAN(
        { 'class':'yuibutton menubutton _active',
          'onclick': function() {
            var display = $(listContainerId).style.display;
            if (display == 'none') {
              selector.isOpendList = 1;
              
              var elGtdListPane = YAHOO.util.Dom.getRegion(selectValueId);
              var elParent      = YAHOO.util.Dom.getRegion(selector.parentElement);
              
              var div1 = $(listContainerId);
              div1.style.top  = (elGtdListPane.top  - elParent.top + (selector.isParentWindow ? 28 : 100) )+'px';
              div1.style.left = (elGtdListPane.left - elParent.left  )+'px';
            }
            Element.toggle(listContainerId);
          }
        },
        SPAN({'class':'first-child'},
          BUTTON({ 'type':'button','id':selectValueId, 
                   'style':'height:28px; width:180px; overflow:hidden; text-align:left;'},TugboatUI.SelectMenu.NULL_LABEL)
        )
      );
    container.appendChild(span1);
    
    var ul1 =
      UL(
        { 'id':TugboatUI.SelectMenu.UL_ID_PREFIX, 'class' : 'first-of-type'},
        this.list.collect(
          function(a, index) {
            var nowSelectedId  = listItemId + a.id;
            var item = 
            LI(
              { 'id'    : nowSelectedId,
                'class' : 'yuimenuitem',
                'onmouseout'  : function(){this.className='yuimenuitem'},
                'onmouseover' : function(){this.className='yuimenuitem selected'},
                'onclick'     : function(){
                  if (selector.selectedValue) {
                    var prevSelectedId = listItemId + selector.selectedValue.id;
                    $(prevSelectedId).className  = 'yuimenuitem';
                    $(prevSelectedId).onmouseout = function() {this.className='yuimenuitem'};
                  }
                  $(nowSelectedId).className  = 'yuimenuitem selected';
                  $(nowSelectedId).onmouseout = function() {this.className='yuimenuitem selected'};
          
                  selector.selectedValue = list.find(
                    function(item) {
                      return (a.id == item.id);
                    }
                  );
                  $(selectValueId).innerHTML = 
                    '<img src="' + selector.selectedValue.icon 
                  + '" class="left_and_right_3px_margin" />'
                  + a.value.substring(0,16);
                 
                  Element.hide(listContainerId);
                  selector.isOpendList = 0;
      
                  if (selector.onSelected != null && typeof(selector.onSelected)=='function') {
                    selector.onSelected(selector.selectedValue);
                  }
                }
              },
              [
                IMG({'src':a.icon, 'class':'left_and_right_3px_margin'}),
                a.value
              ]
            );
            return item;
          }
        )
      );
    
    var div1 =  DIV(null);
    div1.className='module yui-overlay yuimenu';
    div1.style.zIndex='1';
    div1.style.position='absolute';
    div1.style.visibility='visible';
    div1.style.display='none';
    div1.style.height=this.list.length > 8 ? '150px' : 'auto';
    div1.style.overflow='auto';
    div1.setAttribute('id',listContainerId);
    div1.appendChild(ul1);
    container.appendChild(div1);

    if (this.alreadyInit) return false;
    YAHOO.util.Event.addListener(
      document, "keydown",
      function(key){
        if (key.keyCode == Event.KEY_ESC) {
            Element.hide(listContainerId);
        }
      },
      true
    );
    YAHOO.util.Event.addListener(
      document, "click",
      function(key){
        var display = $(listContainerId).style.display;
        if (selector.isOpendList > 1 && display != 'none') {
          Element.hide(listContainerId);
        }
        selector.isOpendList++;
      },
      true
    );
  },
  
  /**
   * clear.
   */
  clear : function() {
    this.selectedValue = null;
    var selectValueId = 
      TugboatUI.SelectMenu.UL_ID_PREFIX 
    + TugboatUI.SelectMenu.HTML_ID_LIST_VALUE + this.instanceId;
    
    $(selectValueId).innerHTML = TugboatUI.SelectMenu.NULL_LABEL;
    
    var listItemId = 
      TugboatUI.SelectMenu.UL_ID_PREFIX 
    + TugboatUI.SelectMenu.HTML_ID_LIST_ITEM + this.instanceId + '_'
    
    this.list.each(
      function(i) {
        $(listItemId+i.id).className='yuimenuitem';
        $(listItemId+i.id).onmouseout = 
          function() {this.className='yuimenuitem'};
      }
    );
  },
  
  /**
   * set selected id.
   * @param {Object} id
   */
  setSelectedId : function(id) {
    if (! this.list) return false;
    var targetValue = this.list.find(
      function(i) {
          return id == i.id;
      }
    );
    
    if (! targetValue) return false;
    var listItemId = 
      TugboatUI.SelectMenu.UL_ID_PREFIX 
    + TugboatUI.SelectMenu.HTML_ID_LIST_ITEM + this.instanceId + '_';
    
    var prevSelectedValue = this.selectedValue;
    if (prevSelectedValue) {
      var prevSelectedId = listItemId + prevSelectedValue.id;
      if ($(prevSelectedId)) {
        $(prevSelectedId).className  = 'yuimenuitem';
        $(prevSelectedId).onmouseout = function() {this.className='yuimenuitem'};
      }
    }
    this.selectedValue = targetValue;
    var selectedId = listItemId + targetValue.id;
    $(selectedId).className  = 'yuimenuitem selected';
    $(selectedId).onmouseout = function() {this.className='yuimenuitem selected'};
    
    var selectValueId = 
      TugboatUI.SelectMenu.UL_ID_PREFIX 
    + TugboatUI.SelectMenu.HTML_ID_LIST_VALUE + this.instanceId;
    
    $(selectValueId).innerHTML = 
        '<img src="' + this.selectedValue.icon 
                     + '" class="left_and_right_3px_margin" style="float:left;" />' 
                     + this.selectedValue.value;
    return false;
  }
};

/*
 * UI.Drag Box. 
 * 
 */
/**
 * @param {Object} id
 * @param {OBject} idPrefix
 * @param {Object} group
 * @param {Object} status
 * @param {Object} classification
 * @param {Object} activityColor
 * @param {Object} options
 */
TugboatUI.DragBox = function (
  id, idPrefix, group, status, classification, activityColor, options) {

  TugboatUI.DragBox.superclass.call(this, id, group);
  
  this.id = id;
  this.idPrefix = idPrefix;
  this.status = status;
  this.classification = classification;
  this.activityColor = activityColor;
  this.options = options;
  this.selected = false;
  
  TugboatUI.DragBox.blocks.push(this);
}
Tugboat.util.extend(TugboatUI.DragBox, YAHOO.util.DDProxy);

// Keep a record of all instances of TugboatUI.DragBox
TugboatUI.DragBox.dragStarted      = false;
TugboatUI.DragBox.blocks           = [];
TugboatUI.DragBox.dropTargetStyles = [];
TugboatUI.DragBox.folderRules      = [];
TugboatUI.DragBox.afterDragDrop    = [];
TugboatUI.DragBox.selectedFolderId = 'folder_inbox';
TugboatUI.DragBox.thumb_classes =
[
  {classId:1,  statusId:1, class_name:'today'      },
  {classId:1,  statusId:2, class_name:'today_doing'},
  {classId:1,  statusId:3, class_name:'today_done' },
  {classId:2,  statusId:1, class_name:'week'       },
  {classId:3,  statusId:1, class_name:'month'      },
  {classId:4,  statusId:1, class_name:'hold'       },
  {classId:4,  statusId:3, class_name:'hold_done'  },
  {classId:5,  statusId:1, class_name:'someday'    },
  {classId:9,  statusId:1, class_name:'inbox'      },
  {classId:21, statusId:1, class_name:'archive'    },
  {classId:99, statusId:1, class_name:'trash'      }
];
TugboatUI.DragBox.thumb_classes.find = function(classId, statusId) {
  var self = TugboatUI.DragBox;
  for (i=0; i<self.thumb_classes.length; i++) {
    if (classId==self.thumb_classes[i].classId && statusId==self.thumb_classes[i].statusId) {
      return self.thumb_classes[i].class_name;
    }
  }
};

YAHOO.util.Event.addListener(
  document, "mousedown",
  function(){TugboatUI.DragBox.unselectAll();}
);
YAHOO.util.Event.addListener(
  document, "keydown",
  function(key){
    if (key.keyCode == Event.KEY_ESC) {
      TugboatUI.DragBox.unselectAll();
    }
  }
);

TugboatUI.DragBox.prototype.id             = -1;
TugboatUI.DragBox.prototype.idPrefix       = '';
TugboatUI.DragBox.prototype.status         = -1;
TugboatUI.DragBox.prototype.classification = -1;
TugboatUI.DragBox.prototype.activityColor  = '';
TugboatUI.DragBox.prototype.options        = null;

TugboatUI.DragBox.prototype.select = function() {
  this.selected = true;
  YAHOO.util.Dom.addClass(this.getEl(), 'selected');
};

TugboatUI.DragBox.prototype.unselect = function() {
  if (this.selected) {
    this.selected = false;
    YAHOO.util.Dom.removeClass(this.getEl(), 'selected');
  }
};

TugboatUI.DragBox.prototype.onMouseDown = function(e) {
  var mac;
  if (!this.selected) {
    mac = (navigator.appVersion.indexOf("Mac")!==-1) ? true : false;
    if ((mac && !e.metaKey) || (!mac && !e.ctrlKey)) {
      TugboatUI.DragBox.unselectAll();
    }
    //var lists = $$('#list_pane li');
    this.select();
  }
};

TugboatUI.DragBox.prototype.startDrag = function(e) {
  var element = 
    $('list_detail_container-' + this.id.substring(this.idPrefix.length));

  TugboatUI.DragBox.dragStarted = true;
  
  var div1 = this.getDragEl(); //#ygddfdiv
  div1.style.border = '0px';
  div1.innerHTML = '';

  var div2=document.createElement('div');
  div2.className = 'ygddfdiv_headerDeny';
  div2.setAttribute('id','ygddfdiv_header');
  div1.appendChild(div2);

  var div3=document.createElement('div');
  div3.setAttribute('id','ygddfdiv_body');
  div1.appendChild(div3);
  
  var selected = TugboatUI.DragBox.selected();
  var ul = document.createElement('ul');
  ul.className='clearfix';
  for (var i=0; i<selected.length; i++) {
    var class_name = 
      TugboatUI.DragBox.thumb_classes.find(
        selected[i].classification, selected[i].status);

    var li = document.createElement('li');
    li.className = class_name;
    li.innerHTML = 
      $('task_list_title-' + selected[i].id.substring(this.idPrefix.length)).innerHTML;
    YAHOO.util.Dom.addClass(selected[i].id, 'dragging');
    ul.appendChild(li);
  }
  div3.appendChild(ul);
  
  var p1=document.createElement('p');
  div3.appendChild(p1);
  var txt6=document.createTextNode( TugboatUI.DragBox.selected().length + ' selected');
  p1.appendChild(txt6);
  
  var div4=document.createElement('div');
  div4.setAttribute('id','ygddfdiv_footer');
  div1.appendChild(div4);
};

TugboatUI.DragBox.prototype.onDragDrop = function(e, id) {
  if ((id.indexOf('folder') == -1 && id.indexOf('list') == -1 && id.indexOf('tag_') == -1)
   || ! TugboatUI.DragBox.dropTargetStyles
   || ! TugboatUI.DragBox._draggable(id)) return false;
  
  var folderId = 0;
  var toStatusId = -1;
  var isSubFolder = false;
  var targetElementName = id;
  
  if (id.indexOf('list') > -1)
    id += '_' + TugboatUI.DragBox.selectedFolderId;
  
  var mode = 
    id.indexOf('folder') > -1 || id.indexOf('list') > -1
    ? Tugboat.constant.task.SEL_MODE_GTD
    : Tugboat.constant.task.SEL_MODE_TAG;
  
  if (mode == Tugboat.constant.task.SEL_MODE_GTD) {
    var dropTargetStyles = TugboatUI.DragBox.dropTargetStyles;
  
    for (var i=0; i<dropTargetStyles.length; i++) {
      if (id == dropTargetStyles[i].id) {
        $(targetElementName).className = dropTargetStyles[i].defaultStyle;
        toStatusId  = dropTargetStyles[i].statusId;
        isSubFolder = dropTargetStyles[i].nodeLevel > 1;
        folderId    =
          isSubFolder 
          ? dropTargetStyles[i].parentNodeValue 
          : dropTargetStyles[i].value;
        break;
      }
    }
  }
  else {
    $(targetElementName).className = 'drag_out';
  }
  
  var selected = TugboatUI.DragBox.selected();
  var params = '';
  var taskIds = []
  for (var i = 0; i < selected.length; i++) {
    if (mode == Tugboat.constant.task.SEL_MODE_TAG) {
      //Effect.Highlight(selected[i].id);
    } else if (isSubFolder) {
    } else {
      Element.remove(selected[i].id);
    }
    
    var taskId = selected[i].id.replace(selected[i].idPrefix,'');
    params +=  '{"id":"' + taskId + '","status":"' + selected[i].status + '"},';
    taskIds.push(taskId);
  }
  var tag_id = 
    mode == Tugboat.constant.task.SEL_MODE_TAG
    ? id.replace('tag_not_selected-','').replace('tag_selected-','')
    : ''
  
  var json_str = 
    '{"folderId":"' + folderId + '","statusId":"' + toStatusId  +
    (mode == Tugboat.constant.task.SEL_MODE_TAG ? '","tagId":"' + tag_id : '') + 
    '","params":[' + params.substring(0,params.length - 1) + ']}'
  
  TugboatUI.DragBox.afterDragDrop[mode](json_str, taskIds, tag_id);
};

TugboatUI.DragBox.prototype.onDragOver = function(e, id) {
  if ((id.indexOf('folder') == -1 && id.indexOf('list') == -1 && id.indexOf('tag_') == -1)
   || ! TugboatUI.DragBox.dropTargetStyles
   || ! TugboatUI.DragBox._draggable(id)) return false;
  
  if ($('ygddfdiv_header')) 
    $('ygddfdiv_header').className = 'ygddfdiv_headerAdd';

  var targetElementName = id;
  if (id.indexOf('list') > -1)
    id += '_' + TugboatUI.DragBox.selectedFolderId;
  
  for (var i=0; i<TugboatUI.DragBox.dropTargetStyles.length; i++) {
    if (id.indexOf('tag_') > -1) {
      $(targetElementName).className = 'drag_over';
      break;
    }
    else if (id == TugboatUI.DragBox.dropTargetStyles[i].id) {
      $(targetElementName).className = TugboatUI.DragBox.dropTargetStyles[i].dragOverStyle;
      break;
    }
  }
};

TugboatUI.DragBox.prototype.onDragOut = function(e, id) {
  if ((id.indexOf('folder') == -1 && id.indexOf('list') == -1 && id.indexOf('tag_') == -1)
   || ! TugboatUI.DragBox.dropTargetStyles
   || ! TugboatUI.DragBox._draggable(id)) return false;;
  
  if ($('ygddfdiv_header'))
    $('ygddfdiv_header').className = 'ygddfdiv_headerDeny';

  var targetElementName = id;
  if (id.indexOf('list') > -1)
    id += '_' + TugboatUI.DragBox.selectedFolderId;

  for (var i=0; i<TugboatUI.DragBox.dropTargetStyles.length; i++) {
    if (id.indexOf('tag_') > -1) {
      $(targetElementName).className = 'drag_out';
      break;
    }
    else if (id == TugboatUI.DragBox.dropTargetStyles[i].id) {
      $(targetElementName).className = TugboatUI.DragBox.dropTargetStyles[i].defaultStyle;
      break;
    }
  }
};

TugboatUI.DragBox.prototype.endDrag = function(e) {
  TugboatUI.DragBox.unselectAll();
};

TugboatUI.DragBox.prototype.showFrame = function(x, y) {
  this.getDragEl().style.visibility = "";
};

TugboatUI.DragBox.prototype.setDragElPos = function(x, y) {
  var proxy = this.getDragEl();
  var r = YAHOO.util.Dom.getRegion(proxy);
  YAHOO.util.Dom.setXY(
    proxy, [x-((r.right-r.left)/2) + 90, y-((r.bottom-r.top)/2)]
  );
};

TugboatUI.DragBox.selected = function() {
  var i, block;
  var selected = [];
  for (i=0; i<TugboatUI.DragBox.blocks.length; i++) {
    block = TugboatUI.DragBox.blocks[i];
    if (block.selected) {
      selected.push(block);
    }
  }
  return selected;
};

TugboatUI.DragBox.unselectAll = function() {
  TugboatUI.DragBox.dragStarted = false;
  for (var i=0; i<TugboatUI.DragBox.blocks.length; i++) {
    TugboatUI.DragBox.blocks[i].unselect();
    YAHOO.util.Dom.removeClass(TugboatUI.DragBox.blocks[i].id, 'dragging');
  }
  var div = $('ygddfdiv'); //drag-proxy
  if (div) {
    div.innerHTML = '';
  }
};

TugboatUI.DragBox.find_folder_style = function(id) {
  var result = 
    TugboatUI.DragBox.dropTargetStyles.find(
      function(folder) {
        return (id == folder.id);
      }
    );
  return result;
};

TugboatUI.DragBox._draggable = function(id) {
  //-- check exists target folder.
  if (id.indexOf('tag_') > -1) return true;
  
  var dragTargets = [];
  TugboatUI.DragBox.folderRules.each(
    function(rule) {
      if (TugboatUI.DragBox.selectedFolderId == rule.selectedFolderId) {
        dragTargets = rule.draggableAllowFolders;
      }
    }
  );
  
  var isExistsTarget = false;
  for (var i=0; i<dragTargets.length; i++ ){
    if (id == dragTargets[i].id) {
      isExistsTarget = true;
      break;
    }
  }
  if (! isExistsTarget) return false;

  //-- check exists target folder & status.
  isExistsTarget = true;
  TugboatUI.DragBox.selected().each(
    function (s) {
      for (var i=0;i<dragTargets.length;i++) {
        
        if (id==dragTargets[i].id 
         && typeof(dragTargets[i].selectedStatus) != 'undefined'
         && s.status != dragTargets[i].selectedStatus) {

          isExistsTarget = false;
          break;
        }
      }
    }
  );
  return isExistsTarget;
};

/*
 * UI.In place editor.
 * 
 */
TugboatUI.InPlaceEditor = Class.create();
TugboatUI.InPlaceEditor.isAlreadyEdit = false;
TugboatUI.InPlaceEditor.INPUT_TYPE_TEXTAREA  = 1;
TugboatUI.InPlaceEditor.INPUT_TYPE_TEXTFIELD = 2;
TugboatUI.InPlaceEditor.INPUT_TYPE_DOM       = 3;
TugboatUI.InPlaceEditor.prototype = {
  form              : null,
  id                : null,
  element           : null,
  editButtonElement : null,
  rowActionElement  : null,
  option            : null,
  saveFunction      : null,
  customeForm       : null,
  original          : null,
  isTextfieldMode   : false,
  inputType         : 1,
  
  /**
   * initialize.
   * @param {Object} id
   * @param {Object} editButtonId
   * @param {Object} option
   */
  initialize: function(id, rowActionId, editButtonId, original, option) {
    this.id      = id;
    this.editButtonElement = $(editButtonId);
    this.rowActionElement  = $(rowActionId);
    this.original = original;
    this.element = $(id);
    this.option = option;
    
    this.onEditclickListener = this.enterEditMode.bindAsEventListener(this);
    Event.observe(this.editButtonElement, 'click', this.onEditclickListener);
    
    if (option && option.save && typeof(option.save)=='function') {
      this.saveFunction = option.save;
    }
    if (option && option.inputType) {
      this.inputType = option.inputType;
    }
    //if (option && option.customeForm) {
    //  this.customeForm = customeForm;
    //}
    return false;
  },
  
  enterEditMode : function() {
    if (TugboatUI.InPlaceEditor.isAlreadyEdit) {
      alert('Already editing...');
      return false;
    }
    var ID_SAFIX = '_inplace';
    var editor = this;
    var form = 
      (this.customeForm) 
      ? this.customeForm
      : FORM({'onsubmit':function(){ return false;} },
          [
            function() {
              if (editor.inputType == TugboatUI.InPlaceEditor.INPUT_TYPE_TEXTAREA) {
                return TEXTAREA({'id'   :editor.id + ID_SAFIX,
                                  'class':'inplace_comment',
                                  'tabindex':'1',
                                  'rows' :'15'}, editor.original);
              }
              else {
                return INPUT({'id'   :editor.id + ID_SAFIX,
                               'type' :'text',
                               'class':'inplace_comment',
                               'tabindex':'1',
                               'value': editor.original});
              }
            },
            DIV({ 'class':'buttons' },
              [
                INPUT({'type':'image','src':'images/default/icon/space.gif',
                       'class':'cancel', 'value':'', 'tabindex':'3',
                       'onclick':function(){ editor.leaveEditMode();} }),
                INPUT({'type':'image','src':'images/default/icon/space.gif',
                       'class':'post',   'value':'', 'tabindex':'2',
                       'onclick':function(){ editor.doSubmit();} })
              ]
            )
          ]
        );
    this.form = form;
    Element.hide(this.rowActionElement);
    Element.hide(this.element);
    this.element.parentNode.insertBefore(form, this.element);
    
    $(editor.id + ID_SAFIX).focus();
    
    TugboatUI.InPlaceEditor.isAlreadyEdit = true;
    return false;
  },
  
  leaveEditMode : function() {
    Element.remove(this.form);
    new Effect.Appear(this.element);
    new Effect.Appear(this.rowActionElement);
    
    TugboatUI.InPlaceEditor.isAlreadyEdit = false;
    return false;
  },
  
  doSubmit : function() {
    var inputValue = $(this.id + '_inplace').value;
    if (this.saveFunction && typeof(this.saveFunction)=='function') {
      this.saveFunction(inputValue);
    }
    this.element.innerHTML = inputValue.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
    this.original = inputValue;
    
    this.leaveEditMode();
    return false;
  }
};