/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat) == 'undefined') {
    Tugboat = {};
}

var Tugboat = {
  messageDialog : null,  
  AJAX_SERVLET_NAME : 'teeda.ajax',
  alert_master_json : 
    [
	  {'id' : '0', 'value' : 'None'             },
	  {'id' : '1', 'value' : '0 second before'  },
	  {'id' : '2', 'value' : '5 minutes before' },
	  {'id' : '3', 'value' : '10 minutes before'},
	  {'id' : '4', 'value' : '15 minutes before'},
	  {'id' : '5', 'value' : '30 minutes before'},
	  {'id' : '6', 'value' : '45 minutes before'},
	  {'id' : '7', 'value' : '1 hour before'    },
	  {'id' : '8', 'value' : '2 hours before'   },
	  {'id' : '9', 'value' : '3 hours before'   },
	  {'id' : '10','value' : '6 hours before'   },
	  {'id' : '11','value' : '12 hours before'  },
	  {'id' : '12','value' : '1 day before'     },
	  {'id' : '13','value' : '2 days before'    },
	  {'id' : '14','value' : '3 days before'    },
	  {'id' : '15','value' : '1 week before'    },
	  {'id' : '16','value' : '2 weeks before'   },
	  {'id' : '17','value' : '3 weeks before'   },
	  {'id' : '18','value' : '1 month before'   }
	],

  showAlertDialog : function (messages) {
    var content = '';
    content += '<div class="dialog_alert_icon"></div>';
    content += '<div class="dialog_alert_message"><ul>';
    
    if ( typeof( messages ) == 'object' ) {         
      for ( i = 0; i < messages.length; i++ ) {
        content += '<li class="message">' + messages[i] + '</li>';
      }
    }
    else {
      content += '<li class="message">' + messages + '</li>';
    }
    content += '</ul></div>';
      
    Dialog.alert(
      content, 
      { windowParameters: { className:"mac_os_x",width:350}, okLabel: "OK",buttonClass:"alert_button" });
  },
  showConfirmDialog : function (messages) {
  
  },
  showInformationDialog : function (messages, okCallback) {
    var content = '';
    content += '<div class="dialog_info_icon"></div>';
    content += '<div class="dialog_info_message"><ul>';
          
    if ( typeof( messages ) == 'object' ) {     
      for ( i = 0; i < messages.length; i++ ) {
        content += '<li class="message">' + messages[i] + '</li>';
      }
    }
    else {
      content += '<li class="message">' + messages + '</li>';
    }  
    content += '</ul></div>';
        
    if ( okCallback ) {
      Dialog.alert(
        content, 
        { windowParameters: { className:'mac_os_x',width:350}, 
          okLabel: 'OK',
          buttonClass: 'alert_button',
          okCallback:okCallback
        }
      );
    }
    else {
      Dialog.alert(
        content, 
        { windowParameters: { className:'mac_os_x',width:350}, 
          okLabel: 'OK',
          buttonClass: 'alert_button'
        }
      );
    }
    
  },
  showWarnDialog : function (messages) {  
  },
  showQuestionDialog : function (messages) {  
  },
  showIndicator : function(messages) {
    
  },
  
  //
  // Initialize
  //
  intialize : function () {
    messageDialog = new Window('messageDialog', 
      { className: 'mac_os_x',
        width:250, height:150, zIndex: 1000,
        minimizable:false, closable: false, maximizable:false,
        resizable: false,
        title: 'Tugboat.GTD - Message',
        draggable:false,
        showEffectOptions: {duration:0.5} 
      });                  
    messageDialog.setDestroyOnClose();
  },

  //
  // get now Datetime.
  //
  getNowDateTime : function (id) {
    var date = new Date(); 
    year       = date.getFullYear(); 
    month      = date.getMonth() + 1;
    dayOfMonth = date.getDate();

    hour   = date.getHours(); 
    minute = date.getMinutes();
    second = date.getSeconds();
    offset = date.getTimezoneOffset() /60 *-1;
    
    return {
      year:year, month:month, dayOfMonth:dayOfMonth, 
      hour:hour, minute:minute, second:second, offset:offset};
  },
  
  // 
  // Get Page size
  //
  getPageSize: function(){
  	var xScroll, yScroll;

  	if (window.innerHeight && window.scrollMaxY) {	
  		xScroll = document.body.scrollWidth;
  		yScroll = window.innerHeight + window.scrollMaxY;
  	} else if (document.body.scrollHeight > document.body.offsetHeight){ // all but Explorer Mac
  		xScroll = document.body.scrollWidth;
  		yScroll = document.body.scrollHeight;
  	} else { // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
  		xScroll = document.body.offsetWidth;
  		yScroll = document.body.offsetHeight;
  	}

  	var windowWidth, windowHeight;

  	if (self.innerHeight) {	// all except Explorer
  		windowWidth = self.innerWidth;
  		windowHeight = self.innerHeight;
  	} else if (document.documentElement && document.documentElement.clientHeight) { // Explorer 6 Strict Mode
  		windowWidth = document.documentElement.clientWidth;
  		windowHeight = document.documentElement.clientHeight;
  	} else if (document.body) { // other Explorers
  		windowWidth = document.body.clientWidth;
  		windowHeight = document.body.clientHeight;
  	}	
  	var pageHeight, pageWidth;

  	// for small pages with total height less then height of the viewport
  	if(yScroll < windowHeight){
  		pageHeight = windowHeight;
  	} else { 
  		pageHeight = yScroll;
  	}

  	// for small pages with total width less then width of the viewport
  	if(xScroll < windowWidth){	
  		pageWidth = windowWidth;
  	} else {
  		pageWidth = xScroll;
  	}

  	return {pageWidth: pageWidth ,pageHeight: pageHeight , windowWidth: windowWidth, windowHeight: windowHeight};
  },
  
  //
  // check input data : is empty?
  //
  isEmpty : function (value) {
    var result = false;
    
    var regexStr = /\s*((\S+\s*)*)/;
    if (value == null || value == '' || value.replace(regexStr, '$1') == '') {
      result = true;      
    }
    return result;
  },
  
  //
  // date serialize
  //
  dateSerialize : function(date) {
    if ( ! date instanceof Date ) return '';
    
    var year  = date.getYear();
    var month = date.getMonth()+1;
    var day   = date.getDate();
    var hour  = date.getHours(); 
    var minute= date.getMinutes();
    var second= date.getSeconds();
    
    var result = '';
    result += new String( year  < 1900 ? 1900+year : year  );
    result += new String( month < 10 ? '0'+month   : month );
    result += new String( day   < 10 ? '0'+day     : day   );
    result += new String( hour  < 10 ? '0'+hour    : hour  );
    result += new String( minute< 10 ? '0'+minute  : minute);
    result += new String( second< 10 ? '0'+second  : second);
    return result; 
  },
  
  /*
   * get date
   */
  getDate : function() {
    var date = new Date();
    var year  = date.getYear();
    var month = date.getMonth()+1;
    var day   = date.getDate();
    
    var result = '';
    result += new String( year  < 1900 ? 1900+year : year  );
    result += new String( month < 10 ? '0'+month   : month );
    result += new String( day   < 10 ? '0'+day     : day   );
    return result; 
  },
  
  /*
   * get time
   */
  getTime : function() {
    var date = new Date();
    var hour  = date.getHours(); 
    var minute= date.getMinutes();
    var timezone = date.getTimezoneOffset()/60*-1;
    
    var tzHour = timezone;
    var tzMin  = 0;
    var tempTz = new String(timezone);
    if ( tempTz.indexOf('.') > -1 ) {
      tzHour = Number( tempTz.substring(0,tempTz.indexOf('.')) );
      tzMin  = Number( tempTz.substring(tempTz.indexOf('.')) )* 60;
    }
    
    var result = '';
    result += new String( hour  < 10 ? '0'+hour    : hour  );
    result += new String( minute< 10 ? '0'+minute  : minute);
    result += new String( tzHour < 0 ? '-' : '+' );
    result += new String( Math.abs(tzHour) < 10
                          ? '0' + Math.abs(tzHour)
                          :       Math.abs(tzHour) );
    result += new String( tzMin < 10 ? '0' + tzMin : tzMin );
    return result;
  },
  
  /**
   * get date formatted string.
   * @param {Object} year
   * @param {Object} month
   * @param {Object} dayOfMonth
   * @param {Object} strSeparator
   */
  getDateFormattedString : function(year, month, dayOfMonth, strSeparator) {
  	var result = '';
	
	if ( year < 1 || month < 1 || dayOfMonth < 1 ) {
	}
	else {
	  result += new String(year);
	  result += strSeparator;
	  result += month < 10 ? '0' : '';
	  result += new String(month);
	  result += strSeparator;
	  result += dayOfMonth < 10 ? '0' : '';
	  result += new String(dayOfMonth);
	}
	return result;
  },
  
  /**
   * get time formatted string.
   * @param {Object} hour
   * @param {Object} minute
   * @param {Object} strSeparator
   */
  getTimeFormattedString : function(hour, minute, strSeparator) {
  	var result = '';
	result += hour < 10 ? '0' : '';
    result += new String(hour);
	result += strSeparator;
	result += minute < 10 ? '0' : '';
	result += new String(minute);
	return result;
  },
  
  /**
   * get date string omit separator.
   * @param {Object} dateString
   * @param {Object} strSeparator
   */
  getDateStringOmitSeparator : function(dateString, strSeparator) {
    if (dateString.length < 10) return '';
	if (!Tugboat.checheckDateFormat(dateString)) return '';
	
	var result = '';
	result += dateString.substring(0,4);
	result += dateString.substring(5,7);
	result += dateString.substring(8,10);
	return result;
  },
  
  /*
   * Escape Html String
   */
  escapeHtmlString : function (value) {
    if ( value == null || Tugboat.isEmpty(value) ) return '';
  
    var result = '';
    for ( i=0; i< value.length; i++ ) {
      if ( value.charAt(i) == '<' ) {
        result += '&lt;';
      }
      else if ( value.charAt(i) == '>' ) {
       result += '&gt;';
      }
      else if ( value.charAt(i) == '&' ) {
        result += '&amp;';
      }
      else if ( value.charAt(i) == '\n' ) {
        result += '<br/>';
      }
      else {
        result += value.charAt(i);
      }
    }
    return result;
  },
  
  /**
   * 
   *
   */
  checkDateFormat : function(value) {
    var reg = /(?:\d{4})([-/.]?)(?:\d{2})\1(?:\d{2})/;
    return reg.test(value);
  },
  
  date : {
    dtCh : "-",
    minYear : 1900,
    maxYear : 2100,

    /**
     * is integer.
     * @param {Object} s
     */
    isInteger : function (s){
      var i;
      for (i = 0; i < s.length; i++){   
        // Check that current character is number.
        var c = s.charAt(i);
        if (((c < "0") || (c > "9"))) return false;
      }
      // All characters are numbers.
      return true;
    },

    /**
     * strip characters in bag.
     * @param {Object} s
     * @param {Object} bag
     */
    stripCharsInBag : function (s, bag){
      var i;
      var returnString = "";
      // Search through string's characters one by one.
      // If character is not in bag, append to returnString.
      for (i = 0; i < s.length; i++){   
        var c = s.charAt(i);
        if (bag.indexOf(c) == -1) returnString += c;
      }
      return returnString;
    },

    /**
     * days in feb.
     * @param {Object} year
     */
    daysInFebruary : function (year){
      // February has 29 days in any year evenly divisible by four,
      // EXCEPT for centurial years which are not also divisible by 400.
      return (((year % 4 == 0) && ( (!(year % 100 == 0)) || (year % 400 == 0))) ? 29 : 28 );
    },
	
	/**
	 * Days Array.
	 * @param {Object} n
	 */
    DaysArray : function (n) {
      for (var i = 1; i <= n; i++) {
        this[i] = 31
        if (i==4 || i==6 || i==9 || i==11) {this[i] = 30}
        if (i==2) {this[i] = 29}
      } 
      return this;
    },
	
	/**
	 * is date.
	 * @param {Object} dtStr
	 * @param {Object} itemName
	 * @param {Object} messages
	 */
    isDate : function (dtStr, itemName, messages){
	  var self = Tugboat.date;
      var daysInMonth = self.DaysArray(12);
	  
      var pos1=dtStr.indexOf(self.dtCh);
      var pos2=dtStr.indexOf(self.dtCh,pos1+1);
	  
	  var strYear=dtStr.substring(0,pos1);
      var strMonth=dtStr.substring(pos1+1,pos2);
      var strDay=dtStr.substring(pos2+1);
      strYr=strYear;
	  
      if (strDay.charAt(0)=="0" && strDay.length>1) strDay=strDay.substring(1);
      if (strMonth.charAt(0)=="0" && strMonth.length>1) strMonth=strMonth.substring(1);
	  
      for (var i = 1; i <= 3; i++) {
        if (strYr.charAt(0)=="0" && strYr.length>1) strYr=strYr.substring(1);
      }
      month=parseInt(strMonth);
      day=parseInt(strDay);
      year=parseInt(strYr);
	  
	  var errorCount = messages.length;
	  
      if (pos1==-1 || pos2==-1){
		messages[errorCount] = '\'' + itemName + '\':The date format should be : yyyy/mm/dd';
		errorCount++;
        return false
      }
      if (strMonth.length<1 || month<1 || month>12){
		messages[errorCount] = '\'' + itemName + '\':Please enter a valid month';
		errorCount++;
        return false;
      }
      if (strDay.length<1 
	  || day<1 || day>31 
	  || (month==2 && day>self.daysInFebruary(year)) || day > daysInMonth[month]){
		messages[errorCount] = '\'' + itemName + '\':Please enter a valid day';
		errorCount++;
        return false;
      }
      if (strYear.length != 4 || year==0 || year<self.minYear || year>self.maxYear){
		messages[errorCount] = '\'' + itemName + '\':Please enter a valid 4 digit year between '+minYear+' and '+maxYear;
		errorCount++;
        return false
      }
      if (dtStr.indexOf(self.dtCh,pos2+1)!=-1 || self.isInteger(self.stripCharsInBag(dtStr, self.dtCh))==false){
		messages[errorCount] = '\'' + itemName + '\':Please enter a valid date';
		errorCount++;
        return false;
      }
      return true;
    }
  },
  
  /**
   * menu
   * 
   */
  menu : {
    open : function () {
      var region = YAHOO.util.Dom.getRegion('navigation_bar_logo');
	  
	  $('menu_window').style.top  = (region.top + 23)  + 'px';
	  $('menu_window').style.left = (region.left + 5) + 'px';
	  Element.toggle('menu_window');
	},
	close : function () {
      $('menu_window').style.display = 'none';
	}
  }
};

//
// Misc
//
Element.empty = function(id) {
  return $(id).innerHTML.match(/^\s*$/);
}

Element.visible = function(element) {
  return ($(element).style.display != "none")
}

Element.showAll = function(array) {
  Element.show.apply(Element.show, array)
}

Element.hideAll = function(array) {
  Element.hide.apply(Element.hide, array)
}

Element.showIf = function() {
  for(var i = 0; i < arguments.length; i++ ) {
    var element = $(arguments[i])
    if(element) Element.show(element)
  }
}

Element.hideIf = function() {
  for(var i = 0; i < arguments.length; i++ ) {
    var element = $(arguments[i])
    if(element) Element.hide(element)
  }
}

Element.previousSibling = function(anchor, type) {
  sib = anchor.previousSibling
  while(sib) {
    if(sib.tagName && sib.tagName == type) break
    sib = sib.previousSibling
  }
  return sib
}

Element.nextSibling = function(anchor, type) {
  sib = anchor.nextSibling
  while(sib) {
    if(sib.tagName && sib.tagName == type) break
    sib = sib.nextSibling
  }
  return sib
}

function scrollWindowTo(id) {
  element = $(id)
  x = ( element.x ? element.x : element.offsetLeft )
  y = ( element.y ? element.y : element.offsetTop )
  window.scrollTo(x,y)
}

Element.activate = function(element, activate) {
  element = $(element)

  var inactive_text = element['bp:inactive_text']
  if(!inactive_text) {
    element['bp:inactive_text'] = element.innerHTML
    inactive_text = element.innerHTML
  }

  var active_text = element.getAttribute('bp:active_text') || element.innerHTML
  var active_class = element.getAttribute('bp:active_class') || element.className

  if(!activate) {
    element.innerHTML = inactive_text
    if(active_class) Element.removeClassName(element, active_class)
    element['bp:active'] = false
  } else {
    element.innerHTML = active_text
    if(active_class) Element.addClassName(element, active_class)
    element['bp:active'] = true
  }
}

Object.extend(Element, {
	getWidth: function(element) {
	   	element = $(element);
	   	return element.offsetWidth; 
	},
	setWidth: function(element,w) {
	   	element = $(element);
    	element.style.width = w +"px";
	},
	setHeight: function(element,h) {
   		element = $(element);
    	element.style.height = h +"px";
	},
	setTop: function(element,t) {
	   	element = $(element);
    	element.style.top = t +"px";
	},
	setSrc: function(element,src) {
    	element = $(element);
    	element.src = src; 
	},
	setHref: function(element,href) {
    	element = $(element);
    	element.href = href; 
	},
	setInnerHTML: function(element,content) {
		element = $(element);
		element.innerHTML = content;
	}
});

// add key code extend 'prototype.Event'. 
Object.extend(Event, 
  {
    KEY_A : 65,
    KEY_B : 66,
    KEY_C : 67,
    KEY_D : 68,
    KEY_E : 69,
    KEY_F : 70,
    KEY_G : 71,
    KEY_H : 72,
    KEY_I : 73,
    KEY_J : 74,
    KEY_K : 75,
    KEY_L : 76,
    KEY_M : 77,
    KEY_N : 78,
    KEY_O : 79,
    KEY_P : 80,
    KEY_Q : 81,
    KEY_R : 82,
    KEY_S : 83,
    KEY_T : 84,
    KEY_U : 85,
    KEY_V : 86,
    KEY_W : 87,
    KEY_X : 88,
    KEY_Y : 89,
    KEY_Z : 90
  }
);

/**
 *  String tokenizer.
 */
String.prototype.tokenize = tokenize;
function tokenize(separator) {
  var input             = '';
  var separator         = ( !separator ? ' ' : separator);
  var trim              = '';
  var ignoreEmptyTokens = true;

  try {
    String(this.toLowerCase());
  }
  catch(e) {
    return;
  }

  if(typeof(this) != 'undefined') {
    input = String(this);
  }
  if(typeof(tokenize.arguments[0]) != 'undefined') {
    separator = String(tokenize.arguments[0]);
  }
  if(typeof(tokenize.arguments[1]) != 'undefined') {
    trim = String(tokenize.arguments[1]);
  }
  if (typeof(tokenize.arguments[2]) != 'undefined') {
    if (!tokenize.arguments[2])
      ignoreEmptyTokens = false;
  }

  var array = input.split(separator);
  if(trim) {
    for(var i=0; i<array.length; i++) {
      while(array[i].slice(0, trim.length) == trim)
        array[i] = array[i].slice(trim.length);

      while(array[i].slice(array[i].length-trim.length) == trim)
        array[i] = array[i].slice(0, array[i].length-trim.length);
    }
  }
  var token = new Array();
  if (ignoreEmptyTokens) {
    for(var i=0; i<array.length; i++) {
      if(array[i] != "") token.push(array[i]);
    }
  }
  else {
    token = array;
  }
  return token;
}

//
// logout.
//
var logout_rules = {
  '#logout' : function(el) {
    el.onclick = function(){
      el.blur();
      if (! confirm('May I logout this system ?')) {
        return false;
      }
      location.href='logout.html';
    }
  }
};
Behaviour.register(logout_rules);