/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.loginAdmin) == 'undefined') {
    Tugboat.loginAdmin = {};
}

Tugboat.loginAdmin = {
  /**
   * Initialize.
   * 
   */
  init : function() {
    var self = Tugboat.loginAdmin;
    self._setup_event_rules();
  },
  
  /**
   * setup event rules.
   */
  _setup_event_rules : function() {
    var self = Tugboat.loginAdmin;
    var rules = {
      '#loginForm' : function(el) {
        el.onsubmit = function() {
          self._auth();
          return false;
        }
      },
      '#login_button' : function(el) {
        el.onclick = function() {
          self._auth();
          el.blur();
          return false;
        }
      }
    };
    Behaviour.register(rules);
  },
  
  /** 
   * authorize
   * 
   */
  _auth : function() {
    var userId = $('userId').value;
    var password = $('password').value;
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component: 'loginAdminAjax',
          action   : 'login',
          userId   : userId,
          password : password
        },
        onComplete: function(transport){
          var responseText = transport.responseText;
          
          if (Tugboat.isEmpty(responseText)) {
            Tugboat.loginAdmin.modal.open();
            document.forms["loginForm"].submit();
          }
          else {
            $('error_message').style.color = 'pink';
            $('error_message').style.fontSize = '18px';
            $('error_message').innerHTML = 'Sorry, User ID or Password is wrong.';
            Effect.Shake('loginForm');
          }
        }
      }
    );
  },
  
  /*
   * Modal window
   *
   * 
   */
  modal : {
    open : function () {
      var page = Tugboat.getPageSize(); 
      Element.setHeight('modal_window', page.pageHeight);
      $('modal_window').style.display = 'block';
    },

    close : function() {
      $('modal_window').style.display = 'none';
    }
  }
};
