/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.gtd_user) == 'undefined') {
    Tugboat.gtd_user = {};
}

Tugboat.gtd_user = {
  /**
   * change password
   */
  password:false,
  
  /**
   * user
   */
  user: null,
  
  /**
   * initialize.
   */
  init : function () {

    var self = Tugboat.gtd_user;
    self._setup_event_rules();
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component:'userAjax',
          action   :'get',
        },
        onComplete: function(transport){
          var self = Tugboat.gtd_user;
          
          self.user = eval('(' +transport.responseText+')');
          self.reset();
        }
      }
    );
    
    
  },
  
  /**
   * setup event rules.
   */
  _setup_event_rules : function() {
    var self = Tugboat.gtd_user;
    var rules = {
      '#menuBar_modifyUser' : function(el) {
        el.onclick = function() {
          self.modify_user_onclick();
          el.blur();
          return false;
        }
      },
      '#modify_user_cancel': function(el) {
        el.onclick = function() {
          Windows.closeAll();
          self.modal.close();
          el.blur();
          return false;
        }
      },
      '#modify_user_post': function(el) {
        el.onclick = function() {
          self.post();
          return false;
        }
      },      'span.user_view': function(el) {
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
        };
      },
      '#user_view_firstName': function(el) {
        el.onclick = function() {
          $('user_view_firstName').hide();
          $('user_edit_firstName').show();
        }
      },
      '#user_view_lastName': function(el) {
        el.onclick = function() {
          $('user_view_lastName').hide();
          $('user_edit_lastName').show();
        }
      },
      '#user_view_email': function(el) {
        el.onclick = function() {
          $('user_view_email').hide();
          $('user_edit_email').show();
        }
      },
      '#user_view_password': function(el) {
        el.onclick = function() {
          $('user_view_password').hide();
          $('user_edit_password').show();
          $('user_edit_passwordConfirm').show();
          self.password = true;
        }
      },
    };
    Behaviour.register(rules);
  },
  
  modify_user_onclick: function() {
    var self = Tugboat.gtd_user;
    
    self.reset();
    
    self.user_modify_window = 
      new Window(
        'userModifyWindow', 
        { className: 'mac_os_x', width:350, height:230, 
          zIndex: 100, 
          minimizable: false, 
          closable   : false, 
          maximizable: false,
          resizable  : false, 
          draggable  : true,
          title      : 'Modify user',
          showEffectOptions:{
            duration:0.3, 
            afterFinish:function(){$('modify_user_post').focus();}
          }
        }
      );
    self.user_modify_window.setContent('user_sub_window_container',false,false);
    self.user_modify_window.setDestroyOnClose();
    self.user_modify_window.showCenter();
    self.modal.open();
    
    var userWindowObserver = {
      onDestroy: function(eventName, win) {
        if (win == self.user_modify_window) {
//          Element.hide('task_sub_window_container');
//          $('task_sub_window_container').appendChild($('task_sub_window'));
//          self.add_task_window = null;
          Windows.removeObserver(this);
          
          Tugboat.gtd_user.modal.close();
        }
      }
    };
    Windows.addObserver(userWindowObserver);
  
  },
  
  post: function() {
    var self = Tugboat.gtd_user;

    /*validate*/
    if($F('user_edit_email') == '') {
      alert('Please enter Email');  
      $('user_edit_email').focus();
      return false;
    } 
    else if($F('user_edit_firstName') == '') {
      alert('Please enter FirstName');  
      $('user_edit_firstName').focus();
      return false;
    } 
    else if($F('user_edit_lastName') == '') {
      alert('Please enter LastName');  
      $('user_edit_lastName').focus();
      return false;
    }
    if(self.password) {
      if($F('user_edit_password') != $F('user_edit_passwordConfirm')) {
        alert('Password mismatch');
        $('user_edit_passwordConfirm').focus();
        return false;
      }
      else if($F('user_edit_password') == '') {
        alert('Please enter Password');
        $('user_edit_password').focus();
        return false;
      }
    }

    var parameters =
    {
      component: 'userAjax',
      action:    'update',
      userId:    self.user.userId,
      email:     $F('user_edit_email'),
      firstName: $F('user_edit_firstName'),
      lastName:  $F('user_edit_lastName'),
    };
    
    if(self.password) {
        parameters['password']   = $F('user_edit_password');
    }
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_GET,
        parameters: parameters,
        onComplete: function(transport){
          if(transport.responseText == 'email') {
            alert('invalid email');
            $('user_edit_email').focus();
            return false;
          }
          var self = Tugboat.gtd_user;
          self.user = eval('(' +transport.responseText+')');
          $('modify_user_post').blur();
          Windows.closeAll();
          self.modal.close();
        }
      }
    );          
  },
  reset: function(){
    var self = Tugboat.gtd_user;
    $$('span.user_view').each(function(span){
      span.show();
    });
    $$('.user_edit').each(function(span){
      span.hide();
    });
    $('user_view_loginId').innerHTML     = self.user.loginId;
    $('user_view_email').innerHTML       = self.user.email;
    $('user_edit_email').value           = self.user.email;
    $('user_view_firstName').innerHTML   = self.user.firstName;
    $('user_edit_firstName').value       = self.user.firstName;
    $('user_view_lastName').innerHTML    = self.user.lastName;
    $('user_edit_lastName').value        = self.user.lastName;
    $('user_edit_password').value        = '';
    $('user_edit_passwordConfirm').value = '';
    
    
  },
  
  
  
  
  
  
  /*
   * Modal window
   *
   * 
   */
  modal : {
    open : function () {
      var page = Tugboat.getPageSize(); 
      Element.setHeight('modal_window', page.pageHeight);
      $('modal_window').style.display = 'block';
    },

    close : function() {
      $('modal_window').style.display = 'none';
    }
  },
};
