/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.gtd_task_event_rule) == 'undefined') {
    Tugboat.gtd_task_event_rule = {};
}

Tugboat.gtd_task_event_rule = {
  /**
   * setup event rules.
   * 
   */
  setup_event_rules : function() {
    var rules = {
      /*
       * header and menu.events.
       */
      '#header_title' : function(el) {
        el.onclick = function(){
            el.blur();
            return false;
        }
      },
      
      '#gtd_folder_arrow' : function(el) {
        el.onclick = function() {
          el.className = 
            el.className.indexOf('right') > -1 ? 'down_arrow' : 'right_arrow';

          Element.toggle('gtd_folder');
          el.blur();
          return false;
        } 
      },
      
      '#tags_folder_arrow' : function(el) {
        el.onclick = function() {
          el.className = 
            el.className.indexOf('right') > -1 ? 'down_arrow' : 'right_arrow';

          Element.toggle('tags_container');
          el.blur();
          return false;
        }
      },
      
      '#list_pane' : function(el) {
        el.onscroll = function() {
          $('block_balloon').style.display=Tugboat.constant.STYLE_DISPLAY_NONE;
        }
      },
      
      '#menuBar_AddTask' : function(el){
        el.onclick = function(){
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_INBOX.id);
          Tugboat.gtd_task.sub_window.add_task_onclick();
            
          el.blur();
          return false;
        }
      },
      '#menuBar_EmptyTrashBox' : function(el){
        el.onclick = function(){
          Tugboat.gtd_task.empty_trashbox_onclick();
          el.blur();
          return false;
        }
      },
      '#menuBar_KeyboardHelp' : function(el){
        el.onclick = function(){
          Tugboat.gtd_task.shortcut_keys_onclick();
          el.blur();
          return false;
        }
      },
      '#shortcut_keys_close' : function(el) {
        el.onclick = function() {
          Windows.closeAll();
          el.blur();
          return false;
        }
      },
      
      '#browser_button' : function(el) {
        el.onclick = function() {
          el.blur();
          if (Tugboat.gtd_task._selected_tab == 1) return false;

          var display = $('browser_pane').style.display;
          var isVisible = (display == '' || display == 'block' ? 0 : 1);
          Tugboat.gtd_task._is_visibled_browser = isVisible == 1;
          
          new Ajax.Request (
            Tugboat.AJAX_SERVLET_NAME,
            {
              method: Tugboat.constant.REQUEST_GET,
              parameters:
              {
                component        :'taskAjax',
                action           :'updateIsVisibleBrowser',
                isVisibleBrowser :isVisible
              },
              onComplete: function(transport){
              }
            }
          );
          
          if (display == '' || display == 'block') {
            Tugboat.gtd_task.browser.reset(true);
            Tugboat.gtd_task._set_person_in_charge_list(null);
            Tugboat.gtd_task.browser._create_person_in_charge_list(
              Tugboat.gtd_task.browser._person_info);
           
            Tugboat.gtd_task.folder._setup_browse_class_and_status(TugboatUI.DragBox.selectedFolderId);
            Tugboat.gtd_task.browser.get_task_list_by_query_params(0,1);
          }
          Tugboat.gtd_common.toggleBrowserArea();
        }
      },
      
      /*
       * block/list mode.
       */
      '#layout_block' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.selected_view_mode(Tugboat.constant.view_mode.BLOCK);
          Tugboat.gtd_common.blockSelect(el);
          Tugboat.gtd_common.resize_list_area(false,false);
          
          Tugboat.gtd_task.setDragnDropTodayPaneStyle('block');
        }
      },
      '#layout_list' : function(el) {
        el.onclick = function() {
          Element.hide('block_balloon');
          Tugboat.gtd_task.selected_view_mode(Tugboat.constant.view_mode.LIST);
          Tugboat.gtd_common.listSelect(el);
          Tugboat.gtd_common.resize_list_area(false,false);
          
          Tugboat.gtd_task.setDragnDropTodayPaneStyle('list');
        }
      },
      /*
       * folder.events.
       */
      '#folder_all' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_ALL.id);
          el.blur();
          return false;
        }
      },
      '#folder_inbox' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_INBOX.id);
          
          var self = Tugboat.gtd_task.sub_window;
          self.get_activities_json();          
          
          el.blur();
          return false;
        }
      },
      '#folder_today' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_TODAY.id);
          el.blur();
          return false;
        }
      },
      
      '#folder_today_todo' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_TODAY.id);
          el.blur();
          return false;
        }
      },
      
      '#folder_today_doing' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_TODAY.id);
          el.blur();
          return false;
        }
      },
      
      '#folder_today_done' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_TODAY.id);
          el.blur();
          return false;
        }
      },
      
      '#folder_week' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_WEEK.id);
          el.blur();
          return false;
        }
      },
      '#folder_month' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_MONTH.id);
          el.blur();
          return false;
        }
      },
      '#folder_hold' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_HOLD.id);
          el.blur();
          return false;
        }
      },
      '#folder_someday' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_SOMEDAY.id);
          el.blur();
          return false;
        }
      },
      '#folder_archives' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_ARCHIVES.id);
          el.blur();
          return false;
        }
      },
      '#folder_trash' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_TRASH_BOX.id);
          el.blur();
          return false;
        }
      },
      
      /*
       * browser.status.events.
       */
      '#browser_status_list-0' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.status_select(0);
          el.blur();
          return false;
        }
      },
      '#browser_status_list-1' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.status_select(1);
          el.blur();
          return false;
        }
      },
      '#browser_status_list-2' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.status_select(2);
          el.blur();
          return false;
        }
      },
      '#browser_status_list-3' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.status_select(3);
          el.blur();
          return false;
        }
      },
      /*
       * browser.classification.events.
       */
      '#browser_class_list-0' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.classification_select(0);
          el.blur();
          return false;
        }
      },
      '#browser_class_list-9' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.classification_select(9);
          el.blur();
          return false;
        }
      },
      '#browser_class_list-1' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.classification_select(1);
          el.blur();
          return false;
        }
      },
      '#browser_class_list-2' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.classification_select(2);
          el.blur();
          return false;
        }
      },
      '#browser_class_list-3' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.classification_select(3);
          el.blur();
          return false;
        }
      },
      '#browser_class_list-4' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.classification_select(4);
          el.blur();
          return false;
        }
      },
      '#browser_class_list-5' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.classification_select(5);
          el.blur();
          return false;
        }
      },
      '#browser_class_list-21' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.classification_select(21);
          el.blur();
          return false;
        }
      },
      
      '#page_prev' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.page_navi_onclick('page_prev');
          el.blur();
        }
      },
      '#page_next' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.browser.page_navi_onclick('page_next');
          el.blur();
        }
      },
      
      '#add_task_cancel_button' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.sub_window.cancel();
        }
      },
      '#add_task_add_button' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.sub_window.add(Tugboat.gtd_task.sub_window.ADD_TYPE_ANOTHER);
        }
      },
      
      '#edit_task_cancel_button' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.sub_window.cancel();
        }
      },
      '#edit_task_add_button' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.sub_window.update();
        }
      },
      
      /*
       * add task sub window.
       */
      '#addTaskForm' : function(el) {
        el.onsubmit = function() {
          return false;
        }
      },
      
      '#edit_tags_cancel' : function(el) {
        el.onclick = function() {
          Windows.closeAll();
          el.blur();
          return false;
        }
      },
      '#edit_tags_update' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task.tag.update();
          Windows.closeAll();
          el.blur();
          return false;
        }
      },
      
      '#add_task_tags' : function(el) {
        el.onblur = function() {
          Tugboat.gtd_task.sub_window._tag_auto_completer.hide();
          Tugboat.gtd_task.sub_window._tag_auto_completer.active = false;
        },
        el.onkeyup = function(key) {
          if (!key || !key.keyCode) return false;
          if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;
          
          if (key.keyCode == 188) {
              Tugboat.gtd_task.sub_window._tag_auto_completer.hide();
              Tugboat.gtd_task.sub_window._tag_auto_completer.active = false;
          }
          if (key.keyCode == Event.KEY_BACKSPACE 
           || key.keyCode == Event.KEY_DELETE 
           || $('add_task_tags').value == '') {

            if (Tugboat.isEmpty($('add_task_tags').value)) {
              $('add_task_tags_target').value = '';
              Tugboat.gtd_task.sub_window._tag_auto_completer.hide();
              Tugboat.gtd_task.sub_window._tag_auto_completer.active = false;
            }
          }
          if (key.keyCode == Event.KEY_RETURN 
           && Tugboat.gtd_task.sub_window._tag_auto_completer.active) {

            Tugboat.gtd_task.sub_window._tag_auto_completer.selectEntry();
            Tugboat.gtd_task.sub_window._tag_auto_completer.hide();
            
            var ret = $('add_task_tags').value.tokenize(',');
            var tags_text = '';
            for (i=0; i<ret.length; i++) {
              if (i < ret.length - 1) tags_text += (ret[i] + ',');
              else                  tags_text += $('add_task_tags_target').value
            }
            $('add_task_tags').value = tags_text;
            $('add_task_tags').focus();
            return false;
          }
          if (key.keyCode == Event.KEY_UP && Tugboat.gtd_task.sub_window._tag_auto_completer.active) {
            Tugboat.gtd_task.sub_window._tag_auto_completer.markPrevious();
            Tugboat.gtd_task.sub_window._tag_auto_completer.render();
            return false;
          }
          if (key.keyCode == Event.KEY_DOWN && Tugboat.gtd_task.sub_window._tag_auto_completer.active) {
            Tugboat.gtd_task.sub_window._tag_auto_completer.markNext();
            Tugboat.gtd_task.sub_window._tag_auto_completer.render();
            return false;
          }

          var tags_str = $('add_task_tags').value;
          if (tags_str.substring(tags_str.length - 1) == ',') {
            $('add_task_tags_target').value = '';
            Tugboat.gtd_task.sub_window._tag_auto_completer.active = false;
          }
          else {
            var ret = $('add_task_tags').value.tokenize(',');
            if (ret && ret.length > 0) {
              $('add_task_tags_target').value = ret[ret.length - 1];
              
              Tugboat.gtd_task.sub_window._tag_auto_completer.onObserverEvent();
            }
          }
        }
      },
      
      '#tag_filter' : function(el) {
        el.onfocus = function() {
          if (el.value == 'tags filter...') {
            el.value = '';
          }
        },
        el.onblur = function() {
          if (Tugboat.isEmpty(el.value)) {
            el.value = 'tags filter...';
          }
        },
        el.onkeyup = function() {
          var input_value = $('tag_filter').value.toLowerCase();
          Tugboat.gtd_task.tag._own_tags.each(
            function(t) {
              if (t.isSelected != true) {
                if (t.tagValue.toLowerCase().indexOf(input_value) > -1 
                 || Tugboat.isEmpty(input_value) ) {
                  Element.show('tag_not_selected-' + t.tagId);
                }
                else {
                  Element.hide('tag_not_selected-' + t.tagId);
                }
              }
            }
          );
        }
      },

      /*
      '#tags_filter_cond_and' : function(el) {
        el.onclick = function() {
          el.blur();
          var classname = el.className;
          if (classname.indexOf('off') > -1) {
            el.className = 'check_on';
            $('tags_filter_cond_or').className = 'check_off';
            
            Tugboat.gtd_task.tag._fileter_cond = 1;
          }
        }
      },
      '#tags_filter_cond_or' : function(el) {
        el.onclick = function() {
          el.blur();
          var classname = el.className;
          if (classname.indexOf('off') > -1) {
            el.className = 'check_on';
            $('tags_filter_cond_and').className = 'check_off';
            
            Tugboat.gtd_task.tag._fileter_cond = 2;
          }
        }
      },
      */
     
      '#add_task_option_arrow' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'pointer';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          var classname = el.className;
          el.className = classname.indexOf('right') > -1 ? 'down_arrow' : 'right_arrow';
          
          Tugboat.gtd_task.sub_window.add_task_window.setSize(
            560, (classname.indexOf('right') > - 1 ? 385 : 150));
          
          Element.toggle('add_task_option_tags');
          if (classname.indexOf('down') > -1) $('add_task_description').value = '';
        }
      },
      
      '#clear_calendar_button' : function(el) {
        el.onclick = function() {
          $('edit_due').value = '';
          $('edit_due_display').innerHTML = '';
          el.blur();
          return false;
        }
      },
      '#block_balloon_close' : function(el) {
        el.onclick = function() {
          $('block_balloon').style.display=Tugboat.constant.STYLE_DISPLAY_NONE;
          el.blur();
          return false;
        }
      }
    };
    Behaviour.register(rules);
  }
};
YAHOO.util.Event.addListener(
  'add_task_title', "keydown",
  function(key){
    if (key.keyCode == Event.KEY_RETURN) {

      if (Tugboat.gtd_task.sub_window._edit_mode == Tugboat.gtd_task.sub_window.MODE_ADD) {
        Tugboat.gtd_task.sub_window.add(Tugboat.gtd_task.sub_window.ADD_TYPE_ANOTHER);
      } else {
        Tugboat.gtd_task.sub_window.update();
      }
    }
  }
);
YAHOO.util.Event.addListener(
  document, "keydown",
  function(key){
    if (key.keyCode == Event.KEY_ESC) {
      if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;
      Windows.closeAll();
    }
    
    var isIE6 = navigator.userAgent.indexOf('MSIE 6.0') > -1;
    if (isIE6) {
    } else {
      if (Tugboat.gtd_task.modal._is_opened) {
        return false;
      }
    
      switch (key.keyCode) {
        //[a]
        case Event.KEY_A:
          Tugboat.gtd_task._prev_entry_key_code = key.keyCode;
          break;
        //[t]
        case Event.KEY_T:
          if (Tugboat.gtd_task._prev_entry_key_code == Event.KEY_A) {
            Tugboat.gtd_task.folder.folder_onclick(Tugboat.constant.task.FOLDER_INBOX.id);
            Tugboat.gtd_task.sub_window.add_task_onclick();
          }
          Tugboat.gtd_task._prev_entry_key_code = 0;
          break;
        default:
          Tugboat.gtd_task._prev_entry_key_code = 0;
      }
    }
  }
);