/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.constant) == 'undefined') {
    Tugboat.constant = {};
}

Tugboat.constant = {
  ROWS_PER_PAGE  : 50,
  REQUEST_GET    : 'get',
  REQUEST_POST   : 'post',
  REQUEST_PUT    : 'put',
  REQUEST_DELETE : 'delete',
  STYLE_DISPLAY_NONE  : 'none',
  STYLE_DISPLAY_BLOCK : 'block',
  
  role : {
    OWNER : 1,
    USER  : 2,
    GUEST : 3
  },
  
  pointer   : {on:'pointer', off:'default'},
  highlight : {on:'#ffa',    off:'#fff'   },
  
  location : {
    TASKS          : 'gtdTasks.html',
    TASK_DETAILS   : 'gtdTaskDetail.html',
    MEETINGS       : 'gtdMeetings.html',
    MEETING_DETAIL : 'gtdMeetingDetail.html',
    ACTIVITIES     : 'gtdActivity.html',
    TIME_LINE      : 'gtdTimeline.htm'
  },
  
  view_mode : {
    BLOCK : 0,
    LIST  : 1
  },
  
  task : {
    SEL_MODE_GTD : 'gtd',
    SEL_MODE_TAG : 'tag',

    findFolderByValue : function(value) {
      var self = Tugboat.constant.task;
      if      (value == 0) return self.FOLDER_ALL;
      else if (value == 1) return self.FOLDER_TODAY;
      else if (value == 2) return self.FOLDER_WEEK;
      else if (value == 3) return self.FOLDER_MONTH;
      else if (value == 4) return self.FOLDER_HOLD;
      else if (value == 5) return self.FOLDER_SOMEDAY;
      else if (value == 9) return self.FOLDER_INBOX;
      else if (value == 11) return self.FOLDER_TODAY_TODO;
      else if (value == 12) return self.FOLDER_TODAY_DOING;
      else if (value == 13) return self.FOLDER_TODAY_DONE;
      else if (value == 41) return self.FOLDER_HOLD_TODO;
      else if (value == 43) return self.FOLDER_HOLD_DONE;
      else if (value == 21) return self.FOLDER_ARCHIVES;
      else if (value == 99) return self.FOLDER_TRASH_BOX;
    },
    findFolderById : function(value) {
      var self = Tugboat.constant.task;
      if      (value == 'folder_all') return self.FOLDER_ALL;
      else if (value == 'folder_inbox') return self.FOLDER_INBOX;
      else if (value == 'folder_today') return self.FOLDER_TODAY;
      else if (value == 'folder_week') return self.FOLDER_WEEK;
      else if (value == 'folder_month') return self.FOLDER_MONTH;
      else if (value == 'folder_hold') return self.FOLDER_HOLD;
      else if (value == 'folder_someday') return self.FOLDER_SOMEDAY;
      else if (value == 'folder_today_todo') return self.FOLDER_TODAY_TODO;
      else if (value == 'folder_today_doing') return self.FOLDER_TODAY_DOING;
      else if (value == 'folder_today_done') return self.FOLDER_TODAY_DONE;
      else if (value == 'folder_hold_todo') return self.FOLDER_HOLD_TODO;
      else if (value == 'folder_hold_done') return self.FOLDER_HOLD_DONE;
      else if (value == 'folder_archives') return self.FOLDER_ARCHIVES;
      else if (value == 'folder_trash') return self.FOLDER_TRASH_BOX;
    },
    
    FOLDER_ALL         : {id:'folder_all',         value:0,  name:'Tasks'   },
    FOLDER_INBOX       : {id:'folder_inbox',       value:9,  name:'Inbox'   },
    FOLDER_TODAY       : {id:'folder_today',       value:1,  name:'Today'   },
    FOLDER_WEEK        : {id:'folder_week',        value:2,  name:'Week'    },
    FOLDER_MONTH       : {id:'folder_month',       value:3,  name:'Month'   },
    FOLDER_HOLD        : {id:'folder_hold',        value:4,  name:'Hold'    },
    FOLDER_SOMEDAY     : {id:'folder_someday',     value:5,  name:'Someday' },
    FOLDER_TODAY_TODO  : {id:'folder_today_todo',  value:11, name:''        },
    FOLDER_TODAY_DOING : {id:'folder_today_doing', value:12, name:''        },
    FOLDER_TODAY_DONE  : {id:'folder_today_done',  value:13, name:''        },
    FOLDER_HOLD_TODO   : {id:'folder_hold_todo',   value:41, name:''        },
    FOLDER_HOLD_DONE   : {id:'folder_hold_done',   value:43, name:''        },
    FOLDER_ARCHIVES    : {id:'folder_archives',    value:21, name:'Archives'},
    FOLDER_TRASH_BOX   : {id:'folder_trash',       value:99, name:'Trash'   },
   
    ID_LI_BROWSER_CLASS_LIST   : 'browser_class_list-',
    ID_IMG_BROWSER_CLASS_LIST  : 'browser_class_list_img-',
    ID_LI_BROWSER_LIST         : 'browser_status_list-',
    ID_IMG_BROWSER_STATUS_LIST : 'browser_status_list_img-',
    ID_LI_ACTIVITY_LIST        : 'browser_activity_list-',
    ID_IMG_ACTIVITY_LIST       : 'browser_activity_list_img-',
    
    CLASS_LIST_SELECT          : 'list_select',
    CLASS_LIST_NOT_SELECT      : 'list_not_select',
    
    STATUS_ALL   : {id:0, value:'',      icon:''                                          },
    STATUS_TODO  : {id:1, value:'To Do', icon:'images/default/folder/gif/status_todo.gif' },
    STATUS_DOING : {id:2, value:'Doing', icon:'images/default/folder/gif/status_doing.gif'},
    STATUS_DONE  : {id:3, value:'Done',  icon:'images/default/folder/gif/status_done.gif' },
    statusValue  : function(id) {
      var self = Tugboat.constant.task;
      if      (id == 0) return self.STATUS_ALL;
      else if (id == 1) return self.STATUS_TODO;
      else if (id == 2) return self.STATUS_DOING;
      else if (id == 3) return self.STATUS_DONE;
    },
    
    CLASS_ALL      : {id:0,  value:'Tasks',     icon:'images/default/folder/gif/folder-red-16.gif'   },
    CLASS_TODAY    : {id:1,  value:'Today',     icon:'images/default/folder/gif/folder-red-16.gif'   },
    CLASS_WEEK     : {id:2,  value:'Week',      icon:'images/default/folder/gif/folder-orange-16.gif'},
    CLASS_MONTH    : {id:3,  value:'Month',     icon:'images/default/folder/gif/folder-yellow-16.gif'},
    CLASS_HOLD     : {id:4,  value:'Hold',      icon:'images/default/folder/gif/folder-green-16.gif' },
    CLASS_SOMEDAY  : {id:5,  value:'Someday',   icon:'images/default/folder/gif/folder-blue-16.gif'  },
    CLASS_INBOX    : {id:9,  value:'Inbox',     icon:'images/default/folder/gif/inbox-16.gif'        },
    CLASS_ARCHIVES : {id:21, value:'Archives',  icon:'images/default/folder/gif/folder-gray-16.gif'  },
    CLASS_TRASH_BOX: {id:99, value:'Trash box', icon:'images/default/folder/gif/trash-16.gif'        },
    classValue : function(id) {
      var self = Tugboat.constant.task;
      if      (id == 0) return self.CLASS_ALL;
      else if (id == 1) return self.CLASS_TODAY;
      else if (id == 2) return self.CLASS_WEEK;
      else if (id == 3) return self.CLASS_MONTH;
      else if (id == 4) return self.CLASS_HOLD;
      else if (id == 5) return self.CLASS_SOMEDAY;
      else if (id == 9) return self.CLASS_INBOX;
      else if (id == 21) return self.CLASS_ARCHIVES;
      else if (id == 99) return self.CLASS_TRASH_BOX;
    },
    
    STYLE_FOLDER_ALL         : {SELECT:'drawer selected',    DEFAULT:'drawer',          OVER:''                             },
    STYLE_FOLDER_INBOX       : {SELECT:'inbox selected',     DEFAULT:'inbox',           OVER:'inbox_add'                    },
    STYLE_FOLDER_TODAY       : {SELECT:'today selected',     DEFAULT:'today',           OVER:'today_add'                    },
    STYLE_FOLDER_WEEK        : {SELECT:'week selected',      DEFAULT:'week',            OVER:'week_add'                     },
    STYLE_FOLDER_MONTH       : {SELECT:'month selected',     DEFAULT:'month',           OVER:'month_add'                    },
    STYLE_FOLDER_HOLD        : {SELECT:'hold selected',      DEFAULT:'hold',            OVER:'hold_add'                     },
    STYLE_FOLDER_SOMEDAY     : {SELECT:'someday selected',   DEFAULT:'someday',         OVER:'someday_add'                  },
    STYLE_FOLDER_TODAY_TODO  : {SELECT:'',                   DEFAULT:'today_todo',      OVER:'today_todo_add'               },
    STYLE_FOLDER_TODAY_DOING : {SELECT:'',                   DEFAULT:'today_doing',     OVER:'today_doing_add'              },
    STYLE_FOLDER_TODAY_DONE  : {SELECT:'',                   DEFAULT:'today_done',      OVER:'today_done_add'               },
    STYLE_FOLDER_ARCHIVES    : {SELECT:'archives selected',  DEFAULT:'archives',        OVER:''                             },
    STYLE_FOLDER_TRASH_BOX   : {SELECT:'trash_box selected', DEFAULT:'trash_box',       OVER:'trash_box_add'                },
    STYLE_PANE_TODAY_TODO    : {SELECT:'',                   DEFAULT:'gtdBox clearfix', OVER:'gtdBox clearfix gtdBox_hover' },
    STYLE_PANE_TODAY_DOING   : {SELECT:'',                   DEFAULT:'gtdBox clearfix', OVER:'gtdBox clearfix gtdBox_hover' },
    STYLE_PANE_TODAY_DONE    : {SELECT:'',                   DEFAULT:'gtdBox clearfix', OVER:'gtdBox clearfix gtdBox_hover' },
    STYLE_PANE_HOLD_TODO     : {SELECT:'',                   DEFAULT:'gtdBox clearfix', OVER:'gtdBox clearfix gtdBox_hover' },
    STYLE_PANE_HOLD_DONE     : {SELECT:'',                   DEFAULT:'gtdBox clearfix', OVER:'gtdBox clearfix gtdBox_hover' },
    
    droppableTargetStyle     : function() {
      var self = Tugboat.constant.task;
      var styles = 
      [
        { id : self.FOLDER_ALL.id,
          value:self.FOLDER_ALL.value,
          statusId : 1,
          selectedStyle : self.STYLE_FOLDER_ALL.SELECT, 
          defaultStyle  : self.STYLE_FOLDER_ALL.DEFAULT, 
          dragOverStyle : self.STYLE_FOLDER_OVER, 
          status:[
            {id:Tugboat.constant.task.STATUS_ALL.id,  isVisible:true},
            {id:Tugboat.constant.task.STATUS_TODO.id, isVisible:true},
            {id:Tugboat.constant.task.STATUS_DOING.id,isVisible:true},
            {id:Tugboat.constant.task.STATUS_DONE.id, isVisible:true}
          ],
          nodeLevel:1
        },
        { id : self.FOLDER_INBOX.id,
          value:self.FOLDER_INBOX.value, 
          statusId : 1,
          selectedStyle : self.STYLE_FOLDER_INBOX.SELECT,
          defaultStyle  : self.STYLE_FOLDER_INBOX.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_INBOX.OVER, 
          status:[
            {id:Tugboat.constant.task.STATUS_ALL.id,  isVisible:false},
            {id:Tugboat.constant.task.STATUS_TODO.id, isVisible:true },
            {id:Tugboat.constant.task.STATUS_DOING.id,isVisible:false},
            {id:Tugboat.constant.task.STATUS_DONE.id, isVisible:false}
          ],
          nodeLevel:1
        },
        { id : self.FOLDER_TODAY.id,
          value:self.FOLDER_TODAY.value, 
          statusId : 1,
          selectedStyle : self.STYLE_FOLDER_TODAY.SELECT,
          defaultStyle  : self.STYLE_FOLDER_TODAY.DEFAULT, 
          dragOverStyle : self.STYLE_FOLDER_TODAY.OVER, 
          status:[
            {id:Tugboat.constant.task.STATUS_ALL.id,  isVisible:true},
            {id:Tugboat.constant.task.STATUS_TODO.id, isVisible:true},
            {id:Tugboat.constant.task.STATUS_DOING.id,isVisible:true},
            {id:Tugboat.constant.task.STATUS_DONE.id, isVisible:true}
          ],
          nodeLevel:1
        },
        { id : self.FOLDER_WEEK.id,
          value:self.FOLDER_WEEK.value, 
          statusId : 1,
          selectedStyle : self.STYLE_FOLDER_WEEK.SELECT,
          defaultStyle  : self.STYLE_FOLDER_WEEK.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_WEEK.OVER, 
          status:[
            {id:Tugboat.constant.task.STATUS_ALL.id,  isVisible:false},
            {id:Tugboat.constant.task.STATUS_TODO.id, isVisible:true },
            {id:Tugboat.constant.task.STATUS_DOING.id,isVisible:false},
            {id:Tugboat.constant.task.STATUS_DONE.id, isVisible:false}
          ],
          nodeLevel:1
        },
        { id : self.FOLDER_MONTH.id,
          value:self.FOLDER_MONTH.value, 
          statusId : 1,
          selectedStyle : self.STYLE_FOLDER_MONTH.SELECT,
          defaultStyle  : self.STYLE_FOLDER_MONTH.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_MONTH.OVER, 
          status:[
            {id:Tugboat.constant.task.STATUS_ALL.id,  isVisible:false},
            {id:Tugboat.constant.task.STATUS_TODO.id, isVisible:true },
            {id:Tugboat.constant.task.STATUS_DOING.id,isVisible:false},
            {id:Tugboat.constant.task.STATUS_DONE.id, isVisible:false}
          ],
          nodeLevel:1
        },
        { id : self.FOLDER_HOLD.id,
          value:self.FOLDER_HOLD.value,
          statusId : 1,
          selectedStyle : self.STYLE_FOLDER_HOLD.SELECT,
          defaultStyle  : self.STYLE_FOLDER_HOLD.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_HOLD.OVER,
          status:[
            {id:Tugboat.constant.task.STATUS_ALL.id,  isVisible:true },
            {id:Tugboat.constant.task.STATUS_TODO.id, isVisible:true },
            {id:Tugboat.constant.task.STATUS_DOING.id,isVisible:false},
            {id:Tugboat.constant.task.STATUS_DONE.id, isVisible:true }
          ],
          nodeLevel:1
        },
        { id : self.FOLDER_SOMEDAY.id,
          value:self.FOLDER_SOMEDAY.value,
          statusId : 1,
          selectedStyle : self.STYLE_FOLDER_SOMEDAY.SELECT,
          defaultStyle  : self.STYLE_FOLDER_SOMEDAY.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_SOMEDAY.OVER, 
          status:[
            {id:Tugboat.constant.task.STATUS_ALL.id,  isVisible:false},
            {id:Tugboat.constant.task.STATUS_TODO.id, isVisible:true },
            {id:Tugboat.constant.task.STATUS_DOING.id,isVisible:false},
            {id:Tugboat.constant.task.STATUS_DONE.id, isVisible:false}
          ],
          nodeLevel:1
        },
        { id : self.FOLDER_ARCHIVES.id,
          value:self.FOLDER_ARCHIVES.value,
          statusId : 3,
          selectedStyle : self.STYLE_FOLDER_ARCHIVES.SELECT,
          defaultStyle  : self.STYLE_FOLDER_ARCHIVES.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_ARCHIVES.OVER, 
          status:[
            {id:Tugboat.constant.task.STATUS_ALL.id,  isVisible:false},
            {id:Tugboat.constant.task.STATUS_TODO.id, isVisible:false},
            {id:Tugboat.constant.task.STATUS_DOING.id,isVisible:false},
            {id:Tugboat.constant.task.STATUS_DONE.id, isVisible:true }
          ],
          nodeLevel:1
        },
        { id : self.FOLDER_TRASH_BOX.id,
          value:self.FOLDER_TRASH_BOX.value,
          statusId : 1,
          selectedStyle : self.STYLE_FOLDER_TRASH_BOX.SELECT,
          defaultStyle  : self.STYLE_FOLDER_TRASH_BOX.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_TRASH_BOX.OVER, 
          status:[
            {id:Tugboat.constant.task.STATUS_ALL.id,  isVisible:false},
            {id:Tugboat.constant.task.STATUS_TODO.id, isVisible:true },
            {id:Tugboat.constant.task.STATUS_DOING.id,isVisible:false},
            {id:Tugboat.constant.task.STATUS_DONE.id, isVisible:false}
          ],
          nodeLevel:1
        },
        //sub folders.
        { id : self.FOLDER_TODAY_TODO.id,
          value:self.FOLDER_TODAY_TODO.value,
          statusId : 1,
          selectedStyle : self.STYLE_FOLDER_TODAY_TODO.SELECT,
          defaultStyle  : self.STYLE_FOLDER_TODAY_TODO.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_TODAY_TODO.OVER,
          nodeLevel:2, parentNodeName:self.FOLDER_TODAY.id, parentNodeValue:1
        },
        { id : self.FOLDER_TODAY_DOING.id,
          value:self.FOLDER_TODAY_DOING.value,
          statusId : 2,
          selectedStyle : self.STYLE_FOLDER_TODAY_DOING.SELECT,
          defaultStyle  : self.STYLE_FOLDER_TODAY_DOING.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_TODAY_DOING.OVER,
          nodeLevel:2, parentNodeName:self.FOLDER_TODAY.id, parentNodeValue:1
        },
        { id : self.FOLDER_TODAY_DONE.id,
          value:self.FOLDER_TODAY_DONE.value,
          statusId : 3,
          selectedStyle : self.STYLE_FOLDER_TODAY_DONE.SELECT,
          defaultStyle  : self.STYLE_FOLDER_TODAY_DONE.DEFAULT,
          dragOverStyle : self.STYLE_FOLDER_TODAY_DONE.OVER,
          nodeLevel:2, parentNodeName:self.FOLDER_TODAY.id, parentNodeValue:1
        },
        
        // today's pane 
        { id : 'list_top_folder_today',
          value:self.FOLDER_TODAY_TODO.value,
          statusId : 1,
          selectedStyle : self.STYLE_PANE_TODAY_TODO.SELECT,
          defaultStyle  : self.STYLE_PANE_TODAY_TODO.DEFAULT,
          dragOverStyle : self.STYLE_PANE_TODAY_TODO.OVER,
          nodeLevel:2, parentNodeName:self.FOLDER_TODAY.id, parentNodeValue:1
        },
        { id : 'list_middle_folder_today',
          value:self.FOLDER_TODAY_DOING.value,
          statusId : 2,
          selectedStyle : self.STYLE_PANE_TODAY_DOING.SELECT,
          defaultStyle  : self.STYLE_PANE_TODAY_DOING.DEFAULT,
          dragOverStyle : self.STYLE_PANE_TODAY_DOING.OVER,
          nodeLevel:2, parentNodeName:self.FOLDER_TODAY.id, parentNodeValue:1
        },
        { id : 'list_bottom_folder_today',
          value:self.FOLDER_TODAY_DONE.value,
          statusId : 3,
          selectedStyle : self.STYLE_PANE_TODAY_DONE.SELECT,
          defaultStyle  : self.STYLE_PANE_TODAY_DONE.DEFAULT,
          dragOverStyle : self.STYLE_PANE_TODAY_DONE.OVER,
          nodeLevel:2, parentNodeName:self.FOLDER_TODAY.id, parentNodeValue:1
        },
        
        // hold's pane
        { id : 'list_top_folder_hold',
          value:self.FOLDER_HOLD_TODO.value,
          statusId : 1,
          selectedStyle : self.STYLE_PANE_HOLD_TODO.SELECT,
          defaultStyle  : self.STYLE_PANE_HOLD_TODO.DEFAULT,
          dragOverStyle : self.STYLE_PANE_HOLD_TODO.OVER,
          nodeLevel:2, parentNodeName:self.FOLDER_HOLD.id, parentNodeValue:4
        },
        { id : 'list_bottom_folder_hold',
          value:self.FOLDER_HOLD_DONE.value,
          statusId : 3,
          selectedStyle : self.STYLE_PANE_HOLD_DONE.SELECT,
          defaultStyle  : self.STYLE_PANE_HOLD_DONE.DEFAULT,
          dragOverStyle : self.STYLE_PANE_HOLD_DONE.OVER,
          nodeLevel:2, parentNodeName:self.FOLDER_HOLD.id, parentNodeValue:4
        }
      ];
      return styles;
    },
    
    droppableFolderRules : function() {
      var self = Tugboat.constant.task;
      var droppableFolderRules = 
      [
        { selectedFolderId:self.FOLDER_TODAY.id,
          draggableAllowFolders:[
            {id:self.FOLDER_TODAY_TODO.id   },
            {id:self.FOLDER_TODAY_DOING.id  },
            {id:self.FOLDER_TODAY_DONE.id   },
            {id:self.FOLDER_WEEK.id         },
            {id:self.FOLDER_MONTH.id        },
            {id:self.FOLDER_HOLD.id         },
            {id:self.FOLDER_SOMEDAY.id      },
            {id:self.FOLDER_INBOX.id        },
            {id:self.FOLDER_TRASH_BOX.id    },
            {id:'list_top'              },
            {id:'list_middle'           },
            {id:'list_bottom'           }
          ]
        },
        { selectedFolderId:self.FOLDER_ALL.id,
          draggableAllowFolders:[
            {id:self.FOLDER_TODAY.id      },          
            {id:self.FOLDER_TODAY_TODO.id },
            {id:self.FOLDER_TODAY_DOING.id},
            {id:self.FOLDER_TODAY_DONE.id },
            {id:self.FOLDER_WEEK.id       },
            {id:self.FOLDER_MONTH.id      },
            {id:self.FOLDER_HOLD.id       },
            {id:self.FOLDER_SOMEDAY.id    },
            {id:self.FOLDER_INBOX.id      },
            {id:self.FOLDER_TRASH_BOX.id  }
          ]
        },
        { selectedFolderId:self.FOLDER_WEEK.id,     
          draggableAllowFolders:[
            {id:self.FOLDER_TODAY.id      },
            {id:self.FOLDER_TODAY_TODO.id },
            {id:self.FOLDER_TODAY_DOING.id},
            {id:self.FOLDER_TODAY_DONE.id },
            {id:self.FOLDER_MONTH.id      },
            {id:self.FOLDER_HOLD.id       },
            {id:self.FOLDER_SOMEDAY.id    },
            {id:self.FOLDER_INBOX.id      },
            {id:self.FOLDER_TRASH_BOX.id  }
          ]
        },
        { selectedFolderId:self.FOLDER_MONTH.id,     
          draggableAllowFolders:[
            {id:self.FOLDER_TODAY.id      },
            {id:self.FOLDER_TODAY_TODO.id },
            {id:self.FOLDER_TODAY_DOING.id},
            {id:self.FOLDER_TODAY_DONE.id },
            {id:self.FOLDER_WEEK.id       },
            {id:self.FOLDER_HOLD.id       },
            {id:self.FOLDER_SOMEDAY.id    },
            {id:self.FOLDER_INBOX.id      },
            {id:self.FOLDER_TRASH_BOX.id  }
          ]
        },
        { selectedFolderId:self.FOLDER_HOLD.id,     
          draggableAllowFolders:[
            {id:self.FOLDER_TODAY.id      },
            {id:self.FOLDER_TODAY_TODO.id },
            {id:self.FOLDER_TODAY_DOING.id},
            {id:self.FOLDER_TODAY_DONE.id },
            {id:self.FOLDER_WEEK.id       },
            {id:self.FOLDER_MONTH.id      },
            {id:self.FOLDER_SOMEDAY.id    },
            {id:self.FOLDER_INBOX.id      },
            {id:self.FOLDER_TRASH_BOX.id  },
            {id:'list_top'            },
            {id:'list_bottom'         }
          ]
        },
        { selectedFolderId:self.FOLDER_SOMEDAY.id,  
          draggableAllowFolders:[
            {id:self.FOLDER_TODAY.id      },
            {id:self.FOLDER_TODAY_TODO.id },
            {id:self.FOLDER_TODAY_DOING.id},
            {id:self.FOLDER_TODAY_DONE.id },
            {id:self.FOLDER_WEEK.id       },
            {id:self.FOLDER_MONTH.id      },
            {id:self.FOLDER_HOLD.id       },
            {id:self.FOLDER_INBOX.id      },
            {id:self.FOLDER_TRASH_BOX.id  }
          ]
        },
        { selectedFolderId:self.FOLDER_INBOX.id,    
          draggableAllowFolders:[
            {id:self.FOLDER_TODAY.id      },
            {id:self.FOLDER_TODAY_TODO.id },
            {id:self.FOLDER_TODAY_DOING.id},
            {id:self.FOLDER_TODAY_DONE.id },
            {id:self.FOLDER_WEEK.id       },
            {id:self.FOLDER_MONTH.id      },
            {id:self.FOLDER_HOLD.id       },
            {id:self.FOLDER_SOMEDAY.id    },
            {id:self.FOLDER_TRASH_BOX.id  }
          ]
        },
        { selectedFolderId:self.FOLDER_TRASH_BOX.id,
          draggableAllowFolders:[
            {id:self.FOLDER_TODAY.id      },
            {id:self.FOLDER_TODAY_TODO.id },
            {id:self.FOLDER_TODAY_DOING.id},
            {id:self.FOLDER_TODAY_DONE.id },
            {id:self.FOLDER_WEEK.id       },
            {id:self.FOLDER_MONTH.id      },
            {id:self.FOLDER_HOLD.id       },
            {id:self.FOLDER_SOMEDAY.id    },
            {id:self.FOLDER_INBOX.id      }
          ]
        },
        // this rule is when selected tags.
        { selectedFolderId:'',
          draggableAllowFolders:[
            {id:self.FOLDER_TODAY.id      },
            {id:self.FOLDER_TODAY_TODO.id },
            {id:self.FOLDER_TODAY_DOING.id},
            {id:self.FOLDER_TODAY_DONE.id },
            {id:self.FOLDER_WEEK.id       },
            {id:self.FOLDER_MONTH.id      },
            {id:self.FOLDER_HOLD.id       },
            {id:self.FOLDER_SOMEDAY.id    },
            {id:self.FOLDER_INBOX.id      }
          ]
        }
      ];
      return droppableFolderRules;
    },
    
    /**
     * get block style.
     * @param {Object} statusId
     * @param {Object} classId
     * @param {Object} isMe
     * @param {Object} isTasks
     */
    blockStyle : function(statusId, classId, isMe, isTasks) {
      var self = Tugboat.constant.task;
      var task_block_styles =
      [
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_TODAY.id,    isMe:true,  isTasks:true,  class_name:'task today_todo'                  },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_TODAY.id,    isMe:false, isTasks:true,  class_name:'task today_todo_another another'  },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_TODAY.id,    isMe:true,  isTasks:false, class_name:'task today_todo'                  },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_TODAY.id,    isMe:false, isTasks:false, class_name:'task today_todo_another another'  },
        { status_id:self.STATUS_DOING.id, class_id :self.CLASS_TODAY.id,    isMe:true,  isTasks:true,  class_name:'task today_doing'                 },
        { status_id:self.STATUS_DOING.id, class_id :self.CLASS_TODAY.id,    isMe:false, isTasks:true,  class_name:'task today_doing_another another' },
        { status_id:self.STATUS_DOING.id, class_id :self.CLASS_TODAY.id,    isMe:true,  isTasks:false, class_name:'task today_doing'                 },
        { status_id:self.STATUS_DOING.id, class_id :self.CLASS_TODAY.id,    isMe:false, isTasks:false, class_name:'task today_doing_another another' },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_TODAY.id,    isMe:true,  isTasks:false, class_name:'task today_done'                  },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_TODAY.id,    isMe:true,  isTasks:true,  class_name:'task today_done'                  },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_TODAY.id,    isMe:false, isTasks:false, class_name:'task today_done_another another'  },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_TODAY.id,    isMe:false, isTasks:true,  class_name:'task today_done_another another'  },
        
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_WEEK.id,     isMe:true,  isTasks:true,  class_name:'task week_todo'                   },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_WEEK.id,     isMe:false, isTasks:true,  class_name:'task week_todo_another another'   },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_WEEK.id,     isMe:true,  isTasks:false, class_name:'task week_todo'                   },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_WEEK.id,     isMe:false, isTasks:false, class_name:'task week_todo_another another'   },
        
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_MONTH.id,    isMe:true,  isTasks:true,  class_name:'task month_todo'                  },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_MONTH.id,    isMe:false, isTasks:true,  class_name:'task month_todo_another another'  },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_MONTH.id,    isMe:true,  isTasks:false, class_name:'task month_todo'                  },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_MONTH.id,    isMe:false, isTasks:false, class_name:'task month_todo_another another'  },
        
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_HOLD.id,     isMe:true,  isTasks:true,  class_name:'task hold_todo'                   },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_HOLD.id,     isMe:false, isTasks:true,  class_name:'task hold_todo_another another'   },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_HOLD.id,     isMe:true,  isTasks:false, class_name:'task hold_todo'                   },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_HOLD.id,     isMe:false, isTasks:false, class_name:'task hold_todo_another another'   },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_HOLD.id,     isMe:true,  isTasks:false, class_name:'task hold_done'                   },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_HOLD.id,     isMe:true,  isTasks:true,  class_name:'task hold_done'                   },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_HOLD.id,     isMe:false, isTasks:false, class_name:'task hold_done_another another'   },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_HOLD.id,     isMe:false, isTasks:true,  class_name:'task hold_done_another another'   },
        
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_SOMEDAY.id,  isMe:true,  isTasks:true,  class_name:'task someday_todo'                },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_SOMEDAY.id,  isMe:false, isTasks:true,  class_name:'task someday_todo_another another'},
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_SOMEDAY.id,  isMe:true,  isTasks:false, class_name:'task someday_todo'                },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_SOMEDAY.id,  isMe:false, isTasks:false, class_name:'task someday_todo_another another'},
        
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_INBOX.id,    isMe:true,  isTasks:false, class_name:'task inbox_todo'                  },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_INBOX.id,    isMe:true,  isTasks:true,  class_name:'task inbox_todo'                  },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_INBOX.id,    isMe:false, isTasks:false, class_name:'task inbox_todo_another another'  },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_INBOX.id,    isMe:false, isTasks:true,  class_name:'task inbox_todo_another another'  },
        
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_ARCHIVES.id, isMe:true,  isTasks:false, class_name:'task archives'                    },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_ARCHIVES.id, isMe:true,  isTasks:true,  class_name:'task archives'                    },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_ARCHIVES.id, isMe:false, isTasks:false, class_name:'task archives_another another'    },
        { status_id:self.STATUS_DONE.id,  class_id :self.CLASS_ARCHIVES.id, isMe:false, isTasks:true,  class_name:'task archives_another another'    },
        
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_TRASH_BOX.id,isMe:true,  isTasks:false, class_name:'task trash_box'                   },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_TRASH_BOX.id,isMe:true,  isTasks:true,  class_name:'task trash_box'                   },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_TRASH_BOX.id,isMe:false, isTasks:false, class_name:'task trash_box_another another'   },
        { status_id:self.STATUS_TODO.id,  class_id :self.CLASS_TRASH_BOX.id,isMe:false, isTasks:true,  class_name:'task trash_box_another another'   }
      ];
      
      var result = 
        task_block_styles.find(
          function(s) {
            return (statusId==s.status_id && classId==s.class_id && isMe==s.isMe && isTasks==s.isTasks);
          }
        );
      return result;
    },
    
    STYLE_LIST_TOP    : 1,
    STYLE_LIST_MIDDLE : 2,
    STYLE_LIST_BOTTOM : 3,
    
    /**
     * get top style of a list.
     * @param {String} id
     * @param {Number} rowType - [1:top, 2:middle, 3:bottom]
     */
    listStyle : function(id, rowType) {
      var self = Tugboat.constant.task;
      var topStyles = [
          'folder_inbox'
         ,'folder_all'
         ,'folder_today'
         ,'folder_week'
         ,'folder_month'
         ,'folder_hold'
         ,'folder_someday'
         ,'folder_trash'
         ,''
      ];
      var middleStyles = [
          'folder_all'
         ,'folder_today'
         ,''
      ];
      var bottomStyles = [
          'folder_all'
         ,'folder_today'
         ,'folder_hold'
         ,'folder_archives'
         ,''
      ];
      var styles = (rowType == self.STYLE_LIST_TOP    ? topStyles    :
                    rowType == self.STYLE_LIST_MIDDLE ? middleStyles 
                                                      : bottomStyles);
      var isExists = false;
      for (i=0; i<styles.length; i++) {
        if (id==styles[i]) {
          isExists = true;
          break;
        }
      }
      return isExists ? Tugboat.constant.STYLE_DISPLAY_BLOCK 
                       : Tugboat.constant.STYLE_DISPLAY_NONE;
    },
    
    /**
     * get default browser statuses.
     */
    getDefaultStatuses : function() {
      var statuses = [];
      statuses[0] = {'id':0,'checked':true};
      statuses[1] = {'id':1,'checked':false};
      statuses[2] = {'id':2,'checked':false};
      statuses[3] = {'id':3,'checked':false};
      
      return statuses;
    },
    
    /**
     * get default classifications.
     */
    getDefaultClassifications : function() {
      var classifications = [];
      classifications[0]  = {'id':0, 'checked':true};
      classifications[1]  = {'id':1, 'checked':false};
      classifications[2]  = {'id':2, 'checked':false};
      classifications[3]  = {'id':3, 'checked':false};
      classifications[4]  = {'id':4, 'checked':false};
      classifications[5]  = {'id':5, 'checked':false};
      classifications[9]  = {'id':9, 'checked':false};
      classifications[21] = {'id':21,'checked':false};
      classifications[99] = {'id':99,'checked':false};
      return classifications;
    },
    
    /**
     * get default activities.
     */
    getDefaultActivities : function() {
      var activities = [];
      activities.push({'id':0,'checked':true});
      return activities;
    }
  },
  
  /*
   * meeting.
   * 
   */
  meeting : {
    FOLDER_ALL          : 'folder_all',
    FOLDER_ARCHIVES     : 'folder_archives'
  },
  
  /*
   * activity.
   * 
   */
  activity : {
    flags :
    [
      { id:1,  value:'Red',         icon:'images/default/palette/pl_bg_ff0000.gif'},
      { id:2,  value:'Orange',      icon:'images/default/palette/pl_bg_ff8000.gif'},
      { id:3,  value:'Yellow',      icon:'images/default/palette/pl_bg_ffff00.gif'},
      { id:4,  value:'Lime',        icon:'images/default/palette/pl_bg_80ff00.gif'},
      { id:5,  value:'Green',       icon:'images/default/palette/pl_bg_00ff00.gif'},
      { id:6,  value:'Aqua',        icon:'images/default/palette/pl_bg_00ffff.gif'},
      { id:7,  value:'Sky',         icon:'images/default/palette/pl_bg_0080ff.gif'},
      { id:8,  value:'Blue',        icon:'images/default/palette/pl_bg_0000ff.gif'},
      { id:9,  value:'Purple',      icon:'images/default/palette/pl_bg_8000ff.gif'},
      { id:10, value:'Pink',        icon:'images/default/palette/pl_bg_ff00ff.gif'},
      { id:11, value:'Dark red',    icon:'images/default/palette/pl_bg_660000.gif'},
      { id:12, value:'Dark orange', icon:'images/default/palette/pl_bg_663300.gif'},
      { id:13, value:'Dark yellow', icon:'images/default/palette/pl_bg_666600.gif'},
      { id:14, value:'Dark lime',   icon:'images/default/palette/pl_bg_336600.gif'},
      { id:15, value:'Dark green',  icon:'images/default/palette/pl_bg_006600.gif'},
      { id:16, value:'Dark aqua',   icon:'images/default/palette/pl_bg_006666.gif'},
      { id:17, value:'Dark blue',   icon:'images/default/palette/pl_bg_000066.gif'},
      { id:18, value:'Dark pink',   icon:'images/default/palette/pl_bg_660066.gif'}
    ],
    roles :
    [
      {id:1, value:'Owner', icon:'images/default/icon/contact_admin.gif'},
      {id:2, value:'User',  icon:'images/default/icon/contact_known.gif'}
    ],
    email : {
      ACTIVE   : {id:1, icon:'images/default/icon/email.gif'},
      INACTIVE : {id:2, icon:'images/default/icon/email_disable.gif'}
    }
  }
};