--
-- taskRelationsDao.getRowsByHasTags
--
SELECT COUNT(*) AS RECORDS
FROM (
    SELECT
        R.*
    FROM
        task_relations R
        INNER JOIN tasks                   T  ON R.TASK_ID           = T.ID
        INNER JOIN activities              V  ON R.ACTIVITY_ID       = V.ID
        INNER JOIN activity_members        Y  ON V.ID                = Y.ACTIVITY_ID
                                             AND Y.USER_ID           = /*condition.userId*/1
        INNER JOIN classifications         C  ON R.CLASSIFICATION_ID = C.ID
        INNER JOIN alerts                  A  ON R.ALERT_ID          = A.ID
        INNER JOIN activity_relations      I  ON R.ACTIVITY_ID       = I.ACTIVITY_ID
                                             AND I.USER_ID           = /*condition.userId*/1
        INNER JOIN activity_colors         O  ON I.COLOR_ID          = O.ID
        LEFT  JOIN users                   U1 ON R.PERSON_ID         = U1.ID
        INNER JOIN users                   U2 ON R.POSTED_USER_ID    = U2.ID
    WHERE
        T.DEL_FLAG = '0'
    /*IF condition.taskIds != null*/  AND R.TASK_ID IN /*condition.taskIds*/(31,32)/*END*/
    ) RESULT