--
-- select person in charge by own activities.
--
SELECT
    R.PERSON_ID
   ,coalesce(U.FIRST_NAME, '') AS PERSON_FIRST_NAME
   ,coalesce(U.LAST_NAME, '' ) AS PERSON_LAST_NAME
FROM
    task_relations R
    LEFT JOIN users U ON R.PERSON_ID = U.ID	
WHERE
    R.ACTIVITY_ID IN (
        SELECT DISTINCT 
            ACTIVITY_ID
        FROM
            activity_members M
        WHERE
            M.USER_ID = /*userId*/1
    )
GROUP BY
    R.PERSON_ID, FIRST_NAME, LAST_NAME
ORDER BY 
    R.PERSON_ID