--
-- select person in charge by activity id.
--
SELECT 
    R.PERSON_ID
   ,CASE WHEN U.LAST_NAME  IS NULL THEN '' ELSE U.LAST_NAME  END AS PERSON_LAST_NAME
   ,CASE WHEN U.FIRST_NAME IS NULL THEN '' ELSE U.FIRST_NAME END AS PERSON_FIRST_NAME 
FROM 
    task_relations R
    LEFT JOIN users U ON R.PERSON_ID = U.ID 
WHERE
    ACTIVITY_ID IN /*activityIds*/(1,5,6) 
GROUP BY
    R.PERSON_ID, U.LAST_NAME, U.FIRST_NAME 
ORDER BY 
    R.PERSON_ID