--
-- taskRelatiosDao.findTaskIdsByHasTags.
--
SELECT
    T.ID AS TASK_ID
FROM
    task_relations R
    INNER JOIN tasks                   T  ON R.TASK_ID           = T.ID
    INNER JOIN activities              V  ON R.ACTIVITY_ID       = V.ID
    INNER JOIN activity_members        Y  ON V.ID                = Y.ACTIVITY_ID
                                         AND Y.USER_ID           = /*condition.userId*/1
WHERE
    T.DEL_FLAG = '0'
AND R.TASK_ID IN (
    SELECT T.task_id FROM task_tags T
    WHERE
        T.user_id = /*condition.userId*/1
    /*IF tagIds != null*/ AND T.tag_id IN /*condition.tagIds*/(1,2)/*END*/
    GROUP BY
        T.task_id
    )
ORDER BY
    R.CLASSIFICATION_ID
   ,R.STATUS_ID
   ,T.DEAD_LINE
   ,R.ACTIVITY_ID
   ,R.ID