--
-- select calendar task history by task id.
--
SELECT 
    H.ID
   ,H.TASK_ID
   ,H.STATUS_ID
   ,S.VALUE      AS STATUS_VALUE
   ,S.VALUE_I18N AS STATUS_VALUE_I18N
   ,H.REGISTERED
   ,H.USER_ID
   ,U.FIRST_NAME
   ,U.LAST_NAME
FROM
    task_histories H
    INNER JOIN tasks T         ON H.TASK_ID   = T.ID
    INNER JOIN task_statuses S ON H.STATUS_ID = S.ID
    INNER JOIN users U         ON H.USER_ID   = U.ID
WHERE
    H.TASK_ID = /*taskId*/1
ORDER BY
    H.ID DESC