--
-- select meeting count by query params.
--
SELECT
    COUNT(*) AS ROW_COUNT
FROM (
    SELECT DISTINCT B.ID
    FROM
        meeting_basics B
        INNER JOIN activity_members M          ON B.ACTIVITY_ID    = M.ACTIVITY_ID
        INNER JOIN users U                     ON B.POSTED_USER_ID = U.ID
        LEFT OUTER JOIN activity_relations A   ON M.ACTIVITY_ID    = A.ACTIVITY_ID
                                              AND M.USER_ID        = A.USER_ID
        LEFT OUTER JOIN activity_colors C      ON A.COLOR_ID       = C.ID
    WHERE
        M.USER_ID=/*condition.userId*/1
    AND B.DEL_FLAG = '0'
    /*IF condition.queryStatusIds         != null*/AND B.STATUS_ID      IN /*condition.queryStatusIds      */(1) /*END*/
    /*IF condition.queryActivityIds       != null*/AND M.ACTIVITY_ID    IN /*condition.queryActivityIds    */(1) /*END*/
    /*IF condition.queryRegistrationIds   != null*/AND B.POSTED_USER_ID IN /*condition.queryRegistrationIds*/(1) /*END*/
    ) AS A