--
-- find meeting basics by user id.
--
SELECT DISTINCT
    B.ID
   ,B.ACTIVITY_ID
   ,A.NAME AS ACTIVITY_NAME
   ,B.STATUS_ID
   ,B.TITLE
   ,B.START_DATE
   ,B.POSTED_USER_ID
   ,B.DEL_FLAG
   ,B.REGISTERED
   ,B.MODIFIED
   ,O.BODY AS BODY
   ,U.FIRST_NAME
   ,U.LAST_NAME
   ,C.COLOR
FROM
    meeting_basics B
    INNER JOIN activity_members M        ON B.ACTIVITY_ID    = M.ACTIVITY_ID
    INNER JOIN meeting_basic_bodies O    ON B.ID             = O.BASIC_ID
    INNER JOIN users U                   ON B.POSTED_USER_ID = U.ID
    INNER JOIN activity_relations R      ON M.ACTIVITY_ID    = R.ACTIVITY_ID
                                        AND M.USER_ID        = R.USER_ID
    INNER JOIN activities A              ON R.ACTIVITY_ID    = A.ID
    INNER JOIN activity_colors C         ON R.COLOR_ID       = C.ID
WHERE
    M.USER_ID=/*condition.userId*/1
AND B.DEL_FLAG = '0'
/*IF condition.queryStatusIds         != null*/AND B.STATUS_ID      IN /*condition.queryStatusIds      */(1) /*END*/
/*IF condition.queryActivityIds       != null*/AND M.ACTIVITY_ID    IN /*condition.queryActivityIds    */(1) /*END*/
/*IF condition.queryRegistrationIds   != null*/AND B.POSTED_USER_ID IN /*condition.queryRegistrationIds*/(1) /*END*/
ORDER BY
    B.STATUS_ID
   ,B.REGISTERED
   ,B.ACTIVITY_ID
LIMIT  /*condition.limit*/20
OFFSET /*condition.offset*/0