--
-- find meeting agendas with discussion by meeting id and agenda id.
--
SELECT
     A.ID
    ,A.PRIORITY
    ,A.POSTED_USER_ID
    ,A.DEL_FLAG
    ,A.REGISTERED
    ,A.MODIFIED
    ,A.MODIFIED_USER_ID
    ,G.BODY
    ,D.ID                AS AGENDA_DISCUSSION_ID
    ,D.TYPE
    ,D.POSTED_USER_ID    AS AGENDA_DISCUSSION_POSTED_USER_ID
    ,S.FIRST_NAME        AS AGENDA_DISCUSSION_FIRST_NAME
    ,S.LAST_NAME         AS AGENDA_DISCUSSION_LAST_NAME
    ,D.REGISTERED        AS AGENDA_DISCUSSION_REGISTERED
    ,D.MODIFIED          AS AGENDA_DISCUSSION_MODIFIED
    ,D.MODIFIED_USER_ID  AS AGENDA_DISCUSSION_MODIFIED_USER_ID
    ,I.BODY              AS AGENDA_DISCUSSION_BODY
    ,U.FIRST_NAME
    ,U.LAST_NAME
    ,K.TASK_ID
    ,K.TASK_TITLE
    ,K.TASK_DEAD_LINE
    ,K.TASK_DESCRIPTION
    ,K.TASK_PERSON_ID
    ,K.TASK_PERSON_FIRST_NAME
    ,K.TASK_PERSON_LAST_NAME
    ,K.TASK_STATUS_ID
    ,K.TASK_CLASSIFICATION_ID
    ,K.TASK_CLASSIFICATION_VALUE
FROM
    meeting_basics B
    INNER JOIN meeting_relations R                     ON B.ID             = R.BASIC_ID
                                                      AND R.BASIC_ID       = /*meetingId*/2
                                                      AND R.AGENDA_ID      = /*agendaId*/4
    INNER JOIN meeting_agendas A                       ON A.DEL_FLAG       = '0'
                                                      AND R.AGENDA_ID      = A.ID
    INNER JOIN meeting_agenda_bodies G                 ON R.AGENDA_ID      = G.AGENDA_ID
    LEFT OUTER JOIN users U                            ON A.POSTED_USER_ID = U.ID
    LEFT OUTER JOIN meeting_agenda_discussions D       ON D.DEL_FLAG       = '0'
                                                      AND A.ID             = D.AGENDA_ID
    LEFT OUTER JOIN meeting_agenda_discussion_bodies I ON D.ID             = I.DISCUSSION_ID
    LEFT OUTER JOIN users S                            ON D.POSTED_USER_ID = S.ID
    LEFT OUTER JOIN
    (
      SELECT
         MT.DISCUSSION_ID
        ,TA.ID                AS TASK_ID
        ,TA.TITLE             AS TASK_TITLE
        ,TA.DEAD_LINE         AS TASK_DEAD_LINE
        ,TB.BODY              AS TASK_DESCRIPTION
        ,U.ID                 AS TASK_PERSON_ID
        ,U.FIRST_NAME         AS TASK_PERSON_FIRST_NAME
        ,U.LAST_NAME          AS TASK_PERSON_LAST_NAME
        ,TR.STATUS_ID         AS TASK_STATUS_ID
        ,TR.CLASSIFICATION_ID AS TASK_CLASSIFICATION_ID
        ,C.VALUE              AS TASK_CLASSIFICATION_VALUE
      FROM
        meeting_to_tasks          MT
        INNER JOIN tasks          TA ON MT.BASIC_ID = /*meetingId*/2
                                    AND MT.AGENDA_ID = /*agendaId*/4
                                    AND MT.TASK_ID = TA.ID
        INNER JOIN task_relations TR ON TA.ID   = TR.TASK_ID
                                    AND TR.CLASSIFICATION_ID <> 99
        INNER JOIN classifications C ON TR.CLASSIFICATION_ID = C.ID
        INNER JOIN task_bodies    TB ON TA.ID   = TB.TASK_ID
        INNER JOIN users          U  ON TR.PERSON_ID = U.ID
    ) K ON D.ID = K.DISCUSSION_ID 
ORDER BY
    A.ID
   ,D.ID