--
-- find discussion relation by id.
--
SELECT 
     D.ID              
    ,D.AGENDA_ID 
    ,D.TYPE 
    ,D.POSTED_USER_ID  
    ,D.DEL_FLAG  
    ,D.REGISTERED
    ,D.MODIFIED        
    ,D.MODIFIED_USER_ID
    ,B.BODY
    ,S.ID AS BASIC_ID
    ,S.ACTIVITY_ID 
    ,U.FIRST_NAME
    ,U.LAST_NAME
    ,T.TITLE AS TASK_TITLE
    ,TB.BODY AS TASK_DESCRIPTION
    ,TR.CLASSIFICATION_ID AS TASK_CLASSIFICATION_ID
    ,TR.STATUS_ID AS TASK_STATUS_ID
    ,TR.ACTIVITY_ID AS TASK_ACTIVITY_ID
    ,TR.PERSON_ID AS TASK_PERSON_ID
    ,T.DEAD_LINE AS TASK_DEAD_LINE
    ,C.VALUE AS TASK_CLASSIFICATION_VALUE
    ,P.FIRST_NAME AS TASK_PERSON_FIRST_NAME
    ,P.LAST_NAME AS TASK_PERSON_LAST_NAME
FROM 
    meeting_agenda_discussions D 
    INNER JOIN meeting_relations R                     ON D.AGENDA_ID = R.AGENDA_ID 
    INNER JOIN meeting_basics S                        ON R.BASIC_ID  = S.ID 
    LEFT OUTER JOIN meeting_agenda_discussion_bodies B ON D.ID = B.DISCUSSION_ID 
    LEFT OUTER JOIN users U                            ON D.POSTED_USER_ID = U.ID
    LEFT OUTER JOIN meeting_to_tasks M                 ON D.ID = M.DISCUSSION_ID
    LEFT OUTER JOIN tasks T                            ON M.TASK_ID = T.ID
    LEFT OUTER JOIN task_bodies TB                     ON T.ID = TB.TASK_ID
    LEFT OUTER JOIN task_relations TR                  ON T.ID = TR.TASK_ID
    LEFT OUTER JOIN classifications C                  ON TR.CLASSIFICATION_ID = C.ID
    LEFT OUTER JOIN users P                            ON TR.PERSON_ID = P.ID
WHERE
    D.ID  = /*id*/1