--
-- find by user id for timeline.
--
SELECT 
     D.ID     
    ,M.ACTIVITY_ID    
    ,R.BASIC_ID     
    ,D.AGENDA_ID 
    ,T.TASK_ID
    ,D.TYPE 
    ,B.BODY
    ,TT.TITLE AS TASK_TITLE
    ,TB.BODY  AS TASK_DESCRIPTION
    ,C.COLOR  AS COLOR_VALUE
    ,D.POSTED_USER_ID  
    ,D.REGISTERED      
FROM 
    meeting_agenda_discussions D 
    LEFT OUTER JOIN meeting_agenda_discussion_bodies B ON D.ID             = B.DISCUSSION_ID 
    INNER JOIN users U                                 ON D.POSTED_USER_ID = U.ID 
    INNER JOIN meeting_relations R                     ON D.AGENDA_ID      = R.AGENDA_ID
    INNER JOIN meeting_basics  M                       ON R.BASIC_ID       = M.ID
    LEFT OUTER JOIN meeting_to_tasks T                 ON R.BASIC_ID       = T.BASIC_ID
                                                      AND D.AGENDA_ID      = T.AGENDA_ID
                                                      AND D.ID             = T.DISCUSSION_ID
    LEFT OUTER JOIN tasks TT                           ON T.TASK_ID        = TT.ID
    LEFT OUTER JOIN task_bodies TB                     ON T.TASK_ID        = TB.TASK_ID
    INNER JOIN activity_relations A                    ON D.POSTED_USER_ID = A.USER_ID
                                                      AND A.USER_ID        = /*userId*/1
                                                      AND M.ACTIVITY_ID    = A.ACTIVITY_ID
    INNER JOIN activity_colors C                       ON A.COLOR_ID       = C.ID
WHERE
    D.POSTED_USER_ID = /*userId*/1
AND (D.TYPE = 1 OR D.TYPE = 5)
ORDER BY
    D.AGENDA_ID