--
-- activity members DAO.findActivityMembersSearch
--
SELECT
    A.ID
   ,A.ACTIVITY_ID
   ,A.USER_ID
   ,A.ROLE_ID
   ,R.NAME AS ROLE_NAME
   ,A.START_DATE
   ,A.END_DATE
   ,A.DEL_FLAG
   ,A.REGISTERED      
   ,A.MODIFIED
   ,A.MODIFIED_USER_ID
   ,M.LAST_NAME
   ,M.FIRST_NAME
   ,M.EMAIL
FROM
    activity_members A
    INNER JOIN users M ON A.USER_ID = M.ID
    INNER JOIN roles R ON A.ROLE_ID = R.ID
WHERE
    A.DEL_FLAG = '0'
AND A.ACTIVITY_ID IN (
    SELECT 
        ID
    FROM activities
    WHERE
        DEL_FLAG = '0'
    AND ( NAME LIKE /*keyword*/'%Proj%' OR ABBREVIATION LIKE /*keyword*/'%Proj%' )
    )
ORDER BY 
    A.ACTIVITY_ID
   ,A.USER_ID