--
-- tugboat.GTD PostgreSQL database 
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = true;
SET client_min_messages = ERROR;
SET escape_string_warning = off;

/*
 * Initalize Database
 */
CREATE LANGUAGE "plpgsql";

/*
 * Create TABLE
 */

CREATE TABLE activities (
    ID                       integer       NOT NULL
   ,NAME                     varchar(96)   NOT NULL   default 'Personal'
   ,ABBREVIATION             varchar(32)              default NULL
   ,DESCRIPTION              text
   ,STATUS                   char(1)       NOT NULL   default '0'
   ,START_DATE               char(8)                  default NULL
   ,END_DATE                 char(8)                  default NULL
   ,IS_SEND_MAIL             char(1)       NOT NULL   default '0'
   ,DEL_FLAG                 char(1)       NOT NULL   default '0'
   ,REGISTERED               char(14)      NOT NULL
   ,MODIFIED                 char(14)      NOT NULL
   ,MODIFIED_USER_ID         integer       NOT NULL
);

CREATE TABLE activity_colors (
    ID                       serial        NOT NULL
   ,COLOR                    char(6)       NOT NULL
   ,NAME                     varchar(24)             default NULL
);

CREATE TABLE activity_members (
    ID                       serial        NOT NULL
   ,ACTIVITY_ID              integer       NOT NULL
   ,USER_ID                  integer       NOT NULL
   ,ROLE_ID                  integer       NOT NULL   default '1'
   ,START_DATE               char(8)                  default NULL
   ,END_DATE                 char(8)                  default NULL
   ,DEL_FLAG                 char(1)       NOT NULL   default '0'
   ,REGISTERED               char(14)      NOT NULL
   ,MODIFIED                 char(14)      NOT NULL
   ,MODIFIED_USER_ID         integer       NOT NULL
);

CREATE TABLE activity_relations (
    ID                       serial        NOT NULL
   ,ACTIVITY_ID              integer       NOT NULL
   ,COLOR_ID                 integer       NOT NULL
   ,USER_ID                  integer       NOT NULL
   ,DISP_ORDER               integer       NOT NULL   default '1'
);

CREATE TABLE alerts (
    ID                       integer       NOT NULL
   ,VALUE                    varchar(64)   NOT NULL
   ,VALUE_I18N               varchar(64)   NOT NULL   default ' '
);

CREATE TABLE classifications (
    ID                       integer       NOT NULL
   ,TYPE                     char(1)       NOT NULL
   ,VALUE                    varchar(64)   NOT NULL
);

CREATE TABLE roles (
    ID                       integer       NOT NULL
   ,TYPE                     char(1)       NOT NULL
   ,NAME                     varchar(96)   NOT NULL
   ,DESCRIPTION              varchar(256)  NOT NULL 
);

CREATE TABLE task_bodies (
    ID                       serial        NOT NULL
   ,TASK_ID                  integer       NOT NULL
   ,REV                      integer       NOT NULL   default '1'
   ,BODY                     text          NOT NULL 
);

CREATE TABLE task_comment_bodies (
    ID                       serial        NOT NULL
   ,TASK_ID                  integer       NOT NULL
   ,COMMENT_ID               integer       NOT NULL
   ,REV                      integer       NOT NULL   default '1'
   ,BODY                     text          NOT NULL 
);

CREATE TABLE task_comments (
    ID                       integer       NOT NULL
   ,TASK_ID                  integer       NOT NULL
   ,USER_ID                  integer       NOT NULL
   ,REGISTERED               char(14)      NOT NULL 
);

CREATE TABLE task_histories (
    ID                      serial        NOT NULL
   ,TASK_ID                 integer       NOT NULL
   ,STATUS_ID               integer       NOT NULL
   ,REGISTERED              char(14)      NOT NULL
   ,USER_ID                 integer       NOT NULL 
);

CREATE TABLE task_member_roles (
    ID                      serial        NOT NULL
   ,ACTIVITY_MEMBER_ID      integer       NOT NULL
   ,TASK_ID                 integer       NOT NULL
   ,ROLE_ID                 integer       NOT NULL
);

CREATE TABLE task_relations (
    ID                      serial        NOT NULL
   ,TASK_ID                 integer       NOT NULL
   ,STATUS_ID               integer       NOT NULL
   ,ACTIVITY_ID             integer       NOT NULL
   ,CLASSIFICATION_ID       integer       NOT NULL
   ,ALERT_ID                integer       NOT NULL
   ,PERSON_ID               integer                  default NULL
   ,MANAGER_ID              integer                  default NULL
   ,POSTED_USER_ID          integer       NOT NULL
);

CREATE TABLE task_statuses (
    ID                       integer      NOT NULL
   ,VALUE                    varchar(64)  NOT NULL
   ,VALUE_I18N               varchar(64)  NOT NULL
);

CREATE TABLE task_to_tasks (
    ID                       serial       NOT NULL
   ,SRC_TASK_ID              integer      NOT NULL
   ,DEST_TASK_ID             integer      NOT NULL
);

CREATE TABLE tasks (
    ID                       integer      NOT NULL
   ,TITLE                    text         NOT NULL
   ,START_DATE               char(8)      NOT NULL
   ,START_YEAR               integer      NOT NULL
   ,START_MONTH              integer      NOT NULL
   ,START_DAY_OF_MONTH       integer      NOT NULL
   ,DEAD_LINE                char(8)                 default '99999999'
   ,DEAD_LINE_YEAR           integer                 default NULL
   ,DEAD_LINE_MONTH          integer                 default NULL
   ,DEAD_LINE_DAY_OF_MONTH   integer                 default NULL
   ,PRIORITY_ORDER           integer      NOT NULL
   ,DEL_FLAG                 char(1)      NOT NULL   default '0'
   ,REGISTERED               char(14)                default NULL
);

CREATE TABLE timezones (
    ID                       integer      NOT NULL
   ,TIMEZONE                 varchar(16)  NOT NULL
   ,OFFSET_TIME              integer      NOT NULL
   ,COUNTRY                  varchar(96)  NOT NULL
   ,COUNTRY_I18N             varchar(96)  NOT NULL
   ,DESCRIPTION              varchar(96)  NOT NULL
   ,DESCRIPTION_I18N         varchar(96)  NOT NULL
);

CREATE TABLE users (
    ID                       integer      NOT NULL
   ,LOGIN_ID                 varchar(64)  NOT NULL
   ,PASSWORD                 varchar(16)  NOT NULL
   ,EMAIL                    varchar(128) NOT NULL
   ,LAST_NAME                varchar(48)  NOT NULL
   ,MIDDLE_NAME              varchar(48)  NOT NULL   default ' '
   ,FIRST_NAME               varchar(48)  NOT NULL
   ,PHOTO_IMG_URL            varchar(128)            default NULL
   ,DEL_FLAG                 char(1)      NOT NULL   default '0'
   ,REGISTERED               char(14)     NOT NULL
   ,MODIFIED                 char(14)     NOT NULL
   ,MODIFIED_USER_ID         integer      NOT NULL
);

CREATE TABLE meeting_basics (
    ID                       integer      NOT NULL
   ,ACTIVITY_ID              integer      NOT NULL
   ,STATUS_ID                integer      NOT NULL   default '1'
   ,TITLE                    text         NOT NULL
   ,START_DATE               char(8)      NOT NULL
   ,DEL_FLAG                 char(1)      NOT NULL   default '0'
   ,POSTED_USER_ID           integer      NOT NULL
   ,REGISTERED               char(14)     NOT NULL
   ,MODIFIED                 char(14)     NOT NULL
);

CREATE TABLE meeting_agendas (
    ID                       integer      NOT NULL
   ,PRIORITY                 char(1)      NOT NULL
   ,POSTED_USER_ID           integer      NOT NULL
   ,DEL_FLAG                 char(1)      NOT NULL   default '0'
   ,REGISTERED               char(14)     NOT NULL
   ,MODIFIED                 char(14)     NOT NULL
   ,MODIFIED_USER_ID         integer      NOT NULL
);

CREATE TABLE meeting_agenda_discussions (
    ID                       integer      NOT NULL
   ,AGENDA_ID                integer      NOT NULL
   ,TYPE                     char(1)      NOT NULL
   ,POSTED_USER_ID           integer      NOT NULL
   ,DEL_FLAG                 char(1)      NOT NULL   default '0'
   ,REGISTERED               char(14)     NOT NULL
   ,MODIFIED                 char(14)     NOT NULL
   ,MODIFIED_USER_ID         integer      NOT NULL
);

CREATE TABLE meeting_relations (
    ID                       serial       NOT NULL
   ,BASIC_ID                 integer      NOT NULL
   ,AGENDA_ID                integer      NOT NULL
);

CREATE TABLE meeting_to_tasks (
    ID                       serial       NOT NULL
   ,BASIC_ID                 integer      NOT NULL
   ,AGENDA_ID                integer      NOT NULL
   ,DISCUSSION_ID            integer      NOT NULL
   ,TASK_ID                  integer      NOT NULL
);

CREATE TABLE meeting_basic_bodies (
    ID                       serial       NOT NULL
   ,BASIC_ID                 integer      NOT NULL
   ,REV                      integer      NOT NULL   default 1
   ,BODY                     TEXT         NOT NULL
);

CREATE TABLE meeting_agenda_bodies (
    ID                      serial        NOT NULL
   ,AGENDA_ID               integer       NOT NULL
   ,REV                     integer       NOT NULL   default 1
   ,BODY                    text          NOT NULL
);

CREATE TABLE meeting_agenda_discussion_bodies (
    ID                      serial        NOT NULL
   ,AGENDA_ID               integer       NOT NULL
   ,DISCUSSION_ID           integer       NOT NULL
   ,REV                     integer       NOT NULL   default 1
   ,BODY                    text          NOT NULL
);

CREATE TABLE tags (
    ID                      serial        NOT NULL
   ,VALUE                   varchar(64)   NOT NULL
);

CREATE TABLE task_tags (
    ID                      serial        NOT NULL
   ,TASK_ID                 integer       NOT NULL
   ,TAG_ID                  integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
   ,POSTED_AT               char(14)      NOT NULL
);

CREATE TABLE task_select_views (
    ID                      serial        NOT NULL
   ,MODE_ID                 integer       NOT NULL default 0 
   ,CLASS_ID                integer       NOT NULL default 0
   ,IS_ViSIBLE_BROWSER      integer       NOT NULL default 0
   ,SELECTED_TAB_ID         integer       NOT NULL default 0
   ,USER_ID                 integer       NOT NULL
);

CREATE TABLE task_select_tags (
    ID                      serial        NOT NULL
   ,TAG_ID                  integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);

CREATE TABLE task_browser_statuses (
    ID                      serial        NOT NULL
   ,STATUS_ID               integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);

CREATE TABLE task_browser_classifications (
    ID                      serial        NOT NULL
   ,CLASS_ID                integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);

CREATE TABLE task_browser_activities (
    ID                      serial        NOT NULL
   ,ACTIVITY_ID             integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);

CREATE TABLE task_browser_persons (
    ID                      serial        NOT NULL
   ,PERSON_ID               integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);

CREATE TABLE web_service_securities (
    ID                      serial        NOT NULL
   ,CLIENT_ADDRESS          varchar(256)  NOT NULL
   ,NONCE                   char(20)      NOT NULL
   ,CREATED_AT              char(20)      NOT NULL
);

CREATE TABLE user_roles (
    ID                      serial        NOT NULL
   ,USER_ID                 integer       NOT NULL
   ,ROLE_ID                 integer       NOT NULL
);

CREATE TABLE task_mails (
    ID                      serial        NOT NULL
   ,MESSAGE_ID              varchar(256)  NOT NULL
   ,TASK_ID                 integer       NOT NULL
   ,SENT_AT                 char(14)      NOT NULL
   ,SENT_BY                 integer       NOT NULL
);

CREATE TABLE meeting_mails (
    ID                      serial        NOT NULL
   ,MESSAGE_ID              varchar(256)  NOT NULL
   ,BASIC_ID                integer       NOT NULL
   ,SENT_AT                 char(14)      NOT NULL
   ,SENT_BY                 integer       NOT NULL
);

CREATE TABLE feed_tokens (
    ID                      serial        NOT NULL
   ,TOKEN                   char(20)      NOT NULL
   ,ACTIVITY_ID             integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
   ,DEL_FLAG                char(1)       NOT NULL
   ,CREATED_AT              char(14)      NOT NULL
);

/*
 * Add primary key.
 */
ALTER TABLE activities 
  ADD CONSTRAINT activities_pk 
  PRIMARY KEY (ID);

ALTER TABLE activity_colors 
  ADD CONSTRAINT activity_colors_pk 
  PRIMARY KEY (ID);

ALTER TABLE activity_members 
  ADD CONSTRAINT activity_members_pk 
  PRIMARY KEY (ID);

ALTER TABLE activity_relations
  ADD CONSTRAINT activity_relations_pk
  PRIMARY KEY (ID);

ALTER TABLE alerts 
  ADD CONSTRAINT alerts_pk
  PRIMARY KEY (ID);

ALTER TABLE classifications 
  ADD CONSTRAINT classifications_pk
  PRIMARY KEY (ID);

ALTER TABLE roles
  ADD CONSTRAINT roles_pk
  PRIMARY KEY (ID);

ALTER TABLE task_bodies 
  ADD CONSTRAINT task_bodies_pk
  PRIMARY KEY (ID);

ALTER TABLE task_comment_bodies
  ADD CONSTRAINT task_comment_bodies_pk
  PRIMARY KEY (ID);

ALTER TABLE task_comments
  ADD CONSTRAINT task_comments_pk 
  PRIMARY KEY (ID);

ALTER TABLE task_histories
  ADD CONSTRAINT task_histories_pk
  PRIMARY KEY (ID);

ALTER TABLE task_member_roles
  ADD CONSTRAINT task_member_roles_pk
  PRIMARY KEY (ID);

ALTER TABLE task_relations
  ADD CONSTRAINT task_relations_pk 
  PRIMARY KEY (ID);

ALTER TABLE task_statuses
  ADD CONSTRAINT task_statuses_pk 
  PRIMARY KEY (ID);

ALTER TABLE task_to_tasks
  ADD CONSTRAINT task_to_tasks_pk 
  PRIMARY KEY (ID);

ALTER TABLE tasks
  ADD CONSTRAINT tasks_pk 
  PRIMARY KEY (ID);

ALTER TABLE timezones
  ADD CONSTRAINT timezones_pk 
  PRIMARY KEY (ID);

ALTER TABLE users
  ADD CONSTRAINT users_pk 
  PRIMARY KEY (ID);

ALTER TABLE meeting_basics
  ADD CONSTRAINT meeting_basics_pk 
  PRIMARY KEY (ID);

ALTER TABLE meeting_agendas
  ADD CONSTRAINT meeting_agendas_pk 
  PRIMARY KEY (ID);

ALTER TABLE meeting_agenda_discussions
  ADD CONSTRAINT meeting_agenda_discussions_pk 
  PRIMARY KEY (ID);

ALTER TABLE meeting_relations
  ADD CONSTRAINT meeting_relations_pk 
  PRIMARY KEY (ID);

ALTER TABLE meeting_to_tasks
  ADD CONSTRAINT meeting_to_tasks_pk 
  PRIMARY KEY (ID);

ALTER TABLE meeting_basic_bodies
  ADD CONSTRAINT meeting_basic_bodies_pk 
  PRIMARY KEY (ID);

ALTER TABLE meeting_agenda_bodies
  ADD CONSTRAINT meeting_agenda_bodies_pk 
  PRIMARY KEY (ID);

ALTER TABLE meeting_agenda_discussion_bodies
  ADD CONSTRAINT meeting_agenda_discussion_bodies_pk 
  PRIMARY KEY (ID);
  
ALTER TABLE tags
  ADD CONSTRAINT tags_pk
  PRIMARY KEY (ID);

ALTER TABLE task_tags
  ADD CONSTRAINT task_tags_pk
  PRIMARY KEY (ID);

ALTER TABLE task_select_views
  ADD CONSTRAINT task_select_views_pk
  PRIMARY KEY (ID);

ALTER TABLE task_select_tags
  ADD CONSTRAINT task_select_tags_pk
  PRIMARY KEY (ID);

ALTER TABLE task_browser_statuses
  ADD CONSTRAINT task_browser_statuses_pk
  PRIMARY KEY (ID);

ALTER TABLE task_browser_classifications
  ADD CONSTRAINT task_browser_classifications_pk
  PRIMARY KEY (ID);

ALTER TABLE task_browser_activities
  ADD CONSTRAINT task_browser_activities_pk
  PRIMARY KEY (ID);

ALTER TABLE task_browser_persons
  ADD CONSTRAINT task_browser_persons_pk
  PRIMARY KEY (ID);

ALTER TABLE web_service_securities
  ADD CONSTRAINT web_service_securities_pk
  PRIMARY KEY (ID);

ALTER TABLE user_roles
  ADD CONSTRAINT user_roles_pk
  PRIMARY KEY (ID);

ALTER TABLE task_mails
  ADD CONSTRAINT task_mails_pk
  PRIMARY KEY (ID);

ALTER TABLE meeting_mails
  ADD CONSTRAINT meeting_mails_pk
  PRIMARY KEY (ID);

ALTER TABLE feed_tokens
  ADD CONSTRAINT feed_tokens_pk
  PRIMARY KEY (ID);

/*
 * Add Foreign key.
 */
ALTER TABLE activities 
  ADD FOREIGN KEY (MODIFIED_USER_ID) 
  REFERENCES users(ID);

ALTER TABLE activity_members
  ADD FOREIGN KEY (ACTIVITY_ID) 
  REFERENCES activities (ID);

ALTER TABLE activity_members
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users (ID);

ALTER TABLE activity_members
  ADD FOREIGN KEY (ROLE_ID) 
  REFERENCES roles (ID);

ALTER TABLE activity_members
  ADD FOREIGN KEY (MODIFIED_USER_ID) 
  REFERENCES users (ID);

ALTER TABLE activity_relations
  ADD FOREIGN KEY (ACTIVITY_ID) 
  REFERENCES activities (ID);

ALTER TABLE activity_relations
  ADD FOREIGN KEY (COLOR_ID) 
  REFERENCES activity_colors (ID);

ALTER TABLE activity_relations
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users (ID);

ALTER TABLE task_bodies
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks (ID);

ALTER TABLE task_comment_bodies
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks (ID);

ALTER TABLE task_comment_bodies
  ADD FOREIGN KEY (COMMENT_ID) 
  REFERENCES task_comments (ID);

ALTER TABLE task_comments
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks (ID);

ALTER TABLE task_comments
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users (ID);

ALTER TABLE task_histories
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks (ID);

ALTER TABLE task_histories
  ADD FOREIGN KEY (STATUS_ID) 
  REFERENCES task_statuses (ID);

ALTER TABLE task_histories
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users (ID);

ALTER TABLE task_member_roles
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks (ID);

ALTER TABLE task_member_roles
  ADD FOREIGN KEY (ROLE_ID) 
  REFERENCES roles (ID);

ALTER TABLE task_member_roles
  ADD FOREIGN KEY (ACTIVITY_MEMBER_ID) 
  REFERENCES users (ID);

ALTER TABLE task_relations
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks (ID);

ALTER TABLE task_relations
  ADD FOREIGN KEY (STATUS_ID) 
  REFERENCES task_statuses (ID);

ALTER TABLE task_relations
  ADD FOREIGN KEY (ACTIVITY_ID) 
  REFERENCES activities (ID);

ALTER TABLE task_relations
  ADD FOREIGN KEY (CLASSIFICATION_ID) 
  REFERENCES classifications (ID);

ALTER TABLE task_relations
  ADD FOREIGN KEY (ALERT_ID) 
  REFERENCES alerts (ID);

ALTER TABLE task_relations
  ADD FOREIGN KEY (PERSON_ID) 
  REFERENCES users (ID);

ALTER TABLE task_relations
  ADD FOREIGN KEY (MANAGER_ID) 
  REFERENCES users (ID);

ALTER TABLE task_relations
  ADD FOREIGN KEY (POSTED_USER_ID) 
  REFERENCES users (ID);

ALTER TABLE task_to_tasks
  ADD FOREIGN KEY (SRC_TASK_ID) 
  REFERENCES tasks (ID);

ALTER TABLE task_to_tasks
  ADD FOREIGN KEY (DEST_TASK_ID) 
  REFERENCES tasks (ID);

ALTER TABLE meeting_basics
  ADD FOREIGN KEY (POSTED_USER_ID) 
  REFERENCES users(ID);

ALTER TABLE meeting_basics
  ADD FOREIGN KEY (ACTIVITY_ID) 
  REFERENCES activities(ID);

ALTER TABLE meeting_agendas
  ADD FOREIGN KEY (POSTED_USER_ID) 
  REFERENCES users(ID);

ALTER TABLE meeting_agendas
  ADD FOREIGN KEY (MODIFIED_USER_ID) 
  REFERENCES users(ID);

ALTER TABLE meeting_agenda_discussions
  ADD FOREIGN KEY (AGENDA_ID) 
  REFERENCES meeting_agendas(ID);

ALTER TABLE meeting_agenda_discussions
  ADD FOREIGN KEY (POSTED_USER_ID) 
  REFERENCES users(ID);

ALTER TABLE meeting_agenda_discussions
  ADD FOREIGN KEY (MODIFIED_USER_ID) 
  REFERENCES users(ID);

ALTER TABLE meeting_relations
  ADD FOREIGN KEY(BASIC_ID) 
  REFERENCES meeting_basics(ID);

ALTER TABLE meeting_relations
  ADD FOREIGN KEY(AGENDA_ID) 
  REFERENCES meeting_agendas(ID);

ALTER TABLE meeting_to_tasks
  ADD FOREIGN KEY(BASIC_ID) 
  REFERENCES meeting_basics(ID);

ALTER TABLE meeting_to_tasks
  ADD FOREIGN KEY(AGENDA_ID) 
  REFERENCES meeting_agendas(ID);

ALTER TABLE meeting_to_tasks
  ADD FOREIGN KEY(DISCUSSION_ID) 
  REFERENCES meeting_agenda_discussions(ID);

ALTER TABLE meeting_to_tasks
  ADD FOREIGN KEY(TASK_ID) 
  REFERENCES tasks(ID);

ALTER TABLE meeting_basic_bodies
  ADD FOREIGN KEY (BASIC_ID) 
  REFERENCES meeting_basics (ID);

ALTER TABLE meeting_agenda_bodies
  ADD FOREIGN KEY (AGENDA_ID) 
  REFERENCES meeting_agendas (ID);

ALTER TABLE meeting_agenda_discussion_bodies
  ADD FOREIGN KEY (AGENDA_ID)     
  REFERENCES meeting_agendas (ID);

ALTER TABLE meeting_agenda_discussion_bodies
  ADD FOREIGN KEY (DISCUSSION_ID) 
  REFERENCES meeting_agenda_discussions (ID);

ALTER TABLE task_tags 
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks(ID);

ALTER TABLE task_tags 
  ADD FOREIGN KEY (TAG_ID) 
  REFERENCES tags(ID);
  
ALTER TABLE task_tags 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_select_views 
  ADD FOREIGN KEY (CLASS_ID) 
  REFERENCES classifications(ID);

ALTER TABLE task_select_views 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_select_tags 
  ADD FOREIGN KEY (TAG_ID) 
  REFERENCES tags(ID);
  
ALTER TABLE task_select_tags 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_statuses 
  ADD FOREIGN KEY (STATUS_ID) 
  REFERENCES task_statuses(ID);
  
ALTER TABLE task_browser_statuses 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_classifications 
  ADD FOREIGN KEY (CLASS_ID) 
  REFERENCES classifications(ID);
  
ALTER TABLE task_browser_classifications 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_activities 
  ADD FOREIGN KEY (ACTIVITY_ID) 
  REFERENCES activities(ID);

ALTER TABLE task_browser_activities 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_persons 
  ADD FOREIGN KEY (PERSON_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_persons 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE user_roles 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);
  
ALTER TABLE user_roles 
  ADD FOREIGN KEY (ROLE_ID) 
  REFERENCES roles(ID);

ALTER TABLE task_mails 
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks(ID);

ALTER TABLE task_mails 
  ADD FOREIGN KEY (SENT_BY) 
  REFERENCES users(ID);

ALTER TABLE meeting_mails 
  ADD FOREIGN KEY (BASIC_ID) 
  REFERENCES meeting_basics(ID);

ALTER TABLE meeting_mails 
  ADD FOREIGN KEY (SENT_BY) 
  REFERENCES users(ID);

ALTER TABLE feed_tokens 
  ADD FOREIGN KEY (ACTIVITY_ID) 
  REFERENCES activities(ID);
  
ALTER TABLE feed_tokens 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

/*
 * Add Comment
 */
COMMENT ON TABLE  activities                                      IS 'Activity Master';
COMMENT ON COLUMN activities.ID                                   IS 'Activity Id';
COMMENT ON COLUMN activities.NAME                                 IS 'Activity Name';
COMMENT ON COLUMN activities.ABBREVIATION                         IS 'Activity Abbreviation';
COMMENT ON COLUMN activities.DESCRIPTION                          IS 'Description';
COMMENT ON COLUMN activities.STATUS                               IS 'Status';
COMMENT ON COLUMN activities.START_DATE                           IS 'Start Date';
COMMENT ON COLUMN activities.END_DATE                             IS 'End Date';
COMMENT ON COLUMN activities.DEL_FLAG                             IS 'Delete Flag [0]:Not Deleted,[1]:Deleted';
COMMENT ON COLUMN activities.REGISTERED                           IS 'Registered';
COMMENT ON COLUMN activities.MODIFIED                             IS 'Modified';
COMMENT ON COLUMN activities.MODIFIED_USER_ID                     IS 'Modified User Id';

COMMENT ON TABLE  activity_colors                                 IS 'activity color';
COMMENT ON COLUMN activity_colors.ID                              IS 'Id';
COMMENT ON COLUMN activity_colors.COLOR                           IS 'Color';
COMMENT ON COLUMN activity_colors.NAME                            IS 'Name';

COMMENT ON TABLE  activity_members                                IS 'Activity Members';
COMMENT ON COLUMN activity_members.ID                             IS 'Id';
COMMENT ON COLUMN activity_members.ACTIVITY_ID                    IS 'Activity Id';
COMMENT ON COLUMN activity_members.USER_ID                        IS 'User Id';
COMMENT ON COLUMN activity_members.ROLE_ID                        IS 'Role Id';
COMMENT ON COLUMN activity_members.START_DATE                     IS 'Start Date';
COMMENT ON COLUMN activity_members.END_DATE                       IS 'End Date';
COMMENT ON COLUMN activity_members.DEL_FLAG                       IS 'Delete Flag';
COMMENT ON COLUMN activity_members.REGISTERED                     IS 'Registered';
COMMENT ON COLUMN activity_members.MODIFIED                       IS 'Modified';
COMMENT ON COLUMN activity_members.MODIFIED_USER_ID               IS 'Modified User Id';

COMMENT ON TABLE  activity_relations                              IS 'activity relations';
COMMENT ON COLUMN activity_relations.ID                           IS 'Id';
COMMENT ON COLUMN activity_relations.ACTIVITY_ID                  IS 'Activity Id';
COMMENT ON COLUMN activity_relations.COLOR_ID                     IS 'Color Id';
COMMENT ON COLUMN activity_relations.USER_ID                      IS 'User Id';
COMMENT ON COLUMN activity_relations.DISP_ORDER                   IS 'Display order';

COMMENT ON TABLE  alerts                                          IS 'alerts';
COMMENT ON COLUMN alerts.ID                                       IS 'Id';
COMMENT ON COLUMN alerts.VALUE                                    IS 'Value';
COMMENT ON COLUMN alerts.VALUE_I18N                               IS 'Value - i18n';

COMMENT ON TABLE  classifications                                 IS 'classifications';
COMMENT ON COLUMN classifications.ID                              IS 'Id';
COMMENT ON COLUMN classifications.TYPE                            IS 'Type:[E:event,T:task]';
COMMENT ON COLUMN classifications.VALUE                           IS 'Value';

COMMENT ON TABLE  roles                                           IS 'Role Master';
COMMENT ON COLUMN roles.ID                                        IS 'Role Id';
COMMENT ON COLUMN roles.TYPE                                      IS 'Type of Role';
COMMENT ON COLUMN roles.NAME                                      IS 'Role Name';
COMMENT ON COLUMN roles.DESCRIPTION                               IS 'Description';

COMMENT ON TABLE  task_bodies                                     IS 'task bodies';
COMMENT ON COLUMN task_bodies.ID                                  IS 'Id';
COMMENT ON COLUMN task_bodies.TASK_ID                             IS 'Task Id';
COMMENT ON COLUMN task_bodies.REV                                 IS 'Revision';
COMMENT ON COLUMN task_bodies.BODY                                IS 'Body';

COMMENT ON TABLE  task_comment_bodies                             IS 'task comment bodies';
COMMENT ON COLUMN task_comment_bodies.ID                          IS 'Id';
COMMENT ON COLUMN task_comment_bodies.TASK_ID                     IS 'Task Id';
COMMENT ON COLUMN task_comment_bodies.COMMENT_ID                  IS 'Comment Id';
COMMENT ON COLUMN task_comment_bodies.REV                         IS 'Revision';
COMMENT ON COLUMN task_comment_bodies.BODY                        IS 'Body';

COMMENT ON TABLE  task_comments                                   IS 'task comments';
COMMENT ON COLUMN task_comments.ID                                IS 'Id';
COMMENT ON COLUMN task_comments.TASK_ID                           IS 'Task Id';
COMMENT ON COLUMN task_comments.USER_ID                           IS 'User Id';
COMMENT ON COLUMN task_comments.REGISTERED                        IS 'Registered';

COMMENT ON TABLE  task_histories                                  IS 'task histories';
COMMENT ON COLUMN task_histories.ID                               IS 'Id';
COMMENT ON COLUMN task_histories.TASK_ID                          IS 'Task Id';
COMMENT ON COLUMN task_histories.STATUS_ID                        IS 'Status Id';
COMMENT ON COLUMN task_histories.REGISTERED                       IS 'Registered';
COMMENT ON COLUMN task_histories.USER_ID                          IS 'User Id';

COMMENT ON TABLE  task_member_roles                               IS 'task member role';
COMMENT ON COLUMN task_member_roles.ID                            IS 'Id';
COMMENT ON COLUMN task_member_roles.ACTIVITY_MEMBER_ID            IS 'Activity member Id';
COMMENT ON COLUMN task_member_roles.TASK_ID                       IS 'Task id';
COMMENT ON COLUMN task_member_roles.ROLE_ID                       IS 'Role Id';

COMMENT ON TABLE  task_relations                                  IS 'task relations';
COMMENT ON COLUMN task_relations.ID                               IS 'Id';
COMMENT ON COLUMN task_relations.TASK_ID                          IS 'Task id';
COMMENT ON COLUMN task_relations.STATUS_ID                        IS 'Status Id';
COMMENT ON COLUMN task_relations.ACTIVITY_ID                      IS 'Activity Id';
COMMENT ON COLUMN task_relations.CLASSIFICATION_ID                IS 'classification Id';
COMMENT ON COLUMN task_relations.ALERT_ID                         IS 'Alert Id';
COMMENT ON COLUMN task_relations.PERSON_ID                        IS 'Person in charge Id';
COMMENT ON COLUMN task_relations.MANAGER_ID                       IS 'Manager Id';
COMMENT ON COLUMN task_relations.POSTED_USER_ID                   IS 'Posted user Id';

COMMENT ON TABLE  task_statuses                                   IS 'task status';
COMMENT ON COLUMN task_statuses.ID                                IS 'Id';
COMMENT ON COLUMN task_statuses.VALUE                             IS 'Task status value';
COMMENT ON COLUMN task_statuses.VALUE_I18N                        IS 'Task status value i18n';

COMMENT ON TABLE  task_to_tasks                                   IS 'Task To Task';
COMMENT ON COLUMN task_to_tasks.ID                                IS 'Id';
COMMENT ON COLUMN task_to_tasks.SRC_TASK_ID                       IS 'source task Id';
COMMENT ON COLUMN task_to_tasks.DEST_TASK_ID                      IS 'destination task Id';

COMMENT ON TABLE  tasks                                           IS 'tasks';
COMMENT ON COLUMN tasks.ID                                        IS 'Id';
COMMENT ON COLUMN tasks.TITLE                                     IS 'Title';
COMMENT ON COLUMN tasks.START_DATE                                IS 'Start date[yyyyMMdd]';
COMMENT ON COLUMN tasks.START_YEAR                                IS 'Start year';
COMMENT ON COLUMN tasks.START_MONTH                               IS 'Start month';
COMMENT ON COLUMN tasks.START_DAY_OF_MONTH                        IS 'Start day of month';
COMMENT ON COLUMN tasks.DEAD_LINE                                 IS 'Dead line';
COMMENT ON COLUMN tasks.DEAD_LINE_YEAR                            IS 'Dead line year';
COMMENT ON COLUMN tasks.DEAD_LINE_MONTH                           IS 'Dead line month';
COMMENT ON COLUMN tasks.DEAD_LINE_DAY_OF_MONTH                    IS 'Dead line day of month';
COMMENT ON COLUMN tasks.PRIORITY_ORDER                            IS 'Priority order';
COMMENT ON COLUMN tasks.DEL_FLAG                                  IS 'Delete flag';
COMMENT ON COLUMN tasks.REGISTERED                                IS 'Registered';

COMMENT ON TABLE  timezones                                       IS 'Time Zone Master';
COMMENT ON COLUMN timezones.ID                                    IS 'Id';
COMMENT ON COLUMN timezones.TIMEZONE                              IS 'Time Zone';
COMMENT ON COLUMN timezones.OFFSET_TIME                           IS 'Offset';
COMMENT ON COLUMN timezones.COUNTRY                               IS 'COUNTRY';
COMMENT ON COLUMN timezones.COUNTRY_I18N                          IS 'COUNTRY i18n';
COMMENT ON COLUMN timezones.DESCRIPTION                           IS 'Description';
COMMENT ON COLUMN timezones.DESCRIPTION_I18N                      IS 'Description i18n';

COMMENT ON TABLE  users                                           IS 'User Master';
COMMENT ON COLUMN users.ID                                        IS 'User Id';
COMMENT ON COLUMN users.LOGIN_ID                                  IS 'Login User Id';
COMMENT ON COLUMN users.PASSWORD                                  IS 'Pass Word';
COMMENT ON COLUMN users.EMAIL                                     IS 'Email';
COMMENT ON COLUMN users.LAST_NAME                                 IS 'Last Name';
COMMENT ON COLUMN users.MIDDLE_NAME                               IS 'Middle Name';
COMMENT ON COLUMN users.FIRST_NAME                                IS 'First Name';
COMMENT ON COLUMN users.PHOTO_IMG_URL                             IS 'Photo Image URL';
COMMENT ON COLUMN users.DEL_FLAG                                  IS 'Delete Flag';
COMMENT ON COLUMN users.REGISTERED                                IS 'Registered';
COMMENT ON COLUMN users.MODIFIED                                  IS 'Modified';
COMMENT ON COLUMN users.MODIFIED_USER_ID                          IS 'Modified User Id';

COMMENT ON TABLE  meeting_basics                                  IS 'Meeting Basics';
COMMENT ON COLUMN meeting_basics.ID                               IS 'Id';
COMMENT ON COLUMN meeting_basics.ACTIVITY_ID                      IS 'Activity Id';
COMMENT ON COLUMN meeting_basics.STATUS_ID                        IS 'status Id[1:new,2:doing,3:done]';
COMMENT ON COLUMN meeting_basics.TITLE                            IS 'Title';
COMMENT ON COLUMN meeting_basics.START_DATE                       IS 'Start Date [yyyyMMdd]';
COMMENT ON COLUMN meeting_basics.DEL_FLAG                         IS 'Delete Flag[0:not delete 1:delete]';
COMMENT ON COLUMN meeting_basics.POSTED_USER_ID                   IS 'Posted User Id';
COMMENT ON COLUMN meeting_basics.REGISTERED                       IS 'Registered';
COMMENT ON COLUMN meeting_basics.MODIFIED                         IS 'Modified';

COMMENT ON TABLE  meeting_agendas                                 IS 'Meeting Agendas';
COMMENT ON COLUMN meeting_agendas.ID                              IS 'Id';
COMMENT ON COLUMN meeting_agendas.PRIORITY                        IS 'Priority[1:lower 2:middle 3:higher]';
COMMENT ON COLUMN meeting_agendas.POSTED_USER_ID                  IS 'Posted User Id';
COMMENT ON COLUMN meeting_agendas.DEL_FLAG                        IS 'Delete Flag[0:not delete 1:delete]';
COMMENT ON COLUMN meeting_agendas.REGISTERED                      IS 'Registered';
COMMENT ON COLUMN meeting_agendas.MODIFIED                        IS 'Modified';
COMMENT ON COLUMN meeting_agendas.MODIFIED_USER_ID                IS 'Modified User Id';

COMMENT ON TABLE  meeting_agenda_discussions                      IS 'Meeting Agenda Discussions';
COMMENT ON COLUMN meeting_agenda_discussions.ID                   IS 'Id';
COMMENT ON COLUMN meeting_agenda_discussions.AGENDA_ID            IS 'Meeting Agendas Id';
COMMENT ON COLUMN meeting_agenda_discussions.TYPE                 IS 'Type[1:comment 2:conclusion 3:memo 4:attachment 5:todo]';
COMMENT ON COLUMN meeting_agenda_discussions.POSTED_USER_ID       IS 'Posted User Id';
COMMENT ON COLUMN meeting_agenda_discussions.DEL_FLAG             IS 'Delete Flag[0:not delete 1:delete]';
COMMENT ON COLUMN meeting_agenda_discussions.REGISTERED           IS 'Registered';
COMMENT ON COLUMN meeting_agenda_discussions.MODIFIED             IS 'Modified';
COMMENT ON COLUMN meeting_agenda_discussions.MODIFIED_USER_ID     IS 'Modified User Id';

COMMENT ON TABLE  meeting_relations                               IS 'Meeting Relations';
COMMENT ON COLUMN meeting_relations.ID                            IS 'Id';
COMMENT ON COLUMN meeting_relations.ID                            IS 'Meeting Basics Id';
COMMENT ON COLUMN meeting_relations.ID                            IS 'Meeting Agendas Id';

COMMENT ON TABLE  meeting_to_tasks                                IS 'Meeting To Tasks';
COMMENT ON COLUMN meeting_to_tasks.ID                             IS 'Id';
COMMENT ON COLUMN meeting_to_tasks.BASIC_ID                       IS 'Meeting Basics Id';
COMMENT ON COLUMN meeting_to_tasks.AGENDA_ID                      IS 'Meeting Agendas Id';
COMMENT ON COLUMN meeting_to_tasks.DISCUSSION_ID                  IS 'Meeting Agenda Discussions Id';
COMMENT ON COLUMN meeting_to_tasks.TASK_ID                        IS 'Tasks Id';

COMMENT ON TABLE  meeting_basic_bodies                            IS 'meeting basic bodies';
COMMENT ON COLUMN meeting_basic_bodies.ID                         IS 'Id';
COMMENT ON COLUMN meeting_basic_bodies.BASIC_ID                   IS 'Meeting Basics Id';
COMMENT ON COLUMN meeting_basic_bodies.REV                        IS 'Revision';
COMMENT ON COLUMN meeting_basic_bodies.BODY                       IS 'Body';

COMMENT ON TABLE  meeting_agenda_bodies                           IS 'meeting agenda bodies';
COMMENT ON COLUMN meeting_agenda_bodies.ID                        IS 'Id';
COMMENT ON COLUMN meeting_agenda_bodies.AGENDA_ID                 IS 'Meeting Agendas Id';
COMMENT ON COLUMN meeting_agenda_bodies.REV                       IS 'Revision';
COMMENT ON COLUMN meeting_agenda_bodies.BODY                      IS 'Body';

COMMENT ON TABLE  meeting_agenda_discussion_bodies                IS 'meeting agenda discussion bodies';
COMMENT ON COLUMN meeting_agenda_discussion_bodies.ID             IS 'Id';
COMMENT ON COLUMN meeting_agenda_discussion_bodies.AGENDA_ID      IS 'Meeting Agendas Id';
COMMENT ON COLUMN meeting_agenda_discussion_bodies.DISCUSSION_ID  IS 'Meeting Discussions Id';
COMMENT ON COLUMN meeting_agenda_discussion_bodies.REV            IS 'Revision';
COMMENT ON COLUMN meeting_agenda_discussion_bodies.BODY           IS 'Body';

COMMENT ON TABLE  tags                                            IS 'Tag Master';
COMMENT ON COLUMN tags.ID                                         IS 'Id';
COMMENT ON COLUMN tags.VALUE                                      IS 'Value';

COMMENT ON TABLE  task_tags                                       IS 'Task Tags';
COMMENT ON COLUMN task_tags.ID                                    IS 'Id';
COMMENT ON COLUMN task_tags.TASK_ID                               IS 'Task Id';
COMMENT ON COLUMN task_tags.TAG_ID                                IS 'Tag Id';
COMMENT ON COLUMN task_tags.USER_ID                               IS 'User Id';
COMMENT ON COLUMN task_tags.POSTED_AT                             IS 'Posted At';

COMMENT ON TABLE  task_select_views                               IS 'Task select views';
COMMENT ON COLUMN task_select_views.ID                            IS 'Id';
COMMENT ON COLUMN task_select_views.MODE_ID                       IS 'Mode Id [0:Block],[1:List]';
COMMENT ON COLUMN task_select_views.CLASS_ID                      IS 'Class Id';
COMMENT ON COLUMN task_select_views.IS_ViSIBLE_BROWSER            IS 'Is Show Browser [0:not visible] [1:visible]';
COMMENT ON COLUMN task_select_views.SELECTED_TAB_ID               IS 'Selected tab Id [0:folder] [1:tags]';
COMMENT ON COLUMN task_select_views.USER_ID                       IS 'User Id';

COMMENT ON TABLE  task_select_tags                                IS 'Task_select_tags';
COMMENT ON COLUMN task_select_tags.ID                             IS 'Id';
COMMENT ON COLUMN task_select_tags.TAG_ID                         IS 'Tag Id';
COMMENT ON COLUMN task_select_tags.USER_ID                        IS 'User Id';

COMMENT ON TABLE  task_browser_statuses                           IS 'Task browse statuses';
COMMENT ON COLUMN task_browser_statuses.ID                        IS 'Id';
COMMENT ON COLUMN task_browser_statuses.STATUS_ID                 IS 'Status Id';
COMMENT ON COLUMN task_browser_statuses.USER_ID                   IS 'User Id';

COMMENT ON TABLE  task_browser_classifications                    IS 'Task browse classifications';
COMMENT ON COLUMN task_browser_classifications.ID                 IS 'Id';
COMMENT ON COLUMN task_browser_classifications.CLASS_ID           IS 'Class Id';
COMMENT ON COLUMN task_browser_classifications.USER_ID            IS 'User Id';

COMMENT ON TABLE  task_browser_activities                         IS 'Task browse activities';
COMMENT ON COLUMN task_browser_activities.ID                      IS 'Id';
COMMENT ON COLUMN task_browser_activities.ACTIVITY_ID             IS 'Activity Id';
COMMENT ON COLUMN task_browser_activities.USER_ID                 IS 'User Id';

COMMENT ON TABLE  task_browser_persons                            IS 'Task browse persons';
COMMENT ON COLUMN task_browser_persons.ID                         IS 'Id';
COMMENT ON COLUMN task_browser_persons.PERSON_ID                  IS 'Person Id';
COMMENT ON COLUMN task_browser_persons.USER_ID                    IS 'User Id';

COMMENT ON TABLE  web_service_securities                          IS 'Web service securities ';
COMMENT ON COLUMN web_service_securities.ID                       IS 'Id';
COMMENT ON COLUMN web_service_securities.CLIENT_ADDRESS           IS 'Client address';
COMMENT ON COLUMN web_service_securities.NONCE                    IS 'Nonce';
COMMENT ON COLUMN web_service_securities.CREATED_AT               IS 'Created at';

COMMENT ON TABLE  user_roles                                      IS 'User roles';
COMMENT ON COLUMN user_roles.ID                                   IS 'Id';
COMMENT ON COLUMN user_roles.USER_ID                              IS 'User id';
COMMENT ON COLUMN user_roles.ROLE_ID                              IS 'Role id';

COMMENT ON TABLE  task_mails                                      IS 'Task mails';
COMMENT ON COLUMN task_mails.ID                                   IS 'Id';
COMMENT ON COLUMN task_mails.MESSAGE_ID                           IS 'Message id';
COMMENT ON COLUMN task_mails.TASK_ID                              IS 'Task id';
COMMENT ON COLUMN task_mails.SENT_AT                              IS 'Sent at';
COMMENT ON COLUMN task_mails.SENT_BY                              IS 'Sent by';

COMMENT ON TABLE  meeting_mails                                   IS 'Task mails';
COMMENT ON COLUMN meeting_mails.ID                                IS 'Id';
COMMENT ON COLUMN meeting_mails.MESSAGE_ID                        IS 'Message id';
COMMENT ON COLUMN meeting_mails.BASIC_ID                          IS 'Meeting Basic id';
COMMENT ON COLUMN meeting_mails.SENT_AT                           IS 'Sent at';
COMMENT ON COLUMN meeting_mails.SENT_BY                           IS 'Sent by';

COMMENT ON TABLE  feed_tokens                                     IS 'Feed tokens';
COMMENT ON COLUMN feed_tokens.ID                                  IS 'Id';
COMMENT ON COLUMN feed_tokens.TOKEN                               IS 'Token';
COMMENT ON COLUMN feed_tokens.ACTIVITY_ID                         IS 'User id';
COMMENT ON COLUMN feed_tokens.USER_ID                             IS 'User id';
COMMENT ON COLUMN feed_tokens.DEL_FLAG                            IS 'Role id';
COMMENT ON COLUMN feed_tokens.CREATED_AT                          IS 'Created at';

/*
 * Add Permission
 */
GRANT ALL ON activities                                       TO tangerine;
GRANT ALL ON activity_colors                                  TO tangerine;
GRANT ALL ON activity_members                                 TO tangerine;
GRANT ALL ON activity_relations                               TO tangerine;
GRANT ALL ON alerts                                           TO tangerine;
GRANT ALL ON classifications                                  TO tangerine;
GRANT ALL ON roles                                            TO tangerine;
GRANT ALL ON task_bodies                                      TO tangerine;
GRANT ALL ON task_comment_bodies                              TO tangerine;
GRANT ALL ON task_comments                                    TO tangerine;
GRANT ALL ON task_histories                                   TO tangerine;
GRANT ALL ON task_member_roles                                TO tangerine;
GRANT ALL ON task_relations                                   TO tangerine;
GRANT ALL ON task_statuses                                    TO tangerine;
GRANT ALL ON task_to_tasks                                    TO tangerine;
GRANT ALL ON tasks                                            TO tangerine;
GRANT ALL ON timezones                                        TO tangerine;
GRANT ALL ON users                                            TO tangerine;
GRANT ALL ON meeting_basics                                   TO tangerine;
GRANT ALL ON meeting_agendas                                  TO tangerine;
GRANT ALL ON meeting_agenda_discussions                       TO tangerine;
GRANT ALL ON meeting_relations                                TO tangerine;
GRANT ALL ON meeting_to_tasks                                 TO tangerine;
GRANT ALL ON meeting_basic_bodies                             TO tangerine;
GRANT ALL ON meeting_agenda_bodies                            TO tangerine;
GRANT ALL ON meeting_agenda_discussion_bodies                 TO tangerine;
GRANT ALL ON tags                                             TO tangerine;
GRANT ALL ON task_tags                                        TO tangerine;
GRANT ALL ON task_select_views                                TO tangerine;
GRANT ALL ON task_select_tags                                 TO tangerine;
GRANT ALL ON task_browser_statuses                            TO tangerine;
GRANT ALL ON task_browser_classifications                     TO tangerine;
GRANT ALL ON task_browser_activities                          TO tangerine;
GRANT ALL ON task_browser_persons                             TO tangerine;
GRANT ALL ON web_service_securities                           TO tangerine;
GRANT ALL ON user_roles                                       TO tangerine;
GRANT ALL ON task_mails                                       TO tangerine;
GRANT ALL ON meeting_mails                                    TO tangerine;
GRANT ALL ON feed_tokens                                      TO tangerine;

GRANT ALL ON SEQUENCE activity_colors_id_seq                  TO tangerine;
GRANT ALL ON SEQUENCE activity_members_id_seq                 TO tangerine;
GRANT ALL ON SEQUENCE activity_relations_id_seq               TO tangerine;
GRANT ALL ON SEQUENCE meeting_agenda_bodies_id_seq            TO tangerine;
GRANT ALL ON SEQUENCE meeting_agenda_discussion_bodies_id_seq TO tangerine;
GRANT ALL ON SEQUENCE meeting_basic_bodies_id_seq             TO tangerine;
GRANT ALL ON SEQUENCE meeting_relations_id_seq                TO tangerine;
GRANT ALL ON SEQUENCE meeting_to_tasks_id_seq                 TO tangerine;
GRANT ALL ON SEQUENCE task_bodies_id_seq                      TO tangerine;
GRANT ALL ON SEQUENCE task_comment_bodies_id_seq              TO tangerine;
GRANT ALL ON SEQUENCE task_histories_id_seq                   TO tangerine;
GRANT ALL ON SEQUENCE task_member_roles_id_seq                TO tangerine;
GRANT ALL ON SEQUENCE task_relations_id_seq                   TO tangerine;
GRANT ALL ON SEQUENCE task_to_tasks_id_seq                    TO tangerine;
GRANT ALL ON SEQUENCE tags_id_seq                             TO tangerine;
GRANT ALL ON SEQUENCE task_tags_id_seq                        TO tangerine;
GRANT ALL ON SEQUENCE task_select_views_id_seq                TO tangerine;
GRANT ALL ON SEQUENCE task_select_tags_id_seq                 TO tangerine;
GRANT ALL ON SEQUENCE task_browser_statuses_id_seq            TO tangerine;
GRANT ALL ON SEQUENCE task_browser_classifications_id_seq     TO tangerine;
GRANT ALL ON SEQUENCE task_browser_activities_id_seq          TO tangerine;
GRANT ALL ON SEQUENCE task_browser_persons_id_seq             TO tangerine;
GRANT ALL ON SEQUENCE web_service_securities_id_seq           TO tangerine;
GRANT ALL ON SEQUENCE user_roles_id_seq                       TO tangerine;
GRANT ALL ON SEQUENCE task_mails_id_seq                       TO tangerine;
GRANT ALL ON SEQUENCE meeting_mails_id_seq                    TO tangerine;
GRANT ALL ON SEQUENCE feed_tokens_id_seq                      TO tangerine;

/*
 * Insert Master Data
 */
INSERT INTO activity_colors VALUES 
  (1,'ff0000','Red'),
  (2,'ff8000','Orange'),
  (3,'ffff00','Yellow'),
  (4,'80ff00','Lime'),
  (5,'00ff00','Green'),
  (6,'00ffff','Aqua'),
  (7,'0080ff','Sky'),
  (8,'0000ff','Blue'),
  (9,'8000ff','Purple'),
  (10,'ff00ff','Pink'),
  (11,'660000','Dark red'),
  (12,'663300','Dark orange'),
  (13,'666600','Dark yellow'),
  (14,'336600','Dark lime'),
  (15,'006600','Dark green'),
  (16,'006666','Dark aqua'),
  (17,'000066','Dark blue'),
  (18,'660066','Dark pink');

INSERT INTO alerts VALUES 
  (0,'None','なし'),
  (1,'0 second before','0秒前'),
  (2,'5 minutes before','5分前'),
  (3,'10 minutes before','10分前'),
  (4,'15 minutes before','15分前'),
  (5,'30 minutes before','30分前'),
  (6,'45 minutes before','45分前'),
  (7,'1 hour before','1時間前'),
  (8,'2 hours before','2時間前'),
  (9,'3 hours before','3時間前'),
  (10,'6 hours before','6時間前'),
  (11,'12 hours before','12時間前'),
  (12,'1 day before','1日前'),
  (13,'2 days before','2日前'),
  (14,'3 days before','3日前'),
  (15,'1 week before','1週間前'),
  (16,'2 weeks before','2週間前'),
  (17,'3 weeks before','3週間前'),
  (18,'1 month before','1ヶ月前');  

INSERT INTO classifications VALUES 
  (0,'T','Tasks'),
  (1,'T','Today'),
  (2,'T','Week'),
  (3,'T','Month'),
  (4,'T','Hold'),
  (5,'T','Someday'),
  (9,'T','Inbox'),
  (21,'T','Archive'),
  (99,'T','Trash box');

INSERT INTO roles VALUES 
  (1,'1','ADMIN','Administrator'),
  (2,'1','USER','Standard User'),
  (3,'1','GUEST','Guest'),
  (11,'2','ADMIN','Administrator'),
  (12,'2','USER','Standard User'),
  (13,'2','GUEST','Guest'); 

INSERT INTO task_statuses VALUES 
  (1,'To Do','新規'),
  (2,'Doing','処理中'),
  (3,'Done','処理済'),
  (4,'Pending','保留');   

INSERT INTO timezones VALUES 
  (1,'NZDT',780,'n/a','n/a','New Zealand Daylight Time','ニュージーランド夏時間'),
  (2,'IDLE',720,'n/a','n/a','International Date Line East','日付変更線、東側'),
  (3,'NZST',720,'n/a','n/a','New Zealand Std Time','ニュージーランド標準時間'),
  (4,'NZT',720,'n/a','n/a','New Zealand Time','ニュージーランド時間'),
  (5,'AESST',660,'n/a','n/a','Australia Eastern Summer Std Time','オーストラリア標準夏時間'),
  (6,'ACSST',630,'n/a','n/a','Central Australia Summer Std Time','オーストラリア中部標準夏時間'),
  (7,'CADT',630,'n/a','n/a','Central Australia Daylight Savings Time','オーストラリア中部夏時間'),
  (8,'SADT',630,'n/a','n/a','South Australian Daylight Time','オーストラリア南部夏時間'),
  (9,'AEST',600,'n/a','n/a','Australia Eastern Std Time','オーストラリア東部標準時間'),
  (10,'EAST',600,'n/a','n/a','East Australian Std Time','オーストラリア東部標準時間'),
  (11,'GST',600,'n/a','n/a','Guam Std Time/USSR Zone 9','グアム標準時間、ソビエトタイムゾーン9');
INSERT INTO timezones VALUES 
  (12,'LIGT',600,'n/a','n/a','Melbourne Australia','オーストラリア、メルボルン時間'),
  (13,'ACST',570,'n/a','n/a','Central Australia Std Time','オーストラリア中部標準時間'),
  (14,'SAST',570,'n/a','n/a','South Australia Std Time','オーストラリア南部標準時間'),
  (15,'CAST',570,'n/a','n/a','Central Australia Std Time','オーストラリア中部標準時間'),
  (16,'AWSST',540,'n/a','n/a','Australia Western Summer Std Time','オーストラリア西部標準時間'),
  (17,'JST',540,'n/a','n/a','Japan Std Time/USSR Zone 8','日本標準時間、ソビエトタイムゾーン8'),
  (18,'KST',540,'n/a','n/a','Korea Standard Time ','韓国標準時間'),
  (19,'WDT',540,'n/a','n/a','West Australian Daylight Time ','オーストラリア西部夏時間'),
  (20,'MT',510,'n/a','n/a','Moluccas Time','モルッカ諸島時間'),
  (21,'AWST',480,'n/a','n/a','Australia Western Std Time','オーストラリア西部標準時間'),
  (22,'CCT',480,'n/a','n/a','China Coastal Time','中国湾岸時間');
INSERT INTO timezones VALUES 
  (23,'WADT',480,'n/a','n/a','West Australian Daylight Time','西部オーストラリア夏時間'),
  (24,'WST',480,'n/a','n/a','West Australian Std Time','西部オーストラリア標準時間'),
  (25,'JT',450,'n/a','n/a','Java Time','ジャワ島時間'),
  (26,'WAST',420,'n/a','n/a','West Australian Std Time','西部オーストラリア標準時間'),
  (27,'IT',210,'n/a','n/a','Iran Time','イラン時間'),
  (28,'BT',180,'n/a','n/a','Baghdad Time','バグダッド時間'),
  (29,'EETDST',180,'n/a','n/a','Eastern Europe Daylight Savings Time','東ヨーロッパ夏時間'),
  (30,'CETDST',120,'n/a','n/a','Central European Daylight Savings Time','中央ヨーロッパ夏時間'),
  (31,'EET',120,'n/a','n/a','Eastern Europe/USSR Zone 1','東ヨーロッパ時間、ソビエトタイムゾーン1'),
  (32,'FWT',120,'n/a','n/a','French Winter Time','フランス冬時間'),
  (33,'IST',120,'n/a','n/a','Israel Std Time ','イスラエル標準時間'),
  (34,'MEST',120,'n/a','n/a','Middle Europe Summer Time','中央ヨーロッパ夏時間');
INSERT INTO timezones VALUES 
  (35,'METDST',120,'n/a','n/a','Middle Europe Daylight Time','中央ヨーロッパ夏時間'),
  (36,'SST',120,'n/a','n/a','Swedish Summer Time','スウェーデン夏時間'),
  (37,'BST',60,'n/a','n/a','British Summer Time','イギリス夏時間'),
  (38,'CET',60,'n/a','n/a','Central European Time','中央ヨーロッパ時間'),
  (39,'DNT',60,'n/a','n/a','Dansk Normal Tid','デンマーク標準時間'),
  (40,'FST',60,'n/a','n/a','French Summer Time','フランス夏時間'),
  (41,'MET',60,'n/a','n/a','Middle Europe Time','中央ヨーロッパ時間'),
  (42,'MEWT',60,'n/a','n/a','Middle Europe Winter Time','中央ヨーロッパ冬時間'),
  (43,'MEZ',60,'n/a','n/a','Middle Europe Zone','中央ヨーロッパ時間'),
  (44,'NOR',60,'n/a','n/a','Norway Standard Time','ノルウェー標準時間'),
  (45,'SET',60,'n/a','n/a','Seychelles Time','セイシェル時間'),
  (46,'SWT',60,'n/a','n/a','Swedish Winter Time ','スウェーデン冬時間'),
  (47,'WETDST',60,'n/a','n/a','Western Europe Daylight Savings Time','西ヨーロッパ夏時間');
INSERT INTO timezones VALUES 
  (48,'GMT',0,'n/a','n/a','Greenwich Mean Time','グリニッジ標準時'),
  (49,'WET',0,'n/a','n/a','Western Europe','西ヨーロッパ'),
  (50,'WAT',-60,'n/a','n/a','West Africa Time','西アフリカ時間'),
  (51,'NDT',-150,'n/a','n/a','Newfoundland Daylight Time','ニューファンドランド夏時間'),
  (52,'ADT',-180,'n/a','n/a','Atlantic Daylight Time','大西洋夏時間'),
  (53,'NFT',-210,'n/a','n/a','Newfoundland Standard Time','ニューファンドランド標準時間'),
  (54,'NST',-210,'n/a','n/a','Newfoundland Standard Time','ニューファンドランド標準時間'),
  (55,'AST',-240,'n/a','n/a','Atlantic Std Time (Canada)','大西洋標準時間 (カナダ)'),
  (56,'EDT',-240,'n/a','n/a','Eastern Daylight Time','アメリカ東部夏時間'),
  (57,'CDT',-300,'n/a','n/a','Central Daylight Time','アメリカ中部夏時間'),
  (58,'EST',-300,'n/a','n/a','Eastern Standard Time','アメリカ東部標準時間'),
  (59,'CST',-360,'n/a','n/a','Central Std Time ','アメリカ中部標準時間'),
  (60,'MDT',-360,'n/a','n/a','Mountain Daylight Time','アメリカ中部標準時間');
INSERT INTO timezones VALUES 
  (61,'MST',-420,'n/a','n/a','Mountain Standard Time ','アメリカ山岳部標準時間'),
  (62,'PDT',-420,'n/a','n/a','Pacific Daylight Time','アメリカ太平洋夏時間'),
  (63,'PST',-480,'n/a','n/a','Pacific Std Time','アメリカ太平洋標準時間'),
  (64,'YDT',-480,'n/a','n/a','Yukon Daylight Time','ユーコン夏時間'),
  (65,'HDT',-540,'n/a','n/a','Hawaii/Alaska Daylight Time','ハワイ/アラスカ夏時間'),
  (66,'YST',-540,'n/a','n/a','Yukon Standard Time','ユーコン標準時間'),
  (67,'AHST',-600,'n/a','n/a','Alaska-Hawaii Std Time','アラスカ-ハワイ標準時間'),
  (68,'CAT',-600,'n/a','n/a','Central Alaska Time','アラスカ中央時間'),
  (69,'NT',-660,'n/a','n/a','Nome Time','ノーム時間'),
  (70,'IDLW',-720,'n/a','n/a','International Date Line West','日付変更線、西側');

-- tags master. - GTD context.
INSERT INTO tags (value) VALUES('@phone');
INSERT INTO tags (value) VALUES('@fax');
INSERT INTO tags (value) VALUES('@web');
INSERT INTO tags (value) VALUES('@home');
INSERT INTO tags (value) VALUES('@office');
INSERT INTO tags (value) VALUES('@starbucks');
INSERT INTO tags (value) VALUES('@blog');
INSERT INTO tags (value) VALUES('@sns');
INSERT INTO tags (value) VALUES('@skype');


-- default user.
INSERT INTO users (
    ID
   ,LOGIN_ID
   ,PASSWORD
   ,EMAIL
   ,LAST_NAME
   ,MIDDLE_NAME
   ,FIRST_NAME
   ,PHOTO_IMG_URL
   ,DEL_FLAG
   ,REGISTERED
   ,MODIFIED
   ,MODIFIED_USER_ID
) VALUES (
    1
   ,'admin_user'
   ,'admin_user'
   ,'admin@mail.com'
   ,'User'
   ,' '
   ,'Administrator'
   ,''
   ,'0'
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,1
);

-- add activity.
INSERT INTO activities (
    ID
   ,NAME
   ,DESCRIPTION
   ,START_DATE
   ,END_DATE
   ,DEL_FLAG
   ,REGISTERED
   ,MODIFIED
   ,MODIFIED_USER_ID
) VALUES (
    1
   ,'Test Project'
   ,'Description'
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDD')
   ,'99999999'
   ,'0'
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,1
);

-- add activity member.
insert into activity_members (
    ACTIVITY_ID
   ,USER_ID 
   ,ROLE_ID
   ,START_DATE
   ,REGISTERED
   ,MODIFIED 
   ,MODIFIED_USER_ID
) values (
    1
   ,1
   ,1
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDD')
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,1
);

-- add activity relation.
INSERT INTO activity_relations (
    ACTIVITY_ID
   ,COLOR_ID 
   ,USER_ID
) VALUES (
    1
   ,1
   ,1
);

-- add user role.
INSERT INTO user_roles (USER_ID, ROLE_ID) VALUES (1,1);