--
-- tugboat.GTD PostgreSQL ver0.7.1 fix.
--
CREATE TABLE tags (
    ID                      serial        NOT NULL
   ,VALUE                   varchar(64)   NOT NULL
);
CREATE TABLE task_tags (
    ID                      serial        NOT NULL
   ,TASK_ID                 integer       NOT NULL
   ,TAG_ID                  integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
   ,POSTED_AT               char(14)      NOT NULL
);
CREATE TABLE task_select_views (
    ID                      serial        NOT NULL
   ,MODE_ID                 integer       NOT NULL default 0 
   ,CLASS_ID                integer       NOT NULL default 0
   ,IS_ViSIBLE_BROWSER      integer       NOT NULL default 0
   ,SELECTED_TAB_ID         integer       NOT NULL default 0
   ,USER_ID                 integer       NOT NULL
);

CREATE TABLE task_select_tags (
    ID                      serial        NOT NULL
   ,TAG_ID                  integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);

CREATE TABLE task_browser_statuses (
    ID                      serial        NOT NULL
   ,STATUS_ID               integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);
CREATE TABLE task_browser_classifications (
    ID                      serial        NOT NULL
   ,CLASS_ID                integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);
CREATE TABLE task_browser_activities (
    ID                      serial        NOT NULL
   ,ACTIVITY_ID             integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);
CREATE TABLE task_browser_persons (
    ID                      serial        NOT NULL
   ,PERSON_ID               integer       NOT NULL
   ,USER_ID                 integer       NOT NULL
);
CREATE TABLE web_service_securities (
    ID                      serial        NOT NULL
   ,CLIENT_ADDRESS          varchar(256)  NOT NULL
   ,NONCE                   char(20)      NOT NULL
   ,CREATED_AT              char(20)      NOT NULL
);


COMMENT ON TABLE  tags                                            IS 'Tag Master';
COMMENT ON COLUMN tags.ID                                         IS 'Id';
COMMENT ON COLUMN tags.VALUE                                      IS 'Value';

COMMENT ON TABLE  task_tags                                       IS 'Task Tags';
COMMENT ON COLUMN task_tags.ID                                    IS 'Id';
COMMENT ON COLUMN task_tags.TASK_ID                               IS 'Task Id';
COMMENT ON COLUMN task_tags.TAG_ID                                IS 'Tag Id';
COMMENT ON COLUMN task_tags.USER_ID                               IS 'User Id';
COMMENT ON COLUMN task_tags.POSTED_AT                             IS 'Posted At';

COMMENT ON TABLE  task_select_views                               IS 'Task select views';
COMMENT ON COLUMN task_select_views.ID                            IS 'Id';
COMMENT ON COLUMN task_select_views.MODE_ID                       IS 'Mode Id [0:Block],[1:List]';
COMMENT ON COLUMN task_select_views.CLASS_ID                      IS 'Class Id';
COMMENT ON COLUMN task_select_views.IS_ViSIBLE_BROWSER            IS 'Is Show Browser [0:not visible] [1:visible]';
COMMENT ON COLUMN task_select_views.SELECTED_TAB_ID               IS 'Selected tab Id [0:folder] [1:tags]';
COMMENT ON COLUMN task_select_views.USER_ID                       IS 'User Id';

COMMENT ON TABLE  task_select_tags                                IS 'Task_select_tags';
COMMENT ON COLUMN task_select_tags.ID                             IS 'Id';
COMMENT ON COLUMN task_select_tags.TAG_ID                         IS 'Tag Id';
COMMENT ON COLUMN task_select_tags.USER_ID                        IS 'User Id';

COMMENT ON TABLE  task_browser_statuses                           IS 'Task browse statuses';
COMMENT ON COLUMN task_browser_statuses.ID                        IS 'Id';
COMMENT ON COLUMN task_browser_statuses.STATUS_ID                 IS 'Status Id';
COMMENT ON COLUMN task_browser_statuses.USER_ID                   IS 'User Id';

COMMENT ON TABLE  task_browser_classifications                    IS 'Task browse classifications';
COMMENT ON COLUMN task_browser_classifications.ID                 IS 'Id';
COMMENT ON COLUMN task_browser_classifications.CLASS_ID           IS 'Class Id';
COMMENT ON COLUMN task_browser_classifications.USER_ID            IS 'User Id';

COMMENT ON TABLE  task_browser_activities                         IS 'Task browse activities';
COMMENT ON COLUMN task_browser_activities.ID                      IS 'Id';
COMMENT ON COLUMN task_browser_activities.ACTIVITY_ID             IS 'Activity Id';
COMMENT ON COLUMN task_browser_activities.USER_ID                 IS 'User Id';

COMMENT ON TABLE  task_browser_persons                            IS 'Task browse persons';
COMMENT ON COLUMN task_browser_persons.ID                         IS 'Id';
COMMENT ON COLUMN task_browser_persons.PERSON_ID                  IS 'Person Id';
COMMENT ON COLUMN task_browser_persons.USER_ID                    IS 'User Id';

COMMENT ON TABLE  web_service_securities                          IS 'Web service securities ';
COMMENT ON COLUMN web_service_securities.ID                       IS 'Id';
COMMENT ON COLUMN web_service_securities.CLIENT_ADDRESS           IS 'Client address';
COMMENT ON COLUMN web_service_securities.NONCE                    IS 'Nonce';
COMMENT ON COLUMN web_service_securities.CREATED_AT               IS 'Created at';

-- 
-- primary key
--
ALTER TABLE tags
  ADD CONSTRAINT tags_pk
  PRIMARY KEY (ID);

ALTER TABLE task_tags
  ADD CONSTRAINT task_tags_pk
  PRIMARY KEY (ID);
  
ALTER TABLE task_select_views
  ADD CONSTRAINT task_select_views_pk
  PRIMARY KEY (ID);
  
ALTER TABLE task_select_tags
  ADD CONSTRAINT task_select_tags_pk
  PRIMARY KEY (ID);
  
ALTER TABLE task_browser_statuses
  ADD CONSTRAINT task_browser_statuses_pk
  PRIMARY KEY (ID);

ALTER TABLE task_browser_classifications
  ADD CONSTRAINT task_browser_classifications_pk
  PRIMARY KEY (ID);

ALTER TABLE task_browser_activities
  ADD CONSTRAINT task_browser_activities_pk
  PRIMARY KEY (ID);

ALTER TABLE task_browser_persons
  ADD CONSTRAINT task_browser_persons_pk
  PRIMARY KEY (ID);

ALTER TABLE web_service_securities
  ADD CONSTRAINT web_service_securities_pk
  PRIMARY KEY (ID);

-- 
-- foreign key
--
ALTER TABLE task_tags 
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks(ID);

ALTER TABLE task_tags 
  ADD FOREIGN KEY (TAG_ID) 
  REFERENCES tags(ID);
  
ALTER TABLE task_tags 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);
  
ALTER TABLE task_select_views 
  ADD FOREIGN KEY (CLASS_ID) 
  REFERENCES classifications(ID);

ALTER TABLE task_select_views 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_select_tags 
  ADD FOREIGN KEY (TAG_ID) 
  REFERENCES tags(ID);
  
ALTER TABLE task_select_tags 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_statuses 
  ADD FOREIGN KEY (STATUS_ID) 
  REFERENCES task_statuses(ID);
  
ALTER TABLE task_browser_statuses 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_classifications 
  ADD FOREIGN KEY (CLASS_ID) 
  REFERENCES classifications(ID);
  
ALTER TABLE task_browser_classifications 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_activities 
  ADD FOREIGN KEY (ACTIVITY_ID) 
  REFERENCES activities(ID);

ALTER TABLE task_browser_activities 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_persons 
  ADD FOREIGN KEY (PERSON_ID) 
  REFERENCES users(ID);

ALTER TABLE task_browser_persons 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);

-- 
-- grant table and sequence.
--
GRANT ALL ON tags                                             TO tangerine;
GRANT ALL ON task_tags                                        TO tangerine;
GRANT ALL ON task_select_views                                TO tangerine;
GRANT ALL ON task_select_tags                                 TO tangerine;
GRANT ALL ON task_browser_statuses                            TO tangerine;
GRANT ALL ON task_browser_classifications                     TO tangerine;
GRANT ALL ON task_browser_activities                          TO tangerine;
GRANT ALL ON task_browser_persons                             TO tangerine;
GRANT ALL ON web_service_securities                           TO tangerine;

GRANT ALL ON SEQUENCE tags_id_seq                             TO tangerine;
GRANT ALL ON SEQUENCE task_tags_id_seq                        TO tangerine;
GRANT ALL ON SEQUENCE task_select_views_id_seq                TO tangerine;
GRANT ALL ON SEQUENCE task_select_tags_id_seq                 TO tangerine;
GRANT ALL ON SEQUENCE task_browser_statuses_id_seq            TO tangerine;
GRANT ALL ON SEQUENCE task_browser_classifications_id_seq     TO tangerine;
GRANT ALL ON SEQUENCE task_browser_activities_id_seq          TO tangerine;
GRANT ALL ON SEQUENCE task_browser_persons_id_seq             TO tangerine;
GRANT ALL ON SEQUENCE web_service_securities_id_seq           TO tangerine;

INSERT INTO classifications VALUES (0, 'T', 'Tasks');
