/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
(function() {
  var heads = document.documentElement.getElementsByTagName("head");
  var isExistsScript = false;
  var _version = '';
  var _view = '';
  var _mode = '';
  
  for (var h = 0; h < heads.length; h++) {
    var scripts = heads[h].getElementsByTagName("script");
    for (var s = 0; s < scripts.length; s++) {
      var url = scripts[s].src;
      var i = url.indexOf("tugboat-api.js");
      if (i >= 0) {
        isExistsScript = true;
        
        var q = url.indexOf("?");
        if (q > 0) {
          var params = url.substr(q + 1).split("&");
          for (var p = 0; p < params.length; p++) {
            var pair = params[p].split("=");
            if (pair[0] == "version") {
              _version = pair[1];
            } else if (pair[0] == "view") {
              _view = pair[1];
            } else if (pair[0] == "mode") {
              _mode = pair[1];
            }
          }
        }
      }
    }
    if (isExistsScript) break;
  }
  
  var index_resources = {
    js : [
      "js/tugboat/setInterval.js?version="       + _version,
      "js/prototype.js?version="                 + _version,
      "js/effects.js?version="                   + _version,
      "js/behaviour.js?version="                 + _version,
      "js/tugboat/tugboat.js?version="           + _version,
      "js/tugboat/constants" + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/login"     + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version
    ],
    css : [
      "css/default/reset.css?version="           + _version,
      "css/default/layout.css?version="          + _version,
      "css/default/login.css?version="           + _version,
      "css/default/buttons.css?version="         + _version
    ]
  };
  
  var task_resources = {
    js : [
      "js/mochiKit/Base.js?version="             + _version,
      "js/mochiKit/Iter.js?version="             + _version,
      "js/mochiKit/DOM.js?version="              + _version,
      "js/tugboat/setInterval.js?version="       + _version,
      "js/prototype.js?version="                 + _version,
      "js/effects.js?version="                   + _version,
      "js/behaviour.js?version="                 + _version,
      "js/window.js?version="                    + _version,
      "js/window_effects.js?version="            + _version,
      "js/controls.js?version="                  + _version,
      "js/yahooUI/yahoo-min.js?version="         + _version,
      "js/yahooUI/dom-min.js?version="           + _version,
      "js/yahooUI/event-min.js?version="         + _version,
      "js/yahooUI/dragdrop-min.js?version="      + _version,
      "js/calendar/calendar.js?version="         + _version,
      "js/calendar/calendar-en.js?version="      + _version,
      "js/calendar/calendar-setup.js?version="   + _version,
      "js/tugboat/tugboat.js?version="           + _version,
    
      "js/tugboat/constants"         + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/util"              + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/ui"                + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/dashboard"         + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdTaskEventRules" + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdTasks"          + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdCommons"        + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version
    ],
    css : [
      "css/default/reset.css?version="               + _version,
      "css/default/layout.css?version="              + _version,
      "css/default/style.css?version="               + _version,
      "css/default/popups.css?version="              + _version,
      "css/default/buttons.css?version="             + _version,
      "css/default/calendar/aqua/theme.css?version=" + _version,
      "css/default/menu.css?version="                + _version,
      "css/default/window/default.css?version="      + _version,
      "css/default/window/mac_os_x.css?version="     + _version,
      "css/default/task.css?version="                + _version
    ]
  };
  
  var task_detail_resources = {
    js : [
      "js/mochiKit/Base.js?version="             + _version,
      "js/mochiKit/Iter.js?version="             + _version,
      "js/mochiKit/DOM.js?version="              + _version,
      "js/tugboat/setInterval.js?version="       + _version,
      "js/prototype.js?version="                 + _version,
      "js/behaviour.js?version="                 + _version,
      "js/effects.js?version="                   + _version,
      "js/controls.js?version="                  + _version,
      "js/window.js?version="                    + _version,
      "js/window_effects.js?version="            + _version,
      "js/yahooUI/yahoo-min.js?version="         + _version,
      "js/yahooUI/dom-min.js?version="           + _version,
      "js/yahooUI/event-min.js?version="         + _version,
      "js/yahooUI/dragdrop-min.js?version="      + _version,
      "js/calendar/calendar.js?version="         + _version,
      "js/calendar/calendar-en.js?version="      + _version,
      "js/calendar/calendar-setup.js?version="   + _version,
      "js/tugboat/tugboat.js?version="           + _version,
    
      "js/tugboat/constants"     + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/util"          + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/ui"            + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/dashboard"     + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdTaskDetail" + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version
    ],
    css : [
      "css/default/reset.css?version="               + _version,
      "css/default/layout.css?version="              + _version,
      "css/default/style.css?version="               + _version,
      "css/default/popups.css?version="              + _version,
      "css/default/buttons.css?version="             + _version,
      "css/default/calendar/aqua/theme.css?version=" + _version,
      "css/default/menu.css?version="                + _version,
      "css/default/window/default.css?version="      + _version,
      "css/default/window/mac_os_x.css?version="     + _version,
      "css/default/task_detail.css?version="         + _version
    ]
  };
  
  var meeting_resources = {
    js : [
      "js/mochiKit/Base.js?version="             + _version,
      "js/mochiKit/Iter.js?version="             + _version,
      "js/mochiKit/DOM.js?version="              + _version,
      "js/tugboat/setInterval.js?version="       + _version,
      "js/prototype.js?version="                 + _version,
      "js/behaviour.js?version="                 + _version,
      "js/effects.js?version="                   + _version,
      "js/controls.js?version="                  + _version,
      "js/window.js?version="                    + _version,
      "js/window_effects.js?version="            + _version,
      "js/yahooUI/yahoo-min.js?version="         + _version,
      "js/yahooUI/dom-min.js?version="           + _version,
      "js/yahooUI/event-min.js?version="         + _version,
      "js/yahooUI/dragdrop-min.js?version="      + _version,
      "js/tugboat/tugboat.js?version="           + _version,
    
      "js/tugboat/constants"     + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/util"          + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/ui"            + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/dashboard"     + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdMeetings"    + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdCommons"    + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version
    ],
    css : [
      "css/default/reset.css?version="               + _version,
      "css/default/layout.css?version="              + _version,
      "css/default/style.css?version="               + _version,
      "css/default/popups.css?version="              + _version,
      "css/default/buttons.css?version="             + _version,
      "css/default/calendar/aqua/theme.css?version=" + _version,
      "css/default/menu.css?version="                + _version,
      "css/default/window/default.css?version="      + _version,
      "css/default/window/mac_os_x.css?version="     + _version,
      "css/default/timeline/styles.css?version="     + _version,
      "css/default/timeline/timeline.css?version="   + _version,
      "css/default/timeline/ethers.css?version="     + _version,
      "css/default/timeline/events.css?version="     + _version,
      "css/default/meeting.css?version="             + _version
    ]      
  };
  
  var meeting_detail_resources = {
    js : [
      "js/mochiKit/Base.js?version="             + _version,
      "js/mochiKit/Iter.js?version="             + _version,
      "js/mochiKit/DOM.js?version="              + _version,
      "js/tugboat/setInterval.js?version="       + _version,
      "js/prototype.js?version="                 + _version,
      "js/behaviour.js?version="                 + _version,
      "js/effects.js?version="                   + _version,
      "js/controls.js?version="                  + _version,
      "js/window.js?version="                    + _version,
      "js/window_effects.js?version="            + _version,
      "js/yahooUI/yahoo-min.js?version="         + _version,
      "js/yahooUI/dom-min.js?version="           + _version,
      "js/yahooUI/event-min.js?version="         + _version,
      "js/yahooUI/dragdrop-min.js?version="      + _version,
      "js/calendar/calendar.js?version="         + _version,
      "js/calendar/calendar-en.js?version="      + _version,
      "js/calendar/calendar-setup.js?version="   + _version,
      "js/tugboat/tugboat.js?version="           + _version,
    
      "js/tugboat/constants"        + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/util"             + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/ui"               + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/dashboard"        + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdMeetingDetail" + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdCommons"       + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version
    ],
    css : [
      "css/default/reset.css?version="               + _version,
      "css/default/layout.css?version="              + _version,
      "css/default/style.css?version="               + _version,
      "css/default/popups.css?version="              + _version,
      "css/default/buttons.css?version="             + _version,
      "css/default/calendar/aqua/theme.css?version=" + _version,
      "css/default/menu.css?version="                + _version,
      "css/default/window/default.css?version="      + _version,
      "css/default/window/mac_os_x.css?version="     + _version,
      "css/default/meeting_detail.css?version="      + _version
    ]      
  };
    
  var activity_resources = {
    js : [
      "js/mochiKit/Base.js?version="             + _version,
      "js/mochiKit/Iter.js?version="             + _version,
      "js/mochiKit/DOM.js?version="              + _version,
      "js/tugboat/setInterval.js?version="       + _version,
      "js/prototype.js?version="                 + _version,
      "js/effects.js?version="                   + _version,
      "js/behaviour.js?version="                 + _version,
      "js/window.js?version="                    + _version,
      "js/window_effects.js?version="            + _version,
      "js/controls.js?version="                  + _version,
      "js/yahooUI/yahoo-min.js?version="         + _version,
      "js/yahooUI/dom-min.js?version="           + _version,
      "js/yahooUI/event-min.js?version="         + _version,
      "js/yahooUI/dragdrop-min.js?version="      + _version,
      "js/tugboat/tugboat.js?version="           + _version,
    
      "js/tugboat/constants"     + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/util"          + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/ui"            + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/dashboard"     + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdCommons"    + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version,
      "js/tugboat/gtdActivities" + (_mode=='product' ? '-min' : '')  +  ".js?version=" + _version
    ],
    
    css : [
      "css/default/reset.css?version="               + _version,
      "css/default/layout.css?version="              + _version,
      "css/default/style.css?version="               + _version,
      "css/default/popups.css?version="              + _version,
      "css/default/buttons.css?version="             + _version,
      "css/default/calendar/aqua/theme.css?version=" + _version,
      "css/default/menu.css?version="                + _version,
      "css/default/window/default.css?version="      + _version,
      "css/default/window/mac_os_x.css?version="     + _version,
      "css/default/activity.css?version="            + _version
    ]
  };

  if (typeof(Tugboat) == 'undefined') Tugboat = {};
  if (typeof(Tugboat.api) == 'undefined') Tugboat.api = {};
  Tugboat.api = {
    /**
     * write tags.
     * 
     * @param {Object} resources
     */
    write_tags : function(resources) {
      for (i=0; i<resources.css.length; i++) {
        document.write(
          "<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"" + resources.css[i] + "\">"
        );
      }
      for (i=0; i<resources.js.length; i++) {
        document.write(
          "<script type='text/javascript' src=\"" + resources.js[i] + "\"></script>"
        );
      }
    }
  };
  
  // index view.
  if (_view == 'index') {
    Tugboat.api.write_tags(index_resources);
  }
  // task view.
  if (_view == 'task') {
    Tugboat.api.write_tags(task_resources);
  }
  // task detail
  if (_view == 'task-detail') {
    Tugboat.api.write_tags(task_detail_resources);
  }
  // meeting view.
  if (_view == 'meeting') {
    Tugboat.api.write_tags(meeting_resources);
  }
  // meeting detail
  if (_view == 'meeting_detail') {
    Tugboat.api.write_tags(meeting_detail_resources);
  }
  // activity
  if (_view == 'activity') {
    Tugboat.api.write_tags(activity_resources);
  }
})();