/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.timeline) == 'undefined') {
    Tugboat.timeline = {};
}

Tugboat.timeline = {
  INTERVAL_HOUR  : 0,
  INTERVAL_DAY   : 1,
  INTERVAL_WEEK  : 2,
  TARGET_ELEMENT : 'timeline_container',
  MINIMUM_HEIGHT : 480,
  
  _select_interval : 1,
  _timeline_band_info : null,
  _timeline_object    : null,
  
  FILTER_TASK           : 1,
  FILTER_TASK_COMMENT   : 2,
  FILTER_MEETING        : 11,
  FILTER_MEETING_AGENDA : 12,
  FILTER_MEETING_COMMENT: 13,
  _select_filters     : [
    {'id': 1,  'selected':true},
    {'id': 2,  'selected':true},
    {'id': 11, 'selected':true},
    {'id': 12, 'selected':true},
    {'id': 13, 'selected':true}
  ],

  CHECK_IMG_ON  : 'images/default/checkbox/task_complete.gif',
  CHECK_IMG_OFF : 'images/default/checkbox/task_notcomplete.gif',

  /**
   * initialize.
   */
  init : function () {
    Tugboat.dashboard.initialize();

    var self = Tugboat.timeline;
    self._setup_event_rules();
    self.resize(true);
    self._generate_timeline(self.TARGET_ELEMENT, self.INTERVAL_DAY, self._select_filters);
    
  },
  
  resize : function(isWhenInit) {
    var self = Tugboat.timeline;
	var window_size = Tugboat.getPageSize();
    var elGtdListPane = YAHOO.util.Dom.getRegion(self.TARGET_ELEMENT);
    
    var height = 
      window_size.windowHeight 
      - elGtdListPane.top-5;
    
    $(self.TARGET_ELEMENT).style.height = 
      (height < self.MINIMUM_HEIGHT ? self.MINIMUM_HEIGHT : height) + 'px';
    
    if (isWhenInit) return false;
    self._generate_timeline(
      self.TARGET_ELEMENT, self._select_interval, self._select_filters);
  },
  
  close_balloon : function() {
    var self = Tugboat.timeline;
    if (self._timeline_object && self._timeline_object._bands[0] ) {
      self._timeline_object._bands[0].closeBubble();
    }
  },
  
  /**
   * setup event rules.
   */
  _setup_event_rules : function() {
    var self = Tugboat.timeline;
    var rules = {
      
      '#menuBar_Help' : function(el) {
      },
      
      '#timeline_interval_day' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'pointer';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          if (self._select_interval == self.INTERVAL_DAY) return false;
          $('radio_day').src = 'images/default/radio/selected_small.gif';
          $('radio_week').src = 'images/default/radio/unselected_small.gif';
          
          self._select_interval = self.INTERVAL_DAY;
          self._reload(self.INTERVAL_DAY, self._select_filters);
        }
      },
      '#timeline_interval_week' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'pointer';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          if (self._select_interval == self.INTERVAL_WEEK) return false;
          $('radio_week').src = 'images/default/radio/selected_small.gif';
          $('radio_day').src = 'images/default/radio/unselected_small.gif';
          
          self._select_interval = self.INTERVAL_WEEK;
          self._reload(self.INTERVAL_WEEK, self._select_filters);
        }
      },
      '#filter_task' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'pointer';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          if (!self._isSelectFilter(self.FILTER_TASK)) return false;

          var f = self._getFilter(self.FILTER_TASK);
          $('check_task').src = (f.selected ? self.CHECK_IMG_OFF : self.CHECK_IMG_ON);
          f.selected = !f.selected;
          
          self._reload(self._select_interval, self._select_filters);
        }
      },
      '#filter_task_comment' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'pointer';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          if (!self._isSelectFilter(self.FILTER_TASK_COMMENT)) return false;

          var f = self._getFilter(self.FILTER_TASK_COMMENT);
          $('check_comment').src = (f.selected ? self.CHECK_IMG_OFF : self.CHECK_IMG_ON);
          f.selected = !f.selected;
          
          self._reload(self._select_interval, self._select_filters);
        }
      },
      '#filter_meeting' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'pointer';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          if (!self._isSelectFilter(self.FILTER_MEETING)) return false;
          
          var f = self._getFilter(self.FILTER_MEETING);
          $('check_meeting').src = (f.selected ? self.CHECK_IMG_OFF : self.CHECK_IMG_ON);
          f.selected = !f.selected;
          
          self._reload(self._select_interval, self._select_filters);
        }
      },
      '#filter_meeting_agenda' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'pointer';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          if (!self._isSelectFilter(self.FILTER_MEETING_AGENDA)) return false;
          
          var f = self._getFilter(self.FILTER_MEETING_AGENDA);
          $('check_agenda').src = (f.selected ? self.CHECK_IMG_OFF : self.CHECK_IMG_ON);
          f.selected = !f.selected;
          
          self._reload(self._select_interval, self._select_filters);
        }
      },
      '#filter_meeting_comment' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'pointer';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          if (!self._isSelectFilter(self.FILTER_MEETING_COMMENT)) return false;
          
          var f = self._getFilter(self.FILTER_MEETING_COMMENT);
          $('check_discussion').src = (f.selected ? self.CHECK_IMG_OFF : self.CHECK_IMG_ON);
          f.selected = !f.selected;
          
          self._reload(self._select_interval, self._select_filters);
        }
      }
    };
    Behaviour.register(rules);
  },
  
  /**
   * get filter.
   * @param {Object} id
   */
  _getFilter : function(id) {
    var self = Tugboat.timeline;
    return filter = 
      self._select_filters.find(
        function(f){
          return (id==f.id);
        }
      );
  },
  
  /**
   * get selected filter.
   */
  _isSelectFilter : function(id) {
    var self = Tugboat.timeline;
    var selected = 0;
    self._select_filters.each(
      function(f) {
        if (f.selected) selected++;
      }
    );
    return !(selected==1 && self._getFilter(id).selected);
  },
  
  /**
   * reload.
   * @param {Number} interval
   */
  _reload : function(interval, filter) {
    var self = Tugboat.timeline;
    $(self.TARGET_ELEMENT).innerHTML = '';
    self._generate_timeline(self.TARGET_ELEMENT, interval, filter);
  },
  
  /**
   * generate timeline.
   * @param {Object} targetId
   * @param {Number} interval
   * @param {Object} filter
   */
  _generate_timeline : function(targetId, interval, filter) {
    Tugboat.timeline.modal.open();

    var self = Tugboat.timeline;
    if (self._timeline_object && self._timeline_object._bands[0] ) {
      self._timeline_object._bands[0].closeBubble();
    }
    var eventSource = new Timeline.DefaultEventSource();
    var theme = Timeline.ClassicTheme.create();
    theme.event.bubble.width = 360;
    theme.event.bubble.height = 240;

    var datetime = Tugboat.getNowDateTime();
    var today = new Date();
    today.setTime(
      today.getTime() - ( (interval == self.INTERVAL_DAY ? 3 : 40) * 3600 * 1000)
    );
    var todayStart = new Date();
    todayStart.setFullYear(datetime.year);
    todayStart.setMonth(datetime.month-1);
    todayStart.setDate(datetime.dayOfMonth);
    todayStart.setHours(0);
    todayStart.setMinutes(0);
    todayStart.setSeconds(0);
   
    var todayEnd = new Date();
    todayEnd.setFullYear(datetime.year);
    todayEnd.setMonth(datetime.month-1);
    todayEnd.setDate(datetime.dayOfMonth);
    todayEnd.setHours(23);
    todayEnd.setMinutes(59);
    todayEnd.setSeconds(59);

    self._timeline_band_info = 
    [
      Timeline.createHotZoneBandInfo(
      {
        zones: [
          {   start:'Sep 01 2006 00:00:00 GMT+0900',
                end:'Jan 01 2009 00:00:00 GMT+0900',
            magnify: (interval == self.INTERVAL_DAY ? 30 : 40),
               unit: (interval == self.INTERVAL_DAY ? Timeline.DateTime.DAY : Timeline.DateTime.WEEK)
          },
          {   start:todayStart.toString(),
                end:todayEnd.toString(),
            magnify:3,
               unit:(interval == self.INTERVAL_DAY ? Timeline.DateTime.HOUR : Timeline.DateTime.DAY)
          }
        ],
        timeZone:       9,
        eventSource:    eventSource,
        date:           today.toString(),
        width:          '100%', 
        intervalUnit:   (interval == self.INTERVAL_DAY ? Timeline.DateTime.WEEK : Timeline.DateTime.MONTH), 
        intervalPixels: 100,
        theme: theme,
        showEventText:  true
      })
    ];
    
    for (var i = 0; i < self._timeline_band_info.length; i++) {
      self._timeline_band_info[i].decorators = [
        new Timeline.SpanHighlightDecorator({
          startDate:  todayStart.toString(),
          endDate:    todayEnd.toString(),
          color:      '#FFFF99',
          opacity:    30,
          startLabel: 'Today',
          endLabel:   '',
          theme:      theme
        })
      ];
    }
    self._timeline_object = 
      Timeline.create(document.getElementById(targetId), self._timeline_band_info,Timeline.HORIZONTAL);
    
    var fileterQueryStr = '';
    self._select_filters.each(
      function(f) {
        if (f.selected) fileterQueryStr += (f.id + ',');
      }
    );
    fileterQueryStr = fileterQueryStr.substring(0,fileterQueryStr.length-1);
    
    Timeline.loadXML(
      './teeda.ajax?component=timelineAjax&action=getXmlData&sysdate=' 
      + Tugboat.dateSerialize(new Date())+ '&selectFunctions=' + fileterQueryStr,
      function(xml, url) {
        eventSource.loadXML(xml, url); 
        
        Tugboat.timeline.modal.close();
      }
    );
  },
  
  /*
   * Modal window
   *
   * 
   */
  modal : {
    open : function () {
      var page = Tugboat.getPageSize(); 
      Element.setHeight('modal_window', page.pageHeight);
      $('modal_window').style.display = 'block';
    },

    close : function() {
      $('modal_window').style.display = 'none';
    }
  }
};
YAHOO.util.Event.addListener(
  document, "keydown",
  function(key){
    if (key.keyCode == Event.KEY_ESC) {
      Tugboat.timeline.close_balloon();
    }
  }
);