/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.gtd_task) == 'undefined') {
    Tugboat.gtd_task = {};
}

Tugboat.gtd_task = {
  _task_list_json   : null,
  _activities       : null,
  _person_in_charge : null,
  _selected_tab     : 0, /* [0]:folder, [1]:tags */
  _is_visibled_browser : false,
  _before_selected_foder_id : '',
  _prev_entry_key_code : 0,

  /**
   * Initialize.
   * 
   */
  init : function() {
    if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) {
      $('add_task_tags_target').style.display    = Tugboat.constant.STYLE_DISPLAY_NONE;
    }
    $('tag_filter').value = 'tags filter...';
    Tugboat.gtd_common.set_application_window_size();
    Tugboat.gtd_common.task.setup_task_droppables();
    Tugboat.dashboard.initialize();
    Tugboat.gtd_task_event_rule.setup_event_rules();
    
    var self = Tugboat.gtd_task;
    self._get_activities_json();
    self.browser.reset(false);
    
    Tugboat.gtd_task.sub_window.setup_auto_completer();
    $('add_task_tags').setAttribute("AutoComplete", "off");
    
    Tugboat.gtd_task.tag._setup_tags_drag_target();
    
    Calendar.setup({
      inputField  : 'edit_due',
      displayArea : 'edit_due_display',
      ifFormat    : '%Y%m%d',
      daFormat    : '%Y-%m-%d',
      button      : 'show_calendar_button'
    });
  },
  
  /**
   * get activities json.
   * 
   */
  _get_activities_json : function() {
    var self = Tugboat.gtd_task;
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component:'taskAjax',
          action   :'getActivitiesJSON'
        },
        onComplete: function(transport){
          self._activities = eval(transport.responseText);
          self._get_before_view_statuses();
        }
      }
    );
  },
  
  /**
   * get before view statuses.
   * 
   */
  _get_before_view_statuses : function() {
    var self = Tugboat.gtd_task;
    new Ajax.Request (
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component:'taskAjax',
          action   :'getBeforeViewStatusesJSON'
        },
        onComplete: function(transport){
          if (Tugboat.isEmpty(transport.responseText)) return false;
          var json = eval('(' + transport.responseText + ')');

          var isExistChecked = false;
          self._activities.each(
            function(a) {
              var selected_activity = json.activities.find(
                function(s) {
                  return a.id == s;
                }
              );
              var before_checled = (typeof(selected_activity) != 'undefined');
              if (before_checled) isExistChecked = true;
              self.browser._activity_info.push(
                { id     :a.id, 
                  value  :a.value,
                  checked:before_checled,
                  color  :a.color
                }
              );
            }
          );
          if (isExistChecked) {
            var activity_value = self.browser._activity_info.find(
              function(a) {
                return a.id == 0;
              }
            );
            activity_value.checked = false;
          }
          Tugboat.gtd_task.browser.create_activity_list(self.browser._activity_info);
          
          self._get_person_in_charge_json(json);
        }
      }
    );
  },
  
  
  /**
   * set person in charge list.
   * 
   * @param {Object} json
   * 
   */
  _set_person_in_charge_list : function(json) {
    var self = Tugboat.gtd_task;
    var isExistChecked = false;
    
    self.browser._person_info = [];
    self._person_in_charge.each(
      function(p) {
        var is_before_selected = false;
        if (json) {
          var selected_person = json.people.find(
            function(s) {
              return p.personId == s;
            }
          );
          is_before_selected = (typeof(selected_person)!='undefined');
          if (typeof(selected_person)!='undefined') isExistChecked = true;
        }
        self.browser._person_info.push(
          { 'id'        :p.personId, 
            'checked'   :is_before_selected,
            'isMe'      :p.isMe, 
            'last_name' :p.personLastName,
            'first_name':p.personFirstName
          }
        );
      }
    );
    if (! isExistChecked) {
      var person_value = self.browser._person_info.find(
        function(p) { return (json ? p.id == 0 : p.isMe) }
      );
      person_value.checked = true;
    }
  },
  
  /**
   * get person in charge json.
   * 
   * @param {Object} json
   */
  _get_person_in_charge_json : function(json) {
    var self = Tugboat.gtd_task;
    var activityQueryParam = self.browser._get_activity_query_params();
    
    new Ajax.Request (
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component   :'activityMemberAjax',
          action      :'getActivityMembersByActivities',
          activityIds :activityQueryParam
        },
        onComplete: function(transport){
          if (! transport.responseText) self._person_in_charge = null;
          else self._person_in_charge = eval(transport.responseText);

          self._set_person_in_charge_list(json);
          Tugboat.gtd_task.browser._create_person_in_charge_list(self.browser._person_info);
          
          // set browser visible. 
          $('browser_pane').style.display = 
            json.is_visible_browser == 0 ? Tugboat.constant.STYLE_DISPLAY_NONE : '';
          
          self._is_visibled_browser = json.is_visible_browser == 1;
          
          if (json.select_mode == 0) {
            Tugboat.gtd_common.blockSelect($('layout_block'));
            Tugboat.gtd_task.setDragnDropTodayPaneStyle('block');
          } else {
            Tugboat.gtd_common.listSelect($('layout_list'));
            Tugboat.gtd_task.setDragnDropTodayPaneStyle('list');
          }
          
          // get tags => create tag folder.
          Tugboat.gtd_task.tag.setup_tag_folder(true);
          
          self._selected_tab = json.select_tab;
          var selected_class = 
            Tugboat.constant.task.findFolderByValue(json.select_class);
          
          Tugboat.gtd_common.resize_list_area(false,false);
          Tugboat.gtd_task.folder.folder_onclick(selected_class.id, false, json);
          
          if (selected_class.id == Tugboat.constant.task.FOLDER_INBOX.id) {
            Tugboat.gtd_task.sub_window.get_activities_json();
          }
        }
      }
    );
  },
  
  /**
   * empty a trash box.
   */
  empty_trashbox_onclick : function() {
    if (! confirm('May I empty a trash box?')) return false;
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component:'taskAjax',
          action   :'emptyTrashBox'
        },
        onComplete: function(transport){
          Tugboat.gtd_task.folder.folder_onclick(
            TugboatUI.DragBox.selectedFolderId, true);
        }
      }
    );
  },
 
  shortcut_keys_window : null,
  shortcut_keys_onclick : function() {
    Tugboat.gtd_task.modal.open();
    var self = Tugboat.gtd_task.sub_window;
      
    self.shortcut_keys_window = 
      new Window(
        'addTaskWindow',
        { className: 'mac_os_x', width:320, height:80, 
          zIndex: 100, 
          minimizable: false, 
          closable   : false, 
          maximizable: false,
          resizable  : false, 
          draggable  : true,
          title      : 'Shortcut keys?',
          showEffectOptions:{
            duration:0.5
          }
        }
      );
    self.shortcut_keys_window.setContent('shortcut_keys_sub_window_container',false,false);
    self.shortcut_keys_window.setDestroyOnClose();
    self.shortcut_keys_window.showCenter();
      
    var taskWindowObserver = {
      onDestroy: function(eventName, win) {
        if (win == self.shortcut_keys_window) {
          Element.hide('shortcut_keys_sub_window_container');
          $('shortcut_keys_sub_window_container').appendChild($('shortcut_keys_sub_window'));
                     
          Windows.removeObserver(this);
          Tugboat.gtd_task.modal.close();
        }
      }
    };
    Windows.addObserver(taskWindowObserver);
  },
  
  /**
   * selected view mode.
   * 
   * @param {Number} modeId
   */
  selected_view_mode : function(modeId) {
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component  :'taskAjax',
          action     :'selectModeBlockOrList',
          selectMode :modeId
        },
        onComplete: function(transport){
        }
      }
    );
    return false;
  },
  
  /**
   * selected tab.
   * 
   * @param {Number} tabId
   */
  selected_tab : function(tabId) {
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component     :'taskAjax',
          action        :'updateSelectedTab',
          selectedTabId :tabId
        },
        onComplete: function(transport){
        }
      }
    );
    return false;
  },
  
  /**
   * set drag and drop today pane style.
   * 
   * @param {String} selectedMode
   */
  setDragnDropTodayPaneStyle : function(selectedMode) {
    $('list_pane').className = 
      (selectedMode == 'block' ? 'block_mode' : 'list_mode');

    var className = (selectedMode == 'block' ? 'gtdBox' : 'gtdList');
    TugboatUI.DragBox.dropTargetStyles.each(
      function(t) {
        if (t.id.indexOf('list_top') > -1
         || t.id.indexOf('list_middle') > -1 
         || t.id.indexOf('list_bottom') > -1 ) {
                
          t.defaultStyle  = className + ' clearfix';
          t.dragOverStyle = className + ' clearfix gtdBox_hover';
        }
      }
    );
  },
  
  /**
   * edit task.
   * 
   * @param {Object} id
   */
  edit_task : function(id) {
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {   
        method: Tugboat.constant.REQUEST_GET,
        parameters: 
        {
          component : 'taskAjax',
          action    : 'getTaskForBalloonJSON',
          id        : id
        },
        onComplete: function(transport){
          if (Tugboat.isEmpty(transport.responseText)) return false;
          
          var json = eval('(' + transport.responseText + ')');
          Tugboat.gtd_task.sub_window.edit_task_onclick(json);
        }
      }
    );
  },
  
  /*
   * Sub window
   *
   * 
   */
  sub_window : {
    add_task_window     : null,
    activity_select     : null,
    _tag_auto_completer : null,
    
    MODE_ADD  : 1,
    MODE_EDIT : 2,
    
    _editing_task       : null,
    _edit_mode          : 1,
    _is_processing      : false,
    
    ADD_TYPE_NORMAL  : 1,
    ADD_TYPE_ANOTHER : 2,
    
    /**
     * add task on click.
     * 
     */
    add_task_onclick : function() {
      Tugboat.gtd_task.modal.open();
      var self = Tugboat.gtd_task.sub_window;
      
      self._edit_mode = self.MODE_ADD;
      var classname = $('add_task_option_arrow').className;
      var window_height = classname.indexOf('right')>-1 ? 150 : 385;
      
      if (! self.activity_select) { self.get_activities_json(0); }
      
      Element.show('add_task_actions');
      Element.hide('edit_task_actions');
      
      self.add_task_window = 
        new Window(
          'addTaskWindow',
          { className: 'mac_os_x', width:570, height:window_height, 
            zIndex: 100, 
            minimizable: false, 
            closable   : false, 
            maximizable: false,
            resizable  : false, 
            draggable  : true,
            title      : 'Add task',
            showEffectOptions:{
              duration:0.5, 
              afterFinish:function(){$('add_task_title').focus();}
            }
          }
        );
      self.add_task_window.setContent('task_sub_window_container',false,false);
      self.add_task_window.setDestroyOnClose();

      var windowScroll = WindowUtilities.getWindowScroll();    
      var pageSize = WindowUtilities.getPageSize();    
      var left = 
        (pageSize.windowWidth - 
          (self.add_task_window.width
         + self.add_task_window.widthW
         + self.add_task_window.widthE)) / 2;
      left += windowScroll.left 
    
      self.add_task_window.setLocation(50, left);
      self.add_task_window.show();
      
      var taskWindowObserver = {
        onDestroy: function(eventName, win) {
          if (win == self.add_task_window) {
            Element.hide('task_sub_window_container');
            $('task_sub_window_container').appendChild($('task_sub_window'));
            
            self.add_task_window = null;
            self._is_processing = false;
            
            Windows.removeObserver(this);
            Tugboat.gtd_task.modal.close();
          }
        }
      };
      Windows.addObserver(taskWindowObserver);
    },
    
    /**
     * edit task onclick.
     * 
     * @param {Object} json
     */
    edit_task_onclick : function(json) {
      Tugboat.gtd_task.modal.open();
      var self = Tugboat.gtd_task.sub_window;
      self._edit_mode = self.MODE_EDIT;
      
      var classname = $('add_task_option_arrow').className;
      var window_height = classname.indexOf('right')>-1 ? 150 : 405;
      
      Element.hide('block_balloon');
      Element.hide('add_task_option_arrow');
      Element.show('add_task_option_tags');
      Element.hide('add_task_actions');
      Element.show('edit_task_actions');
      
      if (! self.activity_select) {
        self.get_activities_json(json.task.activityId);
      } else {
        self.activity_select.setSelectedId(json.task.activityId);
      }
      self._editing_task = {id:json.task.id, statusId:json.task.statusId};
      $('add_task_title').value = json.task.title;
      $('add_task_description').value = json.task.description;
      $('edit_due_display').innerHTML = json.task.dueFormated;
      $('edit_due').value = json.task.dueValue;
      
      var tags = '';
      if (json.tags && json.tags.length > 0) {
        for (i = 0; i < json.tags.length; i++) {
          tags += (json.tags[i].tagValue + (i < json.tags.length - 1 ? ',' : ''));
        }
      }
      $('add_task_tags').value = tags;
      
      self.add_task_window = 
        new Window(
          'addTaskWindow', 
          { className: 'mac_os_x', width:560, height:370, 
            zIndex: 100, 
            minimizable: false,
            closable   : false,
            maximizable: false,
            resizable  : false,
            draggable  : true,
            title      : 'Edit task',
            showEffectOptions:{
              duration:0.5, 
              afterFinish:function(){$('add_task_title').focus();}
            }
          }
        );
      self.add_task_window.setContent('task_sub_window_container',false,false);
      self.add_task_window.setDestroyOnClose();
      self.add_task_window.showCenter();

      var taskWindowObserver = {
        onDestroy: function(eventName, win) {
          if (win == self.add_task_window) {
            Element.hide('task_sub_window_container');
            $('task_sub_window_container').appendChild($('task_sub_window'));
            
            self.add_task_window = null;
            self._is_processing = false;
            
            Windows.removeObserver(this);
            
            $('add_task_title').value = '';
            $('add_task_description').value = '';
            $('edit_due_display').innerHTML = '';
            $('edit_due').value = '';
            $('add_task_tags').value = '';
            
            Element.show('add_task_option_arrow');
            if (window_height == 150) {
              Element.hide('add_task_option_tags');
            }
            self._tag_auto_completer.hide();
            self._tag_auto_completer.active = false;
            
            Tugboat.gtd_task.modal.close();
          }
        }
      };
      Windows.addObserver(taskWindowObserver);
    },
    
    /**
     * get activitys ingformation.
     * @param selectedId
     */
    get_activities_json : function(selectedId) {
      if (Tugboat.gtd_task.sub_window.activity_select) return false; 
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {
          method: Tugboat.constant.REQUEST_GET,
          parameters:
          {
            component:'taskAjax',
            action   :'getActivitiesJSON'
          },
          onComplete: function(transport){
            var activities = eval(transport.responseText);
            var list = [];
            activities.each(
              function(a) {
                list.push(
                  { id:a.id, 
                    value:a.value, 
                    icon:'images/default/palette/pl_bg_' + a.color + '.gif'});
              }
            );
            Tugboat.gtd_task.sub_window.activity_select = 
              new TugboatUI.SelectMenu(
                'add_task_activity_container', 
                list,
                { parentElement:'addTaskWindow',
                  isParentWindow:true,
                  onSelected:function(selectValue){ $('add_task_title').focus(); } }
              );
            if (selectedId > 0 ) {
              Tugboat.gtd_task.sub_window.activity_select.setSelectedId(selectedId);
            }
          }
        }
      );
    },
    
    /**
     * setup auto completer for tags suggestion.
     * 
     */
    setup_auto_completer : function() {
      var self = Tugboat.gtd_task.sub_window;
      self._tag_auto_completer = 
        new Ajax.Autocompleter(
          'add_task_tags_target',
          'add_task_tags_ac', 
          'teeda.ajax?component=taskTagAjax&action=findTagsByKeyword', 
          { minChars :1,
            paramName:'keyword',
            optionTextfield:$('selectedTagId_4ad'),
            optionAttributeName:'tgb:value'
          }
        );
    },
    
    /**
     * Add task.
     * 
     * @type [1:add, 2:add another]
     */
    add : function(type) {
      var self = Tugboat.gtd_task.sub_window;
      if (self._is_processing) return false;
      self._is_processing = true;
      
      var selectActivityValue = self.activity_select.getSelectValue();
      var activityId  = selectActivityValue ? selectActivityValue.id : null;
      var title       = $('add_task_title').value;
      var description = $('add_task_description').value;
      var tags        = $('add_task_tags').value;
      var due         = $('edit_due').value;
      
      var messages = [];
      if (activityId == null)     messages.push('\'Activity\' is not selected.');
      if (Tugboat.isEmpty(title) ) messages.push('\'Title\' is required.');
      if (messages.length > 0) {
        Tugboat.showAlertDialog( messages );
        self._is_processing = false;
        return false;
      }

      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component   : 'taskAjax',
            action      : 'add',
            activityId  : activityId,
            title       : title, 
            description : description,
            deadline    : due,
            tags        : tags
          },
          onComplete: function(transport){
            $('add_task_title').value = '';
            $('add_task_title').focus();
            $('add_task_description').value = '';
            $('add_task_tags').value = '';
            $('add_task_tags_target').value = '';
            $('edit_due').value = '';
            $('edit_due_display').innerHTML = '';
            
            // update view.
            if (Tugboat.gtd_task._person_in_charge) { 
              Tugboat.gtd_task.browser.get_task_list_by_query_params(0,1);
            }
            else {
              var _task = Tugboat.gtd_task;
              new Ajax.Request (
                Tugboat.AJAX_SERVLET_NAME,
                {
                  method: Tugboat.constant.REQUEST_GET,
                  parameters:
                  {
                    component:'activityMemberAjax',
                    action:'getActivityMembersJSON'
                  },
                  onComplete: function(transport){
                    if (! transport.responseText) {
                      _task._person_in_charge = null;
                    }
                    else {
                      _task._person_in_charge = eval(transport.responseText);
                      _task.browser._create_person_in_charge_list(_task._person_in_charge);
                      _task.browser.get_task_list_by_query_params(0,1);
                    }
                  }
                }
              );
            }
            Tugboat.gtd_task.tag.setup_tag_folder(false);
            self._is_processing = false;
          }
        }
      );
      if (type == self.ADD_TYPE_NORMAL) {
        Windows.closeAll();
      }
      return false;
    },
    
    /**
     * update.
     */
    update : function() {
      var self = Tugboat.gtd_task.sub_window;
      if (self._is_processing) return false;
      self._is_processing = true;
      
      var id = self._editing_task.id;
      var statusId = self._editing_task.statusId;
      
      var selectActivityValue = self.activity_select.getSelectValue();
      var activityId  = selectActivityValue ? selectActivityValue.id : null;
      var title       = $('add_task_title').value;
      var description = $('add_task_description').value;
      var tags        = $('add_task_tags').value;
      var due         = $('edit_due').value;
      
      var messages = [];
      if (activityId == null)     messages.push('\'Activity\' is not selected.');
      if (Tugboat.isEmpty(title) ) messages.push('\'Title\' is required.');
      if (messages.length > 0) {
        Tugboat.showAlertDialog( messages );
        self._is_processing = false;
        return false;
      }
      
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component   : 'taskDetailAjax',
            action      : 'update',
            id          : id,
            statusId    : statusId,
            activityId  : activityId,
            title       : title, 
            description : description,
            deadline    : due,
            tags        : tags
          },
          onComplete: function(transport){
            var json = eval('(' + transport.responseText + ')');
            var due_formated = 
              Tugboat.isEmpty(json.task.deadlineFormated) ? 'N/A' : json.task.deadlineFormated;
            
            $('task_list_block_title-' + id).innerHTML = json.task.title;
            $('task_list_title-' + id).innerHTML = json.task.title;
            $('task_list_due-' + id).innerHTML = due_formated;
            $('task_list_activity-' + id).className = 'activity_icon a_' + json.task.colorValue;
            
            if ($('task_summary_title-' + id)) {
              $('task_summary_title-' + id).innerHTML = json.task.title;
              $('task_summary_due-' + id).innerHTML = due_formated;
              $('task_summary_description-' + id).innerHTML =
                json.task.description.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
              
              var detail_tags = '';
              if (json.tags && json.tags.length > 0 ) {
                for (i = 0; i < json.tags.length; i++) {
                  detail_tags += '<span class="tag_text">';
                  detail_tags += json.tags[i].tagValue;
                  detail_tags += (i < json.tags.length ? ', ' : '');
                  detail_tags += '</span>'
                }
              }
              $('list_detail_tags-' + id).innerHTML = detail_tags;
            }
            
            // taqs
            var block_tags = '';
            if (json.tags && json.tags.length > 0 ) {
              for (i = 0; i < json.tags.length; i++) {
                block_tags += json.tags[i].tagValue;
                block_tags += (i < json.tags.length ? ', ' : '');
              }
            }
            $('gtd_tags_block-' + id).innerHTML = block_tags;
            $('gtd_tags_list-' + id).innerHTML = block_tags;

            Tugboat.gtd_task.tag.setup_tag_folder(false);
            self._is_processing = false;
          }
        }
      );
      Windows.closeAll();
      return false;
    },
    
    /**
     * Cancel task.
     * 
     */
    cancel : function() {
      Windows.closeAll();
    }
  },
  
  /*
   * Folder
   *
   * 
   */
  folder : {
    _CHECK_IMG_FILE_PATH_COMPLETE    : 'images/default/checkbox/task_complete.gif',
    _CHECK_IMG_FILE_PATH_NOTCOMPLETE : 'images/default/checkbox/task_notcomplete.gif',
    
    /**
     * set up classification.
     * 
     * @param {Object} id
     * @param {Object} before_selected_statuses
     * @param {Object} before_selected_classes
     */
    _setup_browse_class_and_status : function(id, before_selected_statuses, before_selected_classes) {
      var self = Tugboat.gtd_task.folder;
      var browser = Tugboat.gtd_task.browser;
      var constants = Tugboat.constant.task;
      var classificationId = -1;

      TugboatUI.DragBox.dropTargetStyles.each(
        function(folder) {
          //-- myself.
          if (id == folder.id) {
            $(id).className = folder.selectedStyle;
          
            $(constants.ID_LI_BROWSER_CLASS_LIST  + folder.value).style.display = Tugboat.constant.STYLE_DISPLAY_BLOCK;
            $(constants.ID_LI_BROWSER_CLASS_LIST  + folder.value).className = constants.CLASS_LIST_SELECT;
            $(constants.ID_IMG_BROWSER_CLASS_LIST + folder.value).src = self._CHECK_IMG_FILE_PATH_COMPLETE;
            
            browser._class_info[Number(folder.value)].checked = true;
            classificationId = folder.value;
          
            if (constants.FOLDER_INBOX.id != id) {
              $(constants.ID_LI_BROWSER_CLASS_LIST  + constants.FOLDER_INBOX.value).style.display = Tugboat.constant.STYLE_DISPLAY_NONE;
              $(constants.ID_LI_BROWSER_CLASS_LIST  + constants.FOLDER_INBOX.value).className = constants.CLASS_LIST_NOT_SELECT;
              $(constants.ID_IMG_BROWSER_CLASS_LIST + constants.FOLDER_INBOX.value).src = self._CHECK_IMG_FILE_PATH_NOTCOMPLETE;
            
              browser._class_info[constants.FOLDER_INBOX.value].checked = false;
            }
            if (constants.FOLDER_ARCHIVES.id != id) {
              $(constants.ID_LI_BROWSER_CLASS_LIST  + constants.FOLDER_ARCHIVES.value).style.display = Tugboat.constant.STYLE_DISPLAY_NONE;
              $(constants.ID_LI_BROWSER_CLASS_LIST  + constants.FOLDER_ARCHIVES.value).className = constants.CLASS_LIST_NOT_SELECT;
              $(constants.ID_IMG_BROWSER_CLASS_LIST + constants.FOLDER_ARCHIVES.value).src = self._CHECK_IMG_FILE_PATH_NOTCOMPLETE;
            
              browser._class_info[constants.FOLDER_ARCHIVES.value].checked = false;
            }
            if (constants.FOLDER_TRASH_BOX.id != id) {
              $(constants.ID_LI_BROWSER_CLASS_LIST  + constants.FOLDER_TRASH_BOX.value).style.display = Tugboat.constant.STYLE_DISPLAY_NONE;
              $(constants.ID_LI_BROWSER_CLASS_LIST  + constants.FOLDER_TRASH_BOX.value).className = constants.CLASS_LIST_NOT_SELECT;
              $(constants.ID_IMG_BROWSER_CLASS_LIST + constants.FOLDER_TRASH_BOX.value).src = self._CHECK_IMG_FILE_PATH_NOTCOMPLETE;
            
              browser._class_info[constants.FOLDER_TRASH_BOX.value].checked = false;
            }
          
            // set borowser's status.
            var status = folder.status;
            var isFirst = 0;
            status.each( function(s) {

                if (before_selected_statuses
                 && before_selected_statuses.length > 0
                 && before_selected_statuses[0]) {
                  var selected_status = before_selected_statuses.find(
                    function(t) {
                      return s.id == t;
                    }
                  );
                  $(constants.ID_LI_BROWSER_LIST + s.id).className = 
                    typeof(selected_status) != 'undefined'
                    ? constants.CLASS_LIST_SELECT
                    : constants.CLASS_LIST_NOT_SELECT;

                  $(constants.ID_IMG_BROWSER_STATUS_LIST + s.id).src = 
                    typeof(selected_status) != 'undefined'
                    ? self._CHECK_IMG_FILE_PATH_COMPLETE
                    : self._CHECK_IMG_FILE_PATH_NOTCOMPLETE;
                  
                  browser._status_info[s.id].checked = 
                    (typeof(selected_status) != 'undefined');
                  
                } else {
                  $(constants.ID_LI_BROWSER_LIST + s.id).className = 
                    (s.isVisible && isFirst==0)
                    ? constants.CLASS_LIST_SELECT
                    : constants.CLASS_LIST_NOT_SELECT;

                  $(constants.ID_IMG_BROWSER_STATUS_LIST + s.id).src = 
                    (s.isVisible && isFirst==0) 
                    ? self._CHECK_IMG_FILE_PATH_COMPLETE
                    : self._CHECK_IMG_FILE_PATH_NOTCOMPLETE;
              
                  browser._status_info[s.id].checked = (s.isVisible && isFirst==0);
                  if (s.isVisible) isFirst++;
                }
                $(constants.ID_LI_BROWSER_LIST + s.id).style.display = 
                  s.isVisible
                  ? Tugboat.constant.STYLE_DISPLAY_BLOCK
                  : Tugboat.constant.STYLE_DISPLAY_NONE;
              }
            );
          }
          //
          //-- inbox folder, archives folder, trash box folder.
          //
          else if (folder.value == constants.FOLDER_INBOX.value
                || folder.value == constants.FOLDER_ARCHIVES.value
                || folder.value == constants.FOLDER_TRASH_BOX.value) {
            $(folder.id).className = folder.defaultStyle;
          }
          //
          //-- class folder.
          //
          else if (folder.value < constants.FOLDER_INBOX.value) {
            $(folder.id).className = folder.defaultStyle;
            $(constants.ID_LI_BROWSER_CLASS_LIST  + folder.value).style.display = 
              (id == constants.FOLDER_ALL.id) 
              ? Tugboat.constant.STYLE_DISPLAY_BLOCK 
              : Tugboat.constant.STYLE_DISPLAY_NONE;
            
            if (id == constants.FOLDER_ALL.id && before_selected_classes) {
              if (before_selected_classes.length == 5) {
                $(constants.ID_LI_BROWSER_CLASS_LIST  + folder.value).className = constants.CLASS_LIST_NOT_SELECT;
                $(constants.ID_IMG_BROWSER_CLASS_LIST + folder.value).src = self._CHECK_IMG_FILE_PATH_NOTCOMPLETE;
                browser._class_info[Number(folder.value)].checked = false;
                
              } else {
                var cls = before_selected_classes.find(
                  function(c) {
                    return folder.value == c;
                  }
                );
                browser._class_info[0].checked = false;
                $(constants.ID_LI_BROWSER_CLASS_LIST  + constants.FOLDER_ALL.value).className = constants.CLASS_LIST_NOT_SELECT;
                $(constants.ID_IMG_BROWSER_CLASS_LIST + constants.FOLDER_ALL.value).src       = self._CHECK_IMG_FILE_PATH_NOTCOMPLETE;
                  
                $(constants.ID_LI_BROWSER_CLASS_LIST  + folder.value).className = 
                  (typeof(cls) == 'undefined' ? constants.CLASS_LIST_NOT_SELECT : constants.CLASS_LIST_SELECT);
                  
                $(constants.ID_IMG_BROWSER_CLASS_LIST + folder.value).src = 
                  (typeof(cls) == 'undefined' ? self._CHECK_IMG_FILE_PATH_NOTCOMPLETE : self._CHECK_IMG_FILE_PATH_COMPLETE);

                 browser._class_info[Number(folder.value)].checked = 
                   (typeof(cls) != 'undefined' && folder.value != constants.FOLDER_ALL.value);
              }
            } else {
              $(constants.ID_LI_BROWSER_CLASS_LIST  + folder.value).className = constants.CLASS_LIST_NOT_SELECT;
              $(constants.ID_IMG_BROWSER_CLASS_LIST + folder.value).src = self._CHECK_IMG_FILE_PATH_NOTCOMPLETE;
              browser._class_info[Number(folder.value)].checked = false;
            }
          }
        }
      );
      browser.is_plural_classes  = classificationId == 0;
      browser.is_plural_statuses = classificationId == 0 
                                || classificationId == 1 
                                || classificationId == 4;
                                
      return classificationId;
    },
    
    /**
     * folder onclick
     * @param {Object} id
     * @param {Object} isReloadable
     * @param {Object} selectedBrowseInfo
     */
    folder_onclick : function(id, isReloadable, selectedBrowseInfo) {
      $('block_balloon').style.display=Tugboat.constant.STYLE_DISPLAY_NONE;
      
      if (Tugboat.isEmpty(id) ) id = Tugboat.gtd_task._before_selected_foder_id;
      if ($(id).className.indexOf('selected') > -1 && !isReloadable) return false; 

      if (Tugboat.gtd_task._selected_tab == 1) {
        Tugboat.gtd_task._selected_tab = 0;
        $('menuBar_browser').className = 'menuBar_browser';
        
        if (Tugboat.gtd_task._is_visibled_browser) {
           Element.show('browser_pane');
           Tugboat.gtd_common.resize_list_area(false, false);
        }
      }

      // set selected folder info in view controller.
      var selectedFolder = Tugboat.constant.task.findFolderById(id);
      
      var viewControllerElement = $('selected_folder_info');
      viewControllerElement.innerHTML = '';
      viewControllerElement.appendChild(SPAN(null, 'selected: '));
      viewControllerElement.appendChild(STRONG(null, selectedFolder.name));

      //
      // tag folder to not selected.
      //
      $('selected_tags_container').className = 'selected_tags_off';
      
      // select folder.
      TugboatUI.DragBox.selectedFolderId = id;
      Tugboat.gtd_task._before_selected_foder_id = id;
      
      var self = Tugboat.gtd_task.folder;
      var browser = Tugboat.gtd_task.browser;
      var classificationId = 
        Tugboat.gtd_task.folder._setup_browse_class_and_status(
          id,
          (selectedBrowseInfo ? selectedBrowseInfo.statuses : null),
          (selectedBrowseInfo ? selectedBrowseInfo.classes  : null)
        );

      TugboatUI.DragBox.dropTargetStyles.each( function(droppable) {
        var folderStyle = TugboatUI.DragBox.find_folder_style(droppable.id);
        
        droppable.defaultStyle = 
          (droppable.id == classificationId)
            ? folderStyle.selectedStyle
            : folderStyle.defaultStyle;

        droppable.dragOverStyle = 
          (droppable.id == classificationId)
            ? folderStyle.selectedStyle
            : folderStyle.dragOverStyle;
      });
      browser.get_task_list_by_query_params(0, 1, true, selectedBrowseInfo);
    }
  },
  
  /*
   * Modal window
   *
   * 
   */
  modal : {
    _is_opened : false,
    
    open : function () {
      Tugboat.gtd_task.modal._is_opened = true;
      var page = Tugboat.getPageSize(); 
      Element.setHeight('modal_window', page.pageHeight);
      $('modal_window').style.display = Tugboat.constant.STYLE_DISPLAY_BLOCK;
    },

    close : function() {
      Tugboat.gtd_task.modal._is_opened = false;
      Element.hide('modal_window');
    }
  },
  
  /*
   * Progress
   *
   * 
   */
  progress : {
    open : function () {
      var page = Tugboat.getPageSize(); 
      Element.setHeight('progress_window', page.pageHeight);
      $('progress_window').style.display = Tugboat.constant.STYLE_DISPLAY_BLOCK;
    },
    close : function() {
      Element.hide('progress_window');
    }
  },
  
  /*
   * Browser
   * 
   *  
   */
  browser : {
    _status_info   : [],
    _class_info    : [],
    _activity_info : [],
    _person_info   : [],
    is_plural_statuses : false,
    is_plural_classes  : false,

    /**
     * create activity list.
     * @param {Object} json
     */
    create_activity_list : function(json) {
      if (! json) return false;
      
      $('browser_list_activities').innerHTML = '';
      var ul= $('browser_list_activities');
      
      var activity_value = json.find(
        function(a) {
          return a.id == 0;
        }
      );
      var listAll = 
        LI({'id'    : 'browser_activity_list-0', 
            'class' : (activity_value.checked ?'list_select' : 'list_notselect')},
          [
            A({'id'      : 'browser_activity-0', 
               'class'   : 'button',
               'href'    : 'javascript:void(0);',
               'onclick' : Tugboat.gtd_task.browser.activity_select.bind(this, 0)},
              IMG(
                {'id'    : Tugboat.constant.task.ID_IMG_ACTIVITY_LIST + '0',
                 'border': '0',
                 'align' : 'absmiddle',
                 'src'   : (activity_value.checked 
                            ? 'images/default/checkbox/task_complete.gif'
                            : 'images/default/checkbox/task_notcomplete.gif')}),
                 'All'
            )
          ]
        );
      ul.appendChild(listAll);
      
      json.each(
        function(a) {
          if (a.id > 0) {
            var list = 
              LI({'id'    : Tugboat.constant.task.ID_LI_ACTIVITY_LIST + a.id, 
                  'class' : (a.checked ?'list_select' : 'list_notselect')},
                [
                  A({'id'      : 'browser_activity-'+a.id, 
                     'class'   : 'button',
                     'href'    : 'javascript:void(0);',
                     'onclick' : Tugboat.gtd_task.browser.activity_select.bind(this, a.id)},
                    IMG(
                      {'id'    : Tugboat.constant.task.ID_IMG_ACTIVITY_LIST + a.id,
                       'border': '0',
                       'align' : 'absmiddle',
                       'src'   : (a.checked 
                                  ? 'images/default/checkbox/task_complete.gif'
                                  : 'images/default/checkbox/task_notcomplete.gif')
                      }
                    ),
                    IMG({'border': '0',
                         'align' : 'absmiddle',
                         'class' : 'left_and_right_3px_margin',
                         'src'   : 'images/default/palette/pl_bg_'+a.color + '.gif'}),
                    a.value
                  )
                ]
              );
            ul.appendChild(list);
          }
        }
      );
    },
    
    /**
     * create person in charge list.
     * @param {Object} json
     */
    _create_person_in_charge_list : function(json) {
      if (! json) return false;
      
      $('browser_list_persons').innerHTML = '';
      var ul = $('browser_list_persons');
      
      json.each(
        function(p) {
          var list = 
            LI({'id'    : 'browser_person_list-' + p.id,
                 'class' : p.checked 
                           ? Tugboat.constant.task.CLASS_LIST_SELECT 
                           : Tugboat.constant.task.CLASS_LIST_NOT_SELECT},
              [
                A({'id'      : 'browser_person-' + p.id,
                   'class'   : 'button',
                   'href'    : 'javascript:void(0);',
                   'onclick' : Tugboat.gtd_task.browser.person_select.bind(this, p.id)},
                  IMG({'id'     : 'browser_person_list_img-' + p.id,
                       'border' : '0',
                       'align'  : 'align',
                       'src'    : p.checked ? 'images/default/checkbox/task_complete.gif'
                                            : 'images/default/checkbox/task_notcomplete.gif'}),
                ' ' + p.last_name 
                    + (Tugboat.isEmpty(p.first_name) ? '' : (',' + p.first_name))
                )
              ]
            );
          ul.appendChild(list);
        }
      );
    },

    /**
     * reset browser.
     * @param {boolean} isReload
     */
    reset : function(isReload) {
      var self = Tugboat.gtd_task.browser;
      self._status_info   = Tugboat.constant.task.getDefaultStatuses();
      self._class_info    = Tugboat.constant.task.getDefaultClassifications();
      
      if (isReload) {
        self._activity_info.each(
          function(a) {
            a.checked = a.id == 0;
            
            $('browser_activity_list-' + a.id).className = 
              (a.id == 0 ? 'list_select' : 'list_notselect');

            $(Tugboat.constant.task.ID_IMG_ACTIVITY_LIST + a.id).src = 
              (a.id == 0 ? 'images/default/checkbox/task_complete.gif'
                         : 'images/default/checkbox/task_notcomplete.gif');
          }
        );
      } else {
        self._activity_info = Tugboat.constant.task.getDefaultActivities();
      }
      //-- status.
      $('browser_status_list_img-0').setAttribute('src','images/default/checkbox/task_complete.gif');
      $('browser_status_list-0').className = Tugboat.constant.task.CLASS_LIST_SELECT;
      $('browser_status_list_img-1').setAttribute('src','images/default/checkbox/task_notcomplete.gif');
      $('browser_status_list-1').className = Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
      $('browser_status_list_img-2').setAttribute('src','images/default/checkbox/task_notcomplete.gif');
      $('browser_status_list-2').className = Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
      $('browser_status_list_img-3').setAttribute('src','images/default/checkbox/task_notcomplete.gif');
      $('browser_status_list-3').className = Tugboat.constant.task.CLASS_LIST_NOT_SELECT;

      //-- classification.
      $('browser_class_list_img-0').setAttribute('src','images/default/checkbox/task_complete.gif');
      $('browser_class_list-0').className = Tugboat.constant.task.CLASS_LIST_SELECT;

      $('browser_class_list_img-1').setAttribute('src','images/default/checkbox/task_notcomplete.gif');
      $('browser_class_list-1').className = Tugboat.constant.task.CLASS_LIST_NOT_SELECT;

      $('browser_class_list_img-2').setAttribute('src','images/default/checkbox/task_notcomplete.gif');
      $('browser_class_list-2').className = Tugboat.constant.task.CLASS_LIST_NOT_SELECT;

      $('browser_class_list_img-4').setAttribute('src','images/default/checkbox/task_notcomplete.gif');
      $('browser_class_list-4').className = Tugboat.constant.task.CLASS_LIST_NOT_SELECT;

      $('browser_class_list_img-5').setAttribute('src','images/default/checkbox/task_notcomplete.gif');
      $('browser_class_list-5').className = Tugboat.constant.task.CLASS_LIST_NOT_SELECT;

      $('browser_class_list_img-9').setAttribute('src','images/default/checkbox/task_notcomplete.gif');
      $('browser_class_list-9').className = Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
    },
      
    /**
     * browser status checkbox select.
     * 
     * @param {Object} statusId
     */
    status_select : function(statusId) {
      var self = Tugboat.gtd_task.browser;
      if (!self.is_plural_statuses) return false;

      //
      // set checkbox.
      // 
      var statusList = self._status_info;
      var isChecked = false;
        
      if (statusList[statusId]) {
        isChecked = statusList[statusId].checked;
      }
      var imageElement = $(Tugboat.constant.task.ID_IMG_BROWSER_STATUS_LIST + statusId);
      imageElement.setAttribute(
        'src',
        'images/default/checkbox/'
          + (isChecked ? 'task_notcomplete.gif' : 'task_complete.gif') );
        
      var listElement = $(Tugboat.constant.task.ID_LI_BROWSER_LIST + statusId);
      listElement.className =
        isChecked 
        ? Tugboat.constant.task.CLASS_LIST_NOT_SELECT 
        : Tugboat.constant.task.CLASS_LIST_SELECT;
      
      statusList[statusId] = {'id':statusId,'checked':!isChecked};
        
      //
      // after proc.
      //
      var checkStatus = false;
      for (var i = 0; i < statusList.length; i++) {
        if (statusList[i].checked) {
          checkStatus = true;
          break;
        }
      }
      var checkAll = (!isChecked && statusId ==0)
      if (!checkStatus) checkAll = true;
      
      statusList[0] = {'id':0,'checked':checkAll};
        
      $(Tugboat.constant.task.ID_IMG_BROWSER_STATUS_LIST + 0).setAttribute(
        'src',
        'images/default/checkbox/' 
        + (checkAll ? 'task_complete.gif' : 'task_notcomplete.gif') );
            
      $(Tugboat.constant.task.ID_LI_BROWSER_LIST + 0).className = 
        checkAll 
        ? Tugboat.constant.task.CLASS_LIST_SELECT 
        : Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
          
      if (checkAll && checkStatus) {
        for (i = 0; i < statusList.length; i++) {
          if (i==0) continue;
            
          statusList[i] = {'id':statusId ,'checked':false};
              
          $(Tugboat.constant.task.ID_IMG_BROWSER_STATUS_LIST + i).setAttribute(
            'src','images/default/checkbox/task_notcomplete.gif');

          $(Tugboat.constant.task.ID_LI_BROWSER_LIST + i).className = 
            Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
        }
      }
      self.get_task_list_by_query_params(0,1);
    },
      
    /**
     * browser classification select.
     * 
     * @param {Object} classificationId
     */
    classification_select : function(classificationId) {
      var self = Tugboat.gtd_task.browser;
      if (!self.is_plural_classes) return false;
        
      //
      // set checkbox.
      //
      var classList = self._class_info;
      var isChecked = false;

      if (classList[classificationId]) {
        isChecked = classList[classificationId].checked;
      }
      var imageElement = 
        $(Tugboat.constant.task.ID_IMG_BROWSER_CLASS_LIST + classificationId);
          imageElement.setAttribute(
            'src',
            'images/default/checkbox/'
          + (isChecked ? 'task_notcomplete.gif' : 'task_complete.gif') );
        
      var listElement = 
        $(Tugboat.constant.task.ID_LI_BROWSER_CLASS_LIST + classificationId);

      listElement.className =
        isChecked 
        ? Tugboat.constant.task.CLASS_LIST_NOT_SELECT
        : Tugboat.constant.task.CLASS_LIST_SELECT;
      
      classList[classificationId] = {'id':classificationId,'checked':!isChecked};
        
      //
      // after proc.
      //
      var checkStatus = false;
      for (var i = 0; i < classList.length; i++) {
        if (classList[i] && classList[i].checked) {
          checkStatus = true;
          break;
        }
      }
      
      var checkAll = (!isChecked && classificationId ==0);
      if (!checkStatus) checkAll = true;
      
      classList[0] = {'id':0,'checked':checkAll};
        
      $(Tugboat.constant.task.ID_IMG_BROWSER_CLASS_LIST + '0').setAttribute(
        'src',
        'images/default/checkbox/' 
        + (checkAll ? 'task_complete.gif' : 'task_notcomplete.gif') );
            
      $(Tugboat.constant.task.ID_LI_BROWSER_CLASS_LIST + '0').className = 
        checkAll 
        ? Tugboat.constant.task.CLASS_LIST_SELECT 
        : Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
          
      if (checkAll && checkStatus) {
        for (i = 0; i < classList.length; i++) {
          var elementId = Tugboat.constant.task.ID_IMG_BROWSER_CLASS_LIST + i;
          if (i==0 || !classList[i] || ! $(elementId)) continue;
          
          classList[i].checked = false;

          $(elementId).setAttribute(
            'src','images/default/checkbox/task_notcomplete.gif');

          $(Tugboat.constant.task.ID_LI_BROWSER_CLASS_LIST + i).className = 
            Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
        }
      }
      self.get_task_list_by_query_params(0,1);
    },
      
    /**
     * browser activity select.
     * 
     * @param {Object} activityId
     */
    activity_select : function(activityId) {
      $('browser_activity-' + activityId).blur();

      // set checkbox.
      var self = Tugboat.gtd_task.browser;
      var activity_list = self._activity_info;
      var isChecked = false;
      
      var activity_value = activity_list.find(
        function(a) {
          return a.id == activityId;
        }
      );
      if (typeof(activity_value) != 'undefined' && activity_value) {
        isChecked = activity_value.checked;
        activity_value.checked = !activity_value.checked;
      }
      
      var imageElement = 
        $(Tugboat.constant.task.ID_IMG_ACTIVITY_LIST + activityId);
      imageElement.setAttribute(
        'src',
        'images/default/checkbox/'
          + (isChecked ? 'task_notcomplete.gif' : 'task_complete.gif') );
       
      var listElement = $(Tugboat.constant.task.ID_LI_ACTIVITY_LIST + activityId);
      listElement.className =
        isChecked 
        ? Tugboat.constant.task.CLASS_LIST_NOT_SELECT 
        : Tugboat.constant.task.CLASS_LIST_SELECT;
      
      // after proc.
      var checkActivity = false;
      for (var i = 0; i < activity_list.length; i++) {
        if (activity_list[i].checked) {
          checkActivity = true;
          break;
        }
      }
     
      var checkAll = (!isChecked && activityId == 0);
      if (!checkActivity) checkAll = true;
      
      $('browser_activity_list_img-0').setAttribute(
        'src',
        'images/default/checkbox/' 
        + (checkAll ? 'task_complete.gif' : 'task_notcomplete.gif') );
            
      $(Tugboat.constant.task.ID_LI_ACTIVITY_LIST + '0').className =
        checkAll
        ? Tugboat.constant.task.CLASS_LIST_SELECT
        : Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
          
      if (checkAll && checkActivity) {
        activity_list.each(
          function(a) {
            if (a.id == 0) {
              a.checked = true;
            } else {
              a.checked = false;
              
              $(Tugboat.constant.task.ID_IMG_ACTIVITY_LIST + a.id).setAttribute(
                'src','images/default/checkbox/task_notcomplete.gif');
               $(Tugboat.constant.task.ID_LI_ACTIVITY_LIST + a.id).className = 
                 Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
            }
          }
        );
      } else {
        var acitivity_value = activity_list.find(
          function(a) {
            return a.id == 0;
          }
        );
        acitivity_value.checked = false;
      }

      //
      // get person in charge.
      //
      var me = self._person_info.find(
        function(p) {
          return p.isMe;
        }
      );
      self._person_info = [];
      self._person_info.push(
        { 'id'        :me.id, 
          'checked'   :true,
          'isMe'      :me.isMe, 
          'last_name' :me.last_name,
          'first_name':me.first_name
        }
      );
      var self = Tugboat.gtd_task.browser;
      self._get_person_by_activities();
      self.get_task_list_by_query_params(0,1);
    },
    
    /**
     * get person by selected activities.
     */
    _get_person_by_activities : function() {
      var self = Tugboat.gtd_task.browser;
      var activityQueryParam = self._get_activity_query_params();
      
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component   : 'activityMemberAjax',
            action      : 'getActivityMembersByActivities',
            activityIds : activityQueryParam
          },
          onComplete: function(transport){
            var json = eval(transport.responseText);
            var isExistChecked = false;
            self._person_info = [];
            json.each(
              function(p) {
                self._person_info.push(
                  { 'id'        :p.personId, 
                    'checked'   :p.isMe,
                    'isMe'      :p.isMe, 
                    'last_name' :p.personLastName,
                    'first_name':p.personFirstName
                  }
                );
              }
            );
            self._create_person_in_charge_list(self._person_info);
          }
        }
      );
    },
    
    /**
     * browser person in charge select. 
     * @param {Object} personId
     */
    person_select : function(personId) {
      $('browser_person-' + personId).blur();

      // set checkbox.
      var self = Tugboat.gtd_task.browser;
      var personList = self._person_info;
      var isChecked = false;
      var person_value = personList.find(
        function(p) {
          return p.id == personId;
        }
      );
      isChecked = person_value.checked;
      person_value.checked = !isChecked;

      var imageElement = $('browser_person_list_img-' + personId);
      imageElement.setAttribute(
        'src',
        'images/default/checkbox/'
          + (isChecked ? 'task_notcomplete.gif' : 'task_complete.gif') );
       
      var listElement = $('browser_person_list-' + personId);
      listElement.className =
        isChecked 
        ? Tugboat.constant.task.CLASS_LIST_NOT_SELECT 
        : Tugboat.constant.task.CLASS_LIST_SELECT;
      
      //
      // after proc.
      //
      var checkPerson = false;
      for (var i = 0; i < personList.length; i++) {
        if (personList[i].checked) {
          checkPerson = true;
          break;
        }
      }
      var checkAll = (!isChecked && personId == 0);
      if (!checkPerson) checkAll = true;
      
      $('browser_person_list_img-0').setAttribute(
        'src',
        'images/default/checkbox/' 
        + (checkAll ? 'task_complete.gif' : 'task_notcomplete.gif') );
      
      $('browser_person_list-0').className = 
        checkAll 
        ? Tugboat.constant.task.CLASS_LIST_SELECT 
        : Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
        
      if (checkAll && checkPerson) {
        personList.each(
          function(a) {
            if (a.id == 0) {
              a.checked = true;
            } else {
              a.checked = false;
                 
              $('browser_person_list_img-' + a.id).setAttribute(
                'src','images/default/checkbox/task_notcomplete.gif');

              $('browser_person_list-' + a.id).className = 
                Tugboat.constant.task.CLASS_LIST_NOT_SELECT;
            }
          }
        );
      } else {
        var person_value = personList.find(
          function(a) {
            return a.id == 0;
          }
        );
        person_value.checked = false;
      }
      self.get_task_list_by_query_params(0,1);
    },
   
    /**
     * get status query params.
     * 
     */ 
    _get_status_query_params : function() {
      var self = Tugboat.gtd_task.browser;
      var statusList   = self._status_info;
      var statusQueryParam = '';
      
      statusList.each(
        function(s) {
          if (s.checked) statusQueryParam += s.id + ',';
        }
      );
      if (TugboatUI.DragBox.selectedFolderId == Tugboat.constant.task.FOLDER_ARCHIVES.id) {
        statusQueryParam = Tugboat.constant.task.STATUS_DONE;
      }
      else if (statusQueryParam.length > 0) {
        statusQueryParam = statusQueryParam.substring(0,statusQueryParam.length-1);
      }
      return statusQueryParam;
    },
    
    /**
     * get class query params.
     * 
     */
    _get_class_query_params : function() {
      var self = Tugboat.gtd_task.browser;
      var classList = self._class_info;
      var classQueryParam = '';
      
      classList.each(
        function(c) {
          if (c && c.checked) { classQueryParam += c.id + ','; }
        }
      );
      if (TugboatUI.DragBox.selectedFolderId == Tugboat.constant.task.FOLDER_ARCHIVES.id) {
        classQueryParam = Tugboat.constant.task.CLASS_ARCHIVES.id;
      }
      else if (classQueryParam.length > 0) {
        classQueryParam = classQueryParam.substring(0,classQueryParam.length - 1);
      }
      return classQueryParam;
    },
    
    /**
     * get activity query params.
     * 
     */
    _get_activity_query_params : function() {
      var self = Tugboat.gtd_task.browser;
      var activityList = self._activity_info;
      var activityQueryParam = '';
      
      activityList.each(
        function(a) {
          if (a.checked) {
            activityQueryParam += a.id;
            activityQueryParam += ',';
          }
        }
      );
      if (activityQueryParam.length > 0) {
        activityQueryParam = activityQueryParam.substring(0,activityQueryParam.length - 1);
      }
      if (activityQueryParam == '0') activityQueryParam = '';
      return activityQueryParam;
    },
        
    /**
     * get person query params.
     * 
     */
    _get_person_query_params : function() {
      var self = Tugboat.gtd_task.browser;
      var library = Tugboat.gtd_task;
      var personList   = self._person_info;
      var personQueryParams = '';
      
      personList.each(
        function(p) {
          if (p.checked) {
            personQueryParams += p.id;
            personQueryParams += ',';
          }
        }
      );
      if (personQueryParams.length > 0) {
        personQueryParams = personQueryParams.substring(0,personQueryParams.length - 1);
      }
      if (personQueryParams == '0') {
        personQueryParams = '';
      }
      return personQueryParams;
    },
    
    /**
     * get task list by query params.
     * 
     * @param {Number}  offset
     * @param {Number}  currentPageNumber
     * @param {boolean} isFolderSelect
     * @param {Object}  selectedBrowseInfo
     */
    get_task_list_by_query_params : function(offset, currentPageNumber, isFolderSelect, selectedBrowseInfo) {
      var self = Tugboat.gtd_task.browser;
      var library = Tugboat.gtd_task;
      
      var statusQueryParam = self._get_status_query_params();
      var classQueryParam  = self._get_class_query_params();
      var selectFolderId = 
        Tugboat.constant.task.findFolderById(TugboatUI.DragBox.selectedFolderId).value;
      
      if (Tugboat.constant.task.CLASS_ALL.id == classQueryParam 
        && Tugboat.constant.task.FOLDER_ALL.id == TugboatUI.DragBox.selectedFolderId) {
          classQueryParam = 
          Tugboat.constant.task.CLASS_TODAY.id + ',' 
        + Tugboat.constant.task.CLASS_WEEK.id  + ','
        + Tugboat.constant.task.CLASS_MONTH.id + ','
        + Tugboat.constant.task.CLASS_HOLD.id  + ','
        + Tugboat.constant.task.CLASS_SOMEDAY.id;
      }
      
      if (!library._activities) return false;
      var activityQueryParam = self._get_activity_query_params();
      var personQueryParams  = self._get_person_query_params();
      
      Tugboat.gtd_task.progress.open();
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {
          method: Tugboat.constant.REQUEST_GET,
          parameters:
          {
            component            :'taskAjax',
            action               :'getTaskListByQueryParams',
            queryStatusId        :statusQueryParam,
            queryClassificationId:classQueryParam,
            queryActivityId      :activityQueryParam,
            queryPersonId        :personQueryParams,
            selectFolderId       :selectFolderId,
            currentPageNumber    :currentPageNumber,
            offset               :offset,
            limit                :Tugboat.constant.ROWS_PER_PAGE
          },
          onComplete: function(transport){
            self._task_list_json = 
              Tugboat.gtd_common.create_list_dom(
                transport, Tugboat.gtd_common.FUNC_TYPE_TASK);
             
            //
            // set drag'n drop.
            //
            TugboatUI.DragBox.afterDragDrop['gtd'] = function(params){
              new Ajax.Request(
                Tugboat.AJAX_SERVLET_NAME,
                {
                  method: Tugboat.constant.REQUEST_POST,
                  parameters:
                  {
                    component            :'taskAjax',
                    action               :'updateClassification',
                    params               :params,
                    limit                :Tugboat.constant.ROWS_PER_PAGE,
                    queryStatusId        :statusQueryParam,
                    queryClassificationId:classQueryParam,
                    queryActivityId      :activityQueryParam,
                    queryPersonId        :personQueryParams,
                    isViewStatusUpdate   :false
                  },
                  onComplete: function(transport){
                    Tugboat.gtd_common.create_list_dom(
			          transport, Tugboat.gtd_common.FUNC_TYPE_TASK);
                  }
                }
              );
            };
            Tugboat.gtd_task.progress.close();
          },
          onFailure : function(transport) {
            Tugboat.gtd_task.progress.close();
          }
        }
      );
    },
    
    /**
     * page navigation on click.
     * @param {Object} id
     */
    page_navi_onclick : function(id) {
      var element = $(id);
      if (element.className.indexOf('off') > -1) return false;
      
      var self = Tugboat.gtd_task.browser;
      var pageInfo = Tugboat.gtd_common.task.pageInfo;
      
      var num = id.indexOf('next') == -1 ? -1 : 1;
      var offset = 
        Tugboat.constant.ROWS_PER_PAGE * (pageInfo.currentPageNumber + num -1);

      if (Tugboat.gtd_task._selected_tab == 0) {
        self.get_task_list_by_query_params(offset, pageInfo.currentPageNumber + num);
      }
      else { 
        Tugboat.gtd_task.tag.find_by_has_tags(offset, pageInfo.currentPageNumber + num);
      }
    }
  },
  
  tag : {
    _current_task_id    : 0,
    _current_task_title : '',
    _edit_tags_window   : null,
    _tag_auto_completer : null,
    _own_tags           : null,
    _fileter_cond       : 1, // AND:1, OR:2
     
    /**
     * 
     * @param {Object} offset
     * @param {Object} currentPageNumber
     */
    find_by_has_tags : function(offset, currentPageNumber) {
      Tugboat.gtd_task.progress.open();
      
      if (Tugboat.gtd_task._selected_tab == 0) {
        Tugboat.gtd_task._selected_tab = 1;
        $('menuBar_browser').className = 'menuBar_browser_disable';
        
        Element.hide('browser_pane');
        Tugboat.gtd_common.resize_list_area(false,false);
      }
      
      if (! Tugboat.isEmpty(TugboatUI.DragBox.selectedFolderId)) {
        var className = $(TugboatUI.DragBox.selectedFolderId).className;
        $(TugboatUI.DragBox.selectedFolderId).className=className.replace(' selected','');
        TugboatUI.DragBox.selectedFolderId = '';
      }
      
      $('selected_tags_container').className = 'selected_tags_on';
      
      var self = Tugboat.gtd_task.tag;
      var selected_tags_ids = self._get_selected_tag_ids();
      var tag_ids = '';
      
      if (selected_tags_ids && selected_tags_ids.length > 0) {

        // init selected folder info in view controller.
        if (Tugboat.isEmpty(TugboatUI.DragBox.selectedFolderId)) {
          var viewControllerElement = $('selected_folder_info');
          viewControllerElement.innerHTML = '';
          viewControllerElement.appendChild(SPAN(null, 'selected: '));
        }

        for (i = 0; i < selected_tags_ids.length; i++) {
          // collect selected tags.
          tag_ids += selected_tags_ids[i].tagId;
          tag_ids += (i == selected_tags_ids.length - 1 ? '' : ',');
          
          // set selected folder info in view controller.
          viewControllerElement.appendChild(
            STRONG(null, selected_tags_ids[i].tagValue));
          if (i < selected_tags_ids.length - 1) {
            viewControllerElement.appendChild(SPAN(null, ', ') );
          }
        }
        Element.show('tag_selected_clear');
      } else {
        Element.hide('tag_selected_clear');
      }
      
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component         : 'taskAjax',
            action            : 'findTasksByHasTags',
            tagIdsString      : tag_ids,
            offset            : offset,
            limit             : Tugboat.constant.ROWS_PER_PAGE,
            currentPageNumber : currentPageNumber
          },
          onComplete: function(transport){
            Tugboat.gtd_common.create_list_dom(
			  transport, Tugboat.gtd_common.FUNC_TYPE_TASK);

            Element.show('list_top_caption');
            Element.show('list_top');
            Element.show('list_middle_caption');
            Element.show('list_middle');
            Element.show('list_bottom_caption');
            Element.show('list_bottom');
            
            //
            // set drag'n drop.
            //
            TugboatUI.DragBox.afterDragDrop['gtd'] = function(params){
              new Ajax.Request(
                Tugboat.AJAX_SERVLET_NAME,
                {
                  method: Tugboat.constant.REQUEST_POST,
                  parameters:
                  {
                    component          : 'taskAjax',
                    action             : 'updateClassification',
                    params             : params,
                    limit              : Tugboat.constant.ROWS_PER_PAGE,
                    tagIdsString       : tag_ids,
                    isViewStatusUpdate : false
                  },
                  onComplete: function(transport){
                    Tugboat.gtd_common.create_list_dom(
			          transport, Tugboat.gtd_common.FUNC_TYPE_TASK);
                  }
                }
              );
            };
            Tugboat.gtd_task.progress.close();
          },
          onFailure : function(transport) {
            Tugboat.gtd_task.progress.close();
          }
        }
      );
    },
    
    /**
     * get selected tag ids.
     */
    _get_selected_tag_ids : function() {
      var self = Tugboat.gtd_task.tag;
      var selected_tags_ids= [];
      
      if (self._own_tags) {
        self._own_tags.each(
          function(t) {
            if (t.isSelected == true) {
              selected_tags_ids.push(t);
            }
          }
        );
      }
      return selected_tags_ids;
    },
    
    /**
     * set up tag folder.
     * 
     * @param {boolean} initialize.
     */
    setup_tag_folder : function(initialize) {
      var self = Tugboat.gtd_task.tag;
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_GET,
          parameters:
          {
            component :'taskTagAjax',
            action    :'findByOwnTags'
          },
          onComplete: function(transport){
            if (Tugboat.isEmpty(transport.responseText)) {
              return false;
            }
            var selected_tags = [];
            if (self._own_tags) {
              self._own_tags.each(
                function(t) {
                  if (t.isSelected == true) {
                    selected_tags.push(t);
                  }
                }
              );
            }
            self._own_tags = eval(transport.responseText);
            var isExistsSelectedTag = false;
            
            if (self._own_tags) {
              var match_tags = [];
              self._own_tags.each(
                function(t) {
                  if (selected_tags) {
                    for (i=0; i<selected_tags.length; i++) {
                      if (t.tagId == selected_tags[i].tagId) {
                        t.isSelected = true;
                        isExistsSelectedTag = true;
                        
                        match_tags.push(t);
                      }
                    }
                  }
                }
              );
              
              if (match_tags) {
                var viewControllerElement = $('selected_folder_info');
                if (Tugboat.isEmpty(TugboatUI.DragBox.selectedFolderId)) {
                  viewControllerElement.innerHTML = '';
                  viewControllerElement.appendChild(SPAN(null, 'selected: '));
                }
                i=0;
                match_tags.each(
                  function(t) {
                    viewControllerElement.appendChild(STRONG(null, t.tagValue));
                    if (i < match_tags.length - 1) {
                      viewControllerElement.appendChild(SPAN(null, ', ') );
                    }
                    i++;
                  }
                );
              }
            }
            if (!initialize && selected_tags && !isExistsSelectedTag) {
              Tugboat.gtd_task.folder.folder_onclick(
                Tugboat.gtd_task._before_selected_foder_id, true);
            }
            self._create_dom_for_tag_folder(self._own_tags);
            self._create_dom_for_selected_tags(self._own_tags);
          }
        }
      );
    },
    
    /**
     * create dom for tag folder.
     * 
     * @param {Object} json
     */
    _create_dom_for_tag_folder : function(json) {
      var rootElement = $('not_selected_tags_container');
      rootElement.innerHTML = '';
      
      if (! json) return false;
      
      var self = Tugboat.gtd_task.tag;
      json.each(
        function(t) {
          var list =
            LI(
              { 
                'id':'tag_not_selected-' + t.tagId,
                'style':  t.isSelected == true ? 'display:none;' : 'display:block;',
                'onmouseover' : function() {
                  this.className = 'selected';
                },
                'onmouseout'  : function() {
                  this.className = 'drag_out';
                }
              },
              [
              INPUT(
                { 'type':'image',
                  'src':'images/default/icon/space.gif',
                  'onclick':function() {
                    self._add_tag_onclick(t.tagId);
                    this.blur();
                  }
                }
              ),
              t.tagValue
              ]
            );
          rootElement.appendChild(list);
          new YAHOO.util.DDTarget('tag_not_selected-' + t.tagId, 'block');
        }
      );
    },
    
    /**
     * create dom for selected tags.
     * 
     * @param {Object} json
     */
    _create_dom_for_selected_tags : function(json) {
      var rootElement = $('selected_tags_container');
      rootElement.innerHTML = '';
      
      if (! json) return false;
      
      var self = Tugboat.gtd_task.tag;
      json.each(
        function(t) {
          var list =
            LI(
              {'id':'tag_selected-' + t.tagId, 
                'style':  t.isSelected == true ? 'display:block;' : 'display:none;',
                'onmouseover' : function() {
                  this.className = 'selected';
                  this.style.cursor = 'pointer';
                },
                'onmouseout' : function() {
                  this.className = 'drag_out';
                  this.style.cursor = 'default';
                }
              },
              [
              INPUT(
                { 'type':'image',
                  'src':'images/default/icon/space.gif',
                  'onclick':function() {
                    self._remove_tag_onclick(t.tagId);
                    this.blur();
                    return false;
                  }
                }
              ),
              P({'onclick': function(){
                    if (Tugboat.isEmpty(TugboatUI.DragBox.selectedFolderId) ) {
                      return false;
                    }
                    self.find_by_has_tags(0,1);
                  }
                }, t.tagValue)
              ]
            );
          rootElement.appendChild(list);
          new YAHOO.util.DDTarget('tag_selected-' + t.tagId, 'block');
        }
      );
      rootElement.appendChild(
        LI(
          {'id':'tag_selected_clear', 'style':'display:none;text-align:right;'},
          A({'href':'javascript:void(0);','onclick':'Tugboat.gtd_task.tag._remove_all();','style':'color:#666'},'clear')
        )
      );
    },
    
    /**
     * add tag onclick.
     * 
     * @param {Number} id
     */
    _add_tag_onclick : function(id) {
      Element.hide('tag_not_selected-'+id);
      Element.show('tag_selected-'+id);
      
      var self = Tugboat.gtd_task.tag;
      tag_value = 
        self._own_tags.find(
          function(t) {
            return id == t.tagId; 
          }
        );
      tag_value.isSelected = true;
      self.find_by_has_tags(0,1);
    },
    
    /**
     * remove tag onclick.
     * 
     * @param {Object} id
     */
    _remove_tag_onclick : function(id) {
      Element.hide('tag_selected-'+id);
      Element.show('tag_not_selected-'+id);
      
      var self = Tugboat.gtd_task.tag;
      tag_value = 
        self._own_tags.find(
          function(t) {
            return id == t.tagId; 
          }
        );
      tag_value.isSelected = false;
      
      // is exists selected tags.
      var isExists = 
        self._own_tags.find(
          function(t) {
            return t.isSelected == true; 
          }
        );
      
      if (typeof isExists != 'undefined') {
        self.find_by_has_tags(0,1);
      }
      else {
        Element.hide('tag_selected_clear');
        Tugboat.gtd_task.folder.folder_onclick(TugboatUI.DragBox.selectedFolderId, true);
      }
    },
    
    /**
     * remove all.
     * 
     */
    _remove_all : function() {
      var self = Tugboat.gtd_task.tag;
      self._own_tags.each(
        function(t) {
          Element.hide('tag_selected-'     + t.tagId);
          Element.show('tag_not_selected-' + t.tagId);
          t.isSelected = false;
        }
      );
      Element.hide('tag_selected_clear');
      Tugboat.gtd_task.folder.folder_onclick(TugboatUI.DragBox.selectedFolderId, true);
    },
    
    /**
     * setup tags drag target.
     * 
     */
    _setup_tags_drag_target : function() {
      TugboatUI.DragBox.afterDragDrop['tag'] = function(params, taskIds, tagId){
        new Ajax.Request(
          Tugboat.AJAX_SERVLET_NAME,
          { 
            method: Tugboat.constant.REQUEST_POST,
            parameters:
            {
              component            :'taskTagAjax',
              action               :'updateByDragnDrop',
              params               :params,
              isViewStatusUpdate   :false
            },
            onComplete: function(transport){
              if (Tugboat.isEmpty(transport.responseText)) return false;
              
              var taskTags = eval(transport.responseText);
              taskIds.each(
                function(t) {
                  var tag_values = '';
                  for (i = 0; i<taskTags.length; i++) {
                    if (taskTags[i].taskId == t) {
                      tag_values += 
                        taskTags[i].tagValue + (i < taskTags.length - 1 ? ', ' : '');
                    }
                  }
                  var tags_list  = $('gtd_tags_list-'  + t);
                  tags_list.innerHTML = '';
                  tags_list.appendChild(document.createTextNode(tag_values));
                  
                  var tags_block = $('gtd_tags_block-' + t);
                  tags_block.innerHTML = '';
                  tags_block.appendChild(document.createTextNode(tag_values));

                  new Effect.Highlight('gtd_list_' + t);
                }
              );
            }
          }
        );
      };
    }
  }
};
