/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.gtd_task_detail) == 'undefined') {
    Tugboat.gtd_task_detail = {};
}

Tugboat.gtd_task_detail = {
  WIN_MODE_UPDATE : 1,
  WIN_MODE_CREATE : 2,
  _window_mode    : 1,
  
  _is_after_initialized  : true,
  _selectedTaskId        : 0,
  _selectedCommentId     : 0,
  _select_status         : null,
  _select_class          : null,
  _select_activity       : null,
  _select_personInCharge : null,
  _select_status_list :
    [
      { id:0,  value:'Plese Select', icon:'images/default/icon/space.gif'},
      { id:1,  value:'To Do',        icon:'images/default/folder/gif/status_todo.gif'},
      { id:2,  value:'Doing',        icon:'images/default/folder/gif/status_doing.gif'},
      { id:3,  value:'Done',         icon:'images/default/folder/gif/status_done.gif'}
    ],
  _select_class_list :
    [
      { id:0,  value:'Plese Select', icon:'images/default/icon/space.gif'},
      { id:1,  value:'Today',        icon:'images/default/folder/gif/folder-red-16.gif'},
      { id:2,  value:'Week',         icon:'images/default/folder/gif/folder-orange-16.gif'},
      { id:3,  value:'Month',        icon:'images/default/folder/gif/folder-yellow-16.gif'},
      { id:4,  value:'Hold',         icon:'images/default/folder/gif/folder-green-16.gif'},
      { id:5,  value:'Someday',      icon:'images/default/folder/gif/folder-blue-16.gif'},
      { id:9,  value:'Inbox',        icon:'images/default/folder/gif/inbox-16.gif'},
      { id:21,  value:'Archives',    icon:'images/default/folder/gif/folder-gray-16.gif'},
      { id:99,  value:'Trash',       icon:'images/default/folder/gif/trash-16.gif'}
    ],
  _class_status_rules :
    [
      {classId : 0,  statusIds:[1]},
      {classId : 1,  statusIds:[1,2,3]},
      {classId : 2,  statusIds:[1]},
      {classId : 3,  statusIds:[1]},
      {classId : 4,  statusIds:[1,3]},
      {classId : 5,  statusIds:[1]},
      {classId : 9,  statusIds:[1]},
      {classId : 21, statusIds:[3]},
      {classId : 99, statusIds:[1]}
    ],
  _personInChargeAutoCompleter1 : null,
  _personInChargeAutoCompleter2 : null,
  _add_task_select_activity     : null,
  _tag_auto_completer1          : null,
  _tag_auto_completer2          : null,
  _prev_entry_key_code : 0,

  init : function () {
    var self = Tugboat.gtd_task_detail;
    self.resize();
    
    var taskId = $('param_task_id').value;
	if (Tugboat.isEmpty(taskId) ) return false;
    
    Tugboat.dashboard.initialize();
    
    self._select_class = 
      new TugboatUI.SelectMenu(
        'edit_classification', 
        self._select_class_list,
        { parentElement:'editTaskWindow',
          isParentWindow:true,
          onSelected:function(selectValue)
          {
            var rule = 
              self._class_status_rules.find(
                function(r) {
                  return selectValue.id == r.classId;
                }
              );
            
            var list = [];
            var selected_status_id = -1;
            
            self._select_status_list.each(
              function(s) {
                if (s.id == 0) list.push(s);
                rule.statusIds.each(
                  function(r) {
                    if (s.id == r) {
                      list.push(s);
                      if (s.id == self._select_status.getSelectValue().id) 
                        selected_status_id = s.id;
                    }
                  }
                );
              }
            );
            if (list.length == 2 && selectValue.id > 0) list.shift();
            
            self._select_status.setListItems(list);
            self._select_status.setSelectedId(
              selected_status_id == -1 ? list[0].id : selected_status_id);
          }
        }
      );

    self._selectedTaskId = taskId;
    self._getTaskDetailJson(taskId);
    self.comment._getComments();
    self._getTrackbacksAndTaskToTasks(taskId);
    self._setup_auto_completer();
    $('edit_tagValues').setAttribute("AutoComplete", "off");
    $('add_tagValues').setAttribute("AutoComplete", "off");
        
    Calendar.setup({
      inputField  : 'edit_due',
      displayArea : 'edit_due_display',
      ifFormat    : '%Y%m%d',
      daFormat    : '%Y-%m-%d',
      button      : 'show_calendar_button'
    });
    Calendar.setup({
      inputField  : 'add_due',
      displayArea : 'add_due_display',
      ifFormat    : '%Y%m%d',
      daFormat    : '%Y-%m-%d',
      button      : 'show_calendar_button2'
    });
    Tugboat.gtd_task_detail._setup_event_rules();
  },
  
  /**
   * resize container.
   * 
   */
  resize : function() {
    var page = Tugboat.getPageSize();
    var el_manu_bar = YAHOO.util.Dom.getRegion('menuBar_ul');
    var el_sidebar = YAHOO.util.Dom.getRegion('sidebar');
    
    $('main_pane').style.height = (page.windowHeight - el_manu_bar.bottom) + 'px';
    $('sidebar').style.height   = (page.windowHeight - el_manu_bar.bottom) + 'px';
    
    var isOverflow = page.windowWidth < 960;
    var pageWidth = isOverflow ? 960 : page.windowWidth;
    $('html').className     = isOverflow ? 'overflow_auto' : 'one_column';
    $('document').className = isOverflow ? 'overflow_auto' : 'one_column';
    
    var width = pageWidth - (el_sidebar.right - el_sidebar.left);
    $('header').style.width       = pageWidth    + 'px';
    $('content_body').style.width = pageWidth    + 'px';
    $('main_pane').style.width    = (width - 5 ) + 'px';
    $('detail_view').style.width  = (width - 15) + 'px';
    
    if ($('detail_view').style.display != 'none') {
      var el_leftPane = YAHOO.util.Dom.getRegion('detail_view_left_pane');
      $$('#detail_view_left_pane dd').each(
        function(dd) {
          dd.style.width = el_leftPane.right - el_leftPane.left - 77 - 3 - 10 + 'px';
        }
      );
    }
    
    var isIE6 = navigator.userAgent.indexOf('MSIE 6.0') > -1;
    var el_control_bar = YAHOO.util.Dom.getRegion('control_bar');
    $('comment_list').style.height = 
      (page.windowHeight - el_control_bar.bottom - (isIE6 ? 3 : 5)) + 'px';
    
    if (Tugboat.gtd_task_detail.comment._scroll_top_position
     && Tugboat.gtd_task_detail.comment._scroll_top_position.length > 0) {
      Tugboat.gtd_task_detail.comment._set_comment_scroll(false);
    }
  },
  
  /**
   * setup event rules.
   */
  _setup_event_rules : function() {
    var self = Tugboat.gtd_task_detail;
    var rules = {
      /*
       * add comments events.
       */
      '#add_comment_post' : function(el) {
        el.onclick = function(){
          Tugboat.gtd_task_detail.comment.post_onclick();
          return false;
        }
      },
      '#add_comment_cancel' : function(el) {
        el.onclick = function(){
          Windows.closeAll();
          return false;
        }
      },
      '#add_comment_link' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.comment.add_comment_link_onclick();
          return false;
        }
      },
      
      /*
       * edit task events.
       */
      '#status' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_UPDATE, el.id);
          return false;
        };
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
          return false;
        };
      },
      '#classification' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_UPDATE, el.id);
          return false;
        };
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
          return false;
        };
      },
      '#activity' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_UPDATE, el.id);
          return false;
        };
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
          return false;
        };
      },
      
      '#title' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_UPDATE, el.id);
          return false;
        };
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
          return false;
        };
      },
      
      '#simple_title' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_UPDATE, 'title');
          return false;
        };
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
          return false;
        };
      },
      
      '#detail_toggle_link1' : function(el) {
        el.onclick = function() {
          $('simple_view').style.display = 'none';
          $('detail_view').style.display = 'block';
          Tugboat.gtd_task_detail.resize();
          return false;
        }
      },
      
      '#detail_toggle_link2' : function(el) {
        el.onclick = function() {
          $('simple_view').style.display = 'block';
          $('detail_view').style.display = 'none';
          Tugboat.gtd_task_detail.resize();
          return false;
        }
      },
      
      '#description' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_UPDATE, el.id);
          return false;
        };
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
          return false;
        };
      },
      '#personInCharge' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_UPDATE, el.id);
          return false;
        };
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
          return false;
        };
      },
      '#dueDate' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_UPDATE, el.id);
          return false;
        };
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
          return false;
        };
      },
      
      '#tagValues' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_UPDATE, el.id);
          return false;
        };
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
          return false;
        };
      },
      
      '#detail_edit_cancel' : function(el) {
        el.onclick = function() {
          Windows.closeAll();
          return false;
        };
        el.onmouseover = function() {
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.cursor = 'default';
          return false;
        };
      },
      '#detail_edit_update' : function(el) {
        el.onclick = function() {
          if (self._window_mode == self.WIN_MODE_UPDATE) {
            Tugboat.gtd_task_detail.update_onclick();
          } else {
            Tugboat.gtd_task_detail.add_child_task_onclick();
          }
          return false;
        };
        el.onmouseover = function() {
          el.style.cursor = 'cursor';
          return false;
        };
        el.onmouseout = function() {
          el.style.cursor = 'default';
          return false;
        };
      },
      
      '#edit_task_form' : function(el) {
        el.onsubmit = function() {
          return false;
        }
      },
      
      '#add_task2Tasks_button' :function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.edit_task_onclick(self.WIN_MODE_CREATE, el.id);
          el.blur();
          return false;
        }
      },
     
      '#clear_calendar_button' : function(el) {
        el.onclick = function() {
          $('edit_due').value = '';
          $('edit_due_display').innerHTML = '';
          el.blur();
          return false;
        }
      },
      '#clear_calendar_button2' : function(el) {
        el.onclick = function() {
          $('add_due').value = '';
          $('add_due_display').innerHTML = '';
          el.blur();
          return false;
        }
      },
      /*
       * side bar.
       */
      '#sidebar_tasks_toggle' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.sidebar._toggle_element(el, 'task2Tasks_list');
          el.blur();
          return false;
        }
      },
      '#sidebar_trackbacks_toggle' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.sidebar._toggle_element(el, 'trackbacks_list');
          el.blur();
          return false;
        }
      },
      '#sidebar_from_meeting_tasks_toggle' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_task_detail.sidebar._toggle_element(el, 'fromMeetingTasks_list');
          el.blur();
          return false;
        }
      },
      
      '#sidebar_meeting h2' : function(el) {
        el.onclick = function() {
          var class_name = $('sidebar_meeting').className;
          $('sidebar_meeting').className = 
            class_name.indexOf('expand') > -1 
            ? 'sidebar_content clearfix collapse'
            : 'sidebar_content clearfix expand';

          Element.toggle('fromMeetingTasks_list');
          return false;
        }
      },
      
      '#sidebar_parent_task h2' : function(el) {
        el.onclick = function() {
          var class_name = $('sidebar_parent_task').className;
          $('sidebar_parent_task').className = 
            class_name.indexOf('expand') > -1 
            ? 'sidebar_content clearfix collapse'
            : 'sidebar_content clearfix expand';

          Element.toggle('trackbacks_list');
          return false;
        }
      },
      
      '#sidebar_child_task h2' : function(el) {
        el.onclick = function() {
          var class_name = $('sidebar_child_task').className;
          $('sidebar_child_task').className = 
            class_name.indexOf('expand') > -1 
            ? 'sidebar_content clearfix collapse'
            : 'sidebar_content clearfix expand';

          Element.toggle('task2Tasks_list');
          return false;
        }
      },
      
      '#addTaskForm' : function(el) {
        el.onsubmit = function() {
          return false;
        }
      },
      '#menu_sendmail_button' : function(el) {
        el.onclick = function() {
          if (! confirm('May I send this task?')) {
            return false;
          }
          var self = Tugboat.gtd_task_detail;
          new Ajax.Request(
            Tugboat.AJAX_SERVLET_NAME,
            {
              method: Tugboat.constant.REQUEST_GET,
              parameters:
              {
                component:'taskDetailAjax',
                action   :'sendMail',
                id       : self._selectedTaskId

              },
              onComplete: function(transport){
              }
            }
          );          
        }
        return false;
      },
      
      '#menuBar_KeyboardHelp' : function(el){
        el.onclick = function(){
          Tugboat.gtd_task_detail.shortcut_keys_onclick();
          el.blur();
          return false;
        }
      },
      '#shortcut_keys_close' : function(el) {
        el.onclick = function() {
          Windows.closeAll();
          el.blur();
          return false;
        }
      },
      
      '#edit_tagValues' : function(el) {
        el.onblur = function() {
          Tugboat.gtd_task_detail._tag_auto_completer1.hide();
          Tugboat.gtd_task_detail._tag_auto_completer1.active = false;
          return false;
        }
        el.onkeyup = function(key) {
          if (!key || !key.keyCode) return false;
          if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;

          if (key.keyCode == 188) {
              Tugboat.gtd_task_detail._tag_auto_completer1.hide();
              Tugboat.gtd_task_detail._tag_auto_completer1.active = false;
          }
          if (key.keyCode == Event.KEY_BACKSPACE 
           || key.keyCode == Event.KEY_DELETE 
           || $('edit_tagValues').value == '') {

            if (Tugboat.isEmpty($('edit_tagValues').value)) {
              $('edit_tagValues_target').value = '';
              Tugboat.gtd_task_detail._tag_auto_completer1.hide();
              Tugboat.gtd_task_detail._tag_auto_completer1.active = false;
            }
          }
          if (key.keyCode == Event.KEY_RETURN 
           && Tugboat.gtd_task_detail._tag_auto_completer1.active) {

            Tugboat.gtd_task_detail._tag_auto_completer1.selectEntry();
            Tugboat.gtd_task_detail._tag_auto_completer1.hide();
            
            var ret = $('edit_tagValues').value.tokenize(',');
            var tags_text = '';
            for (i=0; i<ret.length; i++) {
              if (i < ret.length - 1) tags_text += (ret[i] + ',');
              else                    tags_text += $('edit_tagValues_target').value
            }
            $('edit_tagValues').value = tags_text;
            $('edit_tagValues').focus();
            return false;
          }
          if (key.keyCode == Event.KEY_UP && Tugboat.gtd_task_detail._tag_auto_completer1.active) {
            Tugboat.gtd_task_detail._tag_auto_completer1.markPrevious();
            Tugboat.gtd_task_detail._tag_auto_completer1.render();
            return false;
          }
          if (key.keyCode == Event.KEY_DOWN && Tugboat.gtd_task_detail._tag_auto_completer1.active) {
            Tugboat.gtd_task_detail._tag_auto_completer1.markNext();
            Tugboat.gtd_task_detail._tag_auto_completer1.render();
            return false;
          }

          var tags_str = $('edit_tagValues').value;
          if (tags_str.substring(tags_str.length - 1) == ',') {
            $('edit_tagValues_target').value = '';
            Tugboat.gtd_task_detail._tag_auto_completer1.active = false;
          }
          else {
            var ret = $('edit_tagValues').value.tokenize(',');
            if (ret && ret.length > 0) {
              $('edit_tagValues_target').value = ret[ret.length - 1];
              
              Tugboat.gtd_task_detail._tag_auto_completer1.onObserverEvent();
            }
          }
        }
        return false;
      },
      '#add_tagValues' : function(el) {
        el.onblur = function() {
          Tugboat.gtd_task_detail._tag_auto_completer2.hide();
          Tugboat.gtd_task_detail._tag_auto_completer2.active = false;
          return false;
        }
        el.onkeyup = function(key) {
          if (!key || !key.keyCode) return false;
          if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;

          if (key.keyCode == 188) {
              Tugboat.gtd_task_detail._tag_auto_completer2.hide();
              Tugboat.gtd_task_detail._tag_auto_completer2.active = false;
          }
          if (key.keyCode == Event.KEY_BACKSPACE 
           || key.keyCode == Event.KEY_DELETE 
           || $('add_tagValues').value == '') {

            if (Tugboat.isEmpty($('add_tagValues').value)) {
              $('add_tagValues_target').value = '';
              Tugboat.gtd_task_detail._tag_auto_completer2.hide();
              Tugboat.gtd_task_detail._tag_auto_completer2.active = false;
            }
          }
          if (key.keyCode == Event.KEY_RETURN 
           && Tugboat.gtd_task_detail._tag_auto_completer2.active) {

            Tugboat.gtd_task_detail._tag_auto_completer2.selectEntry();
            Tugboat.gtd_task_detail._tag_auto_completer2.hide();
            
            var ret = $('add_tagValues').value.tokenize(',');
            var tags_text = '';
            for (i=0; i<ret.length; i++) {
              if (i < ret.length - 1) tags_text += (ret[i] + ',');
              else                  tags_text += $('add_tagValues_target').value
            }
            $('add_tagValues').value = tags_text;
            $('add_tagValues').focus();
            return false;
          }
          if (key.keyCode == Event.KEY_UP && Tugboat.gtd_task_detail._tag_auto_completer2.active) {
            Tugboat.gtd_task_detail._tag_auto_completer2.markPrevious();
            Tugboat.gtd_task_detail._tag_auto_completer2.render();
            return false;
          }
          if (key.keyCode == Event.KEY_DOWN && Tugboat.gtd_task_detail._tag_auto_completer2.active) {
            Tugboat.gtd_task_detail._tag_auto_completer2.markNext();
            Tugboat.gtd_task_detail._tag_auto_completer2.render();
            return false;
          }

          var tags_str = $('add_tagValues').value;
          if (tags_str.substring(tags_str.length - 1) == ',') {
            $('add_tagValues_target').value = '';
            Tugboat.gtd_task_detail._tag_auto_completer2.active = false;
          }
          else {
            var ret = $('add_tagValues').value.tokenize(',');
            if (ret && ret.length > 0) {
              $('add_tagValues_target').value = ret[ret.length - 1];
              
              Tugboat.gtd_task_detail._tag_auto_completer2.onObserverEvent();
            }
          }
        }
        return false;
      }
    };
    Behaviour.register(rules);
  },
  
  _detail_view_onclick : function(el) {
    Element.hide('detail_view');
    Element.show('detail_edit');
    
    $('edit_title').focus();
  },
  
  /**
   * get task detail json.
   * @param {Object} taskId
   */
  _getTaskDetailJson : function(taskId) {
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_POST,
        parameters:
        {
          component:'taskDetailAjax',
          action   :'getTaskDetailJSON',
          id       : taskId
        },
        onComplete: function(transport){
          var self = Tugboat.gtd_task_detail;
          self._set_values(transport, self._is_after_initialized);
          
          self._is_after_initialized = false;
        }
      }
    );
  },
  
  /**
   * set display.
   * @param {Object} transport
   * @param {boolean} isFirstTime
   */
  _set_values : function(transport, isFirstTime) {
    var self = Tugboat.gtd_task_detail;
    var json = eval('(' + transport.responseText + ')');
    
    $('simple_title').innerHTML = json.task.title;
    $('title').innerHTML = json.task.title; // + '&nbsp;';
    $('edit_title').value = json.task.title;
    
    $('description').innerHTML = 
      Tugboat.isEmpty(json.task.description) 
      ? '&nbsp;'
      : json.task.description.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
    
    $('edit_description').value = json.task.description;
    
    $('status').innerHTML = 
      '<img src="images/default/folder/gif/' 
    + (json.task.statusId == 1 ? 'status_todo.gif' :
       json.task.statusId == 2 ? 'status_doing.gif'
                          : 'status_done.gif'
      )
    + '" class="left_and_right_3px_margin" />' 
    + json.task.statusValue;
    
    $('classification').innerHTML = 
      '<img src="images/default/folder/gif/' 
    + (json.task.classificationId == 1  ? 'folder-red-16.gif'    :
       json.task.classificationId == 2  ? 'folder-orange-16.gif' :
       json.task.classificationId == 3  ? 'folder-yellow-16.gif' :
       json.task.classificationId == 4  ? 'folder-green-16.gif'  :
       json.task.classificationId == 5  ? 'folder-blue-16.gif'   :
       json.task.classificationId == 9  ? 'inbox-16.gif'         :
       json.task.classificationId == 21 ? 'folder-gray-16.gif'   :
       json.task.classificationId == 99 ? 'trash-16.gif'         
                                        : ''
      )
    + '" class="left_and_right_3px_margin" />' 
    + json.task.classificationValue;
          
    self._select_class.setSelectedId(json.task.classificationId);
    
    $('activity').innerHTML = 
      '<img src="images/default/palette/pl_bg_' 
    + json.task.colorValue + '.gif" class="left_and_right_3px_margin" />' 
    + json.task.activityValue;

    $('personInCharge').innerHTML = 
      json.task.personInChargeLastName + ',' + json.task.personInChargeFirstName;
    
    $('edit_personInCharge').value = 
      json.task.personInChargeLastName + ',' + json.task.personInChargeFirstName;
    
    $('selectedUserId1').value = json.task.personInChargeId;
    
    $('dueDate').innerHTML = Tugboat.isEmpty(json.task.deadlineFormated) ? 'N/A' : json.task.deadlineFormated;
    
    $('edit_due_display').innerHTML = (
      json.task.deadlineFormated ? json.task.deadlineFormated : '&nbsp;');

    $('edit_due').value = json.task.deadline;
    
    var tag_values = '';
    if (json.tags) {
      var i = 0;
      json.tags.each(
        function(t) {
          tag_values += t.tagValue + (i < json.tags.length - 1 ? ',' : '');
          i++;
        }
      );
    }
    $('tagValues').innerHTML = tag_values;
    $('edit_tagValues').value = tag_values;
    
    $('task_created').innerHTML = 
      'Created by ' + json.task.userLastName + ',' + json.task.userFirstName 
           + ' at ' +  json.task.registeredFormated;
           
    $('task_permalink').innerHTML = 
      'Permalink: ' + document.URL.replace(/view\/.*/,'browse/tasks/' + $('param_task_id').value);
    
    self._setStatusesSelectMenu(json.task.statusId, json.task.classificationId, isFirstTime);
    self._setActivitiesSelectMenu(json.task.activityId, isFirstTime);
    self._createPersonInChargeAutoCompleter(json.task.activityId, isFirstTime);
  },
  
  /**
   * create person in charge auto completer.
   * @param {Object} activityId
   * @param {boolean} isFirstTime
   */
  _createPersonInChargeAutoCompleter : function(activityId, isFirstTime) {
    if (! isFirstTime) return false;
    
    var self = Tugboat.gtd_task_detail;
    self._personInChargeAutoCompleter1 = 
      new Ajax.Autocompleter(
        'edit_personInCharge',
        'edit_personInCharge_ac', 
        'teeda.ajax?component=activityMemberAjax&action=getActivityMembersByActivityIdAndKeyword&activityId=' + activityId, 
        { minChars: 2,
          paramName:'selectMemberChar',
          optionTextfield:$('selectedUserId1'),
          optionAttributeName:'tgb:value'
        }
      );
      
    self._personInChargeAutoCompleter2 = 
      new Ajax.Autocompleter(
        'add_personInCharge',
        'add_personInCharge_ac', 
        'teeda.ajax?component=activityMemberAjax&action=getActivityMembersByActivityIdAndKeyword&activityId=' + activityId, 
        { minChars: 2,
          paramName:'selectMemberChar',
          optionTextfield:$('selectedUserId2'),
          optionAttributeName:'tgb:value'
        }
      );
  }, 
  
  /**
   * set statuses select menu.
   * @param {Object} statusId
   * @param {Object} classId
   * @param {boolean} isFirstTime
   */
  _setStatusesSelectMenu : function(statusId, classId, isFirstTime) {
    var self = Tugboat.gtd_task_detail;
    var rule = 
      self._class_status_rules.find(
        function(r) {
          return classId == r.classId;
        }
      );
    
    var list = [];
    self._select_status_list.each(
      function(s) {
        if (s.id == 0) list.push(s);
        rule.statusIds.each(
          function(r) { if (s.id == r) list.push(s); }
        );
      }
    );
    if (isFirstTime) {
      self._select_status = 
        new TugboatUI.SelectMenu(
          'edit_status', list,
          { parentElement:'editTaskWindow', isParentWindow:true, onSelected:function(selectValue){} }
        );
    }
    self._select_status.setSelectedId(statusId);
  },

  /**
   * set activity select menu.
   * @param {Object} activityId
   * @param {boolean} isFirstTime
   */
  _setActivitiesSelectMenu : function(activityId, isFirstTime) {
    if (! isFirstTime) return false;

    var self = Tugboat.gtd_task_detail;
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component:'activityAjax',
          action   :'getOwnActivitiesForSelectMenu'
        },
        onComplete: function(transport){
          if (! transport || transport.responseText.length==0) return false;
          var json = eval(transport.responseText);
          
          self._select_activity = 
            new TugboatUI.SelectMenu(
              'edit_activity', 
              json,
              { parentElement:'editTaskWindow',
                isParentWindow:true,
                onSelected:function(selectValue)
                { 
                  $('edit_personInCharge').value='';
                  self._createPersonInChargeAutoCompleter(selectValue.id);
                } 
              }
            );
          self._select_activity.setSelectedId(activityId);
        }
      }
    );
  },

  /**
   * update.
   */
  update_onclick : function() {
    var self = Tugboat.gtd_task_detail;
    var taskId      = $('param_task_id').value;
    var title       = $('edit_title').value;
    var description = $('edit_description').value;
    var statusId    = self._select_status.getSelectValue().id;
    var classId     = self._select_class.getSelectValue().id;
    var activityId  = self._select_activity.getSelectValue().id;
    var userId      = $('selectedUserId1').value;
    var due         = $('edit_due').value;
    var tags        = $('edit_tagValues').value;
    
    var messages = [];
    if ( statusId == 0 ) {
      messages.push('\'Status\' is not selected.');
    }
    if ( classId == 0 ) {
      messages.push('\'Classification\' is not selected.');
    }
    if ( Tugboat.isEmpty(title) ) {
      messages.push('\'Title\' is required.');
    }
    if ( userId == '0' ) {
      messages.push('\'Person In Charge\' is required.');
    }
    if ( messages.length > 0 ) {
      Tugboat.showAlertDialog( messages );
      return false;
    }
    
    Tugboat.gtd_task_detail.progress.open();
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_POST,
        parameters:
        {
          component         :'taskDetailAjax',
          action            :'update',
          id                :taskId,
          statusId          :statusId,
          classificationId  :classId,
          activityId        :activityId,
          title             :title, 
          description       :description,
          personId          :userId,
          deadline          :due,
          tags              :tags
        },
        onComplete: function(transport){
          self._set_values(transport);
          Tugboat.gtd_task_detail.progress.close();
        },
        onFailure: function(transport) {
          Tugboat.gtd_task_detail.progress.close();
        }
      }
    );
    Windows.closeAll();
    return false;
  },
  
  /**
   * edit task onclick.
   * 
   * @param mode
   * @param selected_id (*option)
   */
  edit_task_window : null,
  
  edit_task_onclick : function(mode, selected_id) {
      Tugboat.gtd_task_detail.modal.open();
      var self = Tugboat.gtd_task_detail;
      self._window_mode = mode;
      self._get_activities();
      
      var window_title =       
        mode == self.WIN_MODE_CREATE ? 'add child task' : 'edit task';
      var window_height =       
        mode == self.WIN_MODE_CREATE ? 340 : 405;
      var focus_target = '';
      
      if (mode == self.WIN_MODE_UPDATE) {
        $('dt_status').style.display = 'block';
        $('dd_status').style.display = 'block';
        $('dt_class').style.display = 'block';
        $('dd_class').style.display = 'block';
        
        $('edit_title').style.display = 'block';
        $('edit_description').style.display = 'block';
        $('edit_activity').style.display = 'block';
        $('edit_tag_container').style.display = 'block';
        $('edit_person_container').style.display = 'block';
        $('edit_due_container').style.display = 'block';
        
        $('add_task_title').style.display = 'none';
        $('add_task_description').style.display = 'none';
        $('add_task_activity_container').style.display = 'none';
        $('add_tag_container').style.display = 'none';
        $('add_person_container').style.display = 'none';
        $('add_due_container').style.display = 'none';
        
        focus_target = 'edit_' + selected_id;
        
      } else if (mode == self.WIN_MODE_CREATE) {
        $('edit_title').style.display = 'none';
        $('edit_description').style.display = 'none';
        $('edit_activity').style.display = 'none';
        $('edit_tag_container').style.display = 'none';
        $('edit_person_container').style.display = 'none';
        $('edit_due_container').style.display = 'none';
        
        $('add_task_title').style.display = 'block';
        $('add_task_description').style.display = 'block';
        $('add_task_activity_container').style.display = 'block';
        $('add_tag_container').style.display = 'block';
        $('add_person_container').style.display = 'block';
        $('add_due_container').style.display = 'block';
        
        $('dt_status').style.display = 'none';
        $('dd_status').style.display = 'none';
        $('dt_class').style.display = 'none';
        $('dd_class').style.display = 'none';

        focus_target = 'add_task_title';
      }
      
      self.edit_task_window = 
        new Window(
          'editTaskWindow', 
          { className: 'mac_os_x', width:640, height:window_height, 
            zIndex: 100, 
            minimizable: false, 
            closable   : false, 
            maximizable: false,
            resizable  : false, 
            draggable  : true,
            title      : window_title,
            showEffectOptions: {
              duration:0.3,
              afterFinish:function(){
                if (selected_id.indexOf('due') == -1) {
                  $(focus_target).focus();
                }
              }
            }
          }
        );

      self.edit_task_window.setContent('edit_task_form_container',false,false);
      self.edit_task_window.setDestroyOnClose();
      self.edit_task_window.showCenter();
      
      var taskWindowObserver = { 
        onDestroy: function(eventName, win) {
          if (win == self.edit_task_window) {
            $('edit_task_form_container').style.display = 'none';
            $('edit_task_form_container').appendChild($('edit_task_form'));
            
            self.edit_task_window = null;
            Windows.removeObserver(this);
            
            Tugboat.gtd_task_detail.modal.close();
          }          
        } 
      };
      Windows.addObserver(taskWindowObserver);
  },
  
  /**
   * get activities.
   *
   */
  _get_activities : function() {
    if (Tugboat.gtd_task_detail._add_task_select_activity) return false; 
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component:'taskAjax',
          action   :'getActivitiesJSON'
        },
        onComplete: function(transport){
          var activities = eval(transport.responseText);
          var list = [];
          activities.each(
            function(a) {
              list.push(
                { id:a.id, 
                  value:a.value, 
                  icon:'images/default/palette/pl_bg_' + a.color + '.gif'});
            }
          );
          
          var self = Tugboat.gtd_task_detail;
          self._add_task_select_activity = 
            new TugboatUI.SelectMenu(
              'add_task_activity_container', 
              list,
              { parentElement:'editTaskWindow', 
                isParentWindow:true, 
                onSelected:function(selectValue){} }
            );
          self._add_task_select_activity.setSelectedId(
            self._select_activity.getSelectValue().id);
        }
      }
    );
  },
  
  ADD_TYPE_NORMAL  : 1,
  ADD_TYPE_ANOTHER : 2,
  
  /**
   * add child task.
   * 
   */
  _is_processing : false,
  
  add_child_task_onclick : function() {
    var self = Tugboat.gtd_task_detail;
    if (self._is_processing) return false;
    
    self._is_processing = true;
    
    var taskId = $('param_task_id').value;
    var selectActivityValue = self._add_task_select_activity.getSelectValue();
    var activityId  = selectActivityValue ? selectActivityValue.id : null;
    var title       = $('add_task_title').value;
    var description = $('add_task_description').value;
    var personInChargeId = $('selectedUserId2').value;
    var due = $('add_due').value;
    var tags = $('add_tagValues').value;
    
    if (Tugboat.isEmpty(personInChargeId)) {
      personInChargeId = 0;
    }
    
    var messages = [];
    if (activityId == null) {
      messages.push('\'Activity\' is not selected.');
    }
    if (Tugboat.isEmpty(title)) {
      messages.push('\'Title\' is required.');
    }
    if (personInChargeId == 0) {
      messages.push('\'Person in charge\' is required.');
    }
    if (messages.length > 0) {
      Tugboat.showAlertDialog( messages );
      self._is_processing = false;
      return false;
    }
    
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_POST,
        parameters:
        {
          component  :'taskDetailAjax',
          action     :'addTaskToTasks',
          id         :taskId,
          activityId :activityId,
          title      :title, 
          description:description,
          personId   :personInChargeId,
          deadline   :due,
          tags       :tags
        },
        onComplete: function(transport){
          $('add_task_title').value = '';
          $('add_task_description').value = '';
          $('add_tagValues').value = '';
          $('add_tagValues_target').value = '';
          $('add_tagValues_4ad').value = '';
          $('add_personInCharge').value = '';
          $('selectedUserId2').value = '0';
          $('add_due_display').innerHTML = ' ';
          $('add_due').value = '';
          
          self._add_task_select_activity.setSelectedId(
            self._select_activity.getSelectValue().id);
          
          self._getTrackbacksAndTaskToTasks(taskId);
          
          self._is_processing = false;
        }
      }
    );
    Windows.closeAll();
    return false;
  },

  /**
   * get trackback and task to tasks.
   * @param {Object} taskId
   */
  _getTrackbacksAndTaskToTasks : function(taskId) {
    var self = Tugboat.gtd_task_detail;
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_POST,
        parameters:
        {
          component:'taskDetailAjax',
          action   :'getTaskToTasksAndTrackbacksJSON',
          id       :taskId
        },
        onComplete: function(transport){
          if (!transport.responseText || transport.responseText == 'null') {
            $('task2Tasks_list').innerHTML = '<li><p class="task_title">N/A</p></li>';
            $('trackbacks_list').innerHTML = '<li><p class="task_title">N/A</p></li>';
            $('fromMeetingTasks_list').innerHTML = '<li class="no_records"><p class="meeting_title">N/A</p></li>';
            return false;
          }
          var json = eval(transport.responseText);
          
          var ulTaskToTasks = $('task2Tasks_list');
          var ulTrackbacks = $('trackbacks_list');
          ulTaskToTasks.innerHTML = '';
          ulTrackbacks.innerHTML = '';
          
          //-- Task To Tasks list
          if (json.taskToTasks) {
            json.taskToTasks.each(
              function (t) {
                if (taskId == t.sourceTaskId) {
                  var status_className = 
                    self._getTrackbacksAndTaskToTasks_status_className(t.destinationStatusId);
                  var class_className = 
                    self._getTrackbacksAndTaskToTasks_class_className(t.destinationClassificationId);

                  var li = 
                  LI(null,
                    DIV({'class':''},
                      [
                        DIV({'class':status_className}),
                        DIV({'class':class_className }),
                        P({'class':'task_title'},
                          A(
                            { 'href':'gtdTaskDetail.html?taskId=' + t.destinationTaskId + '&sid=' + Tugboat.dateSerialize(new Date())
                            },t.destinationTitle)
                        ),
                        P({'class':'created_by'},'p: ' + t.destinationPersonInChargeName),
                        P({'class':'created_at'},t.destinationPostedAtFormated)
                      ]
                    )
                  );
                  ulTaskToTasks.appendChild(li);
                }
              }
            );
          
            //-- Trackbacks list
            json.taskToTasks.each(
              function (t) {
                if (taskId == t.destinationTaskId) {
                  var status_className = 
                    self._getTrackbacksAndTaskToTasks_status_className(t.sourceStatusId);
                  var class_className = 
                    self._getTrackbacksAndTaskToTasks_class_className(t.sourceClassificationId);

                  var li = 
                  LI(null,
                    DIV({'class':''},
                      [
                        DIV({'class':status_className}),
                        DIV({'class':class_className }),
                        P({'class':'title'},
                          A(
                            { 'href':'gtdTaskDetail.html?taskId=' + t.sourceTaskId + '&sid=' + Tugboat.dateSerialize(new Date())
                            },t.sourceTitle)
                        ),
                        P({'class':'created_by'},t.sourcePostedBy),
                        P({'class':'created_at'},t.sourcePostedAtFormated)
                      ]
                    )
                  );
                  ulTrackbacks.appendChild(li);
                }
              }
            );
          }
          
          if (ulTaskToTasks.innerHTML == '') {
            ulTaskToTasks.innerHTML = '<li><p class="task_title">N/A</p></li>';
          }
          if (ulTrackbacks.innerHTML == '') {
            ulTrackbacks.innerHTML = '<li><p class="task_title">N/A</p></li>';
          }
            
          // meeting to tasks.
          var ulMeetingToTasks = $('fromMeetingTasks_list');
          ulMeetingToTasks.innerHTML = '';
          
          if (json.meetingToTasks) {
            json.meetingToTasks.each(
              function(t) {
                var li = 
                LI(null,
                  P({'class':'meeting_title'},
                    [
                      //IMG({'src':'images/default/icon/contact_group.gif','class':'left_and_right_3px_margin'}),
                      A(
                        { 'href':'gtdMeetingDetail.html?id=' + t.basicId + '&sid=' + Tugboat.dateSerialize(new Date())
                        },t.meetingTitle
                      )
                    ]
                  )
                );
                ulMeetingToTasks.appendChild(li);
              }
            );
          }
          if (ulMeetingToTasks.innerHTML == '') {
            ulMeetingToTasks.innerHTML = '<li class="no_records"><p class="meeting_title">N/A</p></li>';
          }
          
        }
      }
    );
  },
  
  _getTrackbacksAndTaskToTasks_class_className : function (classId) {
    return (
      classId == 1  ? 'class_icon today'   : 
      classId == 2  ? 'class_icon week'    :
      classId == 3  ? 'class_icon month'   :
      classId == 4  ? 'class_icon hold'    :
      classId == 5  ? 'class_icon someday' :
      classId == 9  ? 'class_icon inbox'   :
      classId == 21 ? 'class_icon archive' :
      classId == 99 ? 'class_icon trash'
                    : 'class_icon inbox');
  },
  
  _getTrackbacksAndTaskToTasks_status_className : function (statusId) {
    return (
      statusId == 1 ? 'status todo'  : 
      statusId == 2 ? 'status doing'
                    : 'status done');
  },

  /**
   * setup auto completer for tags.
   * 
   */
  _setup_auto_completer : function() {
    var self = Tugboat.gtd_task_detail;
    self._tag_auto_completer1 = 
      new Ajax.Autocompleter(
        'edit_tagValues_target',
        'edit_tagValues_ac', 
        'teeda.ajax?component=taskTagAjax&action=findTagsByKeyword', 
        { minChars :1,
          paramName:'keyword',
          optionTextfield:$('edit_tagValues_4ad'),
          optionAttributeName:'tgb:value'
        }
      );
      
    self._tag_auto_completer2 = 
      new Ajax.Autocompleter(
        'add_tagValues_target',
        'add_tagValues_ac', 
        'teeda.ajax?component=taskTagAjax&action=findTagsByKeyword', 
        { minChars :1,
          paramName:'keyword',
          optionTextfield:$('add_tagValues_4ad'),
          optionAttributeName:'tgb:value'
        }
      );
  },
  
  shortcut_keys_window : null,
  shortcut_keys_onclick : function() {
    Tugboat.gtd_task_detail.modal.open();
    var self = Tugboat.gtd_task_detail;
      
    self.shortcut_keys_window = 
      new Window(
        'addTaskWindow',
        { className: 'mac_os_x', width:500, height:250, 
          zIndex: 100, 
          minimizable: false, 
          closable   : false, 
          maximizable: false,
          resizable  : false, 
          draggable  : true,
          title      : 'Shortcut keys?',
          showEffectOptions:{
            duration:0.5
          }
        }
      );
    self.shortcut_keys_window.setContent('shortcut_keys_sub_window_container',false,false);
    self.shortcut_keys_window.setDestroyOnClose();
    self.shortcut_keys_window.showCenter();
      
    var taskWindowObserver = {
      onDestroy: function(eventName, win) {
        if (win == self.shortcut_keys_window) {
          Element.hide('shortcut_keys_sub_window_container');
          $('shortcut_keys_sub_window_container').appendChild($('shortcut_keys_sub_window'));
                     
          Windows.removeObserver(this);
          Tugboat.gtd_task_detail.modal.close();
        }
      }
    };
    Windows.addObserver(taskWindowObserver);
  },

  /*
   * Modal window
   *
   * 
   */
  modal : {
    _is_opened : false,

    open : function () {
      var self = Tugboat.gtd_task_detail.modal;
      self._is_opened = true;

      var page = Tugboat.getPageSize(); 
      Element.setHeight('modal_window', page.pageHeight);
      $('modal_window').style.display = 'block';
    },

    close : function() {
      var self = Tugboat.gtd_task_detail.modal;
      self._is_opened = false;
      $('modal_window').style.display = 'none';
    }
  },
  
  /*
   * Progress
   *
   * 
   */
  progress : {
    open : function () {
      var page = Tugboat.getPageSize(); 
      Element.setHeight('progress_window', page.pageHeight);
      $('progress_window').style.display='block';
    },
    close : function() {
      Element.hide('progress_window');
    }
  },

  /*
   * Comment.
   * 
   * 
   */
  comment : {
    _add_comment_window : null,
        
    /**
     * add comment link onclick.
     * 
     */
    add_comment_link_onclick : function() {
      Tugboat.gtd_task_detail.modal.open();

      var self = Tugboat.gtd_task_detail.comment;
      self._add_comment_window = 
        new Window(
          'addCommentWindow', 
          { className: 'mac_os_x', width:640, height:400, 
            zIndex: 100, 
            minimizable: false, 
            closable   : false, 
            maximizable: false,
            resizable  : false, 
            draggable  : true,
            title      : 'add comment',
            showEffectOptions: {
              duration:0.3,
              afterFinish:function(){
                $('add_comment').focus();
              }
            }
          }
        );

      self._add_comment_window.setContent('add_comment_form_container',false,false);
      self._add_comment_window.setDestroyOnClose();
      self._add_comment_window.showCenter();
      
      var taskWindowObserver = { 
        onDestroy: function(eventName, win) {
          if (win == self._add_comment_window) {
            $('add_comment_form_container').style.display = 'none';
            $('add_comment_form_container').appendChild($('add_comment_form'));
            
            self._add_comment_window = null;
            Windows.removeObserver(this);
            
            Tugboat.gtd_task_detail.modal.close();
          }          
        } 
      };
      Windows.addObserver(taskWindowObserver);
    },
    
    /**
     * post onclick.
     * 
     */
    _is_processing : false,
    
    post_onclick : function() {
      var self = Tugboat.gtd_task_detail.comment;
      if (self._is_processing) return false;
      self._is_processing = true;

      var comment = $('add_comment').value;
      if (Tugboat.isEmpty(comment)) {
        Tugboat.showAlertDialog('\'comment\' is required.');
        self._is_processing = false;
        return false;
      }
      
      var params = 
        $H({component:'taskDetailAjax', action:'addComment', 
            taskId:Tugboat.gtd_task_detail._selectedTaskId, comment:comment});
      
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {
          method: Tugboat.constant.REQUEST_POST,
          parameters: 
          { component:'taskDetailAjax', 
            action   :'addComment', 
            id       :Tugboat.gtd_task_detail._selectedTaskId, 
            comment  :comment
          },
          onComplete: function(transport){
            var commentJson = eval(transport.responseText);
            var self = Tugboat.gtd_task_detail.comment;
            self._create_comments(commentJson);
            
            $('add_comment').value = '';
            Windows.closeAll();
            self._is_processing = false;
          },
          onFailure : function(transport) {
            Windows.closeAll();
            self._is_processing = false;
          }
        }
      );
    },
    
    _getComments : function() {
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {
          method: Tugboat.constant.REQUEST_GET,
          parameters:
          {
            component:'taskDetailAjax',
            action   :'getAllCommentsByTaskId',
            id       :Tugboat.gtd_task_detail._selectedTaskId
          },
          onComplete: function(transport){
            if (Tugboat.isEmpty(transport.responseText) || transport.responseText == 'null') {
              $('comment_header_number_of_count').innerHTML = '0';
              return false;
            }
            var comments = eval(transport.responseText);
            Tugboat.gtd_task_detail.comment._create_comments(comments);
          }
        }
      );
    },
    
    _title_colors : [],
    _scroll_top_position : [],
    _scroll_present_index : 0,
    
    /**
     * create comments.
     * 
     * @param {Object} commentJson
     */
    _create_comments : function(json) {
      var ID_PREFIX_COMMENT    = 'COMMENT-';
      var ID_PREFIX_ROW_ACTION = 'COMMENT_ROW_ACTION-';
      var ID_PREFIX_EDIT_BTN   = 'COMMENT_EDIT-';
      var ul = $('comment_list');
      var self = Tugboat.gtd_task_detail.comment;
      
      self._title_colors = [];
      self._scroll_top_position = [];
      ul.innerHTML = '';
      
      var counter = 0;
      var date = new Date();
      var str_today = 
        Tugboat.getDateFormattedString(
          date.getFullYear(), date.getMonth() + 1, date.getDate(), '-');

      json.each(
	    function(c) {
          var commentId   = ID_PREFIX_COMMENT    + c.id;
          var rowActionId = ID_PREFIX_ROW_ACTION + c.id;
          var editBtnId   = ID_PREFIX_EDIT_BTN   + c.id;
          var comment_list_id = '';
          
          comment_list_id = 'C-'+c.id;
          self._scroll_top_position.push({'id': comment_list_id, 'position':0 });
          counter++;
          
          var title_class = self._get_comment_title_class(c);
          
		  var list = 
            LI({'id':comment_list_id, 'class':'comment_li'},
              [
                P({'id':rowActionId, 'style':'height:0px;'}),
                P({'id':'comment_header-' + c.id, 'class':'comment_header'},
                  [
                    SPAN({'class':title_class + ' posted'},
                      '[' + counter +  '] '
                    + c.userLastName       + ',' 
                    + c.userFirstName      + ' at ' 
                    + (c.registeredFormated.indexOf(str_today) > -1
                       ? 'Today' + c.registeredFormated.substring(str_today.length)
                       : c.registeredFormated) + ' '),

                    function() {
                      if (c.isMyComment) {
                        return A({'id':editBtnId, 'href':'javascript:void(0);'},'edit')
                      }
                    },
                    function() {
                      if (c.isMyComment) {
                        return SPAN(null,' / ')
                      }
                    },
                    function() {
                      if (c.isMyComment) {
                        return A({'href':'javascript:void(0);',
                          'onclick':function(){ self._deleteComment(c.taskId, c.id); }},'delete');
                      }
                    }
                  ]
                ),
                DIV({'class':'comment_body_border'},
                  function() { 
                    var pBody = P({'id':commentId, 'class':'comment_body'});
                    pBody.innerHTML = c.comment.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
                    return pBody;
                  }
                )
              ]
            );
          ul.appendChild(list);
          
          if (c.isMyComment) {
            new TugboatUI.InPlaceEditor(
              ID_PREFIX_COMMENT    + c.id, 
              ID_PREFIX_ROW_ACTION + c.id,
              ID_PREFIX_EDIT_BTN   + c.id,
              c.comment,
              { save:function(inputValue){
                  new Ajax.Request(
                    Tugboat.AJAX_SERVLET_NAME,
                    { 
                      method: Tugboat.constant.REQUEST_POST,
                      parameters: 
                      {
                        component : 'taskDetailAjax',
                        action    : 'updateComment',
                        id        : c.taskId,
                        commentId : c.id,
                        comment   : inputValue
                      },
                      onComplete: function(transport){
                        self._set_comment_scroll(false);
                      }
                    }
                  );
                }
              }
            );
          }
        }
      );
      ul.appendChild(
        LI({'id':'comment_list_spacer'})
      );
      $('comment_header_number_of_count').innerHTML = json.length;
      self._set_comment_scroll(true);
    },
    
    /**
     * set comment scroll.
     * 
     * @param isShowLastRow
     */
    _set_comment_scroll : function(isShowLastRow) {
      var self = Tugboat.gtd_task_detail.comment;

      var last_row_scroll_info = 
        self._scroll_top_position[self._scroll_top_position.length - 1];
      var el_comment_list = YAHOO.util.Dom.getRegion('comment_list');
      var el_last_row = YAHOO.util.Dom.getRegion(last_row_scroll_info.id);
      var list_height =
        (el_comment_list.bottom - el_comment_list.top)
      - (el_last_row.bottom - el_last_row.top  + 5);

      $('comment_list_spacer').style.height = list_height + 'px';
      $('comment_list').scrollTop = 0;

      var el_parent = YAHOO.util.Dom.getRegion('comment_list');
      self._scroll_top_position.each(
        function(s) {
          var el_target = YAHOO.util.Dom.getRegion(s.id);
          s.position = el_target.top - el_parent.top;
        }
      );
      if (isShowLastRow) {
        self._scroll_present_index = self._scroll_top_position.length - 1;
      }
      $('comment_list').scrollTop = 
        self._scroll_top_position[self._scroll_present_index].position;
    },
    
    
    /**
     * get comment title class.
     * 
     * @param {Object} json
     */
    _get_comment_title_class : function(json) {
      if (json.isMyComment) return 'me';
      
      var class_name = '';
      var self = Tugboat.gtd_task_detail.comment;
      
      if (self._title_colors && self._title_colors.length == 0) {
        class_name = 'another_1';
        self._title_colors.push({'user_id': json.userId, 'class_name' : class_name });
      } else {
        var oneself = self._title_colors.find(
          function(c) {
            return c.user_id == json.userId;
          }
        );
        
        if (oneself) {
          class_name = oneself.class_name;
        } else {
          var index = 
            self._title_colors.length % 10 == 0 
            ? 10 
            : self._title_colors.length < 10 
              ? self._title_colors.length + 1 
              : 1;
              
          class_name = 'another_' + index;
          self._title_colors.push({'user_id': json.userId, 'class_name' : class_name });
        }
      }
      return class_name;
    },
    
    /**
     * delete comment.
     * @param {Object} taskId
     * @param {Object} commentId
     */
    _deleteComment : function(taskId, commentId) {
      if (! confirm('May I remove this comment?')) {
        return false;
      }
      
      TugboatUI.InPlaceEditor.isAlreadyEdit = false;
      
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {
          method: Tugboat.constant.REQUEST_POST,
          parameters: 
          { component:'taskDetailAjax', 
            action   :'deleteComment', 
            id       :taskId, 
            commentId:commentId
          },
          onComplete: function(transport){
            if (Tugboat.isEmpty(transport.responseText) || transport.responseText == 'null') {
              $('comment_header_number_of_count').innerHTML = '0';
            }
            var commentJson = eval(transport.responseText);
            var self = Tugboat.gtd_task_detail.comment;
            self._create_comments(commentJson);
          }
        }
      );
    }
  },
  
  /*
   * side bar.
   */  
  sidebar:{
    /**
     * toggle comment.
     * @param {Object} anchorObject
     * @param {Object} elemId
     */
    _toggle_element : function(anchorObject, elemId) {
	  anchorObject.className = 
      $(elemId).style.display == 'none'? 'collapse_icon': 'expand_icon';
	  Element.toggle(elemId);
	}
  }
};
YAHOO.util.Event.addListener(
  document, "keydown",
  function(key){
    if (key.keyCode == Event.KEY_ESC) {
      if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;
      
      Tugboat.gtd_task_detail._prev_entry_key_code = 0;
      Windows.closeAll();
    }

    var isIE6 = navigator.userAgent.indexOf('MSIE 6.0') > -1;
    if (isIE6 
     || Tugboat.gtd_task_detail.modal._is_opened 
     || TugboatUI.InPlaceEditor.isAlreadyEdit) {
    } else {

      switch (key.keyCode) {
        //[home]
        case Event.KEY_HOME:
          if (Tugboat.gtd_task_detail.comment._scroll_top_position.length > 0) {
            var comment = Tugboat.gtd_task_detail.comment;
            comment._scroll_present_index = 0;
            $('comment_list').scrollTop = 0;
            Tugboat.gtd_task_detail._prev_entry_key_code = 0;
          }
          break;
        //[end]
        case Event.KEY_END:
          if (Tugboat.gtd_task_detail.comment._scroll_top_position.length > 0) {
            var comment = Tugboat.gtd_task_detail.comment;
            var position =
              comment._scroll_top_position[comment._scroll_top_position.length - 1].position;
            comment._scroll_present_index = comment._scroll_top_position.length - 1;

            $('comment_list').scrollTop = 0;
            $('comment_list').scrollTop = position;
            Tugboat.gtd_task_detail._prev_entry_key_code = 0;
          }
          break;
        //[a]
        case Event.KEY_A:
          Tugboat.gtd_task_detail._prev_entry_key_code = key.keyCode;
          break;
        //[b]
        case Event.KEY_B:
          if (Tugboat.gtd_task_detail._prev_entry_key_code == Event.KEY_G) {
            Tugboat.gtd_task_detail._prev_entry_key_code = 0;
            location.href='gtdTasks.html';
          }
          break;
        //[c]
        case Event.KEY_C:
          if (Tugboat.gtd_task_detail._prev_entry_key_code == Event.KEY_A) {
            Tugboat.gtd_task_detail._prev_entry_key_code = 0;
            Tugboat.gtd_task_detail.comment.add_comment_link_onclick();
          }
          break;
        //[e]
        case Event.KEY_E:
          Tugboat.gtd_task_detail._prev_entry_key_code = key.keyCode;
          break;
        //[g]
        case Event.KEY_G:
          Tugboat.gtd_task_detail._prev_entry_key_code = key.keyCode;
          break;
        //[t]
        case Event.KEY_T:
          if (Tugboat.gtd_task_detail._prev_entry_key_code == Event.KEY_A) {
            Tugboat.gtd_task_detail.edit_task_onclick(
              Tugboat.gtd_task_detail.WIN_MODE_CREATE, 'add_task2Tasks_button');

          } else if (Tugboat.gtd_task_detail._prev_entry_key_code == Event.KEY_E) {
            Tugboat.gtd_task_detail.edit_task_onclick(
              Tugboat.gtd_task_detail.WIN_MODE_UPDATE, 'title');
          }
          Tugboat.gtd_task_detail._prev_entry_key_code = 0;
          break;
        //[j]
        case Event.KEY_J:
          if (Tugboat.gtd_task_detail.comment._scroll_top_position.length > 0) {
            var comment = Tugboat.gtd_task_detail.comment;
            var length = comment._scroll_top_position.length;
            var present_position = comment._scroll_present_index;
            var position = 0;
            var scroll_top = $('comment_list').scrollTop;

            if (scroll_top != comment._scroll_top_position[present_position].position) {
              for (i = 0; i < length; i++) {
                if (scroll_top < comment._scroll_top_position[i].position) break;
              }
              if (i > 0 ) position = i;
            } else {
              position =
                present_position == length - 1
                ? present_position
                : present_position + 1;
            }
            if (comment._scroll_top_position[position]) {
              comment._scroll_present_index = position;
              $('comment_list').scrollTop = 0;
              $('comment_list').scrollTop = comment._scroll_top_position[position].position;
            }
            Tugboat.gtd_task_detail._prev_entry_key_code = 0;
          }
          break;
        //[k]
        case Event.KEY_K:
          if (Tugboat.gtd_task_detail.comment._scroll_top_position.length > 0) {
            var comment = Tugboat.gtd_task_detail.comment;
            var length = comment._scroll_top_position.length;
            var present_position = comment._scroll_present_index;
            var position = 0;
            var scroll_top = $('comment_list').scrollTop;
        
            if (scroll_top != comment._scroll_top_position[present_position].position) {
              for (i = 0; i < length; i++) {
                if (scroll_top < comment._scroll_top_position[i].position) break;
              }
              if (i > 0 ) position = i - 1;
            } else {
              position =
                present_position == 0 ? 0 : present_position - 1;
            }
            comment._scroll_present_index = position;
            $('comment_list').scrollTop = 0;
            $('comment_list').scrollTop = 
              comment._scroll_top_position[position].position;
            Tugboat.gtd_task_detail._prev_entry_key_code = 0;
          }
          break;
        //[etc...]
        default:
          Tugboat.gtd_task_detail._prev_entry_key_code = 0;
      }
    }
  }
);