/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.meeting) == 'undefined') {
  Tugboat.meeting = {};
}
Tugboat.meeting = {
  _prev_entry_key_code : 0,

  /*
   * library
   */
  library : {
    /**
     * setup event rules.
     */
    _setup_event_rules : function() {
      var rules = {
        '#menuBar_AddLiveMeeting' : function(el) {
          el.onclick = function() {
            Tugboat.meeting.sub_window.meeting.open();
          };
          return false;
        },
        
        '#menuBar_KeyboardHelp' : function(el){
          el.onclick = function(){
            Tugboat.meeting.sub_window.shortcut_keys_onclick();
            el.blur();
            return false;
          }
        },
        '#shortcut_keys_close' : function(el) {
          el.onclick = function() {
            Windows.closeAll();
            el.blur();
            return false;
          }
        },
        
        /*
         * folder.events.
         */
        '#folder_all' : function(el) {
          el.onclick = function() {
            Tugboat.meeting.library.folder.click('folder_all');
            el.blur();
          }
          return false;
        },
        '#folder_archives' : function(el) {
          el.onclick = function() {
            Tugboat.meeting.library.folder.click('folder_archives');
            el.blur();
          }
          return false;
        },
        
        /*
         * browser.
         */
        '#browser_window_switch' : function(el) {
          el.onclick = function() {
            Tugboat.gtd_common.toggleBrowserArea();
            
            var display = $('browser_pane').style.display;
            if (display == Tugboat.constant.STYLE_DISPLAY_NONE) {
              Tugboat.meeting.library.browser.reset();
              Tugboat.meeting.library.browser._status = [];
              if (Tugboat.meeting.library.folder._selected_folder_id == 'folder_all') {
                Tugboat.meeting.library.browser._status.push(
                  {'id':1,'checked':true});
                Tugboat.meeting.library.browser._status.push(
                  {'id':2,'checked':true});
              } else {
                Tugboat.meeting.library.browser._status.push(
                  {'id':3,'checked':true});
              }
              Tugboat.meeting.library.browser._get_meetings_by_query_params(0,1);
            }
            el.blur();
          }
          return false;
        },
        '#layout_block' : function(el) {
          el.onclick = function() {
            Tugboat.gtd_common.blockSelect(el);
            Tugboat.gtd_common.resize_list_area(false,false);
            el.blur();
          }
          return false;
        },
        '#layout_list' : function(el) {
          el.onclick = function() {
            Element.hide('block_balloon');
            Tugboat.gtd_common.listSelect(el);
            Tugboat.gtd_common.resize_list_area(false,false);
            el.blur();
          }
          return false;
        },
        '#page_prev' : function(el) {
          el.onclick = function() {
            Tugboat.meeting.library.browser.page_navi_onclick(el.id);
            el.blur();
          }
          return false;
        },
        '#page_next' : function(el) {
          el.onclick = function() {
            Tugboat.meeting.library.browser.page_navi_onclick(el.id);
            el.blur();
          }
          return false;
        },
        
        /*
         * meeting entry form.
         */
        '#meeting_entry_form_cancel' : function(el) {
          el.onclick = function() {
            Windows.closeAll();
            el.blur();
          }
          return false;
        },
        '#meeting_entry_form_add' : function(el) {
          el.onclick = function() {
            Tugboat.meeting.sub_window.meeting._add();
            el.blur();
          }
          return false;
        },
        /*
         * balloon.
         */
        '#block_balloon_item_close_anchor' : function(el) {
          el.onclick = function() {
            Element.hide('block_balloon');
            el.blur();
          }
          return false;
        }
      };
      Behaviour.register(rules);
      
      YAHOO.util.Event.addListener(
        'add_meeting_title', "keydown",
        function(key){
          if (key.keyCode == Event.KEY_RETURN) {
            Tugboat.meeting.sub_window.meeting._add();
          }
        }
      );
      YAHOO.util.Event.addListener(
        document, "keydown",
        function(key){
          if (key.keyCode == Event.KEY_ESC) {
            if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;
            Windows.closeAll();
          }
        }
      );
      YAHOO.util.Event.addListener(
        document, "keydown",
        function(key){
          if (key.keyCode == Event.KEY_ESC) {
            if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;
            Windows.closeAll();
          }
          var isIE6 = navigator.userAgent.indexOf('MSIE 6.0') > -1;
          if (isIE6) {
          } else {
            if (Tugboat.meeting.modal._is_opened) {
              return false;
            }
            //[a]
            if (key.keyCode == Event.KEY_A) {
              Tugboat.meeting._prev_entry_key_code = key.keyCode;
            }
            //[m]
            else if (key.keyCode == Event.KEY_M) {
              if (Tugboat.meeting._prev_entry_key_code == Event.KEY_A) {
                Tugboat.meeting.sub_window.meeting.open();
              }
              Tugboat.meeting._prev_entry_key_code = 0;
            } else {
              Tugboat.meeting._prev_entry_key_code = 0;
            }
          }
        }
      );
    },
    
    /**
     * initialize.
     * 
     */
    init: function() {
      Tugboat.gtd_common.set_application_window_size();
      Tugboat.gtd_common.resize_list_area(false,false);

      var self = Tugboat.meeting.library;
      Tugboat.dashboard.initialize();
      self._setup_event_rules();
          
      // get browse activities - ajax.request
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters: {'component':'meetingAjax', 'action':'getActivitiesJson'},
          onComplete: function(transport) {
            self.browser._activities_for_browse = eval(transport.responseText);

            var list = [];
            self.browser._activities_for_browse.each(
              function(a) {
                list.push(
                  {id:a.id, value:a.value, icon:'images/default/palette/pl_bg_' + a.color + '.gif'} );
              }
            );
            //Tugboat.meeting.sub_window.meeting.activityList = list;
            Tugboat.meeting.sub_window.meeting.activitySelectList = 
              new TugboatUI.SelectMenu(
                'add_meeting_activity_container', 
                list,
                { parentElement:'meetingSubWindow',
                  isParentWindow:true,
                  onSelected:function(selectValue){$('add_meeting_title').focus();} }
              );

            // get browse register - ajax.request
            new Ajax.Request(
              Tugboat.AJAX_SERVLET_NAME,
              { 
                method: Tugboat.constant.REQUEST_POST,
                parameters: {'component':'meetingAjax', 'action':'getRegisterJson'},
                onComplete: function(transport)
                {
                  self.browser._registers_for_browse = eval(transport.responseText);                     
                  self.folder.click('folder_all');
                }
              }
            );
          } 
        }
      );
    },

    /*
     * folder
     * 
     * 
     */
    folder : {
      FOLDER_ID_LIST:['folder_all', 'folder_archives'],
      _selected_folder_id : 'folder_all',
      
      /**
       * click
       * @param {Object} id
       * @param {Object} anchorObject
       */
      click : function(id) {
        var self = Tugboat.meeting.library;
        if ($(id).className.indexOf('selected') > -1) return false; 

        // select folder.
        self.folder._selected_folder_id = id;
        self.folder.FOLDER_ID_LIST.each(
          function(folderId){
            if(folderId==id){
              $(folderId).className = (folderId=='folder_all' ? 'opened selected' : 'closed selected');
            } else {
              $(folderId).className = (folderId=='folder_all' ? 'opened' : 'closed');
            }
          }
        );
        
        if (!self.browser._is_created_condition_area){
          self.browser.create(
            self.browser.STATUS_LIST_JSON, 
            'meeting_browser_status_list', 'browser_status_list-', 'browser_status_list_img-', null);
          self.browser.create(
            self.browser._activities_for_browse, 
            'meeting_browser_activity_list', 'browser_act_list-', 'browser_act_list_img-', 'activities');
          self.browser.create(
            self.browser._registers_for_browse, 
            'meeting_browser_register_list', 'browser_reg_list-', 'browser_reg_list_img-', 'register');
                                 
          self.browser._is_created_condition_area = true;
          self.browser.reset();
        }
        
        self.browser.STATUS_LIST_JSON.each(
          function(status){
            var checkStatus = self.browser._status[status.id];                         
            if( self.folder._selected_folder_id == 'folder_all' && (status.id == 1 || status.id == 2) ){
              if(!checkStatus || !checkStatus.checked){
                self.browser._set_browse_section(
                  status.id, 'browser_status_list_img-', 'browser_status_list-', self.browser._status);
                Element.show('browser_status_list-' + status.id);
                return true;
              }
            }
            if( self.folder._selected_folder_id=='folder_archives' && status.id == 3 ){
              if(!checkStatus || !checkStatus.checked){
                self.browser._set_browse_section(
                  status.id, 'browser_status_list_img-', 'browser_status_list-', self.browser._status);
                Element.show('browser_status_list-'+status.id);
                return true;
              }
            }
            Element.hide('browser_status_list-'+status.id);         
            if( checkStatus && checkStatus.checked){
              self.browser._set_browse_section(
                status.id, 'browser_status_list_img-', 'browser_status_list-', self.browser._status);
            }
          }
        );
        self.browser._get_meetings_by_query_params(0,1);
      }
    },
    
    /*
     * browser.
     * 
     */
    browser : {
      _is_created_condition_area : false,
      STATUS_LIST_JSON:[
        {id:'1', value:'New',   icon: 'images/default/folder/gif/status_todo.gif'},
        {id:'2', value:'Open',  icon: 'images/default/folder/gif/marker.gif'},
        {id:'3', value:'Close', icon: 'images/default/folder/gif/status_done.gif'}
      ],
      _activities_for_browse: [],
      _registers_for_browse : [],
      _status         : [],
      _activity       : [],
      _register       : [],
      _page_info      : null,

      /**
       * create search item.
       * 
       * @param {Object} items
       * @param {Object} ul_id
       * @param {Object} li_id
       * @param {Object} img_id
       * @param {Object} target
       */
      create : function(
        items, ul_id, li_id, img_id, target) {
        if (!items) return;

        var ulSearchList = $(ul_id);
        ulSearchList.innerHTML = '';

        appendChildNodes(ul_id,
          function(){
            var attrLiAll = {'id':li_id+'0', 'class':'list_select'};
            if(ul_id=='meeting_browser_status_list') attrLiAll.style='display:none;';

            var attrAnchorAll = {
              'href'   : 'javascript:void(0);',
              'class'  : 'button',
              'onclick': function() {
                if(target == 'activities') {
                  Tugboat.meeting.library.browser._activities_select(0);
                } else if (target == 'register') {
                  Tugboat.meeting.library.browser._register_select(0);
                }
                this.blur();
                return false;
              }
            };

            var liItem =
            LI(attrLiAll,
              A(attrAnchorAll,
                IMG(
                  {'id':img_id + '0', 
                   'src':'images/default/checkbox/task_complete.gif'}),
              ' ALL'
              )
            );            
            return liItem; 
          },
          function(){
            var list = [];
            items.each(
              function(item){
                var attrAnchor = {
                  'href'    : 'javascript:void(0);',
                  'class'   : 'button',
                  'onclick' : function() {
                    if(target == 'activities') {
                      Tugboat.meeting.library.browser._activities_select(item.id);
                    } else if (target == 'register') {
                      Tugboat.meeting.library.browser._register_select(item.id);
                    }
                    this.blur();
                    return false;
                  }
                };

                list.push(
                  LI({'id': li_id + item.id, 'class':'list_not_select'},
                    A(attrAnchor, 
                      IMG({'id' : img_id + item.id,
                           'src': 'images/default/checkbox/task_notcomplete.gif'}),
                      function(){
                        var attr = {'border':'0', 'class':'left_and_right_3px_margin'};
                        if      (ul_id == 'meeting_browser_activity_list') attr.src='images/default/palette/pl_bg_'+item.color+'.gif';
                        else if (ul_id == 'meeting_browser_status_list')   attr.src=item.icon;
                        else                                                return null;
                        
                        return IMG(attr);
                      },
                      function(){
                        if(ul_id == 'meeting_browser_register_list') return ' ' + item.value;
                        return item.value;
                      }
                    )
                  )                
                );
              }
            );
            return list;
          }          
        );
      },

      /**
       * reset browser.
       */
      reset : function() {
        var self = Tugboat.meeting.library.browser;
        self._status   = [];
        self._activity = [];
        self._register = [];
        
        self._status[0]   = {'id':0,'checked':true};
        self._activity[0] = {'id':0,'checked':true};
        self._register[0] = {'id':0,'checked':true};        
      },
      
      /**
       * browser activities select.
       * 
       * @param {Object} activityId
       */
      _activities_select : function(activityId) {   
        var self = Tugboat.meeting.library;
        self.browser._set_browse_section(
          activityId, 'browser_act_list_img-', 'browser_act_list-', self.browser._activity);
        self.browser._get_meetings_by_query_params(0,1);
      },
      
      /**
       * browser register select.
       * 
       * @param {Object} registerId
       */
      _register_select : function(registerId) {        
        var self = Tugboat.meeting.library;
        self.browser._set_browse_section(
          registerId, 'browser_reg_list_img-', 'browser_reg_list-', self.browser._register);
        self.browser._get_meetings_by_query_params(0,1);
      },
      
      /**
       * set browser section.
       * 
       * @param {Object} id
       * @param {Object} imgId
       * @param {Object} liId
       * @param {Object} property
       */
      _set_browse_section : function(id, imgId, liId, property) {        
        var imgIdValue  = imgId;
        var li_id   = liId;
        var checkStatus = property;
        
        if (id == 0){
          if (checkStatus[id].checked==true) return;
        }
          
        if (checkStatus[id]) {
          checkStatus[id].checked=(!checkStatus[id].checked);
        } else {
          checkStatus[id] = {'id':id,'checked':true};
        }
        var isChecked = checkStatus[id].checked;
        var imageElement = $(imgIdValue + id);
        imageElement.setAttribute(
          'src',
          'images/default/checkbox/' + (isChecked ? 'task_complete.gif' : 'task_notcomplete.gif') );
        
        var listElement = $(li_id + id);
        listElement.className =(isChecked ? 'list_select' : 'list_not_select');

        if(id == 0){
          for( key in checkStatus ){
            var act = checkStatus[key];
            
            if (act == undefined) continue;
            if (act.id == undefined) continue;
            if (act.checked == undefined) continue;
            if(act.id == 0) continue;
            
            act.checked = false;
            $(imgIdValue + act.id).setAttribute('src','images/default/checkbox/task_notcomplete.gif');
            $(li_id + act.id).className ='list_not_select';
          }
          return false;
        } 
        
        if (isChecked){
          // all is not checked
          checkStatus[0].checked = false;
          $(imgIdValue + '0').setAttribute('src','images/default/checkbox/task_notcomplete.gif');
          $(li_id + '0').className ='list_not_select';

        } else{
          var isCheckedItem = false;
          
          for(key in checkStatus){
            var act = checkStatus[key];
            if (act == undefined) continue;
            if(act.checked == true){
              isCheckedItem = true;
              break;
            } 
          }
          if(!isCheckedItem ){
            checkStatus[0].checked = true;
            $(imgIdValue + '0').setAttribute('src','images/default/checkbox/task_complete.gif');
            $(li_id + '0').className ='list_select';
          }        
        }
      },

      /**
       * get meeting list by query params.
       * 
       * @param {Number} offset
       * @param {Number} currentPageNumber
       */
      _get_meetings_by_query_params : function(offset, currentPageNumber) {        
        var csv = {
          create : function(list) {
            var queryParam = '';
            for(var i = 0; i < list.length; i++){
              if (list[i] && list[i].checked) {
                queryParam += list[i].id;
                queryParam += ',';
              }
            }
            if (queryParam.length > 0) {
              queryParam= queryParam.substring(0,queryParam.length - 1);
            }
            return queryParam;
          }
        };
        
        var self = Tugboat.meeting.library.browser;
        var statusQueryParam   = csv.create(self._status);
        var activityQueryParam = csv.create(self._activity);
        var registerQueryParam = csv.create(self._register);
        
        Tugboat.meeting.progress.open();
        new Ajax.Request(
          Tugboat.AJAX_SERVLET_NAME,
          {
            method: Tugboat.constant.REQUEST_POST,
            parameters: {
              'component'          : 'meetingAjax', 
              'action'             : 'getMeetingListByQueryParams',
              'queryStatusId'      : statusQueryParam,
              'queryActivityId'    : activityQueryParam,
              'queryRegisterId'    : registerQueryParam,
              'currentPageNumber'  : currentPageNumber,
              'offset'             : offset,
              'limit'              : Tugboat.constant.ROWS_PER_PAGE
            },
            onComplete: function(transport){
              var meetings = eval(transport.responseText);
              self._page_info = meetings.page;
              Tugboat.gtd_common.create_list_dom(
                transport, Tugboat.gtd_common.FUNC_TYPE_MEETING);
                
              Tugboat.meeting.progress.close();
            },
            onFailure : function(transport) {
              Tugboat.meeting.progress.close();
            }
          }
        );
      },
      
      /**
       * page navigation on click.
       * 
       * @param {Object} id
       */
      page_navi_onclick : function(id) {
        var element = $(id);
        if (element.className.indexOf('off') > -1) return false;

        var self = Tugboat.meeting.library.browser;
        var num = id.indexOf('next') == -1 ? -1 : 1;
        var offset = Tugboat.constant.ROWS_PER_PAGE * (self._page_info.currentPageNumber + num - 1);
    
        self._get_meetings_by_query_params(offset, self._page_info.currentPageNumber + num);
      }
    }       
  },
  
  /*
   * model
   * 
   * 
   */
  modal : {
    _is_opened : false,
    
    open : function () {
      var page = Tugboat.getPageSize(); 
      Element.setHeight('modal_window', page.pageHeight);
      $('modal_window').style.display = 'block';
      
      Tugboat.meeting.modal._is_opened = true;
    },
    close : function() {
      Element.hide('modal_window');
      Tugboat.meeting.modal._is_opened = false;
    }
  },
  
  /*
   * Progress
   *
   * 
   */
  progress : {
    open : function () {
      var page = Tugboat.getPageSize(); 
      Element.setHeight('progress_window', page.pageHeight);
      $('progress_window').style.display = Tugboat.constant.STYLE_DISPLAY_BLOCK;
    },
    close : function() {
      Element.hide('progress_window');
    }
  },

  /*
   * sub window.
   * 
   * 
   */
  sub_window : {
    shortcut_keys_window : null,
    shortcut_keys_onclick : function() {
      Tugboat.meeting.modal.open();
      var self = Tugboat.meeting.sub_window;
      
      self.shortcut_keys_window = 
        new Window(
          'addTaskWindow',
          { className: 'mac_os_x', width:320, height:80, 
            zIndex: 100, 
            minimizable: false, 
            closable   : false, 
            maximizable: false,
            resizable  : false, 
            draggable  : true,
            title      : 'Shortcut keys?',
            showEffectOptions:{
              duration:0.5
            }
          }
        );
      self.shortcut_keys_window.setContent('shortcut_keys_sub_window_container',false,false);
      self.shortcut_keys_window.setDestroyOnClose();
      self.shortcut_keys_window.showCenter();
      
      var taskWindowObserver = {
        onDestroy: function(eventName, win) {
          if (win == self.shortcut_keys_window) {
            Element.hide('shortcut_keys_sub_window_container');
            $('shortcut_keys_sub_window_container').appendChild($('shortcut_keys_sub_window'));
                     
            Windows.removeObserver(this);
            Tugboat.meeting.modal.close();
          }
        }
      };
      Windows.addObserver(taskWindowObserver);
    },

    meeting: {
      sub_window : null,
      activitySelectList: null,
      //activityList:[],
      
      /**
       * clear task values.
       */
      clear : function () {
        var self = Tugboat.meeting.sub_window.meeting;
        $('add_meeting_title').value       = '';
        $('add_meeting_title').focus();
        $('add_meeting_description').value = '';
      },
      
      /**
       * open task sub window.
       *
       */
      open : function () {
        Tugboat.meeting.modal.open();
        var self = Tugboat.meeting.sub_window.meeting;
        self.sub_window = new Window
        ( 'meetingSubWindow', 
          { 
            className: 'mac_os_x', width:560, height:290, 
            zIndex: 100, 
            minimizable:false, 
            closable: false, 
            maximizable:false,
            resizable: false, 
            draggable:true,
            title: 'Add Meeting',
            showEffectOptions: 
            { duration:0.5, 
              afterFinish:function(){ $('add_meeting_title').focus();}
            }
          }
        );
        self.sub_window.setContent('meeting_sub_window',false,false);
        self.sub_window.setDestroyOnClose();
        self.sub_window.showCenter();
  	
        var windowObserver = { 
          onDestroy: function(eventName, win) {
            if (win == self.sub_window) {
              $('meeting_sub_window_container').appendChild($('meeting_sub_window'));
              self.sub_window = null;
              Windows.removeObserver(this);
  
              Tugboat.meeting.modal.close();
            }          
          } 
        };
        Windows.addObserver(windowObserver);
      },
      
      /**
       * add meeting.
       *
       */
      _add : function() {
        var self = Tugboat.meeting.sub_window.meeting;
        var selectActivityValue = self.activitySelectList.getSelectValue();
        var activityId  = selectActivityValue ? selectActivityValue.id : null;
        var title       = document.getElementById('add_meeting_title').value;
        var descriptionTextile = document.getElementById('add_meeting_description').value;
       
        var messages = new Array();
        if ( activityId == null ) {
          messages.push('\'Activity\' is required.');
        }
        if ( Tugboat.isEmpty(title) ) {
          messages.push('\'Title\' is required.');
        }
        if ( messages.length > 0 ) {
          Tugboat.showAlertDialog( messages );
          return false;
        }
        
        new Ajax.Request(
          Tugboat.AJAX_SERVLET_NAME,
          { method: Tugboat.constant.REQUEST_POST,
            parameters: {
              'component'          : 'meetingAjax', 
              'action'             : 'add',
              'activityId'         : activityId,
              'title'              : title,
              'descriptionTextile' : descriptionTextile
            },
            onComplete: function(transport) {
              var browser = Tugboat.meeting.library.browser;
              var offset = 
                browser._page_info.results / Tugboat.constant.ROWS_PER_PAGE == 0
                ? 0
                : Tugboat.constant.ROWS_PER_PAGE * browser._page_info.currentPageNumber - Tugboat.constant.ROWS_PER_PAGE;
              
              self.clear();
              browser._get_meetings_by_query_params(offset, browser._page_info.currentPageNumber);
            },
            onFailure: function() {
            }
          }
        );
      }
    }
  }
};