/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.gtd_meeting_detail) == 'undefined') {
  Tugboat.gtd_meeting_detail = {};
}
Tugboat.gtd_meeting_detail = {
  _is_already_editing  : null,
  _login_user_info     : null,
  _agenda_summaries    : null,
  _prev_entry_key_code : 0,

  /**
   * setup event rules.
   */
  _setup_event_rules : function() {
    var rules = {
      /*
       * meeting basic edit/view form.
       */
      '#detail_edit_form' : function(el) {
        el.onsubmit = function() {
          return false;
        };
      },
      '#meeting_basic_status' : function(el) {
        var self = Tugboat.gtd_meeting_detail.basic; 
        el.onclick = function() {
          self.open();
          return false;
        };
        el.onmouseover = function() {
          self._hover_edit_form(el);
          return false;
        };
        el.onmouseout = function() {
          self._mouseout_edit_form(el);
          return false;
        };
      },   
      '#meeting_basic_activity' : function(el) {
        var self = Tugboat.gtd_meeting_detail.basic; 
        el.onclick = function() {
          self.open();
          return false;
        };
        el.onmouseover = function() {
          self._hover_edit_form(el);
          return false;
        };
        el.onmouseout = function() {
          self._mouseout_edit_form(el);
          return false;
        };
      },
      
      '#detail_toggle_link1' : function(el) {
        el.onclick = function() {
          $('simple_view').style.display = 'none';
          $('meeting_basic_section').style.display = 'block';
          Tugboat.gtd_meeting_detail.resize();
        }
      },
      '#detail_toggle_link2' : function(el) {
        el.onclick = function() {
          $('simple_view').style.display = 'block';
          $('meeting_basic_section').style.display = 'none';
          Tugboat.gtd_meeting_detail.resize();
        }
      },
      
      '#meeting_basic_title' : function(el) {
        var self = Tugboat.gtd_meeting_detail.basic; 
        el.onclick = function() {
          self.open();
          return false;
        };
        el.onmouseover = function() {
          self._hover_edit_form(el);
          return false;
        };
        el.onmouseout = function() {
          self._mouseout_edit_form(el);
          return false;
        };
      },
      
      '#simple_title' : function(el) {
        var self = Tugboat.gtd_meeting_detail.basic; 
        el.onclick = function() {
          self.open();
          return false;
        };
        el.onmouseover = function() {
          self._hover_edit_form(el);
          return false;
        };
        el.onmouseout = function() {
          self._mouseout_edit_form(el);
          return false;
        };
      },
      
      '#meeting_basic_description' : function(el) {
        var self = Tugboat.gtd_meeting_detail.basic; 
        el.onclick = function() {
          self.open();
          return false;
        };
        el.onmouseover = function() {
          self._hover_edit_form(el);
          return false;
        };
        el.onmouseout = function() {
          self._mouseout_edit_form(el);
          return false;
        };
      },
      '#meeting_basic_edit_cancel' : function(el) {
        el.onclick = function() {          
          Tugboat.gtd_meeting_detail.basic.cancel();
          return false;
        }
      },      
      '#meeting_basic_edit_post' : function(el) {
        el.onclick = function() {          
          Tugboat.gtd_meeting_detail.basic.update();
          return false;
        }
      },
      
      '#agenda_arrow' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.discussion._close_discussion();
          el.blur();
        }
      },
      
      '#agenda_discuss_close_link' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.discussion._close_discussion();
          el.blur();
        }
      },
      
      /*
       * agenda entry form.
       */
      '#agenda_entry_form_open' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.agenda.add_onclick(el);
          return false;
        }
      },   
      '#agenda_entry_form_cancel' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.agenda.cancel_onclick();
          el.blur();
          return false;
        }
      },      
      '#agenda_entry_form_post' : function(el) {
        el.onclick = function() {
          var self = Tugboat.gtd_meeting_detail;
          if(self._is_already_editing.mode == 'add') {
            self.agenda._add();
          } else {
            self.agenda._update();
          }
          el.blur();
          $('agenda_entry_form_text').focus();
          return false;
        }
      },

      /*
       * sidebar.
       */
      '#sidebar_members_toggle' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.sidebar.toggle_element(el, 'sidebar_members_body');
          el.blur();
          return false;
        }
      },      
      '#sidebar_tasks_toggle' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.sidebar.toggle_element(el, 'sidebar_task_list');
          el.blur();
          return false;
        }
      },
      '#menu_sendmail_button' : function(el) {
        el.onclick = function() {
          if (! confirm('May I send this meeting?')) {
            return false;
          }
          var self = Tugboat.gtd_meeting_detail;
          new Ajax.Request(
            Tugboat.AJAX_SERVLET_NAME,
            {
              method: Tugboat.constant.REQUEST_GET,
              parameters:
              {
                component:'meetingDetailAjax',
                action   :'sendMail',
                basicId  : self.basic.jsonMeetingBasic.id
              },
              onComplete: function(transport){}
            }
          );
          return false;
        }
      },
      '#menu_add_agenda_button' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.agenda.add_onclick();
          return false;
        }
      },
      
      '#menuBar_KeyboardHelp' : function(el){
        el.onclick = function(){
          Tugboat.gtd_meeting_detail.shortcut_keys_onclick();
          el.blur();
          return false;
        }
      },
      '#shortcut_keys_close' : function(el) {
        el.onclick = function() {
          Windows.closeAll();
          el.blur();
          return false;
        }
      },
      
      '#add_comment_cancel_button' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.discussion.comment.cancel_onclick();
          el.blur();
          return false;
        }
      },      
      '#add_comment_add_button' : function(el) {
        el.onclick = function() {
          var self = Tugboat.gtd_meeting_detail;
          if(self._is_already_editing.mode == 'add') {
            self.discussion.comment._add();
          } else {
            self.discussion.comment._update();
          }
          el.blur();
          return false;
        }
      },
      '#add_task_cancel_button' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.discussion.todo.cancel_onclick();
          el.blur();
          return false;
        }
      },      
      '#add_task_add_button' : function(el) {
        el.onclick = function() {
          var self = Tugboat.gtd_meeting_detail;
          if(self._is_already_editing.mode == 'add') {
            self.discussion.todo._add();
          } else {
            self.discussion.todo._update();
          }
          el.blur();
          return false;
        }
      },
      '#clear_calendar_button' : function(el) {
        el.onclick = function() {
          $('edit_due').value = '';
          $('edit_due_display').innerHTML = '';
          el.blur();
          return false;
        }
      },
      '#add_task_cancel_button' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_meeting_detail.discussion.todo.cancel_onclick();
          return false;
        }
      },
      '#sidabar_cap_members' : function(el) {
        el.onclick = function() {
          var parent_node = $('sidabar_cap_members').parentNode;
          var class_name = parent_node.className;
          parent_node.className = 
            class_name.indexOf('collapse') == -1 
            ? 'sidebar_content clearfix collapse' : 'sidebar_content clearfix';
          return false;
        }
      },
      '#sidabar_cap_tasks': function(el) {
        el.onclick = function(el){
          var parent_node = $('sidabar_cap_tasks').parentNode;
          var class_name = parent_node.className;
          parent_node.className = 
            class_name.indexOf('collapse') == -1 
            ? 'sidebar_content clearfix collapse' : 'sidebar_content clearfix';
          return false;
        }
      }
    };
    Behaviour.register(rules);
  },
  
  /**
   * initialize.
   * 
   */
  init: function() {
    Tugboat.dashboard.initialize();
    
    $('menu_reload_button').setAttribute('href',document.URL);
    
    var basicId = document.getElementById('meeting_basic_basicId').innerHTML;
    $('meeting_basic_permalink').innerHTML = 
      document.URL.replace(/view\/.*/,'browse/meetings/' + basicId);

    $('agenda_download_link').setAttribute('href', document.URL + '&action=agenda-download');

    var self = Tugboat.gtd_meeting_detail;
    self._setup_event_rules();
    
    new Ajax.Request
    ( 
      Tugboat.AJAX_SERVLET_NAME,
      { 
        asynchronous: true,
        method: Tugboat.constant.REQUEST_GET,
        parameters: {
          'component': 'meetingDetailAjax',
          'action'   : 'getAgendaListOnLoad',
          'basicId'  : basicId
        },
        onComplete: function(transport) {
          var js_object = eval( '('+transport.responseText+')' );
          self.basic.jsonMeetingBasic = js_object.meetingBasicJson;
          self._login_user_info =  js_object.loginUserJson;       
          self.basic._refresh_form();

          // get browse activities - ajax.request
          new Ajax.Request(
            Tugboat.AJAX_SERVLET_NAME,
            {
              method: Tugboat.constant.REQUEST_GET,
              parameters: {
                'component':'meetingAjax',
                'action'   :'getActivitiesJson'
              },
              onComplete: function(transport) {
                var activities = eval(transport.responseText);
                var list = [];
                activities.each(
                  function(a) {
                    if (
                       (js_object.meetingBasicJson.statusId == '2' 
                     || js_object.meetingBasicJson.statusId == '3')
                     && a.id == js_object.meetingBasicJson.activityId) {
                      list.push(
                        {   id:a.id,
                         value:a.value,
                          icon:'images/default/palette/pl_bg_' + a.color + '.gif'}
                      );
                    } else if (js_object.meetingBasicJson.statusId == '1'){
                      list.push(
                        {   id:a.id,
                         value:a.value,
                          icon:'images/default/palette/pl_bg_' + a.color + '.gif'}
                      );
                    }
                  }
                );
                self.basic.activityList = list;
                self.sidebar._create_members();
                self.agenda.create(js_object.sectionAgendaListJson);
              }
            }
          );

          $('add_task_personInCharge').value = 
            self._login_user_info.lastName + ',' + self._login_user_info.firstName;
          $('selectedUserId').value = self._login_user_info.id;

          self.setSendMailButton(self.basic.jsonMeetingBasic.activityId);
          return false;
        }
      }
    );
    Calendar.setup({
      inputField  : 'edit_due',
      displayArea : 'edit_due_display',
      ifFormat    : '%Y%m%d',
      daFormat    : '%Y-%m-%d',
      button      : 'show_calendar_button'
    });
    return false;
  },
  
  /**
   * resize page.
   * 
   */
  resize : function() {
    var MIN_PAGE_WIDTH = 960;
    var SIDEBAR_WIDTH  = 221;

    var window_size = Tugboat.getPageSize();
    var el_content = $('content_body');
    var el_sidebar = $('sidebar');
    var el_menu_bar_pane = YAHOO.util.Dom.getRegion('menuBar_ul');
    el_sidebar.style.height = 
      el_content.style.height = 
        window_size.windowHeight - el_menu_bar_pane.bottom  + 'px';
    
    var el_main_pane = $('main_pane');
    var el_sidebar = YAHOO.util.Dom.getRegion('sidebar');
    var main_pane_width = window_size.windowWidth - (SIDEBAR_WIDTH);
    
    var is_overflow = window_size.windowWidth < MIN_PAGE_WIDTH;
    var content_width = is_overflow ? MIN_PAGE_WIDTH : window_size.windowWidth;
    $('html').className     = is_overflow ? 'overflow_auto' : 'one_column';
    $('document').className = is_overflow ? 'overflow_auto' : 'one_column';
    
    $('header').style.width       = content_width + 'px';
    $('content_body').style.width = content_width + 'px';
    main_pane_width = content_width - SIDEBAR_WIDTH;
    el_main_pane.style.width = main_pane_width  + 'px';
    
    // inside meeting info pane.
    if ($('meeting_basic_section').style.display != 'none') {
      var el_left_pane = YAHOO.util.Dom.getRegion('left_pane');
      $$('#meeting_basic_section dl.left_pane dd').each(
        function(dd) {
          dd.style.width = 
            el_left_pane.right - el_left_pane.left - 82 + 'px';
        }
      );
    }

    // agendas, agenda + discussions
    var el_agendas = $('agendas');
    var is_agendas_visibled = 
      (el_agendas.style.display == 'block' || el_agendas.style.display == '');
    
      var el_control_bar_pane = YAHOO.util.Dom.getRegion('control_bar');
      el_agendas.style.height = 
        window_size.windowHeight - el_control_bar_pane.bottom + 'px';
    
      $$('div.agenda_header_body').concat(
        $('agenda_header_body')).each(
          function(agenda_header_body) {
            agenda_header_body.style.width = 
              (main_pane_width - SIDEBAR_WIDTH - 2) + 'px';
          }
        );

    if (! is_agendas_visibled) {
      var el_agenda_header = YAHOO.util.Dom.getRegion('agenda_header');
      var el_agenda_footer = YAHOO.util.Dom.getRegion('agenda_footer');
      var agenda_body = $('agenda_body');
      agenda_body.style.height = 
        (window_size.windowHeight - el_agenda_header.bottom 
        - (el_agenda_footer.bottom - el_agenda_footer.top)
        - 5) + 'px';
    }
    
    Tugboat.gtd_meeting_detail.discussion._set_comment_scroll(false);
  },
  
  /**
   * set SendMail button enable/disable.
   * 
   * @param {Object} activityId
   */
  setSendMailButton: function(activityId) {
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_GET,
        parameters: {
          'component':'applicationCommonAjax',
          'action'   :'getSendMailEnabled',
          'activityId':activityId
        },
        onComplete: function(transport) {
          var sendMailEnable = eval(transport.responseText);
          if(sendMailEnable) {
            $('menuBar_SendMail').show();
            $('menuBar_SendMail_Disable').hide();
          } else {
            $('menuBar_SendMail_Disable').show();
            $('menuBar_SendMail').hide();
          }
        }
      }
    );
  },
  
  shortcut_keys_window : null,
  shortcut_keys_onclick : function() {
    Tugboat.gtd_meeting_detail.modal.open();
    var self = Tugboat.gtd_meeting_detail;
      
    self.shortcut_keys_window = 
      new Window(
        'addTaskWindow',
        { className: 'mac_os_x', width:500, height:310, 
          zIndex: 100, 
          minimizable: false, 
          closable   : false, 
          maximizable: false,
          resizable  : false, 
          draggable  : true,
          title      : 'Shortcut keys?',
          showEffectOptions:{
            duration:0.5
          }
        }
      );
    self.shortcut_keys_window.setContent('shortcut_keys_sub_window_container',false,false);
    self.shortcut_keys_window.setDestroyOnClose();
    self.shortcut_keys_window.showCenter();
      
    var taskWindowObserver = {
      onDestroy: function(eventName, win) {
        if (win == self.shortcut_keys_window) {
          Element.hide('shortcut_keys_sub_window_container');
          $('shortcut_keys_sub_window_container').appendChild($('shortcut_keys_sub_window'));
                     
          Windows.removeObserver(this);
          Tugboat.gtd_meeting_detail.modal.close();
        }
      }
    };
    Windows.addObserver(taskWindowObserver);
  },

  /*
   * basic.
   * 
   * 
   * 
   */
  basic: {
    jsonMeetingBasic       : null,
    statusSelectListForNew : null,
    statusSelectList       : null,
    activitySelectList     : null,
    statusListForNew       : [],
    statusList             : [],
    activityList           : [],
    
    MEETING_STATUS_NEW   : 1,
    MEETING_STATUS_OPEN  : 2,
    MEETING_STATUS_CLOSE : 3,
    _meeting_status : [
      {id:1, value:'New',   icon:'images/default/folder/gif/status_todo.gif' },
      {id:2, value:'Open',  icon:'images/default/folder/gif/marker.gif'      },
      {id:3, value:'Close', icon:'images/default/folder/gif/status_done.gif' }
    ],
    _find_meeting_status : function(id) {
      var self = Tugboat.gtd_meeting_detail.basic;
      return self._meeting_status.find(
        function(s){ return (id == s.id); } 
      );
    },
    
    /**
     * hover edit form.
     * @param {Object} el
     */
    _hover_edit_form : function(el) {
      el.style.backgroundColor = '#ffa';
      el.style.cursor          = 'cursor';
    },
    
    /**
     * mouseout edit form.
     * @param {Object} el
     */
    _mouseout_edit_form : function(el) {
      el.style.backgroundColor = '#fff';
      el.style.cursor          = 'default';
    },
      
    /**
     * refresh form.
     */
    _refresh_form : function(){
      var self = Tugboat.gtd_meeting_detail;
      var statusElem   = $('meeting_basic_status');
      var activityElem = $('meeting_basic_activity');
          
      statusElem.innerHTML = '';
      appendChildNodes(statusElem,
        function(){
          var status = self.basic._find_meeting_status(self.basic.jsonMeetingBasic.statusId);
          var imgStatus = IMG({'class':'left_and_right_3px_margin', 'src': status.icon});
          return [imgStatus, status.value];
        }
      );

      activityElem.innerHTML = '';
      appendChildNodes(activityElem,
        function(){
          var activityColor =self.basic.jsonMeetingBasic.activiyColor;
          var imgActivity = IMG(
            {'class':'left_and_right_3px_margin',
             'src': 'images/default/palette/pl_bg_' 
                  + self.basic.jsonMeetingBasic.activityColor 
                  + '.gif'});

          return [imgActivity, self.basic.jsonMeetingBasic.activityName];
        }
      );

      $('simple_title').innerHTML = self.basic.jsonMeetingBasic.title;
      $('meeting_basic_title').innerHTML = self.basic.jsonMeetingBasic.title;

      $('meeting_basic_description').innerHTML =
        self.basic.jsonMeetingBasic.description.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');

      $('meeting_basic_date').innerHTML =
        'Created by '+self.basic.jsonMeetingBasic.lastName
      + ','
      + self.basic.jsonMeetingBasic.firstName 
      + ' at ' 
      + self.basic.jsonMeetingBasic.registered;
    },
    
    /**
     * clear.
     */
    clear :function(){
      var self = Tugboat.gtd_meeting_detail;   
      $('meeting_basic_title_modify').value="";
      $('meeting_basic_description_modify').value="";
     
      if(!self.basic.statusSelectListForNew){
        self.basic._meeting_status.each(
          function(a) {
            self.basic.statusListForNew.push( {id:a.id, value:a.value, icon:a.icon} );
          }
        );
        self.basic.statusSelectListForNew = 
          new TugboatUI.SelectMenu(
            'meeting_basic_status_modify_for_new',
            self.basic.statusListForNew,
            {parentElement:'meetingBasicWindow',isParentWindow:true});
      }
      if(!self.basic.statusSelectList){
        self.basic._meeting_status.each(
          function(a) {
            if(self.basic.MEETING_STATUS_NEW==a.id) return false;
            self.basic.statusList.push( {id:a.id, value:a.value, icon:a.icon} );
          }
        );
        self.basic.statusSelectList = 
          new TugboatUI.SelectMenu(
            'meeting_basic_status_modify',
            self.basic.statusList,
            {parentElement:'meetingBasicWindow',isParentWindow:true});
      }
      if(!self.basic.activitySelectList){
        self.basic.activitySelectList = 
          new TugboatUI.SelectMenu(
            'meeting_basic_activity_modify',
            self.basic.activityList,
            {parentElement:'meetingBasicWindow',isParentWindow:true});
      }
      self.basic.statusSelectListForNew.clear();
      self.basic.statusSelectList.clear();
      self.basic.activitySelectList.clear();      
    },
    
    /**
     * cancel.
     */
    cancel :function(){
      var self = Tugboat.gtd_meeting_detail;
      Windows.closeAll();
    },
    
    /**
     * open.
     */
    open : function(){
      var self = Tugboat.gtd_meeting_detail;
      self.modal.open();
      self.basic.clear();

      self.basic._meeting_basic_window =
        new Window(
          'meetingBasicWindow',
          { className: 'mac_os_x', width:560, height:330,
            zIndex: 200,
            minimizable: false,
            closable   : false,
            maximizable: false,
            resizable  : false,
            draggable  : true,
            title      : "Edit meeting",
            showEffectOptions:{
              duration:0.3,
              afterFinish:function(){
                $('meeting_basic_title_modify').focus();
              }
            }
          }
        );

      self.basic._meeting_basic_window.setContent(
        'meeting_basic_sub_window_container',false,false);
      self.basic._meeting_basic_window.setDestroyOnClose();
      self.basic._meeting_basic_window.showCenter();

      var meetingBasicWindowObserver = {
        onDestroy: function(eventName, win) {
          if (win == self.basic._meeting_basic_window) {
            self.basic._meeting_basic_window = null;

            self.modal.close();
            Windows.removeObserver(this);
          }
        }
      };
      Windows.addObserver(meetingBasicWindowObserver);

      if(self.basic.MEETING_STATUS_NEW==self.basic.jsonMeetingBasic.statusId ){
        Element.show('meeting_basic_status_modify_for_new');
        Element.hide('meeting_basic_status_modify');

        self.basic.statusSelectListForNew.setSelectedId(
          self.basic.jsonMeetingBasic.statusId);

      } else {
        Element.hide('meeting_basic_status_modify_for_new');
        Element.show('meeting_basic_status_modify');

        self.basic.statusSelectList.setSelectedId(self.basic.jsonMeetingBasic.statusId);
      }
      self.basic.activitySelectList.setSelectedId(self.basic.jsonMeetingBasic.activityId);
      $('meeting_basic_title_modify').value= self.basic.jsonMeetingBasic.title;
      $('meeting_basic_description_modify').value=self.basic.jsonMeetingBasic.descriptionTextile;
      return true;
    },

    /**
     * update.
     */
    update: function(){
      var self = Tugboat.gtd_meeting_detail;
      var statusId  = null;
      if(self.basic.MEETING_STATUS_NEW == self.basic.jsonMeetingBasic.statusId ){
        var selectStatusValue = self.basic.statusSelectListForNew.getSelectValue();
        statusId  = selectStatusValue ? selectStatusValue.id : null;
      } else {
        var selectStatusValue = self.basic.statusSelectList.getSelectValue();
        statusId  = selectStatusValue ? selectStatusValue.id : null;
      }
      var selectActivityValue = self.basic.activitySelectList.getSelectValue();
      var activityId  = selectActivityValue ? selectActivityValue.id : null;
     
      var title = document.getElementById('meeting_basic_title_modify').value;
      var descriptionTextile =
        document.getElementById('meeting_basic_description_modify').value;
     
      var messages = new Array();
      if ( statusId == null ) {
        messages.push('\'Status\' is required.');
      }
      if ( activityId == null ) {
        messages.push('\'Activity\' is required.');
      }
      if ( Tugboat.isEmpty(title) ) {
        messages.push('\'Title\' is required.');
      }
      if ( messages.length > 0 ) {
        Tugboat.showAlertDialog( messages );
        return false;
      }
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { method: Tugboat.constant.REQUEST_POST,
          parameters: {
            'component'         : 'meetingDetailAjax',
            'action'            : 'updateMeeting',
            'basicId'           : self.basic.jsonMeetingBasic.id,
            'statusId'          : statusId,
            'activityId'        : activityId,
            'title'             : title,
            'descriptionTextile': descriptionTextile
          },
          onComplete: function(transport)
          {
            var basicJson = eval( '('+transport.responseText+')' );
            self.basic.jsonMeetingBasic = basicJson;
            self.basic._refresh_form();
            Windows.closeAll();
            self.basic.clear();
            self.setSendMailButton(activityId);
            self.sidebar._create_members();

            Tugboat.gtd_meeting_detail.discussion.todo._reload_tasks_in_sidebar();
          },
          onFailure: function() {}
        }
      );
      return true;
    }      
  }, 

  /*
   * agenda.
   * 
   * 
   * 
   */
  agenda : {
    def_value : {
      id              : null,
      pid             : null,
      priority        : 0,
      postedUserId    : null, 
      firstName       : null, 
      lastName        : null,
      body            : null,
      bodyTextile     : null,
      modified        : null,
      discussionList: []
    },
    
    /**
     * create agenda dom.
     * 
     * @param {Object} agendas
     */
    create : function(agendas){
      var self = Tugboat.gtd_meeting_detail;
      var containerBody = $('meeting_container_body');
      $('agendas').remove();
      var ulAgendas;
      containerBody.appendChild( 
        ulAgendas = UL({'id':'agendas'})
      );
      
      self._agenda_summaries = [];
      agendas.each(function(agenda) {
        var id = agenda.pid ? agenda.pid : agenda.id;
        self._agenda_summaries.push(
          {'id'   :agenda.id, 
           'title':agenda.body.replace(/\x0D\x0A|\x0D|\x0A/g,' ').substring(0,30)}
        );
        ulAgendas.appendChild(
          Tugboat.gtd_meeting_detail.agenda._create_agenda_list(id, agenda) );
      });
      Tugboat.gtd_meeting_detail.resize();
      return false;
    },
    
    /**
     * create agenda list.
     * 
     * @param {Object} id
     * @param {Object} agenda
     */
    _create_agenda_list : function(id, agenda) {
      var list =
        LI({'id':'agenda_' + id, 'class':'agenda'},
          DIV({'class': 'agenda_header'},
            [
              DIV({'id':'agenda_arrow_' + id, 
                   'class':'topic_arrow',
                   'onclick':function() {
                      Tugboat.gtd_meeting_detail.discussion._open_discussion(id);
                    }
                   }),
              DIV({'id':'agenda_header_text_'+ id, 'class':'agenda_header_body'},
                A({'href':'javascript:void(0);',
                   'onclick':function() {
                      Tugboat.gtd_meeting_detail.discussion._open_discussion(id);
                    }
                  },agenda.body.replace(/\x0D\x0A|\x0D|\x0A/g,' '))
              ),
              DIV({'class':'topic_info'},
                [
                  DIV({'id'   :'agenda_comments_record_'+id, 
                       'class':'text_records'},agenda.commentCount),
                  DIV({'id'   :'agenda_tasks_record_'+id,
                       'class':'text_records'},agenda.taskCount)
                ]
              ),
              DIV({'id'   :'agenda_action_' + id,
                   'class':'agenda_command'},
                [
                  A({'id'  :'agenda_edit_' + id,
                     'href':'javascript:void(0)',
                     'onclick':function(){
                        Tugboat.gtd_meeting_detail.agenda.open_edit_sub_window(agenda);
                      }
                    },'edit'
                  ),
                  
                  P({'style':'display:none', 
                     'id':'agenda_text_' + id}, agenda.body),
                  
                  function() {
                    var dom  = null;
                    if (agenda.commentCount == 0 && agenda.taskCount == 0) {
                      dom =
                        [
                          '/',
                          A({'id':'agenda_delete_' + id,
                             'href':'javascript:void(0)',
                             'onclick':function(){
                               Tugboat.gtd_meeting_detail.agenda.del_onclick(agenda);
                             }
                            },'delete')
                        ];
                    } else {
                      dom =  ' ';
                    }
                    return dom;
                  }
                ]
              )
            ]
          )
        );
      return list;
    },
   
    /**
     * clear value.
     * 
     */
    clear: function() {
      var self = Tugboat.gtd_meeting_detail;
      $('agenda_entry_form_text').value = '';
      return false;
    },
    
    /**
     * cancel.
     * 
     */
    cancel_onclick : function() {
      var self = Tugboat.gtd_meeting_detail;
      Windows.closeAll();
      return false;
    },
    
    /**
     * add agenda.
     * 
     * @param {Object} elem
     */
    add_onclick : function(elem) {
      var self = Tugboat.gtd_meeting_detail;
      if(self._is_already_editing){
        Tugboat.showAlertDialog(['already edit.']);
        return false;
      }
      self._is_already_editing = {mode:'add'};
      self.agenda._open_sub_window('Add agenda');
      return false;
    },
    
    /**
     * open edit window.
     * 
     * @param {Object} agenda
     */
    open_edit_sub_window : function(agenda) {
      var self = Tugboat.gtd_meeting_detail;
      if(self._is_already_editing){
        Tugboat.showAlertDialog( ['already edit.'] );
        return;
      }
      self._is_already_editing = {
        mode:'edit',
        agenda:agenda,
        agendaId:agenda.id
      }
      var self = Tugboat.gtd_meeting_detail;
      $('agenda_entry_form_text').value = '';
      self.agenda._open_sub_window('Edit agenda');
      return true;
    },
    
    /**
     * add agenda.
     */
    _add: function() {
      var bodyTextile = $('agenda_entry_form_text').value;
      var messages = [];
      if ( Tugboat.isEmpty(bodyTextile) ) {
        messages.push('\'agenda\' is required.');
      }
      if ( messages.length > 0 ) {
        Tugboat.showAlertDialog( messages );
        return false;
      }

      var ul_agendas =  $('agendas');
      if( $('agenda_empty') != null ) ul_agendas.innerHTML = '';
      
      var self = Tugboat.gtd_meeting_detail;
      self.agenda.clear();

      var agenda_obj = {
        agenda : function() {
          var _agenda = self.agenda.def_value;
          _agenda.body = bodyTextile;
          _agenda.bodyTextile = bodyTextile;
          _agenda.postedUserId = self._login_user_info.id;
          _agenda.firstName = self._login_user_info.firstName;
          _agenda.lastName = self._login_user_info.lastName;
          return _agenda;
        },
        execute : function(obj) {
          ul_agendas.appendChild(
            Tugboat.gtd_meeting_detail.agenda._create_agenda_list(obj.id, obj) );
         
          if (Tugboat.gtd_meeting_detail._agenda_summaries == null
           || Tugboat.gtd_meeting_detail._agenda_summaries.length == 0) {
            
            new Ajax.Request(
              Tugboat.AJAX_SERVLET_NAME,
              { method: Tugboat.constant.REQUEST_POST,
                parameters: {
                  'component' : 'meetingDetailAjax',
                  'action'    : 'updateStatus',
                  'basicId'   : self.basic.jsonMeetingBasic.id,
                  'statusId'  : '2'
                },
                onComplete: function(transport)
                {
                  var meeting = eval( '('+transport.responseText+')' );
                  self.basic.jsonMeetingBasic = meeting;
                  
                  self.basic._refresh_form();
                  var activity_select_items = [];
                  for (var i = 0; i < self.basic.activityList.length; i++) {
                    if (meeting.activityId  == self.basic.activityList[i].id) {
                      activity_select_items.push(self.basic.activityList[i]);
                      break;
                    }
                  }
                  self.basic.activityList = activity_select_items
                  self.basic.activitySelectList.setListItems(self.basic.activityList);
                }
              }
            );
          }
          Tugboat.gtd_meeting_detail._agenda_summaries.push(
            {'id':obj.id, 'title':bodyTextile.substring(0,30)}
          );
          self.resize();
        }
      };
      self.agenda._do_ajax_request(
        'meetingDetailAjax', 'addAgenda', agenda_obj);
      return false;
    },
    
    /**
     * edit agenda.
     * 
     * @param {Object} inputValue
     * @param {Object} agenda
     */
    _update:function(){
      var self = Tugboat.gtd_meeting_detail;
      var bodyTextile = $('agenda_entry_form_text').value;
      var messages = new Array();
      if ( Tugboat.isEmpty(bodyTextile) ) {
        messages.push('\'agenda\' is required.');
      }
      if ( messages.length > 0 ) {
        Tugboat.showAlertDialog( messages );
        return false;
      }
      
      var agenda_body = $F('agenda_entry_form_text');
      var agenda_obj = {
        agenda : function() {
          var _agenda = self.agenda.def_value;
          _agenda.id           = self._is_already_editing.agenda.id;
          _agenda.pid          = self._is_already_editing.agenda.pid;
          _agenda.priority     = self._is_already_editing.agenda.priority;
          _agenda.postedUserId = self._is_already_editing.agenda.postedUserId;
          _agenda.firstName    = self._is_already_editing.agenda.firstName;
          _agenda.lastName     = self._is_already_editing.agenda.lastName;
          _agenda.body         = agenda_body;
          _agenda.bodyTextile  = agenda_body;
          _agenda.modified     = self._is_already_editing.agenda.modified;
          return _agenda;
        },
        execute : function(obj) {
          var divAgendaHeader = $("agenda_header_text_" + obj.id);
          divAgendaHeader.innerHTML = '';
          divAgendaHeader.appendChild(
            A({'href':'javascript:void(0);',
               'onclick':function() {
                  Tugboat.gtd_meeting_detail.discussion._open_discussion(obj.id);
                }
              },obj.body.replace(/\x0D\x0A|\x0D|\x0A/g,' ')
            )
          );
          $('agenda_text_' + obj.id).innerHTML = obj.body;

          var divAgendaHeaderText = $('agenda_header_text');
          divAgendaHeaderText.innerHTML = '';
          divAgendaHeaderText.appendChild(
            A(
              {'href':'javascript:void(0)',
               'class':'title',
               'onclick':function(){
                  Tugboat.gtd_meeting_detail.discussion._close_discussion();
                }
              },
              obj.body.replace(/\x0D\x0A|\x0D|\x0A/g,' ')
            )
          );
          $('agenda_text').innerHTML =
            obj.body.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
        
          //
          var agenda = Tugboat.gtd_meeting_detail._agenda_summaries.find(
            function(a) {
              return obj.id == a.id;
            } 
          );
          agenda.title = obj.body.replace(/\x0D\x0A|\x0D|\x0A/g,' ').substring(0,30);
          Windows.closeAll();
        }
      };
      self.agenda._do_ajax_request(
        'meetingDetailAjax', 'updateAgenda', agenda_obj);
    },
    
    /**
     * remove agenda.
     * 
     * @param {Object} agenda
     */
    del_onclick : function(agenda) {
      var self = Tugboat.gtd_meeting_detail;
      if (! confirm('May I delete this agenda?') ) {
        return false;
      }
      
      Tugboat.gtd_meeting_detail.discussion._clear_discussion();
      Tugboat.gtd_meeting_detail.discussion._close_discussion();
      
      var detail = Tugboat.gtd_meeting_detail;
      for (i = 0; i < detail._agenda_summaries.length; i++) {
        if (agenda.id == detail._agenda_summaries[i].id) {
          detail._agenda_summaries.splice(i,1);
          break;
        }
      }

      var agenda_obj = {
        agenda : function() {
          return agenda;
        },
        execute : function(obj) {
          $('agendas').removeChild($('agenda_' + agenda.id));
        }
      };
      self.agenda._do_ajax_request(
        'meetingDetailAjax', 'deleteAgenda', agenda_obj);  
    },
    
    /**
     * do ajax request.
     * 
     * @param {Object} component
     * @param {Object} action
     * @param {Object} postProcessorObj
     */
    _do_ajax_request: function(component, action, postProcessorObj) {
      var self = Tugboat.gtd_meeting_detail;      
      var agenda = postProcessorObj.agenda();

      Tugboat.gtd_meeting_detail.modal.open();
      new Ajax.Request
      ( 
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters: {
            'component'    : component,
            'action'       : action, 
            'basicId'      : self.basic.jsonMeetingBasic.id,
            'activityId'   : self.basic.jsonMeetingBasic.activityId,
            'agendaId'     : agenda.pid,
            'postedUserId' : agenda.postedUserId,
            'bodyTextile'  : agenda.bodyTextile
          },                  
          onComplete : function(transport) {
            var obj = eval( '('+transport.responseText+')' );
            postProcessorObj.execute(obj);
            
            if (action != 'addAgenda') 
              Tugboat.gtd_meeting_detail.modal.close();
          },
          onFailure : function(transport) {
            if (action != 'addAgenda') 
              Tugboat.gtd_meeting_detail.modal.close();
          }
        }
      );
    },
    
    /**
     * open add agenda wub window.
     * 
     * @param {Object} title
     */
    _open_sub_window: function(title) {
      var self = Tugboat.gtd_meeting_detail;
      self.modal.open();
      if(self._is_already_editing.mode == 'edit') {
        $('agenda_entry_form_text').value = 
          $('agenda_text_' + self._is_already_editing.agendaId).innerHTML.replace(/<br>/g,'\n').replace(/<BR>/g,'\n');
      }
      
      self.agenda._add_agenda_window = 
        new Window(
          'addAgendaWindow', 
          { className: 'mac_os_x', width:560, height:300, 
            zIndex: 200, 
            minimizable: false, 
            closable   : false, 
            maximizable: false,
            resizable  : false,//true,
            draggable  : true,
            title      : title,
            showEffectOptions:{
              duration:0.3, 
              afterFinish:function(){
                $('agenda_entry_form_text').focus();
                var div = YAHOO.util.Dom.getRegion('addAgendaWindow_content');
                $('agenda_entry_form_text').style.height= div.bottom - div.top - 65 + 'px';
              }
            }
          }
        );
      
      self.agenda._add_agenda_window.setContent('agenda_sub_window_container',false,false);
      self.agenda._add_agenda_window.setDestroyOnClose();
      self.agenda._add_agenda_window.showCenter();
      self.modal.open();
      
      var agendaWindowObserver = {
        onDestroy: function(eventName, win) {
          if (win == self.agenda._add_agenda_window) {
            Element.hide('agenda_sub_window_container');
            $('agenda_sub_window_container').appendChild($('add_agenda_sub_window'));
            
            self.agenda._add_agenda_window = null;

            Windows.removeObserver(this);
            if(self._is_already_editing.mode == 'edit') {
              self.agenda.clear();
            }
            self._is_already_editing = false;
            Tugboat.gtd_meeting_detail.modal.close();
          }
        }
      };
      Windows.addObserver(agendaWindowObserver);
    }
  },
  
  /*
   * discussion.
   * 
   * 
   * 
   */
  discussion:{
    _open_discuss_id      : 0,
    _scroll_present_index : 0,
    _scroll_top_position  : [],
    TYPE_COMMENT    : {ID:'1', NAME:'comment'   },
    TYPE_CONCLUSION : {ID:'2', NAME:'conclusion'},
    TYPE_MEMO       : {ID:'3', NAME:'memo'      },
    TYPE_ATTACHMENT : {ID:'4', NAME:'attachment'},
    TYPE_TODO       : {ID:'5', NAME:'task'      },
    _type:
    [
      {'id':'1', 'name':'comment',    'text':'Comment',    'src':'images/default/icon/comment.gif'     ,
       'classNameType':'comment'    , 'classNameButton':'comment_button'   },
      {'id':'2', 'name':'conclusion', 'text':'Conclusion', 'src':'images/default/icon/comment_tick.gif',
       'classNameType':'conclusion' , 'classNameButton':'conclusion_button'},
      {'id':'3', 'name':'memo',       'text':'Memo',       'src':'images/default/icon/note.gif'        ,
       'classNameType':'memo'       , 'classNameButton':'memo_button'      },
      {'id':'4', 'name':'attachment', 'text':'Attachment', 'src':'images/default/icon/attach.gif'      ,
       'classNameType':'attachment' , 'classNameButton':'attachment_button'},
      {'id':'5', 'name':'task',       'text':'Task',       'src':'images/default/icon/time.gif'        ,
       'classNameType':'task'       , 'classNameButton':'todo_button'      }
    ],

    /**
     * find type by id.
     * 
     * @param {Object} id
     */
    _find_type_by_id : function(id) {
      return Tugboat.gtd_meeting_detail.discussion._type.find(
        function(t){ return (id == t.id); } );
    },
    
    /**
     * find type by name.
     * 
     * @param {Object} name
     */
    _find_type_by_name : function(name) {
      return Tugboat.gtd_meeting_detail.discussion._type.find(
        function(t){ return (name == t.name); } );
    },
    
    /**
     * open discussion.
     * 
     * @param {Object} id
     * @param {Object} is_update
     */
    _open_discussion : function(id, is_update) {
      $('agendas').style.display = 'none';
      $('discussions').style.display = 'block';

      Tugboat.gtd_meeting_detail.discussion._open_discuss_id = id;
      
      Tugboat.gtd_meeting_detail.resize();
      $('progress_window').show();
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {
          method: Tugboat.constant.REQUEST_GET,
          parameters:
          {
            component:'meetingDetailAjax',
            action   :'getAgendaDiscussion',
            basicId  : Tugboat.gtd_meeting_detail.basic.jsonMeetingBasic.id,
            agendaId : id
          },
          onComplete: function(transport){
            var obj = eval('(' + transport.responseText + ')');
            var agenda = obj.sectionAgendaListJson[0];
            
            if (is_update) {
              $('agenda_comments_record_' + agenda.id).innerHTML = agenda.commentCount;
              $('agenda_tasks_record_'    + agenda.id).innerHTML = agenda.taskCount;

              $('agenda_action_' + agenda.id).innerHTML = '';
              appendChildNodes('agenda_action_' + agenda.id,
                [
                  A({'id'  :'agenda_edit_' + id,
                     'href':'javascript:void(0)',
                     'onclick':function(){
                        Tugboat.gtd_meeting_detail.agenda.open_edit_sub_window(agenda);
                      }
                    },'edit'
                  ),
                  
                  P({'style':'display:none', 
                     'id':'agenda_text_' + id}, agenda.body),
                  
                  function() {
                    var dom  = null;
                    if (agenda.commentCount == 0 && agenda.taskCount == 0) {
                      dom =
                        [
                          '/',
                          A({'id':'agenda_delete_' + id,
                             'href':'javascript:void(0)',
                             'onclick':function(){
                               Tugboat.gtd_meeting_detail.agenda.del_onclick(agenda);
                             }
                            },'delete')
                        ];
                    } else {
                      dom =  ' ';
                    }
                    return dom;
                  }
                ]
              );
            }
            
            $('agenda_header_text').appendChild(
              A(
                {'href':'javascript:void(0)',
                 'class':'title',
                 'onclick':function(){
                    Tugboat.gtd_meeting_detail.discussion._close_discussion();
                  }
                },
                agenda.body.replace(/\x0D\x0A|\x0D|\x0A/g,' ')
              )
            );
            $('agenda_comments_record').innerHTML = agenda.commentCount;
            $('agenda_tasks_record').innerHTML = agenda.taskCount;
            $('agenda_text').innerHTML = 
              agenda.body.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');

            $('agenda_date').innerHTML =
              'Posted by ' + agenda.lastName 
              + ','        + agenda.firstName 
              + ' at '     + agenda.registered;

            $('agenda_action').appendChild(
              A({'id'  :'agenda_edit_' + id,
                 'href':'javascript:void(0)',
                 'onclick':function(){
                    Tugboat.gtd_meeting_detail.agenda.open_edit_sub_window(agenda);
                  }
                },
                'edit'
              )
            );
            if (agenda.commentCount == 0 && agenda.taskCount == 0) {
              $('agenda_action').appendChild(document.createTextNode('/'));
              $('agenda_action').appendChild(
                A({'id'  :'agenda_delete_' + id,
                   'href':'javascript:void(0)',
                   'onclick':function(){
                      Tugboat.gtd_meeting_detail.agenda.del_onclick(agenda);
                    }
                  },
                  'delete'
                )
              );
            }
            
            var prev_and_next_agendas = 
              Tugboat.gtd_meeting_detail.discussion._get_prev_and_next_agendas(id);
              
            $('agenda_prev').appendChild(
              prev_and_next_agendas[0] != null
              ? A({'href':'javascript:void(0);',
                   'onclick':function() {
                      Tugboat.gtd_meeting_detail.discussion._clear_discussion();
                      Tugboat.gtd_meeting_detail.discussion._open_discussion(
                        prev_and_next_agendas[0].id);
                    }
                  }, prev_and_next_agendas[0].title)
              : document.createTextNode(' ')
            );
            $('agenda_prev').className = 
              prev_and_next_agendas[0] != null ? 'left_pane' : 'disabled';
            
            $('agenda_next').appendChild(
              prev_and_next_agendas[1] != null
              ? A({'href':'javascript:void(0);',
                   'onclick':function() {
                      Tugboat.gtd_meeting_detail.discussion._clear_discussion();
                      Tugboat.gtd_meeting_detail.discussion._open_discussion(
                        prev_and_next_agendas[1].id);
                    }
                  }, prev_and_next_agendas[1].title)
              : document.createTextNode(' ')
            );
            $('agenda_next').className = 
              prev_and_next_agendas[1] != null ? 'right_pane' : 'disabled';
            
            $('agenda_discuss_add_comment_link').onclick = function() {
              Tugboat.gtd_meeting_detail.discussion.comment.add_onclick(id);
            };
            $('agenda_discuss_add_task_link').onclick = function() {
              Tugboat.gtd_meeting_detail.discussion.todo.add_onclick(id);
            };
            
            // create discussions.
            var count = 0;
            var self = Tugboat.gtd_meeting_detail.discussion;
            self._scroll_present_index = 0;
            self._scroll_top_position = [];
            self._scroll_top_position.push({'id': 'agenda_text', 'position':0 });
                  
            agenda.discussionList.each(function(discuss) {
              var agendaId = agenda.pid;
              var discussId = discuss.pid ? discuss.pid : discuss.id;
              var element_id = agendaId + '_' + discussId;
              var myClassName =
                Tugboat.gtd_meeting_detail._login_user_info.id == discuss.postedUserId ? ' myComment' : '';        

              var _discussion = null;
              count++;
              self._scroll_top_position.push({'id': 'discussion_' +  element_id, 'position':0 });
                
              switch(discuss.type) {
                case Tugboat.gtd_meeting_detail.discussion.TYPE_TODO.ID:
                  _discussion = 
                    LI({'id':'discussion_' + element_id,
                        'class':'discussion_li task' + myClassName},
                      [
                        P({'class':'discussion_header'},
                          [
                            '[' + count + '] ' + 
                            discuss.lastName + ',' + discuss.firstName +' ',
                            SPAN({'id':'discussion_date_' + element_id},
                              !discuss.modified ? '' : discuss.modified
                            ),
                            ' ',
                            SPAN({'class':'discussion_command'},
                              [
                                A({'id':'discussion_edit_' + element_id,
                                   'href':'javascript:void(0)',
                                   'onclick':function() {
                                      Tugboat.gtd_meeting_detail.discussion.todo.edit_onclick(agendaId,discussId);
                                    }
                                  }, 'edit'),
                                '/',
                                function() {
                                  var inputDel = 
                                    A({'id':'discussion_remove_' + element_id,
                                       'onclick' : function() {
                                          Tugboat.gtd_meeting_detail.discussion.todo.del_onclick(agendaId, discussId);
                                        },
                                       'href':'javascript:void(0)'},'delete');
                                  return inputDel;
                                }
                              ]
                            ),
                            ' ',
                            A({'href':'gtdTaskDetail.html?taskId=' + discuss.taskId}, 'show task'),
                            IMG({'src':'images/default/icon/lastpost.gif', 'class':'left_and_right_5px_margin'})
                          ]
                        ),
                        DIV({'class':'discussion_body_border'},
                          DIV({'class':'discussion_body'},
                            DL(null,
                              [
                                DT(null, 'Title:'),
                                DD({'id':'discussion_title_' + element_id}, discuss.taskTitle),
                                DT(null, 'Description:'),
                                DD(null,
                                  function() {
                                    var p = P({'id':'discussion_description_' + element_id,
                                               'class':'discussion_description'});
                                    p.innerHTML = discuss.taskDescriptionTextile.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
                                    return p;
                                  }
                                ),
                                DT(null, 'Status:'),
                                DD(null,
                                  [
                                    IMG({'class':'left_and_right_3px_margin',
                                         'src':'images/default/folder/gif/'+
                                        (discuss.taskStatusId == 1 ? 'status_todo.gif' :
                                         discuss.taskStatusId == 2 ? 'status_doing.gif'
                                                                   : 'status_done.gif'
                                        )
                                      }
                                    ),
                                    discuss.taskStatusId == 1 ? 'To Do' :
                                    discuss.taskStatusId == 2 ? 'Doing'
                                                              : 'Done'
                                  ]
                                ),
                              DT(null, 'Classification:'),
                              DD(null,
                                [
                                  IMG({'class':'left_and_right_3px_margin',
                                       'src':'images/default/folder/gif/'
                                      + (discuss.taskClassificationId == 1  ? 'folder-red-16.gif'    :
                                         discuss.taskClassificationId == 2  ? 'folder-orange-16.gif' :
                                         discuss.taskClassificationId == 3  ? 'folder-yellow-16.gif' :
                                         discuss.taskClassificationId == 4  ? 'folder-green-16.gif'  :
                                         discuss.taskClassificationId == 5  ? 'folder-blue-16.gif'   :
                                         discuss.taskClassificationId == 9  ? 'inbox-16.gif'         :
                                         discuss.taskClassificationId == 21 ? 'folder-gray-16.gif'   :
                                         discuss.taskClassificationId == 99 ? 'trash-16.gif'         
                                                                            : ''
                                      )
                                    }
                                  ),
                                  discuss.taskClassificationValue
                                ]
                              ),
                              DT(null, 'Due:'),
                                function() {
                                  var dd = DD({'id':'discussion_dead_line_' + element_id});
                                  var due = discuss.taskDeadLine;
                                  due = Tugboat.isEmpty(due) ? '&nbsp;' : due;
                                  dd.innerHTML = due;
                                  return dd;
                                },
                                DT(null, 'Person in charge:',
                                  SPAN({'id':'discussion_person_id_' + element_id,
                                        'style':'display:none;'},discuss.taskPersonId)),
                                DD({'id':'discussion_person_' + element_id}, 
                                  discuss.taskPersonLastName + ',' + discuss.taskPersonFirstName
                                )
                              ]
                            )
                          )
                        )
                      ]
                    );
                  $('discussion_ul').appendChild(_discussion);
                  break;
                    
                case Tugboat.gtd_meeting_detail.discussion.TYPE_COMMENT.ID:
                  _discussion = 
                    LI({'id':'discussion_' + element_id,
                        'class' : 'discussion_li comment' + myClassName},
                      [
                        P({'class':'discussion_header'},
                          [
                            '[' + count + '] ' + 
                            discuss.lastName + ' ' + discuss.firstName +' ',
                            SPAN({'id':'discussion_date_' + element_id},
                              !discuss.modified ? '' : discuss.modified
                            ),
                            ' ',
                            SPAN({'class':'discussion_command'},
                              [
                                A({'id':'discussion_edit_' + element_id,
                                   'href':'javascript:void(0)',
                                   'onclick': function() {
                                      Tugboat.gtd_meeting_detail.discussion.comment.edit_onclick(agendaId, discussId)}
                                    },'edit'
                                ),
                                '/',
                                A({'id':'discussion_remove_' + element_id,
                                   'href':'javascript:void(0)',
                                   'onclick' : function() {
                                      Tugboat.gtd_meeting_detail.discussion.comment.del_onclick(agendaId, discussId);
                                    }
                                  },'delete'
                                )
                              ]
                            )
                          ]
                        ),
                        DIV({'class':'discussion_body_border'},
                          function() {
                            var p = P({'id':'discussion_text_' + element_id,
                                       'class':'discussion_body'});
                            p.innerHTML = discuss.body.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
                            return p;
                          }
                        )
                      ]
                    );
                  $('discussion_ul').appendChild(_discussion);
                  break;
                }
              }
            );
            $('discussion_ul').appendChild(
              LI({'id':'discuss_list_spacer'})
            );
            $('agenda_body').scrollTop = 0;
            $('progress_window').hide();
            
            self._set_comment_scroll(is_update);
          },
          onFailure : function(transport) {
            $('progress_window').hide();
          }
        }
      );
    },
    
    /**
     * set comment scroll.
     * 
     * @param {Object} isShowLastRow
     */
    _set_comment_scroll : function(isShowLastRow) {
      var self = Tugboat.gtd_meeting_detail.discussion;
      var is_visibled_discussion = 
        $('discussions').style.display != '' && $('discussions').style.display != 'none';
      
      if (! is_visibled_discussion
       || ! self._scroll_top_position
       || self._scroll_top_position.length == 0) {
        return false;
      }

      var self = Tugboat.gtd_meeting_detail.discussion;
      var el_comment_list = YAHOO.util.Dom.getRegion('agenda_body');
      
      var last_row_scroll_info = self._scroll_top_position[self._scroll_top_position.length - 1];
      var el_last_row = YAHOO.util.Dom.getRegion(last_row_scroll_info.id);
      
      var list_height =
        (el_comment_list.bottom - el_comment_list.top)
      - (el_last_row.bottom - el_last_row.top  + 5);
      
      $('discuss_list_spacer').style.height = list_height + 'px';

      var el_parent = YAHOO.util.Dom.getRegion('agenda_body');
      self._scroll_top_position.each(
        function(s) {
          var el_target = YAHOO.util.Dom.getRegion(s.id);
          s.position = el_target.top - el_parent.top;
        }
      );
      if (isShowLastRow) {
        self._scroll_present_index = self._scroll_top_position.length - 1;
        $('agenda_body').scrollTop = 
          self._scroll_top_position[self._scroll_present_index].position;
      } else {
        $('agenda_body').scrollTop = 0;
      }
    },
    
    /**
     * clear discussion.
     */
    _clear_discussion : function() {
      $('agenda_header_text').innerHTML ='';
      $('agenda_text').innerHTML ='';
      $('agenda_action').innerHTML = '';
      $('discussion_ul').innerHTML = '';
      $('agenda_prev').innerHTML = '';
      $('agenda_next').innerHTML = '';
      
      Tugboat.gtd_meeting_detail.discussion._scroll_top_position = [];
    },
    
    /**
     * close discussion.
     * 
     */
    _close_discussion : function() {
      $('agendas').style.display = 'block';
      $('discussions').style.display = 'none';

      Tugboat.gtd_meeting_detail.discussion._open_discuss_id = 0;
      Tugboat.gtd_meeting_detail.discussion._clear_discussion();
      Tugboat.gtd_meeting_detail.resize();
    },
    
    /**
     * get prev and next agendas.
     * 
     * @param {Object} id
     */
    _get_prev_and_next_agendas : function(id) {
      var detail = Tugboat.gtd_meeting_detail;
      if (! detail._agenda_summaries || detail._agenda_summaries.length == 0) return null;

      var target_agenda_index = 0;
      for (i = 0; i < detail._agenda_summaries.length; i++) {
        if (id == detail._agenda_summaries[i].id) {
          target_agenda_index = i;
          break;
        }
      }
      var agendas = null;
      if (target_agenda_index == 0) {
        agendas = [
          null,
          detail._agenda_summaries[1]
        ];
      } else if (target_agenda_index == detail._agenda_summaries.length - 1) {
        agendas = [
          detail._agenda_summaries[target_agenda_index - 1],
          null
        ];
      } else {
        agendas = [
          detail._agenda_summaries[target_agenda_index - 1],
          detail._agenda_summaries[target_agenda_index + 1]
        ];
      }
      return agendas;
    },
    
    /*
     * discussion-comment.
     * 
     * 
     */
    comment: {
      /**
       * open edit sub_window.
       * 
       * @param {Object} agenda
       * @param {Object} discussion
       */
      edit_onclick : function(agendaId, discussionId){
        var self = Tugboat.gtd_meeting_detail;
        self._is_already_editing = {
            mode:'edit',
            agendaId:agendaId,
            discussionId:discussionId
        };
        self.discussion.comment._open_sub_window('Edit comment');
      },
      
      /**
       * open add comment's sub window.
       * 
       * @param {Object} agenda
       */
      add_onclick: function(agendaId){
        var self = Tugboat.gtd_meeting_detail;
        self._is_already_editing = {
          mode : 'add',
          agendaId : agendaId,
          discussionId : 'tmp_' + new Date().getTime()
        };
        $('comment_text').value = '';
        self.discussion.comment._open_sub_window('Add comment');
      },
      
      /**
       * add comment cancel.
       * 
       */
      cancel_onclick: function() {
        var self = Tugboat.gtd_meeting_detail;
        Windows.closeAll();
        return false;
      },

      /**
       * add comment.
       * 
       */
      _add: function(){
        var self = Tugboat.gtd_meeting_detail;
        var agendaId = self._is_already_editing.agendaId;
        var discussionId = self._is_already_editing.discussionId;
        var postedUserId = self._login_user_info.id;
        var firstName = self._login_user_info.firstName;
        var lastName = self._login_user_info.lastName;
        var commentText = $F('comment_text');
        var myClassName = self._login_user_info.id == postedUserId ? ' myComment' : '';        
  
        var messages = new Array();
        if ( Tugboat.isEmpty(commentText) ) {
          messages.push('\'Comment\' is required.');
        }
        if ( messages.length > 0 ) {
          Tugboat.showAlertDialog( messages );
          return false;
        }
        Windows.closeAll();
    
        var comment_obj = {
          execute : function(obj) {
            self.discussion._clear_discussion();
            self.discussion._open_discussion(agendaId, true);
          }
        };
        self.discussion.comment._do_ajax_request(
          'meetingDetailAjax', 'addAgendaDiscussion', comment_obj);

        return false;
      },
      
      /**
       * update comment.
       * 
       */
      _update: function(){
        var self = Tugboat.gtd_meeting_detail;
        var agendaId = self._is_already_editing.agendaId;
        var discussionId = self._is_already_editing.discussionId;
        var inputValue = $F('comment_text');

        var divDiscussionText =
          $('discussion_text_' + agendaId + '_' + discussionId);
        
        divDiscussionText.innerHTML =
          $F('comment_text').replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');

        Windows.closeAll();
        self.discussion.comment._do_ajax_request(
          'meetingDetailAjax', 'updateAgendaDiscussion');
      },
      
      /**
       * remove comment.
       * 
       * @param {Object} agenda
       * @param {Object} discussion
       */
      del_onclick: function(agendaId, discussionId) {
        var self = Tugboat.gtd_meeting_detail; 
        if ( !confirm('May I delete this discussion?') ) {
          return false;
        }
        var self = Tugboat.gtd_meeting_detail;
        self._is_already_editing = {
          mode:'remove',
          agendaId:agendaId,
          discussionId:discussionId
        };
       
        var comment_obj = {
          execute : function(obj) {
            Tugboat.gtd_meeting_detail.discussion._clear_discussion();
            Tugboat.gtd_meeting_detail.discussion._open_discussion(agendaId, true);
          }
        };
        self.discussion.comment._do_ajax_request(
          'meetingDetailAjax', 'deleteAgendaDiscussion', comment_obj
        );
      },
      
      /**
       * do ajax request.
       * 
       * @param {Object} component
       * @param {Object} action
       * @param {Object} postProcessorObj
       */
      _do_ajax_request: function(component, action, postProcessorObj) {
        var self = Tugboat.gtd_meeting_detail;     
        var agendaId = self._is_already_editing.agendaId;
        var discussionId = self._is_already_editing.discussionId;
        
        new Ajax.Request (
          Tugboat.AJAX_SERVLET_NAME, 
            {
            method: Tugboat.constant.REQUEST_POST,
            parameters: {
              'component':component,
              'action':action,
              'activityId'   : self.basic.jsonMeetingBasic.activityId,
              'basicId'      : self.basic.jsonMeetingBasic.id,
              'agendaId'     : agendaId,
              'discussionId' : self._is_already_editing.mode == 'add' ? 0 : discussionId,                       
              'postedType'   : self.discussion.TYPE_COMMENT.ID,
              'postedUserId' : self._login_user_info.id,
              'bodyTextile'  : $F('comment_text')
            },
            onComplete: function(transport) {
              var obj = eval( '('+transport.responseText+')');
              if(postProcessorObj) {
                postProcessorObj.execute(obj);
              }
              self._is_already_editing = false;
              $('comment_text').value = '';
            }
          }
        );
      },
      
      /**
       * open comment sub window.
       * 
       * @param {Object} title
       */
      _open_sub_window: function(title) {
        var self = Tugboat.gtd_meeting_detail;
        self.modal.open();

        var agendaId = self._is_already_editing.agendaId;
        var discussionId = self._is_already_editing.discussionId;
        
        if(self._is_already_editing.mode == 'edit') {
          var element_id_suffix = agendaId + '_' + discussionId;
          $('comment_text').value = 
            $('discussion_text_' + element_id_suffix).innerHTML.replace(/<br>/g,'\n').replace(/<BR>/g,'\n');
        }
        
        self.discussion.add_comment_window = 
          new Window(
            'addCommentWindow', 
            { className: 'mac_os_x', width:560, height:300, 
              zIndex: 100, 
              minimizable: false, 
              closable   : false, 
              maximizable: false,
              resizable  : false,
              draggable  : true,
              title      : title,
              showEffectOptions:{
                duration:0.3, 
                afterFinish:function(){
                  $('comment_text').focus();
                  var div = YAHOO.util.Dom.getRegion('addCommentWindow_content');
                  $('comment_text').style.height= div.bottom - div.top - 65 + 'px';
                }
              }
            }
          );
        self.discussion.add_comment_window.setContent('comment_sub_window_container',false,false);
        self.discussion.add_comment_window.setDestroyOnClose();
        self.discussion.add_comment_window.showCenter();
  
        var commentWindowObserver = {
          onDestroy: function(eventName, win) {
            if (win == self.discussion.add_comment_window) {
              Element.hide('comment_sub_window_container');
              $('comment_sub_window_container').appendChild($('add_comment_sub_window'));
              if(self._is_already_editing.mode == 'edit') {
                $('comment_text').value = '';
              }
              self._is_already_editing = false;
              self.add_comment_window = null;
              Windows.removeObserver(this);
              
              self.modal.close();
            }
          }
        };
        Windows.addObserver(commentWindowObserver);
        return false;
      }
    },
    
    /*
     * discussion-task.
     * 
     * 
     */
    todo: {
      /**
       * open task sub window.
       * 
       * @param {Object} agendaId
       * @param {Object} discussionId
       */
      edit_onclick: function(agendaId, discussionId){
        var self = Tugboat.gtd_meeting_detail;
        self._is_already_editing = {
          mode:'edit',
          agendaId:agendaId,
          discussionId: discussionId
        };
        
        self.discussion.todo._open_sub_window('Edit task');
      },
        
      /**
       * clear.
       * 
       */
      clear: function() {
        $('add_task_title').value = '';
        $('add_task_description').value = '';
        $('edit_due').value = '';
        $('edit_due_display').innerHTML = '';
      },
      
      /**
       * open add task sub window.
       * 
       * @param {Object} agenda
       */
      add_onclick: function(agendaId){
        var self = Tugboat.gtd_meeting_detail;
        self._is_already_editing = {
          mode:'add',
          agendaId:agendaId,
          discussionId:'tmp_'+new Date().getTime()
        };
        self.discussion.todo._open_sub_window('Add task');
      },
      
      /**
       * close add task sub window.
       */
      cancel_onclick: function() {
        Windows.closeAll();
        return false;
      },
      
      /**
       * refresh task side bar.
       * 
       * @param {Object} agenda
       * @param {Object} discussion
       */
      _reload_tasks_in_sidebar: function() { 
        var self = Tugboat.gtd_meeting_detail;
        var page_info = self.sidebar.page_info;
        self.sidebar._create_tasks(0, self.sidebar.page_info.currentPageNumber);
        return false;
      },
      
      /**
       * open dialog.
       * 
       * @param {Object} title
       */
      _open_sub_window: function(title) {
        var self = Tugboat.gtd_meeting_detail;
        self.modal.open();
        
        $('add_task_title').value = '';
        $('add_task_description').value = '';
        $('edit_due_display').innerHTML = '';
        $('edit_due').value = '';
        
        if(self._is_already_editing.mode == 'edit') {
          var agendaId = self._is_already_editing.agendaId;
          var discussionId = self._is_already_editing.discussionId;
          var element_id_suffix = agendaId + '_' + discussionId;

          $('add_task_title').value          = $('discussion_title_'       + element_id_suffix).innerHTML;
          $('add_task_description').value    = $('discussion_description_' + 
                                                 element_id_suffix).innerHTML.replace(/<br>/g,'\n').replace(/<BR>/g,'\n');
          $('edit_due').value                = $('discussion_dead_line_'   + element_id_suffix).innerHTML
                                               ? $('discussion_dead_line_' + element_id_suffix).innerHTML.replace(/-/g,'')
                                               : '';
          $('edit_due_display').innerHTML    = $('discussion_dead_line_'   + element_id_suffix).innerHTML;
          $('add_task_personInCharge').value = $('discussion_person_'      + element_id_suffix).innerHTML;
          $('selectedUserId').value          = $('discussion_person_id_'   + element_id_suffix).innerHTML;
        }

        self.discussion.todo.add_task_window =
          new Window(
            'addTaskWindow', 
            { className: 'mac_os_x', width:560, height:320, 
              zIndex: 100, 
              minimizable: false, 
              closable   : false, 
              maximizable: false,
              resizable  : false, 
              draggable  : true,
              title      : title,
              showEffectOptions:{
                duration:0.3,
                afterFinish:function(){
                  $('add_task_title').focus();
                }
              }
            }
          );
        self.discussion.todo.add_task_window.setContent('task_sub_window_container',false,false);
        self.discussion.todo.add_task_window.setDestroyOnClose();
        self.discussion.todo.add_task_window.showCenter();

          new Ajax.Autocompleter(
            'add_task_personInCharge',
            'add_task_personInCharge_ac', 
            'teeda.ajax?component=activityMemberAjax&action=getActivityMembersByActivityIdAndKeyword&activityId='
              + self.basic.jsonMeetingBasic.activityId, 
            { minChars: 2,
              paramName:'selectMemberChar',
              optionTextfield:$('selectedUserId'),
              optionAttributeName:'tgb:value'
            }
          );

        var taskWindowObserver = {
          onDestroy: function(eventName, win) {
            if (win == self.discussion.todo.add_task_window) {
              Element.hide('task_sub_window_container');
              $('task_sub_window_container').appendChild($('task_sub_window'));
              
              self.discussion.add_task_window = null;
              Windows.removeObserver(this);
              self._is_already_editing = false;
              self.modal.close();
            }
          }
        };
        Windows.addObserver(taskWindowObserver);
        return false;
      },

      /**
       * add todo.
       * 
       */
      _add: function() {
        var self = Tugboat.gtd_meeting_detail;
        var agendaId = self._is_already_editing.agendaId;
        var discussionId = self._is_already_editing.discussionId;
        
        var title = $F('add_task_title');
        var description = $F('add_task_description');
        var dead_line = $('edit_due').value.replace('&nbsp;','');
        var personId = $F('selectedUserId');
        var personValue = $F('add_task_personInCharge');
        var due = $('edit_due_display').innerHTML;
        due = Tugboat.isEmpty(due) ? '&nbsp;' : due;
        
        var postedUserId = self._login_user_info.id;
        var firstName    = self._login_user_info.firstName;
        var lastName     = self._login_user_info.lastName;
        var statusId     = 1;
        var statusValue  = 'To Do';
        var classificationId = 9;
        var classificationValue = 'inbox';
        var type = self.discussion.TYPE_TODO.ID;
        
        var messages = new Array();
        if ( Tugboat.isEmpty(title) ) {
          messages.push('\'Title\' is required.');
        }
        if ( Tugboat.isEmpty(personId) ) {
          messages.push('\'Person\' is required.');
        }
        if ( messages.length > 0 ) {
          Tugboat.showAlertDialog( messages );
          return false;
        }
        Windows.closeAll();

        var todo_obj = {
          execute : function(obj) {
            self.discussion._clear_discussion();
            self.discussion._open_discussion(agendaId, true);
            self.discussion.todo._reload_tasks_in_sidebar();
          }
        };
        self.discussion.todo._do_ajax_request(
          'meetingDetailAjax', 'addAgendaDiscussion', todo_obj);        
      },

      /**
       * update todo.
       * 
       * @param {Object} agendaId
       * @param {Object} discussionId
       */
      _update: function(agendaId,discussionId) {
        var self = Tugboat.gtd_meeting_detail;
        var agendaId = self._is_already_editing.agendaId;
        var discussionId = self._is_already_editing.discussionId;
        var title = $F('add_task_title');
        var personId = $F('selectedUserId');
        var description = $F('add_task_description');
        var dead_line = $('edit_due').value.replace('&nbsp;','');
        var personId = $F('selectedUserId');
        var personValue = $F('add_task_personInCharge');
        var due = $('edit_due_display').innerHTML;
        
        var messages = new Array();
        if ( Tugboat.isEmpty(title) ) {
          messages.push('\'Title\' is required.');
        }
        if ( Tugboat.isEmpty(personId) ) {
          messages.push('\'Person\' is required.');
        }
        if ( messages.length > 0 ) {
          Tugboat.showAlertDialog( messages );
          return false;
        }

        var ddDiscussionTitle        = $('discussion_title_'       + agendaId+ '_' + discussionId);
        var ddDiscussionDescription  = $('discussion_description_' + agendaId+ '_' + discussionId);
        var ddDiscussionDeadLine     = $('discussion_dead_line_'   + agendaId+ '_' + discussionId);
        var ddDiscussionPerson       = $('discussion_person_'      + agendaId+ '_' + discussionId);
        var spanDiscussionPersonId   = $('discussion_person_id_'   + agendaId+ '_' + discussionId);

        ddDiscussionTitle.innerHTML= title;
        ddDiscussionDescription.innerHTML = description.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
        ddDiscussionDeadLine.innerHTML = due;
        ddDiscussionPerson.innerHTML = personValue;
        spanDiscussionPersonId.innerHTML = personId;
        Windows.closeAll();

        var todo_obj = {
          execute : function(obj) {
            self.discussion.todo._reload_tasks_in_sidebar();
          }
        };
        self.discussion.todo._do_ajax_request(
          'meetingDetailAjax', 'updateAgendaDiscussion', todo_obj);
      },
      
      /**
       * remove.
       * 
       * @param {Object} agenda
       * @param {Object} discussion
       */
      del_onclick: function(agendaId, discussionId) {
        var self = Tugboat.gtd_meeting_detail; 
        if ( !confirm('May I delete this discussion?') ) {
          return false;
        }
        var self = Tugboat.gtd_meeting_detail;
        self._is_already_editing = {
          mode:'remove',
          agendaId:agendaId,
          discussionId:discussionId
        };

        var todo_obj = {
          execute : function(obj) {
            var discussion = Tugboat.gtd_meeting_detail.discussion;
            discussion._clear_discussion();
            discussion._open_discussion(agendaId, true);
            discussion.todo._reload_tasks_in_sidebar();
          }
        };
        self.discussion.todo._do_ajax_request(
          'meetingDetailAjax', 'deleteAgendaDiscussion', todo_obj);
        return false;
      },

      /**
       * do ajax request.
       * 
       * @param {Object} component
       * @param {Object} action
       * @param {Object} todo_obj
       */
      _do_ajax_request: function(component, action, todo_obj) {
        var self = Tugboat.gtd_meeting_detail;
        var agendaId     = self._is_already_editing.agendaId;
        var discussionId = self._is_already_editing.discussionId;
        new Ajax.Request
        ( 
          Tugboat.AJAX_SERVLET_NAME,
          { 
            method: Tugboat.constant.REQUEST_POST,
            parameters: {
              'component':component, 'action':action,
              'activityId'        :self.basic.jsonMeetingBasic.activityId,
              'basicId'           :self.basic.jsonMeetingBasic.id,
              'agendaId'          :agendaId,
              'discussionId'      :self._is_already_editing.mode=='add'?0:discussionId,
              'postedType'        :self.discussion.TYPE_TODO.ID,
              'postedUserId'      :self._login_user_info.id,
              'taskTitle'         :$F('add_task_title'),
              'taskDescription'   :$F('add_task_description'),
              'taskDeadLine'      :$('edit_due').value.replace('&nbsp;',''),
              'taskPersonId'      :$F('selectedUserId')
            },
            onComplete: function(transport)
            {
              var obj = eval( '('+transport.responseText+')' ); 
              todo_obj.execute(obj);
              self._is_already_editing = false;
              self.discussion.todo.clear();
            }
          }
        );
      },
      
      /**
       * open edit sub window.
       * 
       * @param {Object} agendaId
       * @param {Object} discussionId
       */
      open_edit_sub_window: function(agendaId,discussionId){
        var self = Tugboat.gtd_meeting_detail;
        self._is_already_editing = {
            mode:'edit',
            agendaId:agendaId,
            discussionId:discussionId
        };
        self.discussion.todo._open_sub_window('Edit task');
      }
    }
  },
  
  /*
   * sidebar.
   * 
   * 
   * 
   */
  sidebar: {
    page_info : null,
    _task_status : [
      {id:1, value:'To Do', icon:'images/default/folder/gif/status_todo.gif', className:'todo' },
      {id:2, value:'Doing', icon:'images/default/folder/gif/marker.gif',      className:'doing'},
      {id:3, value:'Done',  icon:'images/default/folder/gif/status_done.gif', className:'done' }
    ],
    _task_class : [
      {id:1,  value:'Today',     className:'today'  },
      {id:2,  value:'Week',      className:'week'   },
      {id:3,  value:'Month',     className:'month'  },
      {id:4,  value:'Hold',      className:'hold'   },
      {id:5,  value:'Someday',   className:'someday'},
      {id:9,  value:'Inbox',     className:'inbox'  },
      {id:21, value:'Archive',   className:'archive'},
      {id:99, value:'Trash box', className:'inbox'  }
    ],
    
    /**
     * find task status.
     * 
     * @param {Object} id
     */
    _find_task_status : function(id) {
      var self = Tugboat.gtd_meeting_detail;
      return self.sidebar._task_status.find( 
        function(s){ return (id == s.id);} 
      );
    },
    
    /**
     * find task class.
     * 
     * @param {Object} id
     */
    _find_task_class : function(id) {
      var self = Tugboat.gtd_meeting_detail;
      return self.sidebar._task_class.find( 
        function(c){return (id == c.id);}
      );
    },

    /**
     * create members dom.
     */
    _create_members:function() {
      var self = Tugboat.gtd_meeting_detail;
      new Ajax.Request
      (
        Tugboat.AJAX_SERVLET_NAME,
        {
          method:Tugboat.constant.REQUEST_POST,
          parameters: {
            'component' : 'meetingDetailAjax',
            'action'    : 'getSidebarMembersContents',
            'activityId': self.basic.jsonMeetingBasic.activityId
          },
          onComplete:  function(transport) {
            var jsonSectionMemberList = eval( '('+transport.responseText+')' );
                     
            var targetElement = document.getElementById('sidebar_members_body');
            targetElement.innerHTML = "";
            targetElement.appendChild(
              UL({'class':'online_members'},
                function(){
                  var list =[];
                  
                  jsonSectionMemberList.each( 
                    function(member){
                      list.push(
                        LI({'class':'online'},
                          IMG({'width':'16',
                               'height':'16',
                               'style':'margin-right:5px; vertical-align:middle;',
                               'src':'images/default/icon/contact_known.gif'}),
                          member.lastName + ',' + member.firstName
                        )
                      );
                    }
                  );
                  return list;
                }
              ) 
            );
            self.sidebar._create_tasks(0, 1);
            $('progress_window').hide();
            $('content').style.visibility='visible';
          }
        }
      );
      return false;
    },
    
    /**
     * create tasks dom.
     * 
     * @param {Object} offset
     * @param {Object} currentPageNumber
     */
    _create_tasks : function(offset, currentPageNumber) {
      var self = Tugboat.gtd_meeting_detail;
      new Ajax.Request
      (
        Tugboat.AJAX_SERVLET_NAME,
        {
          method:Tugboat.constant.REQUEST_POST,
          parameters: {
            'component'        : 'meetingDetailAjax',
            'action'           : 'getSidebarTasksContents',
            'basicId'          : self.basic.jsonMeetingBasic.id,
            'currentPageNumber': currentPageNumber,
            'offset'           : offset,
            'limit'            : Tugboat.constant.ROWS_PER_PAGE
          },
          onComplete:  function(transport) {
            var jsonTasks = eval( transport.responseText );
            var jsonSectionTasksList = jsonTasks.tasks;
            self.sidebar.page_info = jsonTasks.page;

            var targetElement = document.getElementById('sidebar_task_list');
            targetElement.innerHTML = "";            
         
            appendChildNodes(targetElement,
              function(){
                var list = [];
                jsonSectionTasksList.each( 
                  function(task){
                    var liTask = 
                      LI({'id':'task_list_text_'+task.taskId},[
                        DIV({'class':'status '+self.sidebar._find_task_status(task.statusId).className}),
                        DIV({'class':'class_icon '+self.sidebar._find_task_class(task.classificationId).className}),
                        P({'class':'title'},
                          function(){
                            var aTag = A({'href':'gtdTaskDetail.html?taskId='+task.taskId}, task.title);
                            return aTag;
                          }
                        ),
                        P({'class':'createdBy'}, task.lastName+','+task.firstName),
                        P({'class':'createdAt'}, task.createdAt)
                      ]);
                    list.push(liTask);
                  }
                );
                return list;
              }
            );
          }
        }
      );
      return false;
    },

    /**
     * 
     * @param {Object} anchorObject
     * @param {Object} elemId
     */
    toggle_element : function(anchorObject, elemId) {
      anchorObject.className =
      $(elemId).style.display == 'none'? 'collapse_icon': 'expand_icon';
      Element.toggle(elemId);
      return false;
    }
  },
  
  /*
   * Modal window
   *
   * 
   */
  modal : {
    _is_opened : false,

    open : function () {
      Tugboat.gtd_meeting_detail.modal._is_opened = true;
      var page = Tugboat.getPageSize(); 
      Element.setHeight('modal_window', page.pageHeight);
      $('modal_window').style.display = Tugboat.constant.STYLE_DISPLAY_BLOCK;
      return false;
    },

    close : function() {
      Tugboat.gtd_meeting_detail.modal._is_opened = false;
      Element.hide('modal_window');
      return false;
    }
  }
};
YAHOO.util.Event.addListener(
  document, "keydown",
  function(key){
    if (key.keyCode == Event.KEY_ESC) {
      if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;
      Windows.closeAll();
    }
    
    var isIE6 = navigator.userAgent.indexOf('MSIE 6.0') > -1;
    if (isIE6) {
    } else {
      if (Tugboat.gtd_meeting_detail.modal._is_opened) {
        return false;
      }

      var is_visibled_discussion = 
        $('discussions').style.display != '' && $('discussions').style.display != 'none';
      
      switch (key.keyCode) {
        //[a]
        case Event.KEY_A:
          Tugboat.gtd_meeting_detail._prev_entry_key_code = key.keyCode;
          break;
        //[b]
        case Event.KEY_B:
          if (Tugboat.gtd_meeting_detail._prev_entry_key_code == Event.KEY_G) {
            location.href = 'gtdMeetings.html';
          }
          Tugboat.gtd_meeting_detail._prev_entry_key_code = 0;
          break;
        //[e]
        case Event.KEY_E:
          Tugboat.gtd_meeting_detail._prev_entry_key_code = key.keyCode;
          break;
        //[g]
        case Event.KEY_G:
          if (Tugboat.gtd_meeting_detail._prev_entry_key_code == Event.KEY_A) {
            Tugboat.gtd_meeting_detail.agenda.add_onclick();
            Tugboat.gtd_meeting_detail._prev_entry_key_code = 0;
          } else {
            Tugboat.gtd_meeting_detail._prev_entry_key_code = Event.KEY_G;
          }
          break;
        //[l]
        case Event.KEY_L:
          if (! is_visibled_discussion && Tugboat.gtd_meeting_detail._agenda_summaries) {
            Tugboat.gtd_meeting_detail.discussion._open_discussion(
              Tugboat.gtd_meeting_detail._agenda_summaries[0].id
            );
          }
          break;
        //[m]
        case Event.KEY_M:
          if (Tugboat.gtd_meeting_detail._prev_entry_key_code == Event.KEY_E) {
            Tugboat.gtd_meeting_detail.basic.open();
            Tugboat.gtd_meeting_detail._prev_entry_key_code = 0;
          }
          break;
        default:
      }

      if (is_visibled_discussion) {
        var agendas = Tugboat.gtd_meeting_detail._agenda_summaries;
        switch (key.keyCode) {
          //[l]:next-agenda
          case Event.KEY_L:
            if (agendas) {
              var index = -1;
              for (var i = 0; i < agendas.length; i++) {
                if (Tugboat.gtd_meeting_detail.discussion._open_discuss_id == agendas[i].id) {
                  index = i;
                  break;
                }
              }
              if (index > -1 && agendas.length > index + 1) {
                Tugboat.gtd_meeting_detail.discussion._clear_discussion();
                Tugboat.gtd_meeting_detail.discussion._open_discussion(agendas[index + 1].id);
              }
            }
            break;

          //[h]:prev-agenda
          case Event.KEY_H:
            if (agendas) {
              var index = -1;
              for (var i = 0; i < agendas.length; i++) {
                if (Tugboat.gtd_meeting_detail.discussion._open_discuss_id == agendas[i].id) {
                  index = i;
                  break;
                }
              }
              if (index > -1 && index > 0) {
                Tugboat.gtd_meeting_detail.discussion._clear_discussion();
                Tugboat.gtd_meeting_detail.discussion._open_discussion(agendas[index - 1].id);
              }
            }          
            break;
            
          //[c]:add-comment
          case Event.KEY_C:
            if (Tugboat.gtd_meeting_detail._prev_entry_key_code == Event.KEY_A) {
              Tugboat.gtd_meeting_detail.discussion.comment.add_onclick(
                Tugboat.gtd_meeting_detail.discussion._open_discuss_id
              );
            }
            break;

          //[t]:add-task
          case Event.KEY_T:
            if (Tugboat.gtd_meeting_detail._prev_entry_key_code == Event.KEY_A) {
              Tugboat.gtd_meeting_detail.discussion.todo.add_onclick(
                Tugboat.gtd_meeting_detail.discussion._open_discuss_id
              );
            }
            break;

          //[j]:next-dis
          case Event.KEY_J:
            var discussion = Tugboat.gtd_meeting_detail.discussion;
            var length = discussion._scroll_top_position.length;
            var present_position = discussion._scroll_present_index;
            var position = 0;
            var scroll_top = $('agenda_body').scrollTop;

            if (discussion._scroll_top_position
             && discussion._scroll_top_position[present_position]) {
              if (scroll_top != discussion._scroll_top_position[present_position].position) {
                for (i = 0; i < length; i++) {
                  if (scroll_top < discussion._scroll_top_position[i].position) break;
                }
                if (i > 0 ) position = i;
              } else {
                position =
                  present_position == length - 1
                  ? present_position
                  : present_position + 1;
              }
              if (discussion._scroll_top_position[position]) {
                discussion._scroll_present_index = position;
                $('agenda_body').scrollTop = 0;
                $('agenda_body').scrollTop = discussion._scroll_top_position[position].position;
              }
            }
            Tugboat.gtd_meeting_detail._prev_entry_key_code = 0;
            break;

          //[k]:prev-dis
          case Event.KEY_K:
            var discussion = Tugboat.gtd_meeting_detail.discussion;
            var length = discussion._scroll_top_position.length;
            var present_position = discussion._scroll_present_index;
            var position = 0;
            var scroll_top = $('agenda_body').scrollTop;

            if (discussion._scroll_top_position
             && discussion._scroll_top_position[present_position]) {
              if (scroll_top != discussion._scroll_top_position[present_position].position) {
                for (i = 0; i < length; i++) {
                  if (scroll_top < discussion._scroll_top_position[i].position) break;
                }
                if (i > 0 ) position = i - 1;
              } else {
                position =
                  present_position == 0 ? 0 : present_position - 1;
              }
              discussion._scroll_present_index = position;
              $('agenda_body').scrollTop = 0;
              $('agenda_body').scrollTop = 
                discussion._scroll_top_position[position].position;
            }
            Tugboat.gtd_meeting_detail._prev_entry_key_code = 0;
            break;
            
          //[x]:close-dis
          case Event.KEY_X:
            Tugboat.gtd_meeting_detail.discussion._close_discussion();
            break;
          default:
        }
      }
    }
  }
);