/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
Tugboat.gtd_common = {
  FUNC_TYPE_TASK     : 'T',
  FUNC_TYPE_MEETING  : 'L',
  FUNC_TYPE_ACTIVITY : 'A',
  
  BROWSER_HEIGHT     : 122,

  /**
   * toggle browser area. #show/#hide
   */
  toggleBrowserArea : function() {
    var display = $('browser_pane').style.display;
    Tugboat.gtd_common.resize_list_area(
      display == Tugboat.constant.STYLE_DISPLAY_NONE, true);
    Element.toggle('browser_pane');
  },

  /**
   * block select
   * @param {Object} object
   */
  blockSelect : function(object) {
    if (object.className == 'layout_blocks_icon') {
      //expand list -> collapse list.
      var args = $$('div.detailContainer');
      args.each(
        function(a) {
          a.style.display = 'none';
          
          var id = a.id.substring('list_detail_container-'.length);
          $('gtd_list_'+id).className = 'default';
        }
      );

      // mode change
      $('layout_block').className = 'layout_blocks_icon_inactive';
      $('layout_list').className   = 'layout_list_icon';
      $('list_pane').className = 'block_mode';

      if ($('list_top'))    $('list_top').className     = 'gtdBox clearfix';
      if ($('list_middle')) $('list_middle').className  = 'gtdBox clearfix';
      if ($('list_bottom')) $('list_bottom').className  = 'gtdBox clearfix';

      $('list_column_header').style.display = Tugboat.constant.STYLE_DISPLAY_NONE;
      $('list_pane').style.height = 
        Number($('list_pane').style.height.replace('px','')) + 21 + 'px';
    }
    object.blur();
  },
  
  /**
   * list select
   * @param {Object} object
   */
  listSelect : function(object) {
    if (object.className == 'layout_list_icon') {
      $('layout_block').className = 'layout_blocks_icon';
      $('layout_list').className   = 'layout_list_icon_inactive';
      $('list_pane').className = 'gtdList';

      if ($('list_top'))    $('list_top').className     = 'gtdList clearfix';
      if ($('list_middle')) $('list_middle').className  = 'gtdList clearfix';
      if ($('list_bottom')) $('list_bottom').className  = 'gtdList clearfix';

      $('list_column_header').style.display = Tugboat.constant.STYLE_DISPLAY_BLOCK;
    }
    object.blur();
  },
  
  /**
   * toggle folder area.
   * @param object
   */
  toggleFolderArea : function(object) {
    var self = Tugboat.gtd_common;
    var isVisibled = 
      !($('folders_pane').style.display == Tugboat.constant.STYLE_DISPLAY_NONE);
      
    if (isVisibled) self._hide();
    else            self._show();
    object.blur();
  },
    
  /**
   * show folder's area.
   */
  _show : function() {
    $('folders_pane').style.display = Tugboat.constant.STYLE_DISPLAY_BLOCK;
    $('folders_pane').style.width = '130px';
    $('main_pane').style.width = '790px';
  },
    
  /**
   * hide folder's area.
   */
  _hide : function() {
    $('folders_pane').style.display = Tugboat.constant.STYLE_DISPLAY_NONE;
    $('folders_pane').style.width = '0px';
    $('main_pane').style.width = '920px';
  },
  
  /**
   * create list dom.
   * @param {Object} transport
   * @param {Object} functionType
   * @return {Object} json
   */
  create_list_dom : function(transport, functionType) {
    var self = Tugboat.gtd_common;
    
    $('res_number').innerHTML = '0 results';
    $('res_page').innerHTML   = '1/1 page';
    $('page_prev').className  = 'page_prev_off';
    $('page_next').className  = 'page_next_off';
    
    //
    //-- TASK
    //
    if (functionType == self.FUNC_TYPE_TASK) {
      $('list_top').innerHTML = '';
      $('list_middle').innerHTML = '';
      $('list_bottom').innerHTML = '';
      
      Tugboat.gtd_common.task._setup_task_default_folder();
        
      $('list_top_container').style.display =
        Tugboat.constant.task.listStyle(
          TugboatUI.DragBox.selectedFolderId, Tugboat.constant.task.STYLE_LIST_TOP);

      $('list_middle_container').style.display =
        Tugboat.constant.task.listStyle(
          TugboatUI.DragBox.selectedFolderId, Tugboat.constant.task.STYLE_LIST_MIDDLE);    

      $('list_bottom_container').style.display =
        Tugboat.constant.task.listStyle(
          TugboatUI.DragBox.selectedFolderId, Tugboat.constant.task.STYLE_LIST_BOTTOM);
    }
    //
    //-- MEETING
    //
    else if(functionType == self.FUNC_TYPE_MEETING){
      

      $('list_top').innerHTML = '';
      $('list_middle').innerHTML = '';
      $('list_bottom').innerHTML = '';
      Tugboat.gtd_common.meeting._setup_meeting_default_folder();
      
      $('list_top').style.display = 'block';
      $('list_middle').style.display = 'block';
      $('list_bottom').style.display = 'block';      
    }
    //
    //-- ACTIVITY
    //
    else if (functionType == self.FUNC_TYPE_ACTIVITY) {
    }
    if (Tugboat.isEmpty(transport.responseText)) return false;
    json = eval(transport.responseText);
    
    return (functionType == self.FUNC_TYPE_TASK ? self.task._create_list_dom(json) :
            functionType == self.FUNC_TYPE_MEETING ? self.meeting._create_list_dom(json) :
                                                     self.activity._create_list_dom(json));
  },

  /*
   * Task.
   * 
   * 
   */
  task : {
    pageInfo       : null,
    editTagsWindow : null,
    title_cells    : [],

    /**
     * create task list dom.
     * @param {Object} json
     */
    _create_list_dom : function (json) {
      $('dummy_drop_box').innerHTML = '';
      
      var ID_PREFIX = 'gtd_list_';
      var isExistsRules = false;
      TugboatUI.DragBox.folderRules.each(
        function(rule) {
          if (TugboatUI.DragBox.selectedFolderId == rule.selectedFolderId 
            && rule.draggableAllowFolders.length > 0) {
            isExistsRules = true;
          }
        }
      );
      
      var self = Tugboat.gtd_common.task;
      self.pageInfo = json.page;
      
      $('res_number').innerHTML = self.pageInfo.results + ' results';
      $('res_page').innerHTML   = 
        (self.pageInfo.currentPageNumber < 0 
        ? '1'
        : self.pageInfo.currentPageNumber) + '/' + self.pageInfo.totalPages + ' page';
      
      $('page_prev').className = 
        self.pageInfo.totalPages==1 
     || self.pageInfo.currentPageNumber==1 
        ? 'page_prev_off' : 'page_prev';
        
      $('page_next').className = 
        self.pageInfo.totalPages==1 
     || self.pageInfo.currentPageNumber==self.pageInfo.totalPages 
        ? 'page_next_off' : 'page_next';
      
      var is_selected_tags = 
        Tugboat.isEmpty(TugboatUI.DragBox.selectedFolderId);

      var elMainPane = YAHOO.util.Dom.getRegion('main_pane');
      var title_column_header_width = (elMainPane.right - elMainPane.left) - 335;
      if (title_column_header_width < 430) title_column_header_width = 430;
      $('list_column_header_title').style.width = title_column_header_width + 'px';

      self.title_cells = [];

      var ul = null;
      var tasks = json.tasks;
      tasks.each(
        function(t) {
          ul = t.statusId== Tugboat.constant.task.STATUS_TODO.id  ? $('list_top') :
               t.statusId== Tugboat.constant.task.STATUS_DOING.id ? $('list_middle') 
                                                                  : $('list_bottom');
          var isFolderAll = 
            TugboatUI.DragBox.selectedFolderId == 'folder_all' || is_selected_tags;
          var blockStyle = 
            Tugboat.constant.task.blockStyle(t.statusId, t.classId, t.isMe, isFolderAll);
            
          var title_cell = null;

          var list =
          LI({'id':ID_PREFIX + t.id, 'class':'default'},
            [
              DIV({'class':blockStyle.class_name},
                [
                  function() {
                    var folderDiv = null;
                    if (is_selected_tags) {
                      folderDiv = 
                        DIV({'class': t.classId == 1  ? 'class_icon today'  :
                                      t.classId == 2  ? 'class_icon week'   :
                                      t.classId == 3  ? 'class_icon month'  :
                                      t.classId == 4  ? 'class_icon hold'   :
                                      t.classId == 5  ? 'class_icon someday':
                                      t.classId == 9  ? 'class_icon inbox'  :
                                      t.classId == 21 ? 'class_icon archive':
                                      t.classId == 99 ? 'class_icon trash_box_folder'  
                                                      : 'class_icon'});
                    }
                    else {
                      folderDiv = (TugboatUI.DragBox.selectedFolderId != 'folder_all')
                                ? DIV({'class': 'class_icon'})
                                : DIV({'class': t.classId == 1 ? 'class_icon today'  :
                                                t.classId == 2 ? 'class_icon week'   :
                                                t.classId == 3 ? 'class_icon month'  :
                                                t.classId == 4 ? 'class_icon hold'   :
                                                t.classId == 5 ? 'class_icon someday'
                                                               : 'class_icon'});
                    }
                    return folderDiv;
                  },
                  DIV({'id':'task_list_activity-' + t.id,
                       'class':'activity_icon a_' + t.activityColor,
                       'title':'Activity: [' + t.activityName + ']'}),
                  //DIV({'class': 'status'}),
                  
                  // for block-mode.
                  P({'class':'title',
                     'onclick':function(){
                         if ($('list_pane').className.indexOf('block_mode') > -1 ) {
                           return false;
                         } else {
                           self._list_title_onclick(t.id);
                           this.blur();
                         }
                       }
                     },
                    [
                      A({'id':'task_list_block_title-' + t.id,
                         'class':'block',
                         'onclick': function(){
                            Tugboat.gtd_common.show_block_balloon(
                              null, t.id,  Tugboat.gtd_common.FUNC_TYPE_TASK);
                            this.blur();
                          }
                        }, t.title
                      ),
                      A({'id':'task_list_title-' + t.id, 'class':'list', 'href':'javascript:void(0);'}, t.title) 
                    ]
                  ),
                  
                  // for list-mode.
                  title_cell = P({'class':'title_for_list',
                     'style':'width:' + (title_column_header_width + 10) + 'px',
                     'onclick':function(){
                         if ($('list_pane').className.indexOf('block_mode') > -1 ) {
                           return false;
                         } else {
                           self._list_title_onclick(t.id);
                           this.blur();
                         }
                       }
                     },
                    [
                      function() {
                        return self._create_tag_list_dom(t, 'list');
                      },
                      A({'id':'task_list_title-' + t.id, 'class':'list', 'href':'javascript:void(0);'}, t.title) 
                    ]
                  ),
                  P({'id':'task_list_due-' + t.id, 'class':'due'}, t.due == '' ? 'N/A' : t.due),
                  P({'class':'personInCharge'}, t.isMe ? '[Me]' : (t.personInChargeLastName + ',' + t.personInChargeFirstName) )
                ]
              ),
              DIV({'id':'list_detail_container-' + t.id , 'class':'detailContainer', 'style':'display:none'}),
              DIV({'class':'block_tags'},
                   function(){return self._create_tag_list_dom(t, 'block');})
            ]
          );

          list.ondblclick = function() {
            if ($('list_pane').className == 'list_mode' 
             || $('list_pane').className == '') return false;

            Tugboat.gtd_common.show_block_balloon(
              null, t.id,  Tugboat.gtd_common.FUNC_TYPE_TASK);
          };
          ul.appendChild(list);
        
          if (t.isMe && t.classId != Tugboat.constant.task.CLASS_ARCHIVES) {
            new TugboatUI.DragBox(
              list.id, ID_PREFIX, 'block', t.statusId, t.classId, t.activityColor);
          }
          self.title_cells.push(title_cell);
        }
      );
      
      var list_bottom = $('list_bottom');
      if (list_bottom) {
        var elBottomHeader = YAHOO.util.Dom.getRegion('list_bottom_caption');
        var height = (elMainPane.bottom - elBottomHeader.bottom);
        if (height - 30 < 0) {
        } else {
          list_bottom.style.height= (height - 30) + 'px';
        }
      }
      return tasks;
    },
    
    /**
     * create tag list dom.
     * 
     * @param {Object} t
     * @param {String} mode - [block/list]
     */
    _create_tag_list_dom : function(t, mode) {
      if (!t.tags) 
        return (P({'id': 'gtd_tags_' + mode + '-' + t.id, 'class':'tag'}, ''));;
      
      var tags_value = '';
      var i = 0;
      t.tags.each(
        function(tag) {
          i++;
          tags_value += tag.tagValue + (t.tags.length==i ? '' : ', ');
        }
      );
      return (P({'id': 'gtd_tags_' + mode + '-' + t.id, 'class':'tag'}, tags_value));
    },
    
    /**
     * list title onclick.
     * 
     * @param {Number} id
     */
    _list_title_onclick : function(id) {
      var element = $('list_detail_container-' + id);
      element.innerHTML = '';
      
      var display = element.style.display;
      element.style.display = (display=='none' ? 'block' : 'none');
      $('gtd_list_'+id).className = (display=='none' ? 'default expanded' : 'default');
      if (display == 'block') return false;

      // get data. same create balloon.
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {   
          method: Tugboat.constant.REQUEST_GET,
          parameters: 
          {
            component: 'taskAjax',
            action   : 'getTaskForBalloonJSON',
            id       : id
          },
          onComplete: function(transport){
            if (Tugboat.isEmpty(transport.responseText)) return false;
            
            var self = Tugboat.gtd_common.task;
            var json = eval('(' + transport.responseText + ')');
                        
            self._list_title_create_dom(json);
            self._getTaskToTasksAndTrackbacksJSON(id, $('list_detail_link-' + id));
          }
        }
      );
    },
    
    /**
     * create list title's dom.
     * 
     * @param {Object} json
     */
    _list_title_create_dom : function(json) {
      var self = Tugboat.gtd_common.task;
      var table = 
        TABLE({'class':'tableStyleB'},
          TBODY(null,
          [
            TR(null,
              [
                TH(null,'Title:'),
                TD(null,
                  [
                  A({'id':'task_summary_title-' + json.task.id,
                     'href':'gtdTaskDetail.html?taskId=' + json.task.id},json.task.title),
                  IMG({'src':'images/default/icon/lastpost.gif', 'class':'left_and_right_5px_margin'})
                  ]
                )
              ]
            ),
            TR(null,
              [
                TH(null,'Discription:'),
                function() { 
                  var td = TD({'id':'task_summary_description-' + json.task.id, 'style':'padding-bottom:3px;'});
                  td.innerHTML = json.task.description.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
                  return td;
                }
              ]
            ),
            
            TR(null,
              [
                TH(null,'Person in charge:'),
                TD(null, json.task.personName )
              ]
            ),
            
            TR(null,
              [
                TH(null,'Due:'),
                TD({'id':'task_summary_due-' + json.task.id}, Tugboat.isEmpty(json.task.dueFormated) ? 'N/A' : json.task.dueFormated )
              ]
            ),
            
            TR(null,
              [
                TH(null,'Link:'),
                TD(null,
                  UL({'id':'list_detail_link-'+json.task.id})
                )
              ]
            ),
            TR(null,
              [
                TH(null,'Tags:'),
                TD(null,
                  [
                    DIV({'id':'list_detail_tags-'+json.task.id},
                      [
                        function() {
                          if (!json.tags) return null;
                          
                          var tags = [];
                          for (i=0; i<json.tags.length; i++) {
                            tags.push(SPAN({'class':'tag_text'},json.tags[i].tagValue + (i == json.tags.length - 1 ? '' : ',')))
                          }
                          return tags;
                        }
                      ]
                    )
                  ]
                )
              ]
            ),
            TR(null,
              [
                TH(null),
                TD(null,
                  [
                    P({'style':'line-height:1.5; text-align:left; color:#666;'},
                      'Permalink: ' + document.URL.replace(/view\/.*/,'browse/tasks/' + json.task.id)
                    ),
                    A({'href':'javascript:void(0);', 
                       'onclick':function(){Tugboat.gtd_task.edit_task(json.task.id);}}, 'quick edit'),
                    SPAN({'style':'padding-left:15px;'},'Created by ' + json.task.postedBy + ' at ' + json.task.postedAt),
                    P({'style':'line-height:1.5; text-align:right;'},
                      A({'href':'javascript:void(0);', 
                         'style':'padding-right:5px;',
                         'onclick':function(){
                           $('list_detail_container-' + json.task.id).style.display = 'none';
                           $('gtd_list_' + json.task.id).className = 'default';
                          }
                        }, '[x] close'
                      )
                    )
                  ]
                )
              ]
            )
          ]
          )
        );
      
      $('list_detail_container-' + json.task.id).appendChild(table);
    },

    /**
     * setup task default folder.
     */
    _setup_task_default_folder : function() {
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {
          method: Tugboat.constant.REQUEST_GET,
          parameters:
          {
            component:'taskAjax',
            action   :'getDefaultFolderTasks'
          },
          onComplete: function(transport){
            var json = eval('(' + transport.responseText + ')');
            if (! json) return;

            $('task_folder_all').innerHTML     = json.allTasks;
            $('task_folder_inbox').innerHTML   = json.inboxTasks;
            $('task_folder_today').innerHTML   = json.todayTasks;
            $('task_folder_week').innerHTML    = json.weekTasks;
            $('task_folder_month').innerHTML   = json.monthTasks;
            $('task_folder_hold').innerHTML    = json.holdTasks;
            $('task_folder_someday').innerHTML = json.somedayTasks;

            $('task_today_todo').innerHTML     = json.todayToDoTasks;
            $('task_today_doing').innerHTML    = json.todayDoingTasks;
            $('task_today_done').innerHTML     = json.todayDoneTasks;

            $('task_folder_archives').innerHTML= json.archiveTasks;
            $('task_folder_trash').innerHTML   = json.trashBoxTasks;
          }
        }
      );
    },
  
    /**
     * setup task droppables.
     */
    setup_task_droppables : function() {
      if (TugboatUI.DragBox.dropTargetStyles.length > 0) return false;
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_INBOX.id,      'block');
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_TODAY.id,      'block');
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_WEEK.id,       'block');
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_MONTH.id,      'block');
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_HOLD.id,       'block');
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_SOMEDAY.id,    'block');
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_TODAY_TODO.id, 'block');
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_TODAY_DOING.id,'block');
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_TODAY_DONE.id, 'block');
      new YAHOO.util.DDTarget(Tugboat.constant.task.FOLDER_TRASH_BOX.id,  'block');
      
      new YAHOO.util.DDTarget('list_top',   'block');
      new YAHOO.util.DDTarget('list_middle','block');
      new YAHOO.util.DDTarget('list_bottom','block');
      
      TugboatUI.DragBox.dropTargetStyles = Tugboat.constant.task.droppableTargetStyle();
      TugboatUI.DragBox.folderRules = Tugboat.constant.task.droppableFolderRules();
    },
    /**
     * create task balloon.
     * @param {Object} transport
     */
    _create_balloon : function(transport) {
      var json = eval('(' + transport.responseText + ')');
      
      //-- title.
      var titleAreaHtml = '';
      titleAreaHtml += '<img class="left_and_right_3px_margin" '
      titleAreaHtml += 'src="images/default/palette/pl_bg_' + json.task.activityColor + '.gif" />';
      titleAreaHtml += '<a href="gtdTaskDetail.html?taskId='+ json.task.id + '">' + json.task.title + '</a>';
      $('block_balloon_item_calendar').innerHTML = titleAreaHtml;
     
      //-- icons.
      var self = Tugboat.gtd_common.task;
      var status = Tugboat.constant.task.statusValue(json.task.statusId);
      var statusIcon = status.icon;
      var statusValue = status.value;
      
      var classification = 
        Tugboat.constant.task.classValue(json.task.classId);
      var classIcon = classification.icon;
      var classValue = classification.value;
    
      var iconsAreaHtml = '';
      iconsAreaHtml += '<img src="' + statusIcon + '" class="left_and_right_3px_margin"/>';
      iconsAreaHtml += statusValue;
      iconsAreaHtml += '&nbsp;<img src="' + classIcon  + '" class="left_and_right_3px_margin" />';
      iconsAreaHtml += classValue;
      iconsAreaHtml += '&nbsp;<img class="left_and_right_3px_margin" ';
      iconsAreaHtml += 'src="images/default/palette/pl_bg_' + json.task.activityColor + '.gif" />';
      iconsAreaHtml += json.task.activityName;
     
      $('block_balloon_item_icons').innerHTML = iconsAreaHtml;
     
      var personInCharge = 'Person In Charge: ' + json.task.personName;
      $('detail_balloon_option_1').innerHTML = personInCharge;
      
      var due = 'Due: ' + json.task.dueFormated;
      $('detail_balloon_option_2').innerHTML = due;
      
      // setup tags.
      var balloon_item_tags = $('block_balloon_item_tags');
      balloon_item_tags.innerHTML = '';
      
      var tagsText = '';
      var tag_span_elements = [];
      
      if (json.tags) {
        for (i=0; i<json.tags.length; i++) {
          var tag = json.tags[i].tagValue + (i == json.tags.length - 1 ? '' : ',');
          tagsText += tag;
          tag_span_elements.push(SPAN({'class':'tag_text'}, tag));
        }
      }
      var tag_values_container = 
        DIV({'id':'tag_values_container_' + json.task.id, 'style':'float:left'});

      if (tag_span_elements) {
        tag_span_elements.each(
          function(e) {
            tag_values_container.appendChild(e);
          }
        );
      }
      balloon_item_tags.appendChild(tag_values_container);
      
      // setup posted at.
      $('block_balloon_edit_link').onclick = function() {
        Tugboat.gtd_task.edit_task(json.task.id);
      }
      
      $('block_balloon_item_posted').innerHTML = 
        'Created by ' + json.task.postedBy + ' at ' + json.task.postedAt;
      
      var self = Tugboat.gtd_common.task;
      self._getTaskToTasksAndTrackbacksJSON(
        json.task.id, $('block_balloon_item_links_list'));
    },
    
    /**
     * get task to tasks and trackbacks.
     * 
     * @param {Number} taskId
     * @param {Object} ulElement
     */
    _getTaskToTasksAndTrackbacksJSON : function(taskId, ulElement) {
      var self = Tugboat.gtd_common.task;
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component :'taskDetailAjax',
            action    :'getTaskToTasksAndTrackbacksJSON',
            id        :taskId
          },
          onComplete: function(transport){
            ulElement.innerHTML = '';
            
            if (!transport.responseText || transport.responseText == 'null') {
              return false;
            }
            var json = eval(transport.responseText);
            
            //-- related tasks.
            if (json.taskToTasks) {
              json.taskToTasks.each(
                function (t) {
                  if (taskId == t.destinationTaskId) {
                    var li =
                    LI({'class':'oneliner'},
                      [
                      IMG({'src':'images/default/icon/chart_organisation_parent.gif','class':'left_and_right_3px_margin'}),
                      A(
                        { 'href':'gtdTaskDetail.html?taskId=' + t.sourceTaskId + '&sid=' + Tugboat.dateSerialize(new Date())
                        },t.sourceTitle
                      )
                      ]
                    );
                    ulElement.appendChild(li);
                  }
                }
              );
            
              //-- task to tasks.
              json.taskToTasks.each(
                function (t) {
                  if (taskId == t.sourceTaskId) {
                    var li =
                    LI({'class':'oneliner'},
                      [
                      IMG({'src':'images/default/icon/chart_organisation_child.gif','class':'left_and_right_3px_margin'}),
                      A(
                        { 'href':'gtdTaskDetail.html?taskId=' + t.destinationTaskId + '&sid=' + Tugboat.dateSerialize(new Date())
                        },t.destinationTitle
                      )
                      ]
                    );
                    ulElement.appendChild(li);
                  }
                }
              );
            }
            
            //-- meeting to tasks.
            if (json.meetingToTasks) {
              json.meetingToTasks.each(
                function(t) {
                  var li =
                  LI({'class':'oneliner'},
                    [
                    IMG({'src':'images/default/icon/contact_group.gif','class':'left_and_right_3px_margin'}),
                    A(
                      { 'href':'gtdMeetingDetail.html?id=' + t.basicId + '&sid=' + Tugboat.dateSerialize(new Date())
                      },t.meetingTitle
                    )
                    ]
                  );
                  ulElement.appendChild(li);
                }
              );
            }            
          }
        }
      );
    }
  },
  
  /*
   * Meeting.
   * 
   * 
   */
  meeting : {
    LM_STATUS_NEW  : 1,
    LM_STATUS_OPEN : 2,
    LM_STATUS_DONE : 3,
    _lm_status : [
      {id:1, value:'New',   icon:'images/default/folder/gif/status_todo.gif'},
      {id:2, value:'Open',  icon:'images/default/folder/gif/marker.gif'},
      {id:3, value:'Close', icon:'images/default/folder/gif/status_done.gif'}
    ],
    _find_lm_status : function(id) {
      var status = Tugboat.gtd_common.meeting._lm_status.find( function(s){
        return (id == s.id);
      });
      return status;
    },
    
    /**
     * setup meeting default folder.
     */
    _setup_meeting_default_folder : function() {
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component:'meetingAjax',
            action   :'getFolderMeetingCountJson'
          },
          onComplete: function(transport){
            var json = eval('(' + transport.responseText + ')');
            if (! json) return;
          
            $('folder_all_count').innerHTML      = json.libraryCount;          
            $('folder_archives_count').innerHTML = json.archivesCount;
          }
        }
      );
    },

    /**
     * create meeting list dom.
     * @param {Object} json
     */
    _create_list_dom : function(json) {
      var self = Tugboat.gtd_common.meeting;
      var pageInfo = json.page;

      var pageInfo = json.page;
      $('res_number').innerHTML = pageInfo.results + ' results';
      $('res_page').innerHTML   = pageInfo.currentPageNumber + '/' + pageInfo.totalPages + ' page';
      
      $('page_prev').className = 
        pageInfo.totalPages==1 || pageInfo.currentPageNumber==1 ? 'page_prev_off' : 'page_prev';
      
      $('page_next').className = 
        pageInfo.totalPages==1 || pageInfo.currentPageNumber==pageInfo.totalPages ? 'page_next_off' : 'page_next';  
      
      $('dummy_drop_box').innerHTML = '';
      var ID_PREFIX = 'gtd_list_';
      var isThreeSection = true;
   
      var ul = null;
      var meetings = json.meetings;
      meetings.each(
        function(m) {
          if (isThreeSection) {
            ul = m.statusId == self.LM_STATUS_NEW
               ? $('list_top')
               : m.statusId == self.LM_STATUS_OPEN
                 ? $('list_middle')
                 : $('list_bottom');
          }
          appendChildNodes(ul,
            function(){
              var liMeeting = 
              LI({'class':'default', 'id':'gtd_list_' + m.id},
                [
                  DIV(
                    {'class': m.statusId=='1' ? 'meeting meeting_new'  : 
                              m.statusId=='2' ? 'meeting meeting_open' 
                                              : 'meeting meeting_close'
                    },
                    [
                      DIV({'class':'pushpin'}),
                      DIV({'class':m.statusId=='1' ? 'status' :
                                   m.statusId=='2' ? 'status' 
                                                   : 'status done'
                           }),
                      DIV({'class':'activity_icon a_' + m.activityColor, 'title':'Activity: [' + m.activityName + ']'}),
                      P({'class':'title'}, 
                        [
                          A({'class':'block',
                             'href':'javascript:void(0);',
                             'onclick':function(){
                              Tugboat.gtd_common.show_block_balloon(
                                null, m.id,  Tugboat.gtd_common.FUNC_TYPE_MEETING);
                              this.blur();
                            }
                          },m.title),
                          A({'class':'list',
                             'href':'javascript:void(0);',
                             'onclick':function(){
                               self._list_title_onclick(m.id);
                               this.blur();}
                             }, m.title)
                        ]
                      ),
                      P({'class':'posted'},m.postedByLastName + ',' + m.postedByFirstName),
                      P({'class':'posted'},m.postedAt)
                    ]
                  ),
                  DIV({'id':'list_detail_container-' + m.id ,
                       'class':'detailContainer',
                       'style':'display:none'})
                ]
              );
              liMeeting.ondblclick = function() {
                if ($('list_pane').className == 'gtdList') return false;
                
                Tugboat.gtd_common.show_block_balloon(
                  null, m.id,  Tugboat.gtd_common.FUNC_TYPE_MEETING);
              };
              return liMeeting;              
            }           
          );
        }
      );
      return meetings;
    },
    
    /**
     * list title onclick.
     * 
     * @param {Number} id
     */
    _list_title_onclick : function(id) {
      var element = $('list_detail_container-' + id);
      element.innerHTML = '';
      
      var display = element.style.display;
      element.style.display = (display=='none' ? 'block' : 'none');
      $('gtd_list_'+id).className = (display=='none' ? 'default expanded' : 'default');
      if (display == 'block') return false;

      // get data. same create balloon.
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        {   
          method: Tugboat.constant.REQUEST_GET,
          parameters: 
          {
             component : 'meetingAjax',
             action    : 'getMeetingBalloonJson',
            id         : id
          },
          onComplete: function(transport){
            if (Tugboat.isEmpty(transport.responseText)) return false;
            
            // create dom.
            var self = Tugboat.gtd_common.meeting;
            var json = eval('(' + transport.responseText + ')');
            
            self._list_title_create_dom(json);
          }
        }
      );
    },
    
    /**
     * list title create dom.
     * 
     * @param {Object} json
     */
    _list_title_create_dom : function(json) {
      var self = Tugboat.gtd_common.meeting;
      var table = 
        TABLE({'class':'tableStyleB'},
          [
          TBODY(null,
            [
              TR(null,
                [
                  TH(null,'Title:'),
                  TD(null,
                    [
                    A({'href':'gtdMeetingDetail.html?id=' + json.id},json.title),
                    IMG({'src':'images/default/icon/lastpost.gif', 'class':'left_and_right_5px_margin'})
                    ]
                  )
                ]
              ),
              TR(null,
                [
                  TH(null,'Discription:'),
                  function() { 
                    var td = TD({'style':'padding-bottom:3px;'});
                    td.innerHTML = json.description.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
                    return td;
                  }
                ]
              ),
              TR(null,
                [
                  TH(null,'Task(s):'),
                  TD({'id':'list_detail_link-' + json.id},

                    UL(null,
                      function() {
                        var link_elements = [];
                        json.links.each(
                          function(j) {
                            var list = LI({'class':'oneliner'});
                            var task_status_img = 
                              j.taskStatusId == '1' ? 'status_todo.gif' :
                              j.taskStatusId == '2' ? 'status_doing.gif'
                                                    : 'status_done.gif';

                            list.appendChild(
                              IMG({'class':'left_and_right_3px_margin','border':'0',
                                   'src':'images/default/folder/gif/' + task_status_img})
                            );
                          
                            var task_class_img = 
                              j.taskClassId == '1'  ? 'folder-red-16.gif'    :
                              j.taskClassId == '2'  ? 'folder-orange-16.gif' :
                              j.taskClassId == '3'  ? 'folder-yellow-16.gif' :
                              j.taskClassId == '4'  ? 'folder-green-16.gif'  :
                              j.taskClassId == '5'  ? 'folder-blue-16.gif'   :
                              j.taskClassId == '9'  ? 'inbox-16.gif'         :
                              j.taskClassId == '21' ? 'folder-gray-16.gif'
                                                    : 'folder-gray-16.gif';
                            
                            list.appendChild(
                              IMG({'class':'left_and_right_3px_margin','border':'0',
                                   'src':'images/default/folder/gif/' + task_class_img})
                            );
                          
                            list.appendChild(
                              A({'href':'gtdTaskDetail.html?taskId=' + j.id}, j.title)
                            );
                            link_elements.push(list);
                          }
                        );
                        return link_elements;
                      }
                    )
                  )
                ]
              ),
              TR(null,
                [
                  TH(null),
                  TD(null,
                    [
                      P({'style':'line-height:1.5; text-align:left; color:#666;'},
                        'Permalink: ' + document.URL.replace(/view\/.*/,'browse/meetings/' + json.id)
                      ),
                      'Created by ' + json.postedBy + ' at ' + json.postedAt,
                      P({'style':'line-height:1.5; text-align:right;'},
                        A({'href':'javascript:void(0);', 
                           'style':'padding-right:5px;',
                           'onclick':function(){
                             $('list_detail_container-' + json.id).style.display = 'none';
                             $('gtd_list_' + json.id).className = 'default';
                            }
                          }, '[x] close'
                        )
                      )
                    ]
                  )
                ]
              )
            ]
            )
          ]
        );
      $('list_detail_container-' + json.id).appendChild(table);
    },
  
    /**
     * create meeting balloon.
     * @param {Object} transport
     */
    _create_balloon : function(transport) {
      var self = Tugboat.gtd_common.meeting;
      
      var json = eval('(' + transport.responseText + ')');
      //-- title.
      var titleUrl="gtdMeetingDetail.html?id="+json.id;
      var titleAreaHtml = '';
      titleAreaHtml += '<img class="left_and_right_3px_margin" '
      titleAreaHtml += 'src="images/default/palette/pl_bg_' + json.activityColor + '.gif" />';
      titleAreaHtml += '<a href="'+titleUrl+'">' + json.title + '</a>';
      $('block_balloon_item_calendar').innerHTML = titleAreaHtml;
    
      //-- icons.
      var status = self._find_lm_status(json.statusId);
      var statusIcon = status.icon;
      var statusValue = status.value;
      var iconsAreaHtml = '';
      iconsAreaHtml += '<img src="' + statusIcon + '" class="left_and_right_3px_margin"/>';
      iconsAreaHtml += statusValue;
      $('block_balloon_item_icons').innerHTML = iconsAreaHtml;

      var createdAtHtml = '';
      createdAtHtml = '<p class="left_and_right_3px_margin">Created by ' + json.postedBy + ' at ' + json.postedAt + '</p>';
      $('detail_balloon_option_1').innerHTML = createdAtHtml;    
      $('detail_balloon_option_2').innerHTML = ""; 

      var linksAreaHtml = '<ul>';
      var linkUrl='';
      for(var i = 0; i < json.links.length; i++){
        var status_img =
          json.links[i].taskStatusId == '1' ? 'status_todo.gif' :
          json.links[i].taskStatusId == '2' ? 'status_doing.gif'
                                            : 'status_done.gif';
        var class_img =
          json.links[i].taskClassId == '1'  ? 'folder-red-16.gif'    :
          json.links[i].taskClassId == '2'  ? 'folder-orange-16.gif' :
          json.links[i].taskClassId == '3'  ? 'folder-yellow-16.gif' :
          json.links[i].taskClassId == '4'  ? 'folder-green-16.gif'  :
          json.links[i].taskClassId == '5'  ? 'folder-blue-16.gif'   :
          json.links[i].taskClassId == '9'  ? 'inbox-16.gif'         :
          json.links[i].taskClassId == '21' ? 'folder-gray-16.gif'
                                            : 'folder-gray-16.gif';

        linkUrl="gtdTaskDetail.html?taskId=" + json.links[i].id;
        linksAreaHtml += '<img src="images/default/folder/gif/' + status_img + '" border="0" class="left_and_right_3px_margin" />';
        linksAreaHtml += '<img src="images/default/folder/gif/' + class_img  + '" border="0" class="left_and_right_3px_margin" />';
        linksAreaHtml += '<a href="'+linkUrl+'">' + json.links[i].title + '</a><br/>';
      }
      linksAreaHtml += '</ul>';
      $('block_balloon_item_links').innerHTML = linksAreaHtml;      
    
      //-- posted by ... at ...
      $('block_balloon_item_posted').innerHTML = 
        'Posted by ' + json.postedBy + ' at ' + json.postedAt;
    }
  },

  activity : {
    /**
     * create activity list dom.
     * @param {Object} json
     */
    _create_list_dom : function(json) {
      var ul = $('list_top');
      ul.innerHTML = '';

      var self = Tugboat.gtd_common.task;
      self.pageInfo = json.page;
      
      $('res_number').innerHTML = self.pageInfo.results + ' results';
      $('res_page').innerHTML   = 
        self.pageInfo.currentPageNumber + '/' + self.pageInfo.totalPages + ' page';
      
      $('page_prev').className = 
        self.pageInfo.totalPages==1 
     || self.pageInfo.currentPageNumber==1 
        ? 'page_prev_off' : 'page_prev';
        
      $('page_next').className = 
        self.pageInfo.totalPages==1 
     || self.pageInfo.currentPageNumber==self.pageInfo.totalPages 
        ? 'page_next_off' : 'page_next';

      var ID_PREFIX = 'gtd_list_';
      var members = json.members;
      members.each(
        function(member) {
          var list = 
            LI({'class':'default', 'id':'gtd_list_'+member.id},
              DIV(
                {'class':'activity'},
                [
                  DIV({'class':'pushpin'}),
                  DIV({'class':'photo'},
                    IMG({'src':'images/default/contacts/photoFrameL.gif','height':'60','width':'60'})  
                  ),
                  P({'class':'memberLastName'},
                    A({'onclick': function(){
                          Tugboat.gtd_activity.sub_window.editMember_onclick(member);
                        }
                      }, member.lastName
                    )
                  ),
                  P({'class':'memberFirstName'},
                    A({'onclick':function(){
                          Tugboat.gtd_activity.sub_window.editMember_onclick(member);
                        }
                      },member.firstName
                    )
                  ),
                  P({'class':(member.roleId == '1' ? 'memberRole owner' : member.roleId == '2' ? 'memberRole user' : 'memberRole guest')},
                             (member.roleId == '1' ? 'Owner'            : member.roleId == '2' ? 'User'            : 'Guest')),
                  P({'class':'memberFullName'},
                    A({'onclick':function(){
                          Tugboat.gtd_activity.sub_window.editMember_onclick(member);                    
                        }
                      },(member.lastName + ', ' + member.firstName)
                    )
                  ),
                  P({'class':'memberJoined'},member.registeredFormated)
                ]
              )
            );
          list.ondblclick = function() {
            Tugboat.gtd_activity.sub_window.editMember_onclick(member);
          };
          ul.appendChild(list);
        }
      );
    }
  },

  /**
   * resize list area.
   * 
   * @param isVisibleBrowser
   * @param isCallToggleBrowser
   */
  resize_list_area : function(isVisibleBrowser, isCallToggleBrowser) {
    Element.show('folders_pane');
    Element.show('list_pane');
    Element.show('main_pane');

    var window_size = Tugboat.getPageSize();
    //
    // folder area.
    //
    var folderPane = $('folders_pane');
    var elMenuBarPane = YAHOO.util.Dom.getRegion('menuBar_ul');
    
    folderPane.style.height = (window_size.windowHeight - elMenuBarPane.bottom) + 'px';

    //
    // contents area.
    //
    var mainPane = $('main_pane');
    var elFolderPane = YAHOO.util.Dom.getRegion('folders_pane');
    var elMainPaneWidth = window_size.windowWidth - (elFolderPane.left + elFolderPane.right);
    
    var isIE6 = navigator.userAgent.indexOf('MSIE 6.0') > -1;
    mainPane.style.width =
      (window_size.windowWidth < 960 ? 770 : (elMainPaneWidth + (isIE6 ? 4 : 0))) + 'px';
    
    // list/block pane.
    var BROWSER_HEIGHT = Tugboat.gtd_common.BROWSER_HEIGHT;
    var elGtdListPane = YAHOO.util.Dom.getRegion('list_pane');
    var pane_height = 0;
    if (isCallToggleBrowser) {
      pane_height = 
        window_size.windowHeight 
        - elGtdListPane.top + (!isVisibleBrowser && isCallToggleBrowser ? BROWSER_HEIGHT : 0)
        - (isVisibleBrowser ? BROWSER_HEIGHT : 0);
    }
    else {
      var isShownBrowserPane = Element.visible('browser_pane')
      pane_height = window_size.windowHeight - elGtdListPane.top;
    }
  
    if (pane_height<0) pane_height = 1000;
    $('list_pane').style.height = pane_height + 'px';
    
    // balloon.
    var displayBalloon = $('block_balloon').style.display;
    if (displayBalloon == Tugboat.constant.STYLE_DISPLAY_BLOCK) {
      $('block_balloon').style.display = Tugboat.constant.STYLE_DISPLAY_NONE;
    }
    
    // list bottom resize.
    var list_bottom = $('list_bottom');
    if (list_bottom) {
      var elMainPane = YAHOO.util.Dom.getRegion('main_pane');
      var elBottomHeader = YAHOO.util.Dom.getRegion('list_bottom_caption');
      var height = (elMainPane.bottom - elBottomHeader.bottom);

      if (height) {
        if (height - 30 < 0) {
        } else {
          list_bottom.style.height = (height - 30) + 'px';
        }
      }
    }
    
    // task list title column resize.
    if (Tugboat.gtd_common.task.title_cells && $('list_column_header_title')) {
      var elMainPane = YAHOO.util.Dom.getRegion('main_pane');
      var title_column_header_width = (elMainPane.right - elMainPane.left) - 335;
      if (title_column_header_width < 430) title_column_header_width = 430;
      $('list_column_header_title').style.width = title_column_header_width + 'px';
      
      Tugboat.gtd_common.task.title_cells.each(
        function(p) {
          p.style.width = (title_column_header_width + 10) + 'px';
        }
      );
    }
  },
  
  /**
   * set application window size.
   * 
   */
  set_application_window_size : function() {
    var window_size = Tugboat.getPageSize();
    var window_width  = window_size.windowWidth;
    var isOverflow = window_width < 960;
    $('container').style.width    = isOverflow ? '960px' : '100%';
    $('content_body').style.width = isOverflow ? '960px' : '100%';
    $('html').className           = isOverflow ? 'overflow_auto' : 'one_column';
  },

  BOX_WIDTH : 148,
  BOX_HEIGHT: 130,
  BALLOON_MODE_TOP_LEFT     : 1,
  BALLOON_MODE_TOP_RIGHT    : 2,
  BALLOON_MODE_RIGHT_TOP    : 3,
  BALLOON_MODE_RIGHT_BOTTOM : 4,
  BALLOON_MODE_BOTTOM_RIGHT : 5,
  BALLOON_MODE_BOTTOM_LEFT  : 6,
  BALLOON_MODE_LEFT_BOTTOM  : 7,
  BALLOON_MODE_LEFT_TOP     : 8,
  BALLOON_ATTRIBUTE : 
  [
    {top:20,   left:-50,  class_name:'block_balloonTopLeft'},
    {top:20,   left:-50,  class_name:'block_balloonTopLeft'},
    {top:20,   left:-360, class_name:'block_balloonTopRight'},
    {top:-50,  left:-445, class_name:'block_balloonRightTop'},
    {top:-230, left:-445, class_name:'block_balloonRightBottom'},
    {top:-305, left:-360, class_name:'block_balloonBottomRight'},
    {top:-305, left:-50,  class_name:'block_balloonBottomLeft'},
    {top:-230, left:120,  class_name:'block_balloonLeftBottom'},
    {top:-50,  left:120,  class_name:'block_balloonLeftTop'}
  ],

  /**
   * show block balloon.
   * 
   * @param {Object} anchorObject
   * @param {Object} id
   * @param {Object} functionType
   */
  show_block_balloon : function(anchorObject, id, functionType) {
    //anchorObject.blur();
    if (TugboatUI.DragBox.dragStarted) return;
    var self = Tugboat.gtd_common;
    var elGtdListPane = YAHOO.util.Dom.getRegion('list_pane');
    var elBlock       = YAHOO.util.Dom.getRegion('gtd_list_' + id);
    
    var elGridListPaneHeight = elGtdListPane.bottom - elGtdListPane.top;
    var elGridListPaneWidth  = elGtdListPane.right  - elGtdListPane.left;
    var amountOfCol = Math.floor(elGridListPaneWidth  / self.BOX_WIDTH);
    var amountOfRow = Math.round(elGridListPaneHeight / self.BOX_HEIGHT);
    var boxPosX = Math.floor((elBlock.left - elGtdListPane.left)/self.BOX_WIDTH ) + 1;
    var boxPosY = Math.round((elBlock.top  - elGtdListPane.top )/self.BOX_HEIGHT) + 1;
    
    var showMode = 0;
    if      (boxPosX == 1                         && boxPosY <= Math.round(amountOfRow/2)) showMode = self.BALLOON_MODE_LEFT_TOP;
    else if (boxPosX == amountOfCol               && boxPosY <= Math.round(amountOfRow/2)) showMode = self.BALLOON_MODE_RIGHT_TOP;
    else if (boxPosX == 1                         && boxPosY >  Math.round(amountOfRow/2)) showMode = self.BALLOON_MODE_LEFT_BOTTOM;
    else if (boxPosX == amountOfCol               && boxPosY >  Math.round(amountOfRow/2)) showMode = self.BALLOON_MODE_RIGHT_BOTTOM;
    else if (boxPosX <= Math.round(amountOfCol/2) && boxPosY <= Math.round(amountOfRow/2)) showMode = self.BALLOON_MODE_TOP_LEFT;
    else if (boxPosX >  Math.round(amountOfCol/2) && boxPosY <= Math.round(amountOfRow/2)) showMode = self.BALLOON_MODE_TOP_RIGHT;
    else if (boxPosX <= Math.round(amountOfCol/2) && boxPosY >  Math.round(amountOfRow/2)) showMode = self.BALLOON_MODE_BOTTOM_LEFT;
    else if (boxPosX >  Math.round(amountOfCol/2) && boxPosY >  Math.round(amountOfRow/2)) showMode = self.BALLOON_MODE_BOTTOM_RIGHT;
    
    $('block_balloon').className     = self.BALLOON_ATTRIBUTE[showMode].class_name;
    $('block_balloon').style.top     = (elBlock.top  + self.BALLOON_ATTRIBUTE[showMode].top ) + 'px';
    $('block_balloon').style.left    = (elBlock.left + self.BALLOON_ATTRIBUTE[showMode].left) + 'px';
    $('block_balloon').style.display = Tugboat.constant.STYLE_DISPLAY_BLOCK;
    
    // processing....
    $('block_balloon_item_icons').innerHTML = '';
    $('detail_balloon_option_1').innerHTML = '';
    $('detail_balloon_option_2').innerHTML = '';
    
    if ($('block_balloon_item_links_list')) $('block_balloon_item_links_list').innerHTML = '';
    if ($('block_balloon_item_tags')) $('block_balloon_item_tags').innerHTML = '';
    
    var component = '';
    var action = '';
    if (functionType == Tugboat.gtd_common.FUNC_TYPE_TASK) {
      component = 'taskAjax';
      action = 'getTaskForBalloonJSON';
    }
    else if (functionType == Tugboat.gtd_common.FUNC_TYPE_MEETING) {
      component = 'meetingAjax';
      action = 'getMeetingBalloonJson';
    }
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_GET,
        parameters: 
        {
          component: component,
          action   : action,
          id       : id
        },
        onComplete: function(transport){
          if (functionType == Tugboat.gtd_common.FUNC_TYPE_TASK) {
            self.task._create_balloon(transport);
          }
          else if (functionType == Tugboat.gtd_common.FUNC_TYPE_MEETING) {
            self.meeting._create_balloon(transport);
          }
        }
      }
    );
  }
};

YAHOO.util.Event.addListener(
  document, "keydown",
  function(key){
    if (key.keyCode == Event.KEY_ESC) {
      var elmBlockBalloon = $('block_balloon');
      if(elmBlockBalloon) {
        $('block_balloon').style.display=Tugboat.constant.STYLE_DISPLAY_NONE;
      }
    }
  }
);