/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

if (typeof(Tugboat) == 'undefined') {
  Tugboat = {};
}
if (typeof(Tugboat.gtd_admin) == 'undefined') {
  Tugboat.gtd_admin = {};
}

Tugboat.gtd_admin = {
  _editId : null,
  _users  : new Hash(),
  add_user_window: null,
  limit: 20,
  page : 0,
  result: 0,
  uploading: false,
  
  /**
   * initialize.
   * 
   */
  init: function() {
    var self = Tugboat.gtd_admin;

    // event rules.
    var rules = {
      '#menuBar_AddUser'  : function(el) {
        el.onclick = function() {
          Tugboat.gtd_admin.showWindow();
        }
      },
      '#menuBar_AddUsers' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_admin.showUsersWindow();
        }
      },
    
      '#add_user_add_button' : function(el) {
        el.onclick = function(){
          if($F('add_user_loginId') == '') {
            alert('LoginID is required');
            $('add_user_loginId').focus();
            return false;   
          }
          else if($F('add_user_password1') != $F('add_user_password2')) {
            alert('Password mismatch');
            $('add_user_password2').focus();
            return false;
          }
          else if($F('add_user_password1') == '') {
            alert('Please enter Password');
            $('add_user_password1').focus();
            return false;
          }
          else if($F('add_user_password2') == '') {
            alert('Please enter Password');
            $('add_user_password2').focus();
            return false;
          }
          else if($F('add_user_email') == '') {
            alert('Please enter Email');
            $('add_user_email').focus();
            return false;
          } 
          else if($F('add_user_firstName') == '') {
            alert('Please enter FirstName');  
            $('add_user_firstName').focus();
            return false;
          } 
          else if($F('add_user_lastName') == '') {
            alert('Please enter LastName');  
            $('add_user_lastName').focus();
            return false;
          }
          else {
            if(! self._editId) {
              new Ajax.Request(
                'teeda.ajax',
                { 
                  method: 'POST',
                  parameters:
                  {
                    component :'adminAjax',
                    action    :'add',
                    loginId   :$F('add_user_loginId'),
                    password  :$F('add_user_password1'),
                    email     :$F('add_user_email'),
                    lastName  :$F('add_user_lastName'),
                    firstName :$F('add_user_firstName'),
                    roleId    :$F('add_user_role')
                  },
                  onComplete: function(transport){
                    var self = Tugboat.gtd_admin;
                    if(transport.responseText == '') {
                      alert($F('add_user_loginId')+' is already exist');
                    }
                    else if(transport.responseText == 'email'){
                      alert('Email address is wrong');
                    }
                    else {
                      user = eval('('+transport.responseText+')');
//                      Tugboat.gtd_admin.appendUser(user);
//                      self._users[user.userId] = user;
                      self.list();
                      el.blur();
                      Windows.closeAll();
                      self.modal.close();
                    }
                  }
                }
              );                            
            }
            else {
              new Ajax.Request(
                'teeda.ajax',
                { 
                  method: 'POST',
                  parameters:
                  {
                    component :'adminAjax',
                    action    :'update',
                    userId    :self._editId,
                    loginId   :$F('add_user_loginId'),
                    password  :$F('add_user_password1'),
                    email     :$F('add_user_email'),
                    lastName  :$F('add_user_lastName'),
                    firstName :$F('add_user_firstName'),
                    roleId    :$F('add_user_role')
                  },
                  onComplete: function(transport){
                    var self = Tugboat.gtd_admin;
                    if(transport.responseText == '') {
                      alert($F('add_user_loginId')+' is already exist');
                    } else if(transport.responseText == 'email'){
                      alert('Email address is wrong');
                    } else {
                      user = eval('('+transport.responseText+')');
                      self._users[user.userId] = user;
                      self.refleshLI(user);
                      el.blur();
                      Windows.closeAll();
                      self.modal.close();
                    }
                  }
                }
              );
            }
            return false;
          }
        }
      },

      '#add_user_cancel_button' : function(el) {
        el.onclick = function(){
          el.blur();
          Windows.closeAll();
          self.modal.close();
          return false;
        }
      },
      
      '#add_users_cancel_button' : function(el) {
        el.onclick = function(){
          el.blur();
          Windows.closeAll();
          self.modal.close();
          return false;
        }
      },
      '#logout' : function(el) {
        el.onclick = function(){
          el.blur();
          if (! confirm('May I logout this system ?')) {
            return false;
          }
          location.href='adminLogout.html';
        }
      },
      '#sendFile': function(el) {
        el.onclick = function() {
          
          if(self.uploading) {
            alert('Now uploading...');
            return false;
          }
          if('' == $F('addByFile:filePath')) {
            alert('Please select a file');
            return false;
          }

          $('uploadFrame').onload = function() {

            var i = $('uploadFrame');
            if (i.contentDocument) {
              var d = i.contentDocument;
            } else if (i.contentWindow) {
              var d = i.contentWindow.document;
            }
//            alert(d.body.innerHTML);
            var message  = d.body.innerHTML;
            if(message == '[error]') {
              message = 'Please check the file.';  
            }
            $('message').innerHTML = message;

            
            $('uploadFrame').onload = null;
            self.uploading = false;
            self.list();
          };
        }
      },
      '#page_prev' : function(el) {
        el.onclick = function() {
          if (el.className.indexOf('off') > -1) return false;
          self.page -= 1;
          self.list();
          el.blur();
        }
      },
      '#page_next' : function(el) {
        el.onclick = function() {
          if (el.className.indexOf('off') > -1) return false;
          self.page += 1;
          self.list();
          el.blur();
        }
      }
    };
    Behaviour.register(rules);
    self.list();
  },

  /**
   * listing all users.
   * 
   */
  list: function() {
    var listBody = $('userListBody');
    while(listBody.hasChildNodes()) {
      listBody.removeChild(listBody.firstChild);
    }
    
    var self = Tugboat.gtd_admin;
    new Ajax.Request(
      'teeda.ajax',
      {
        method: 'GET',
        parameters:
        {
          component: 'adminAjax',
          action   : 'list',
          offset   : self.page * self.limit,
          limit    : self.limit
        },
        onComplete: function(transport){
          lstUser = eval(transport.responseText);
          lstUser.each(Tugboat.gtd_admin.appendUser);
          self._users = new Hash();
          lstUser.each(function(user) {self._users[user.userId] = user;});
          self.uploadPager();
        }
      }
    );
  },
  
  /** remove user by userId
   * 
   * @param {Object} userId
   */
  remove: function(userId) {
    if(confirm('are you sure?') ) {
      new Ajax.Request(
        'teeda.ajax',
        { 
          method: 'POST',
          parameters:
          {
            component:'adminAjax',
            action   :'delete',
            userId   :userId
          },
          onComplete: function(transport){
            if(transport.responseText == '') {
              var self = Tugboat.gtd_admin;
              self.page = 0;
              self.list();
//              $('user_' + userId).remove();
//              self._users.remove(userId);            
            }
          }
        }
      );
    }
  },
    
  /**
   * update user.
   * 
   * @param {Object} userId
   */
  edit: function(userId) {
    $('show_password_' + userId).toggle();
    $('edit_password_' + userId).toggle();
    $('show_email_' + userId).toggle();
    $('edit_email_' + userId).toggle();
    $('show_lastName_' + userId).toggle();
    $('edit_lastName_' + userId).toggle();
    $('show_firstName_' + userId).toggle();
    $('edit_firstName_' + userId).toggle();
    $('show_role_' + userId).toggle();
    $('edit_role_' + userId).toggle();
        
    $$('input.btn_edit').each(function(btnEdit) {
      btnEdit.disabled = true;
    });
    $$('input.btn_remove').each(function(btnRemove) {
      btnRemove.disabled = true;
    });
    $('edit_' + userId).hide();
    $('remove_' + userId).hide();
    $('cancel_' + userId).show();
    $('submit_' + userId).show();
  },

  /**
   * cancel.
   * 
   * @param {Object} userId
   */
  cancel: function(userId) {
      /*
    $$('.edit').each(function(divEdit){
      divEdit.hide();
    });
    $$('.show').each(function(divShow){
      divShow.show();
    });
    $$('input.btn_edit').each(function(btnEdit){
      btnEdit.disabled = false;
      btnEdit.show();
    });
    $$('.btn_cancel').each(function(btnCancel){
      btnCancel.hide();
    });
    $$('.btn_submit').each(function(btnSubmit){
      btnSubmit.hide();
    });
    $$('input.btn_remove').each(function(btnRemove){
      btnRemove.disabled = false;
      btnRemove.show();
    });
    var self = Tugboat.gtd_admin;
    self.refleshRow(self._users[userId]);
    */
  },
    
  /**
   * submit editing user.
   * @param {Object} userId
   */
  submit: function(userId) {
    new Ajax.Request(
      'teeda.ajax',
      {
        method: 'POST',
        parameters:
        {
          component :'adminAjax',
          action    :'update',
          userId    :userId,
          loginId   :$F('loginId_' + userId),
          password  :$F('password_' + userId),
          email     :$F('email_' + userId),
          lastName  :$F('lastName_' + userId),
          firstName :$F('firstName_' + userId),
          roleId    :$F('role_' + userId)
        },
        onComplete: function(transport){
          if(transport.responseText != '') {
            var self = Tugboat.gtd_admin;
            var newUser = eval('(' + transport.responseText + ')');
            self.refleshLI(newUser);
            self._users[newUser.userId] = newUser;
          }
          Tugboat.gtd_admin.cancel();
        }
      }
    );
  },
    
  /**
   * appending user.
   * @param {Object} user
   */
  appendUser: function(user) {
    var elmUL = $('userListBody');
    elmUL.appendChild(
      Tugboat.gtd_admin.getUserList(user)
    );
  },
  
  /**
   * refresh rows.
   * @param {Object} user
   */
  refleshRow: function(user){
    var self = Tugboat.gtd_admin;
    var tr = self.getUserTR(user);
    var next = $('user_' + user.userId).nextSibling;
    $('user_'+ user.userId).remove();
    var elmNewTR = Tugboat.gtd_admin.getUserTR(user);
    var elmTbody = $('tbody');
    elmTbody.appendChild(elmNewTR);
    $('tbody').insertBefore(elmNewTR, next);
  },
  
  refleshLI: function(user) {
    var self = Tugboat.gtd_admin;
    var next = $('user_' + user.userId).nextSibling;
    $('user_'+ user.userId).remove();
    var elmNewList = self.getUserList(user);
    var elmListBody = $('userListBody');
//    elmListBody.appendChild(elmNewList);
    $('userListBody').insertBefore(elmNewList, next);
  },

  /**
   * get user's TR element.
   * @param {Object} user
   */
  getUserTR: function(user){
    return TR({'id':'user_' + user.userId},[
      TD({'class':'login_id'},[
        DIV({'id':'show_loginId_' + user.userId,'class':'show'},user.loginId)
      ]),
      TD({'class':'password'},[
        DIV({'id':'show_password_' + user.userId,'class':'show'},user.password.gsub('.','*'))
      ]),
      TD({'class':'email'},[
        DIV({'id':'show_email_' + user.userId,'class':'show'},user.email)
      ]),
      TD({'class':'lastName'},[
        DIV({'id':'show_lastName_' + user.userId,'class':'show'},user.lastName)
      ]),
      TD({'class':'firstName'},[
        DIV({'id':'show_firstName_' + user.userId,'class':'show'},user.firstName)
      ]),
      TD({'class':'role'},[
        DIV({'id':'show_role_' + user.userId,'class':'show'},user.roleName)
      ]),
      TD({'class':'command'},[
        A({
          'href'    :'javaScript:void(0)',
          'id'      :'edit_'+user.userId,
          'class'   :'edit',
          'onclick' :'Tugboat.gtd_admin.showWindow('+user.userId+')'
        },
          'edit'
        ),
        ' / ',
        A({
          'href'    :'javaScript:void(0)',
          'id'      :'remove_'+user.userId,
          'onclick' :'Tugboat.gtd_admin.remove('+user.userId+')'
        },
          'delete'
        )
      ])
    ]);
  },
  
  getUserList: function(user) {
    return LI({'id':'user_' + user.userId,'class':'default'},
      DIV({'class':'user'},[
        P({'class':'loginId'},user.loginId),
//        P({'class':'password'},user.password.gsub('.','*')),
        P({'class':'email'},user.email),
        P({'class':'lastName'},user.lastName),
        P({'class':'firstName'},user.firstName),
        P({'class':'role'},user.roleName),
        P({'class':'command'},
          A({
            'href'    :'javaScript:void(0)',
            'id'      :'edit_'+user.userId,
            'class'   :'edit',
            'onclick' :'Tugboat.gtd_admin.showWindow('+user.userId+')'
          },
            'edit'
          ),
          ' / ',
          A({
            'href'    :'javaScript:void(0)',
            'id'      :'remove_'+user.userId,
            'onclick' :'Tugboat.gtd_admin.remove('+user.userId+')'
          },
            'delete'
          )
        )
      ])
    );
  },
    
  /**
   * show window.
   * @param {Object} userId
   */
  showWindow: function(userId){
    var self = Tugboat.gtd_admin;
    self._editId = userId;
    var title;
    if(! userId) {
      title = 'Add user';
      $('add_user_loginId').disabled   = false;
      $('add_user_loginId').value      = '';
      $('add_user_password1').value    = '';
      $('add_user_password2').value    = '';
      $('add_user_email').value        = '';
      $('add_user_lastName').value     = '';
      $('add_user_firstName').value    = '';
      $('add_user_role').selectedIndex = 1;

    }
    else {
      title = 'Edit user';
      $('add_user_loginId').disabled   = true;
      $('add_user_loginId').value      = self._users[userId].loginId;
      $('add_user_password1').value    = self._users[userId].password;
      $('add_user_password2').value    = self._users[userId].password;
      $('add_user_email').value        = self._users[userId].email;
      $('add_user_lastName').value     = self._users[userId].lastName;
      $('add_user_firstName').value    = self._users[userId].firstName;
      $('add_user_role').selectedIndex = self._users[userId].roleId-1;
    }
    self.modal.open();
    self.add_user_window = new Window(
        'addUserWindow',
        { className: 'mac_os_x', width:360, height:285, 
          zIndex: 100, 
          minimizable: false, 
          closable   : false, 
          maximizable: false,
          resizable  : false, 
          draggable  : true,
          title      : title,
          showEffectOptions:{
            duration:0.5,
            afterFinish:function(){ $('add_user_loginId').focus();}
          }
        }
      );
    self.add_user_window.setContent('user_sub_window_container',false,false);
    self.add_user_window.setDestroyOnClose();
    self.add_user_window.showCenter();

    var userWindowObserver = {
      onDestroy: function(eventName, win) {
        if (win == self.add_user_window) {
          Element.hide('user_sub_window_container');
          $('user_sub_window_container').appendChild($('user_sub_window'));
            
          self.add_user_window = null;
          Windows.removeObserver(this);
            
          Tugboat.gtd_admin.modal.close();
        }
      }
    };
    Windows.addObserver(userWindowObserver);    
  },
  
  showUsersWindow: function(){
    var self = Tugboat.gtd_admin;
    self.modal.open();
    self.add_users_window = 
      new Window(
        'addUsersWindow',
        { className: 'mac_os_x', width:380, height:280, 
          zIndex: 100, 
          minimizable: false, 
          closable   : false, 
          maximizable: false,
          resizable  : false, 
          draggable  : true,
          title      : 'Add Users',
          showEffectOptions:{
            duration:0.5
//            afterFinish:function(){ $('add_user_loginId').focus();}
          }
        }
      );
    self.add_users_window.setContent('users_sub_window_container',false,false);
    self.add_users_window.setDestroyOnClose();
    self.add_users_window.showCenter();
    var usersWindowObserver = {
      onDestroy: function(eventName, win) {
        if (win == self.add_users_window) {
          Element.hide('users_sub_window_container');
//          $('users_sub_window_container').appendChild($('users_sub_window'));
          $('addByFile:filePath').value=null;
          self.add_users_window = null;
          $('message').innerHTML = '';
          Windows.removeObserver(this);
          self.list();
          Tugboat.gtd_admin.modal.close();
        }
      }
    };
    Windows.addObserver(usersWindowObserver);    
  },
  
  /**
   * upload pager
   */
  uploadPager: function() {
    var self = Tugboat.gtd_admin;
    new Ajax.Request(
      'teeda.ajax',
      {
        method       : 'POST',
        asynchronous : false,
        parameters:
        {
          component :'adminAjax',
          action    :'getCount'
        },
        onComplete: function(transport){
          if(transport.responseText != '') {
            self.result = Number(transport.responseText);
          }
        }
      }
    );
    
    $('count').innerHTML = self.result;
    $('page_offset').innerHTML = self.page+1;
    $('total_page').innerHTML  = Math.ceil(self.result / self.limit);
    
    if(self.page == 0) {
      $('page_prev').className = "page_prev_off";
    } else {
      $('page_prev').className = "page_prev";
    }
    if(Math.ceil(self.result / self.limit) == self.page+1) {
      $('page_next').className = "page_next_off";
    } else {
      $('page_next').className ="page_next";
    }
    
  },
  /**
   * resize list area.
   * 
   * @param isVisibleBrowser
   * @param isCallToggleBrowser
   */
  resize_list_area : function() {
    Element.show('gtd_list_pane');

    var window_size = Tugboat.getPageSize();

    // list/block pane.
    var BROWSER_HEIGHT = Tugboat.gtd_common.BROWSER_HEIGHT;
    var elGtdListPane = YAHOO.util.Dom.getRegion('gtd_list_pane');
    var pane_height = 0;
    pane_height = window_size.windowHeight - elGtdListPane.top;
  
    if (pane_height<0) pane_height = 1000;
    $('gtd_list_pane').style.height = pane_height + 'px';
    
  },  
  
  /*
   * Modal window
   *
   * 
   */
  modal : {
    open : function () {
      var page = Tugboat.getPageSize();
      $('modal_window').style.height = page.pageHeight +"px";
      $('modal_window').style.display = 'block';
    },

    close : function() {
      $('modal_window').style.display = 'none';
    }
  }
};

YAHOO.util.Event.addListener(
  document, "keydown",
  function(key){
    if (key.keyCode == Event.KEY_ESC) {
      if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;
      Windows.closeAll();
    }
  }
);