/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.gtd_activity) == 'undefined') {
    Tugboat.gtd_activity = {};
}

Tugboat.gtd_activity = {
  _activities     : null,
  _selectId       : 0,
  _roleId         : 0,
  _activitySelect : null,
  _addActivityColorSelect : null,
  _addMemberRoleSelect    : null,
  _editMemberRoleSelect   : null,
  _smtp : null,

  /**
   * Initialize.
   */
  init : function() {
    Tugboat.dashboard.initialize();

    Tugboat.gtd_common.set_application_window_size();
    Tugboat.gtd_common.BROWSER_HEIGHT=222;
    
    Tugboat.gtd_common.resize_list_area(false,false);
    var self = Tugboat.gtd_activity;
    self._getActivityFolderJSON(true);
    self._setup_event_rules();
    
    self._activitySelect = 
      new TugboatUI.SelectMenu(
        'color_selector',
        Tugboat.constant.activity.flags,
        { parentElement:'content',
          isParentWindow:false,
          onSelected:function(selectValue){
            self._updateActivityColor(self._selectId, selectValue.id);
        } }
      );
    self._addActivityColorSelect = 
      new TugboatUI.SelectMenu(
        'add_activity_color_container',
        Tugboat.constant.activity.flags,
        { parentElement:'_addActivityWindow',
          isParentWindow:true,
          onSelected:function(selectValue){
            $('add_activity_title').focus();
          } 
        }
    );
    self._addMemberRoleSelect = 
      new TugboatUI.SelectMenu(
        'add_member_role_container',
        Tugboat.constant.activity.roles,
        { parentElement:'_addMemberWindow',
          isParentWindow:true,
          onSelected:function(selectValue){
            $('selectMemberChar').focus();
          } 
        }
    );
    self._editMemberRoleSelect = 
      new TugboatUI.SelectMenu(
        'edit_member_role_container',
        Tugboat.constant.activity.roles,
        {  parentElement:'_editMemberWindow', isParentWindow:true, onSelected:function(selectValue){} 
      }
    );
    
    new Ajax.Autocompleter(
      'selectMemberChar',
      'selectMemberChar_ac', 
      'teeda.ajax?component=activityMemberAjax&action=getActivityMembers', 
      { minChars: 2,
        paramName:'selectMemberChar',
        optionTextfield:$('selectedMemberId'),
        optionAttributeName:'tgb:value',
        paramName:'selectMemberChar'
      }
    );
    Tugboat.dashboard.initialize();
  },
  
  /**
   * update activity color.
   * @param {Object} activityId
   * @param {Object} colorId
   */
  _updateActivityColor : function(activityId, colorId) {
    var self = Tugboat.gtd_activity;
    var activity = 
      self._activities.activities.find(
        function(a) {
          return activityId != a.id && colorId == a.colorId;
        }
      );
    if (activity) {
      if (! confirm('A chosen color is already registered. Do you change it?')) {
        var beforeSelectedId = 
          self._activities.activities.find(
            function(a) {
              return activityId == a.id;
            }
          );
        self._activitySelect.setSelectedId(beforeSelectedId.colorId);
        return false;
      }
    }
    
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component  :'activityAjax',
          action     :'updateActivityColor',
          activityId :activityId,
          colorId    :colorId
        },
        onComplete: function(transport){
          self._getActivityFolderJSON(false);
        }
      }
    );
  }, 
  
  /**
   * get activity folder json.
   * @param {boolean} isUpdateMembers
   */
  _getActivityFolderJSON : function(isUpdateMembers) {
    var self = Tugboat.gtd_activity;
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component:'activityAjax',
          action   :'getOwnActivities'
        },
        onComplete: function(transport){
          self._activities = eval(transport.responseText);
          self._selectId = self._createActivityFolder(
            self._activities.activities, self._activities.smtp);
          
          if (isUpdateMembers) {
            self._getSelectedActivityMembersJSON(self._selectId);
            self._setActivityDetail(self._findActivityById(self._selectId));
          }
        }
      }
    );
  },
  
  /**
   * create activity folder.
   * @param {Object} activitiesJson
   */
  _createActivityFolder : function(activitiesJson, smtp) {
    var folderPane = $('folders_pane');
    folderPane.innerHTML = '';
    
    var self = Tugboat.gtd_activity;
    self._smtp = smtp;
    
    if (! activitiesJson) return false;
    var selectedFolderId = self._selectId;
    
    var ul = UL({'class':'folder'},
      activitiesJson.collect(
        function(a, index) {
          if (index==0 && self._selectId==0) {
            selectedFolderId = a.id;
          }
          return (
            LI({'id':'FLD-' + a.id,
                'class':'f_'+ a.colorValue + (a.id == selectedFolderId ? ' selected' : ''),
                'onclick':function(){self._folder_onclick(a.id);}},

              [
                DIV({'class':'node_level_1'},
                  [
                    IMG({'class':'left_and_right_3px_margin','src':'images/default/palette/pl_bg_' +  a.colorValue + '.gif'}),
                    SPAN({'id':'activity_folder_name_' + a.id}, a.name)
                  ]
                ),
                P({'class':'text_records'},
                  function(){
                    return IMG({'id':'activity_folder_email_img_'+ a.id,
                                'height':'16',
                                'width' :'16',
                                'style' :'height:16px; width:16px;',
                                'src': (a.isSendMail == '0' ? 'images/default/icon/space.gif'
                                                            : (Tugboat.isEmpty(smtp) 
                                                                ? Tugboat.constant.activity.email.INACTIVE.icon
                                                                : Tugboat.constant.activity.email.ACTIVE.icon))});
                  }
                )
              ]
            )
          );
        }
      )
    );
    folderPane.appendChild(ul);
    return selectedFolderId;
  },

  /**
   * get selected activity members json.
   * @param {Object} selectedActivityId
   */
  _getSelectedActivityMembersJSON : function(selectedActivityId) {
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component  : 'activityAjax',
          action     : 'getMembersByActivityId',
          activityId : selectedActivityId,
          limit      : Tugboat.constant.ROWS_PER_PAGE,
          offset     : 0,
          currentPageNumber : 1
        },
        onComplete: function(transport){
          var self = Tugboat.gtd_activity;
          self._setRoleId(transport);

          var invertedL = Tugboat.gtd_common;
          invertedL.create_list_dom(transport, 'A');
        }
      }
    );
  },
  
  /**
   * set role id.
   * @param {Object} transport
   */
  _setRoleId : function(transport) {
    if (transport && transport.responseText.length > 0) {
      var json = eval(transport.responseText);
      var self = Tugboat.gtd_activity;
      self._roleId = json.role.roleId;
    }
    return false;
  },
  
  /**
   * set activity detail.
   */
  _setActivityDetail : function(activity) {
    var self = Tugboat.gtd_activity;
    self._activitySelect.setSelectedId(activity.colorId);
    $('detail_color_value').innerHTML = 
      '<img src="images/default/palette/pl_bg_' 
    + activity.colorValue 
    + '.gif" border="0" class="left_and_right_3px_margin" />'
    + activity.colorName;
    
    $('detail_is_send_mail_value').innerHTML = '1' == activity.isSendMail ? 'Yes' : 'No';
    $('is_send_mail_checkbox').checked       = '1' == activity.isSendMail;
    
    $('detail_activity_name').innerHTML = activity.name;
    $('detail_activity_name_edit').value = activity.name;
    
    $('detail_activity_description').innerHTML = activity.description.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
    $('detail_activity_description_edit').value = activity.description;
    
    $('detail_activity_createdAt').innerHTML = activity.registeredFormated;
  },
  
  /**
   * setup event rules.
   */
  _setup_event_rules : function() {
    var self = Tugboat.gtd_activity;
    var rules = {
      /*
       * header and menu.events.
       */
      '#header_title' : function(el) {
        el.onclick = function(){
            el.blur();
            return false;
        }
      },
      '#menuBar_AddActivity' : function(el){
        el.onclick = function(){
            Tugboat.gtd_activity.sub_window.addActivity_onclick();
            el.blur();
            return false;
        }
      },
      '#menuBar_AddMember' : function(el) {
        el.onclick = function() {
          el.blur();
          var self = Tugboat.gtd_activity;
          self._roleId = json.role.roleId;
          if (self._roleId == Tugboat.constant.role.GUEST ) {
            return false;
          }
          Tugboat.gtd_activity.sub_window.addMember_onclick();
        }
      },
      
      '#page_prev' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_activity.pageNavi_onclick('page_prev');
          el.blur();
        }
      },
      '#page_next' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_activity.pageNavi_onclick('page_next');
          el.blur();
        }
      },
      
      '#menuBar_browser' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_common.toggleBrowserArea();
          Tugboat.gtd_common.resize_list_area(false,false);
          el.blur();
        }
      },
      
      '#detail_color_value' : function(el) {
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
        },
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          self._showActivityDetailEdit();
        }
      },
      
      '#detail_is_send_mail_value' : function(el) {
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
        },
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          self._showActivityDetailEdit();
        }
      },
      
      '#detail_activity_name' : function(el) {
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
        },
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          self._showActivityDetailEdit();
        }
      },
      '#detail_activity_description' : function(el) {
        el.onmouseover = function() {
          el.style.backgroundColor = '#ffa';
          el.style.cursor = 'cursor';
        },
        el.onmouseout = function() {
          el.style.backgroundColor = '#fff';
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          self._showActivityDetailEdit();
        }
      },
      
      '#layout_block' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_common.blockSelect(el);
          Tugboat.gtd_common.resize_list_area(false,false);
        }
      },
      '#layout_list' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_common.listSelect(el);
          Tugboat.gtd_common.resize_list_area(false,false);
        }
      },
      
      '#detail_edit_cancel' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'cursor';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          self._hideActivityDetailEdit();
        }
      },
      '#detail_edit_update' : function(el) {
        el.onmouseover = function() {
          el.style.cursor = 'cursor';
        },
        el.onmouseout = function() {
          el.style.cursor = 'default';
        },
        el.onclick = function() {
          self._detailPost_onclick();
        }
      },
      '#detail_edit_trash' : function(el) {
        el.onclick = function() {
          self._removeActivity();
        }
      },
      
      '#add_activity_cancel' : function(el) {
        el.onclick = function() {
          Windows.closeAll();
          el.blur();
        }
      },
      '#add_activity_addAnother' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_activity.sub_window.addActivity(2);
          el.blur();
          $('add_activity_title').focus();
        }
      },
      '#add_activity_add' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_activity.sub_window.addActivity(1);
          el.blur();
        }
      },
      '#add_member_sub_window' : function(el) {
        el.onsubmit = function() {
          return false;
        }
      },
      '#add_member_cancel' : function(el) {
        el.onclick = function() {
          Windows.closeAll();
          el.blur();
        }
      },
      '#add_member_add' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_activity.sub_window.addMember(2);
          el.blur();
        }
      },
      
      '#edit_member_trash' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_activity.sub_window._removeMember();
          el.blur();
        }
      },
      '#edit_member_cancel' : function(el) {
        el.onclick = function() {
          Windows.closeAll();
          el.blur();
        }
      },
      '#edit_member_update' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_activity.sub_window._updateMember();
          el.blur();
        }
      },
      '#add_activity_sub_window' : function(el) {
        el.onsubmit = function() {
          return false;
        }
      },
      '#activity_cancel_button' : function(el) {
        el.onclick = function() {
          Windows.closeAll();
          el.blur();
        }
      },
      '#activity_add_button' : function(el) {
        el.onclick = function() {
          Tugboat.gtd_activity.sub_window.addActivity(2);
          el.blur();
        }
      }
    };
    Behaviour.register(rules);
  },
  
  /**
   * folder onclick
   * @param {Object} id
   */
  _folder_onclick : function(id) {
    var SELECTED = ' selected';
    var selectedClassName = $('FLD-' + id).className;
    if (selectedClassName.indexOf(SELECTED) > -1) {
      return false;
    }
    var self = Tugboat.gtd_activity;
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_GET,
        parameters:
        {
          component  : 'activityAjax',
          action     : 'getMembersByActivityId',
          activityId : id,
          limit      : Tugboat.constant.ROWS_PER_PAGE,
          offset     : 0,
          currentPageNumber : 1
        },
        onComplete: function(transport){
          self._setRoleId(transport);

          var invertedL = Tugboat.gtd_common;
          invertedL.create_list_dom(
            transport, Tugboat.gtd_common.FUNC_TYPE_ACTIVITY);
          
          var PREFIX_ID = 'FLD-';
          var beforeSelClassName = $(PREFIX_ID + self._selectId).className.replace(SELECTED,'');
          $(PREFIX_ID + self._selectId).className = beforeSelClassName;
          $(PREFIX_ID + id).className = selectedClassName + SELECTED;
          self._selectId = id;
          
          self._setActivityDetail(self._findActivityById(id));
        }
      }
    );
  },
  
  /**
   * find activity by id.
   * @param {Object} id
   */
  _findActivityById : function(id) {
    var self = Tugboat.gtd_activity;
    if (! self._activities.activities) return false;
    
    var activity = self._activities.activities.find(
      function(a) {
        return id == a.id;
      }
    );
    return activity;
  },
  
  /**
   * remove activity.
   */  
  _removeActivity : function() {
    var self = Tugboat.gtd_activity;
    if ( self._roleId != 1 ) {
      Tugboat.showAlertDialog( 'Sorry, Not allowed to delete it.' );
      return false
    };
    if ( !confirm('May I remove this activity ?') ) return false;
    
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_POST,
        parameters:
        {
          component  : 'activityAjax',
          action     : 'remove',
          activityId : self._selectId
        },
        onComplete: function(transport){
          if (transport.responseText.indexOf('ERROR')>-1) {
            Tugboat.showAlertDialog( 'Sorry, Don\'t remove this activity, <br/>because already exists data,' );
            return false;
          }
          self._selectId = 0;
          self._getActivityFolderJSON(true);
        }
      }
    );
  },
  
  /**
   * show activity detail edit.
   * 
   */
  _showActivityDetailEdit : function() {
    Element.hide('detail_color_value');
    Element.show('color_selector');
    Element.hide('detail_is_send_mail_value');
    Element.show('detail_is_send_mail_edit');
    Element.hide('detail_activity_name');
    Element.show('detail_activity_name_edit');
    Element.hide('detail_activity_description');
    Element.show('detail_activity_description_edit');
    Element.show('detail_activity_actions');
  },
  
  /**
   * hide activity detail edit.
   * 
   */
  _hideActivityDetailEdit : function() {
    Element.show('detail_color_value');
    Element.hide('color_selector');
    Element.show('detail_is_send_mail_value');
    Element.hide('detail_is_send_mail_edit');
    Element.show('detail_activity_name');
    Element.hide('detail_activity_name_edit');
    Element.show('detail_activity_description');
    Element.hide('detail_activity_description_edit');
    Element.hide('detail_activity_actions');
  },
  
  /**
   * detail post onclick.
   * 
   */
  _detailPost_onclick : function() {
    var self = Tugboat.gtd_activity;
    var activityId = self._selectId;
    var activityName = $('detail_activity_name_edit').value;
    var description = $('detail_activity_description_edit').value;
    var isSendMail = $('is_send_mail_checkbox').checked;
    
    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      { 
        method: Tugboat.constant.REQUEST_POST,
        parameters:
        {
          component    :'activityAjax',
          action       :'update',
          activityId   :activityId,
          activityName :activityName,
          description  :description,
          isSendMail   :isSendMail
        },
        onComplete: function(transport){
          color_selected_value = self._activitySelect.getSelectValue();
          $('detail_color_value').innerHTML =
            '<img src="' + color_selected_value.icon
          + '" border="0" class="left_and_right_3px_margin" />'
          + color_selected_value.value;
         
          $('detail_is_send_mail_value').innerHTML = isSendMail ? 'Yes' : 'No';
          $('detail_activity_name').innerHTML = activityName;
          $('detail_activity_description').innerHTML = description.replace(/\x0D\x0A|\x0D|\x0A/g,'<br/>');
          
          $('activity_folder_name_'     +activityId).innerHTML = activityName;
          $('activity_folder_email_img_'+activityId).src = 
            isSendMail ? (Tugboat.isEmpty(self._smtp) ? 'images/default/icon/email_disable.gif' : 'images/default/icon/email.gif')
                       : 'images/default/icon/space.gif';
          
          var activity =
          self._activities.activities.find(
            function(a) {
              return activityId == a.id;
            }
          );
          activity.name = activityName;
          activity.description = description;
          activity.isSendMail = isSendMail ? "1" : "0";
        }
      }
    );
    self._hideActivityDetailEdit();
  },
  
  /**
   * page navigation on click.
   * @param {Object} id
   */
  pageNavi_onclick : function(id) {
    var element = $(id);
    if (element.className.indexOf('off') > -1) return false;
    
    var self = Tugboat.gtd_activity;
    var activityId = self._selectId;
    var pageInfo = Tugboat.gtd_common.task.pageInfo;
    var num = id.indexOf('next') == -1 ? -1 : 1;
    var offset = 
      Tugboat.constant.ROWS_PER_PAGE * (pageInfo.currentPageNumber + num -1);

    new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method: Tugboat.constant.REQUEST_POST,
        parameters:
        {
          component         : 'activityAjax',
          action            : 'getMembersByActivityId',
          activityId        : activityId,
          currentPageNumber : pageInfo.currentPageNumber + num,
          offset            : offset,
          limit             : Tugboat.constant.ROWS_PER_PAGE
        },
        onComplete: function(transport){
          self._setRoleId(transport);

          var invertedL = Tugboat.gtd_common;
          invertedL.create_list_dom(transport, 'A');
        }
      }
    );
  },
  
  /*
   * Sub window
   *
   * 
   */
  sub_window : {
    _addActivityWindow : null,
    _addMemberWindow   : null,
    _editMemberWindow  : null,
    _editMemberId      : 0,
    _editMemberUserId  : 0,
    
    addActivity_onclick : function() {
      Tugboat.gtd_activity.modal.open();
      
      var self = Tugboat.gtd_activity.sub_window;
      self._addActivityWindow = 
        new Window(
          '_addActivityWindow', 
          { className: 'mac_os_x', width:560, height:295, 
            zIndex: 100, 
            minimizable: false, 
            closable   : false, 
            maximizable: false,
            resizable  : false, 
            draggable  : true,
            title      : 'Add activity',
            showEffectOptions: {
              duration:0.5,
              afterFinish:function(){
                $('add_activity_title').focus();
              }
            }
          }
        );
      self._addActivityWindow.setContent('add_activity_sub_window_container',false,false);
      self._addActivityWindow.setDestroyOnClose();
      self._addActivityWindow.showCenter();
      
      var taskWindowObserver = { 
        onDestroy: function(eventName, win) {
          if (win == self._addActivityWindow) {
            $('add_activity_sub_window_container').style.display = 'none';
            $('add_activity_sub_window_container').appendChild($('add_activity_sub_window'));
            
            self._addActivityWindow = null;
            Windows.removeObserver(this);
            
            Tugboat.gtd_activity.modal.close();
          }          
        } 
      };
      Windows.addObserver(taskWindowObserver);
    },
    
    /**
     * add activity
     * @param {Object} type
     */
    addActivity : function(type) {
      var selectValue = 
        Tugboat.gtd_activity._addActivityColorSelect.getSelectValue();
      var colorId = 
        selectValue ? selectValue.id : 0;
      
      var name = $('add_activity_title').value;
      var description = $('add_activity_description').value;
      
      var messages = [];
      if ( colorId == 0 ) {
        messages.push('\'Color\' is not selected.');
      }
      if ( Tugboat.isEmpty(name) ) {
        messages.push('\'Title\' is required.');
      }
      /*
      if ( Tugboat.isEmpty(description) ) {
        messages.push('\'Description\' is required.');
      }
      */
      if ( messages.length > 0 ) {
        Tugboat.showAlertDialog( messages );
        return false;
      }
      
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component       :'activityAjax',
            action          :'add',
            colorId         :colorId,
            activityName    :name,
            description     :description
          },
          onComplete: function(transport){
            $('add_activity_title').value = '';
            $('add_activity_title').focus();
            $('add_activity_description').value = '';

            Tugboat.gtd_activity._getActivityFolderJSON(false);
          }
        }
      );
      if (type==1) {
        Windows.closeAll();
      }
    },
    
    addMember_onclick : function() {
      Tugboat.gtd_activity.modal.open();
      
      var self = Tugboat.gtd_activity.sub_window;
      self._addMemberWindow = 
        new Window(
          '_addMemberWindow', 
          { className: 'mac_os_x', width:410, height:140, 
            zIndex: 100, 
            minimizable: false, 
            closable   : false, 
            maximizable: false,
            resizable  : false, 
            draggable  : true,
            title      : 'Add member',
            showEffectOptions: { duration:0.1, afterFinish:function(){$('selectMemberChar').focus();} }
          }
        );
      self._addMemberWindow.setContent('add_member_sub_window_container',false,false);
      self._addMemberWindow.setDestroyOnClose();
      self._addMemberWindow.showCenter();
      
      var addWindowObserver = { 
        onDestroy: function(eventName, win) {
          if (win == self._addMemberWindow) {
            $('add_member_sub_window_container').style.display = 'none';
            $('add_member_sub_window_container').appendChild($('add_member_sub_window'));
            
            self._addMemberWindow = null;
            Windows.removeObserver(this);
            
            Tugboat.gtd_activity.modal.close();
          }          
        } 
      };
      Windows.addObserver(addWindowObserver);
    },
    
    addMember : function(type) {
      var activity = Tugboat.gtd_activity;
      var activityId = activity._selectId;
      var selectRole = activity._addMemberRoleSelect.getSelectValue();
      var roleId = selectRole ? selectRole.id : 0;
      var userId = $('selectedMemberId').value;
      
      var messages = [];
      if ( roleId == 0 ) {
        messages.push('\'Role\' is not selected.');
      }
      if ( userId == 0 ) {
        messages.push('\'Name\' is required.');
      }
      if ( messages.length > 0 ) {
        Tugboat.showAlertDialog( messages );
        return false;
      }
      
      // check already exists.
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_GET,
          parameters:
          {
            component  :'activityMemberAjax',
            action     :'checkAlreadyExists',
            activityId :activityId,
            userId     :userId
          },
          onComplete: function(transport){
            var respText = transport.responseText;
            if (! transport.responseText || respText == 'null') {
              activity.sub_window._addMemberAjaxRequest(activityId, roleId, userId);
              if (type==1) {
                Windows.closeAll();
              }
              $('selectMemberChar').value='';
              $('selectMemberChar_ac').value='0';
            }
            else {
              Tugboat.showAlertDialog('This user is already exists.');
              return false;
            }
            $('selectMemberChar').focus();
          }
        }
      );
    },
  
    /**
     * add member ajax request.
     * @param {Object} activityId
     * @param {Object} roleId
     * @param {Object} userId
     */
    _addMemberAjaxRequest : function(activityId, roleId, userId) {
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component  :'activityMemberAjax',
            action     :'add',
            activityId : activityId,
            roleId     :roleId,
            userId     :userId
          },
          onComplete: function(transport){
            Tugboat.gtd_activity._getSelectedActivityMembersJSON(activityId);
          }
        }
      );
    },
    
    /**
     * edit member click.
     * @param {Object} member
     */
    editMember_onclick : function(member) {
      var self = Tugboat.gtd_activity;
      self._roleId = json.role.roleId;
      if (self._roleId == Tugboat.constant.role.GUEST ) {
        return false;
      }
      Tugboat.gtd_activity.modal.open();
      
      var self = Tugboat.gtd_activity.sub_window;
      self._editMemberId = member.id;
      self._editMemberUserId = member.userId;
      
      Tugboat.gtd_activity._editMemberRoleSelect.setSelectedId(member.roleId);
      $('edit_member_name').innerHTML = member.lastName + ', ' + member.firstName;

      self._editMemberWindow = 
        new Window(
          '_editMemberWindow', 
          { className: 'mac_os_x', width:410, height:140, 
            zIndex: 100, 
            minimizable: false, 
            closable   : false, 
            maximizable: false,
            resizable  : false, 
            draggable  : false,
            title      : 'Edit member',
            showEffectOptions: {duration:0.1}
          }
        );
      self._editMemberWindow.setContent('edit_member_sub_window_container',false,false);
      self._editMemberWindow.setDestroyOnClose();
      self._editMemberWindow.showCenter();
      
      var editWindowObserver = { 
        onDestroy: function(eventName, win) {
          if (win == self._editMemberWindow) {
            $('edit_member_sub_window_container').style.display = 'none';
            $('edit_member_sub_window_container').appendChild($('edit_member_sub_window'));
            
            self._editMemberWindow = null;
            Windows.removeObserver(this);
            
            Tugboat.gtd_activity.modal.close();
          }          
        } 
      };
      Windows.addObserver(editWindowObserver);
    },
    
    /**
     * remove member.
     */
    _removeMember : function() {
      if (Tugboat.gtd_activity._roleId != 1) {
        Tugboat.showAlertDialog( 'Sorry, Not allowed to delete it.' );
        return false;
      }
      if ( !confirm('May I remove this member ?') ) return false;      
      
      var self = Tugboat.gtd_activity.sub_window;
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component  : 'activityMemberAjax',
            action     : 'remove',
            activityId : Tugboat.gtd_activity._selectId,
            userId     : self._editMemberUserId
          },
          onComplete: function(transport){
            if (transport.responseText.indexOf('ERROR')>-1) {
              Tugboat.showAlertDialog( 'Sorry, Don\'t remove this member, <br/>because already exists data,' );
              return false;
            }
            Tugboat.gtd_activity._getActivityFolderJSON(true);
          }
        }
      );
      Windows.closeAll();
    },
    
    /**
     * update member.
     */
    _updateMember : function() {
      var self = Tugboat.gtd_activity.sub_window;
      var activityId = Tugboat.gtd_activity._selectId;
      var roleId = Tugboat.gtd_activity._editMemberRoleSelect.getSelectValue().id;
      
      new Ajax.Request(
        Tugboat.AJAX_SERVLET_NAME,
        { 
          method: Tugboat.constant.REQUEST_POST,
          parameters:
          {
            component  : 'activityMemberAjax',
            action     : 'update',
            activityId : activityId,
            roleId     : roleId,
            userId     : self._editMemberId
          },
          onComplete: function(transport){
            Tugboat.gtd_activity._getSelectedActivityMembersJSON(activityId);
          }
        }
      );
      Windows.closeAll();
    }
  },
  
  /*
   * Modal window
   *
   * 
   */
  modal : {
    open : function () {
      var page = Tugboat.getPageSize(); 
      Element.setHeight('modal_window', page.pageHeight);
      $('modal_window').style.display = 'block';
    },

    close : function() {
      $('modal_window').style.display = 'none';
    }
  }
};

YAHOO.util.Event.addListener(
  document, "keydown",
  function(key){
    if (key.keyCode == Event.KEY_ESC) {
      if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) return false;
      Windows.closeAll();
    }
  }
);
