/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
if (typeof(Tugboat.dashboard) == 'undefined') {
    Tugboat.dashboard = {};
}

Tugboat.dashboard = {
  pageOffset   : 1,
  nextPage     : false,
  previousPage : false,
  _isAlreadySearch : false,

  /**
   * initialize.
   * 
   */
  initialize : function() {
    Tugboat.dashboard._continuation();
    Tugboat.dashboard._setup_event_rules();
    
    $('search_keyword').value = 'search...';
    
    return false;
  },
  
  /**
   * session continuation.
   */
  _continuation : function() {
    try {
      new Ajax.PeriodicalUpdater(
        '',
        Tugboat.AJAX_SERVLET_NAME,
        {
          method: Tugboat.constant.REQUEST_GET,
          parameters:
          {
            component:'loginAjax',
            action   :'continuation'
          },
          frequency: 300,
          onSuccess: function(transport) {},
          onFailure: function() {
            throw 'continuation error.';
          }
        }
      );
    } catch(e) {
      Tugboat.dashboard._continuation();
    }
  },
  
  /**
   * setup event rules.
   */
  _setup_event_rules : function() {
    var rules = {
      '#globalMenuActions input.search_icon' : function(el) {
        el.onclick = function(){
          $('globalSearch').style.display='block';
          el.blur();
          
          $('search_keyword').focus();
          return false;
        };
      },
      '#globalSearch a.close_icon' : function(el) {
        el.onclick = function() {
          $('globalSearch').style.display='none'; 
          $('modal_window').style.display = 'none';
          el.blur();
          
          //$('modal_window').style.display = 'none';
          return false;
        }
      },
      '#globalSearch a.close_icon_xs' : function(el) {
        el.onclick = function() {
          $('search_keyword').value = '';
          $('search_result_page_info').style.display='none';
          $('search_results').style.display='none';
          $('modal_window').style.display = 'none';
          el.blur();
          
          $('search_keyword').focus();
          $('globalSearchResultBody').style.height = 'auto';
          return false;
        }
      },
      '#globalSearchForm' : function(el) {
        el.onsubmit = function() {
          var self = Tugboat.dashboard;
          if (self._isAlreadySearch) return false;
          var keyword = $('search_keyword').value;
  	      if ( Tugboat.isEmpty(keyword) ) {
  		    return false;
  	      }
          self._isAlreadySearch = true;
          Tugboat.dashboard.resizeSearchResultBody();
          Tugboat.dashboard.pageOffset = '1';
          Tugboat.dashboard.clearKeywords();
          Tugboat.dashboard.keywordSearch(keyword);
          return false;
        }
      },
      '#search_page_prev' : function(el) {
        el.onclick = function() {
          if (el.className.indexOf('off') > -1) return false;
          Tugboat.dashboard.pageOffset-- ;
          Tugboat.dashboard.clearKeywords();
          Tugboat.dashboard.keywordSearch($('search_keyword').value);
          return false;
        }
      },
      '#search_page_next' : function(el) {
        el.onclick = function() {
          if (el.className.indexOf('off') > -1) return false;
          Tugboat.dashboard.pageOffset++ ;
          Tugboat.dashboard.clearKeywords();
          Tugboat.dashboard.keywordSearch($('search_keyword').value);
          return false;
        }
      },
      '#search_keyword' : function(el) {
        el.onfocus = function() {
          if ('search...' == el.value) {
            el.value = '';
          }
        },
        el.onblur = function() {
          if (Tugboat.isEmpty(el.value)) {
            el.value = 'search...';
          }
        }
      }
    };
    Behaviour.register(rules);
    return false;
  },
  
  /**
   * resize search result body.
   */
  resizeSearchResultBody : function() {
	var window_size = Tugboat.getPageSize();
    var elGtdListPane = YAHOO.util.Dom.getRegion('globalSearchResultBody');
    
    var height = 
      window_size.windowHeight 
      - elGtdListPane.top
      - 10;
    
    $('globalSearchResultBody').style.height = height+'px';
    $('search_results').style.height = (height - 50) + 'px';
    return false;
  },
  
  /**
   * keyword search.
   * 
   * @param {String} keywordS
   */
  keywordSearch : function(keyword) {
  	new Ajax.Request(
      Tugboat.AJAX_SERVLET_NAME,
      {
        method:Tugboat.constant.REQUEST_POST,
        parameters:
        {
          component:'searcherAjax',
          action   :'keywordSearch',
          keyword  :keyword,
          offset   :Tugboat.dashboard.pageOffset
        },
        onComplete:  function(transport) {
          var  jsonValue = eval( '(' + transport.responseText + ')' );
          
          $('search_count').innerHTML = jsonValue.search_count;
          $('page_offset').innerHTML = jsonValue.page_offset;
          $('total_page').innerHTML = jsonValue.total_page;

          var resultsTask = jsonValue.task;
          var searchResultsTask = resultsTask.collect(
            function(value, index) {
              var pbody = P(null);
              pbody.innerHTML = value.body; 
              return (
                LI(null,
                  [ P({'class':'title'}, 
                    A( {'href':'gtdTaskDetail.html?taskId=' + value.dataID + (value.dataLevel > 0 ? '&commentId=' + value.dataLevel : '') }, value.title) ),
                    pbody,
                    P({'class':'Limit'}, value.modified ),
                    P({'class':'posted'}, value.userName )
                  ]
                )
              )
            }
          );
          appendChildNodes("search_results_task", searchResultsTask); 
          
          var resultsMeeting = jsonValue.meeting;
          var searchResultsMeeting = resultsMeeting.collect(
            function(value, index) {
              var pbody = P(null);
              pbody.innerHTML = value.body; 
              return (
                LI(null,
                  [ P({'class':'title'}, 
                    A( {'href':'gtdMeetingDetail.html?id=' + value.dataID }, value.title) ),
                    pbody,
                    P({'class':'Limit'}, value.modified ),
                    P({'class':'posted'}, value.userName )
                  ]
                )
              )
            }
          );
          appendChildNodes("search_results_meeting", searchResultsMeeting); 
         
          $('search_result_page_info').style.display='block';
          $('search_results').style.display='block';
          
          var page = Tugboat.getPageSize(); 
          Element.setHeight('modal_window', page.pageHeight);
          //$('modal_window').style.display = 'block';

          Tugboat.dashboard.nextPage     = jsonValue.next_page;
          if (Tugboat.dashboard.nextPage) {
            $('search_page_next').className = 'page_next';
          }    else {
            $('search_page_next').className = 'page_next_off';
          }
          Tugboat.dashboard.previousPage = jsonValue.previous_page;
          if (Tugboat.dashboard.previousPage) {
            $('search_page_prev').className = 'page_prev';
          }    else {
            $('search_page_prev').className = 'page_prev_off';
          }
         
          var self = Tugboat.dashboard;
          self._isAlreadySearch = false;
          
          return false;
        }
      }
    );
  },

  /**
   * clear keywords.
   * @param {String} keywordS
   */
  clearKeywords : function() {
    $('search_count').innerHTML = '0';
    $('page_offset').innerHTML = '0';
    $('total_page').innerHTML = '0';

    $('search_results_task').innerHTML = '';
    $('search_results_meeting').innerHTML = '';
    return false;
  },

  /**
   * close window on click.
   */
  closeWindow_onclick : function() {
  	var targetElement = document.getElementById('navigation_search_result');
	targetElement.style.display = 'none';
    return false;
  }
};
YAHOO.util.Event.addListener(
  'search_keyword', "keydown",
  function(key){
    if (key.keyCode == Event.KEY_ESC) {
      $('globalSearch').style.display = 'none';
    }
  }
);