--
-- find task to tasks by task id.
--
SELECT
    T.SRC_TASK_ID
   ,A.TITLE AS SRC_TITLE
   ,C.STATUS_ID         AS SRC_STATUS_ID
   ,C.ACTIVITY_ID       AS SRC_ACTIVITY_ID
   ,C.CLASSIFICATION_ID AS SRC_CLASS_ID
   ,C.POSTED_USER_ID    AS SRC_POSTED_USER_ID
   ,UA.LAST_NAME || ', ' || UA.FIRST_NAME AS SRC_POSTED_BY 
   ,A.REGISTERED        AS SRC_POSTED_AT
   ,T.DEST_TASK_ID
   ,B.TITLE AS DEST_TITLE
   ,D.STATUS_ID         AS DEST_STATUS_ID
   ,D.ACTIVITY_ID       AS DEST_ACTIVITY_ID
   ,D.CLASSIFICATION_ID AS DEST_CLASS_ID
   ,D.PERSON_ID         AS DEST_PERSON_ID
   ,U.LAST_NAME ||', ' || U.FIRST_NAME AS DEST_PERSON_NAME
   ,D.POSTED_USER_ID    AS DEST_POSTED_USER_ID
   ,UB.LAST_NAME ||', ' || UB.FIRST_NAME AS DEST_POSTED_BY
   ,B.REGISTERED        AS DEST_POSTED_AT
FROM 
    task_to_tasks T
    INNER JOIN tasks A          ON T.SRC_TASK_ID    = A.ID
                               AND A.DEL_FLAG = '0'
    INNER JOIN tasks B          ON T.DEST_TASK_ID   = B.ID
                               AND B.DEL_FLAG = '0'
    INNER JOIN task_relations C ON T.SRC_TASK_ID    = C.TASK_ID
    INNER JOIN task_relations D ON T.DEST_TASK_ID   = D.TASK_ID
    INNER JOIN users          U ON D.PERSON_ID = U.ID
    INNER JOIN users         UA ON C.POSTED_USER_ID = UA.ID
    INNER JOIN users         UB ON D.POSTED_USER_ID = UB.ID
WHERE
    T.SRC_TASK_ID  = /*taskId*/2
OR  T.DEST_TASK_ID = /*taskId*/2