--
-- select all task by user id.
--
SELECT
    T.ID
   ,T.TITLE
   ,T.START_DATE
   ,T.START_YEAR
   ,T.START_MONTH
   ,T.START_DAY_OF_MONTH
   ,T.DEAD_LINE
   ,T.DEAD_LINE_YEAR
   ,T.DEAD_LINE_MONTH
   ,T.DEAD_LINE_DAY_OF_MONTH
   ,T.PRIORITY_ORDER
   ,R.ACTIVITY_ID      AS ACTIVITY_ID
   ,V.NAME             AS ACTIVITY_VALUE
   ,R.STATUS_ID
   ,R.CLASSIFICATION_ID
   ,C.TYPE             AS CLASSIFICATION_TYPE
   ,C.VALUE            AS CLASSIFICATION_VALUE
   ,R.ALERT_ID
   ,A.VALUE            AS ALERT_VALUE
   ,O.COLOR            AS COLOR_VALUE
FROM
    task_relations R
    INNER JOIN tasks                   T ON R.TASK_ID           = T.ID
    INNER JOIN activities              V ON R.ACTIVITY_ID       = V.ID
    INNER JOIN activity_members        Y ON V.ID                = Y.ACTIVITY_ID
                                        AND Y.USER_ID           = /*userId*/1
    INNER JOIN classifications         C ON R.CLASSIFICATION_ID = C.ID
    INNER JOIN alerts                  A ON R.ALERT_ID          = A.ID
    INNER JOIN activity_relations      I ON R.ACTIVITY_ID       = I.ACTIVITY_ID
    INNER JOIN activity_colors         O ON I.COLOR_ID          = O.ID
WHERE
    R.CLASSIFICATION_ID < 9
ORDER BY
    R.ACTIVITY_ID
   ,R.CLASSIFICATION_ID
   ,T.PRIORITY_ORDER DESC