--
-- select task rows  by query params
--
SELECT COUNT(*) AS RECORDS
FROM
    (
    SELECT DISTINCT R.*
    FROM
        task_relations R
        INNER JOIN tasks                   T ON R.TASK_ID           = T.ID
        INNER JOIN activities              V ON R.ACTIVITY_ID       = V.ID
        INNER JOIN activity_members        Y ON V.ID                = Y.ACTIVITY_ID
                                            AND Y.USER_ID           = /*condition.userId*/1
                                            AND Y.DEL_FLAG          = '0'
        INNER JOIN classifications         C ON R.CLASSIFICATION_ID = C.ID
        INNER JOIN alerts                  A ON R.ALERT_ID          = A.ID
        INNER JOIN activity_relations      I ON R.ACTIVITY_ID       = I.ACTIVITY_ID
        INNER JOIN activity_colors         O ON I.COLOR_ID          = O.ID
        INNER JOIN users                   U ON R.POSTED_USER_ID    = U.ID
    /*BEGIN*/
    WHERE
    /*IF condition.queryStatusIds         != null*/AND R.STATUS_ID         IN /*condition.queryStatusIds*/(1)         /*END*/
    /*IF condition.queryClassificationIds != null*/AND R.CLASSIFICATION_ID IN /*condition.queryClassificationIds*/(1) /*END*/
    /*IF condition.queryActivityIds       != null*/AND R.ACTIVITY_ID       IN /*condition.queryActivityIds*/(1)       /*END*/
    /*IF condition.queryPersonIds         != null 
     && !condition.queryPersonIsNull*/AND R.PERSON_ID IN /*condition.queryPersonIds*/(1) /*END*/
    /*IF condition.queryPersonIds         == null 
     &&  condition.queryPersonIsNull*/AND R.PERSON_ID IS NULL /*END*/
    /*IF condition.queryPersonIds         != null 
     &&  condition.queryPersonIsNull*/AND (R.PERSON_ID IN /*condition.queryPersonIds*/(1) OR R.PERSON_ID IS NULL) /*END*/
    AND T.DEL_FLAG = '0'
    /*END*/
    ) RESULT