--
-- select person in charge by activity id.
--
SELECT 
    R.PERSON_ID
   ,coalesce(U.LAST_NAME,'')  AS PERSON_LAST_NAME
   ,coalesce(U.FIRST_NAME,'') AS PERSON_FIRST_NAME
FROM 
    task_relations R
    LEFT JOIN users U ON R.PERSON_ID = U.ID
WHERE
    ACTIVITY_ID IN /*activityIds*/(1,5,6)
GROUP BY
    R.PERSON_ID, U.LAST_NAME, U.FIRST_NAME
ORDER BY 
    R.PERSON_ID