--
-- select task library info
--
SELECT
    A.ROWS1  AS INBOX_TASKS
   ,B.ROWS2  AS TODAY_TASKS
   ,C.ROWS3  AS WEEK_TASKS
   ,D.ROWS4  AS MONTH_TASKS
   ,E.ROWS5  AS HOLD_TASKS
   ,F.ROWS6  AS SOMEDAY_TASKS
   ,G.ROWS7  AS TODAY_TODO_TASKS
   ,H.ROWS8  AS TODAY_DOING_TASKS
   ,I.ROWS9  AS TODAY_DONE_TASKS
   ,J.ROWS10 AS ARCHIVE_TASKS 
   ,K.ROWS11 AS TRASH_BOX_TASKS 
FROM
    (
    SELECT
        COUNT(*) AS ROWS1
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 9
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) A
   ,(
    SELECT
        COUNT(*) AS ROWS2
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 1
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) B
   ,(
    SELECT
        COUNT(*) AS ROWS3
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 2
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) C
   ,(
    SELECT
        COUNT(*) AS ROWS4
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 3
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) D
   ,(
    SELECT
        COUNT(*) AS ROWS5
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 4
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) E
   ,(
    SELECT
        COUNT(*) AS ROWS6
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 5
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) F
   ,(
    SELECT
        COUNT(*) AS ROWS7
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 1
    AND R.STATUS_ID        = 1
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) G
   ,(
    SELECT
        COUNT(*) AS ROWS8
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 1
    AND R.STATUS_ID        = 2
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) H
   ,(
    SELECT
        COUNT(*) AS ROWS9
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 1
    AND R.STATUS_ID        = 3
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) I
   ,(
    SELECT
        COUNT(*) AS ROWS10
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 21
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) J
   ,(
    SELECT
        COUNT(*) AS ROWS11
    FROM
        task_relations R
        INNER JOIN tasks T ON R.TASK_ID = T.ID
                          AND T.DEL_FLAG = '0'
    WHERE
        R.CLASSIFICATION_ID = 99
    AND PERSON_ID = /*userId*/1
    AND R.ACTIVITY_ID IN /*activities*/(1,2,3)
    ) K