--
-- Select calendar's tasks by user Id.
--  
SELECT
    R.TASK_ID
   ,T.TITLE
   ,B.BODY
   ,T.START_DATE
   ,T.START_YEAR
   ,T.START_MONTH
   ,T.START_DAY_OF_MONTH
   ,T.DEAD_LINE
   ,T.DEAD_LINE_YEAR
   ,T.DEAD_LINE_MONTH
   ,T.DEAD_LINE_DAY_OF_MONTH
   ,R.ACTIVITY_ID      AS ACTIVITY_ID
   ,V.NAME             AS ACTIVITY_VALUE
   ,R.STATUS_ID
   ,R.CLASSIFICATION_ID
   ,C.VALUE            AS CLASSIFICATION_VALUE
   ,O.COLOR            AS COLOR_VALUE
   ,R.POSTED_USER_ID
   ,S.LAST_NAME
   ,S.FIRST_NAME
   ,T.REGISTERED
FROM
    task_relations R
    INNER JOIN tasks                   T ON R.TASK_ID           = T.ID
    INNER JOIN task_bodies             B ON R.TASK_ID           = B.TASK_ID
    INNER JOIN activities              V ON R.ACTIVITY_ID       = V.ID
    INNER JOIN activity_members        Y ON V.ID                = Y.ACTIVITY_ID
                                        AND Y.USER_ID           = /*userId*/1
    INNER JOIN classifications         C ON R.CLASSIFICATION_ID = C.ID
    INNER JOIN alerts                  A ON R.ALERT_ID          = A.ID
    INNER JOIN activity_relations      I ON R.ACTIVITY_ID       = I.ACTIVITY_ID
                                        AND I.USER_ID           = /*userId*/1
    INNER JOIN activity_colors         O ON I.COLOR_ID          = O.ID
    INNER JOIN users                   S ON R.POSTED_USER_ID    = S.ID
WHERE
    R.PERSON_ID = /*userId*/1
/*IF isIncludeDone == true*/AND R.STATUS_ID < 4/*END*/
ORDER BY
    R.ACTIVITY_ID
   ,R.CLASSIFICATION_ID
