--
-- select task by id.
--
SELECT 
    T.ID AS TASK_ID
   ,T.TITLE
   ,B.BODY
   ,T.START_DATE
   ,T.START_YEAR
   ,T.START_MONTH
   ,T.START_DAY_OF_MONTH
   ,T.DEAD_LINE
   ,T.DEAD_LINE_YEAR
   ,T.DEAD_LINE_MONTH
   ,T.DEAD_LINE_DAY_OF_MONTH
   ,T.PRIORITY_ORDER
   ,R.ACTIVITY_ID      AS ACTIVITY_ID
   ,V.NAME             AS ACTIVITY_VALUE
   ,R.STATUS_ID
   ,U.VALUE            AS STATUS_VALUE
   ,R.CLASSIFICATION_ID
   ,C.TYPE             AS CLASSIFICATION_TYPE
   ,C.VALUE            AS CLASSIFICATION_VALUE
   ,R.ALERT_ID
   ,A.VALUE            AS ALERT_VALUE
   ,O.COLOR            AS COLOR_VALUE
   ,R.PERSON_ID
   ,CASE WHEN U1.LAST_NAME  IS NULL THEN '' ELSE U1.LAST_NAME  END AS PERSON_LAST_NAME
   ,CASE WHEN U1.FIRST_NAME IS NULL THEN '' ELSE U1.FIRST_NAME END AS PERSON_FIRST_NAME
   ,R.POSTED_USER_ID
   ,U2.LAST_NAME
   ,U2.FIRST_NAME
   ,T.REGISTERED 
FROM
    task_relations R
    INNER JOIN tasks                   T  ON R.TASK_ID           = T.ID
    INNER JOIN task_bodies             B  ON R.TASK_ID           = B.TASK_ID
    INNER JOIN task_histories          H  ON R.TASK_ID           = H.TASK_ID
    INNER JOIN activities              V  ON R.ACTIVITY_ID       = V.ID
    INNER JOIN classifications         C  ON R.CLASSIFICATION_ID = C.ID
    INNER JOIN alerts                  A  ON R.ALERT_ID          = A.ID
    INNER JOIN activity_relations      I  ON R.ACTIVITY_ID       = I.ACTIVITY_ID
                                         AND I.USER_ID             = /*userId*/1
    INNER JOIN activity_colors         O  ON I.COLOR_ID          = O.ID
    INNER JOIN task_statuses           U  ON R.STATUS_ID         = U.ID
    LEFT  JOIN users                   U1 ON R.PERSON_ID         = U1.ID
    INNER JOIN users                   U2 ON R.POSTED_USER_ID    = U2.ID 
WHERE
    T.ID = /*id*/1
