--
-- select calendar task member role by task id.
--
SELECT 
    R.ID
   ,R.ACTIVITY_MEMBER_ID
   ,R.TASK_ID
   ,R.ROLE_ID
   ,L.NAME AS ROLE_VALUE
   ,A.USER_ID
   ,U.FIRST_NAME
   ,U.LAST_NAME
   ,A.START_DATE
   ,A.END_DATE 
FROM
    task_member_roles R
    INNER JOIN activity_members A ON R.ACTIVITY_MEMBER_ID = A.ID
    INNER JOIN roles            L ON R.ROLE_ID            = L.ID
    INNER JOIN users            U ON A.USER_ID            = U.ID 
WHERE
    R.TASK_ID  = /*taskId*/1
    AND A.DEL_FLAG = '0' 
ORDER BY
    R.ROLE_ID DESC
   ,R.ID