--
-- find meeting basic with task by id.
--
SELECT DISTINCT
    B.ID
   ,B.ACTIVITY_ID
   ,A.NAME AS ACTIVITY_NAME
   ,B.STATUS_ID
   ,B.TITLE
   ,B.START_DATE
   ,B.POSTED_USER_ID
   ,B.DEL_FLAG
   ,B.REGISTERED
   ,B.MODIFIED
   ,D.BODY AS BODY
   ,U.FIRST_NAME
   ,U.LAST_NAME
   ,C.COLOR
   ,T.ID    AS TASK_ID
   ,T.TITLE AS TASK_TITLE
   ,T.STATUS_ID         AS TASK_STATUS_ID
   ,T.CLASSIFICATION_ID AS TASK_CLASS_ID
   ,T.PERSON_ID         AS TASK_PERSON_ID
   ,T.FIRST_NAME        AS TASK_PERSON_FNAME
   ,T.LAST_NAME         AS TASK_PERSON_LNAME
FROM
    meeting_basics B
    INNER JOIN meeting_basic_bodies D  ON B.ID             = D.BASIC_ID
    INNER JOIN users U                 ON B.POSTED_USER_ID = U.ID
    INNER JOIN activity_relations R    ON B.ACTIVITY_ID    = R.ACTIVITY_ID
                                      AND R.USER_ID        = /*userId*/1
    INNER JOIN activities A            ON R.ACTIVITY_ID    = A.ID
    INNER JOIN activity_colors C       ON R.COLOR_ID       = C.ID
    LEFT OUTER JOIN
    (
      SELECT
          MT.BASIC_ID
         ,MT.DISCUSSION_ID
         ,TA.ID
         ,TA.TITLE
         ,TR.STATUS_ID
         ,TR.CLASSIFICATION_ID
         ,TR.PERSON_ID
         ,UU.FIRST_NAME
         ,UU.LAST_NAME
      FROM
          meeting_to_tasks         MT
         INNER JOIN tasks          TA ON MT.BASIC_ID = /*id*/1
                                     AND MT.TASK_ID = TA.ID
         INNER JOIN task_relations TR ON TA.ID   = TR.TASK_ID
                                     AND TR.CLASSIFICATION_ID <> 99
         INNER JOIN users          UU ON TR.PERSON_ID = UU.ID
    ) T ON B.ID=T.BASIC_ID 
WHERE
    B.ID=/*id*/1
ORDER BY
    T.ID