--
--  select activity members by activity id / page.
--
SELECT 
    M.ID
   ,M.ACTIVITY_ID
   ,M.USER_ID
   ,M.ROLE_ID
   ,R.NAME AS ROLE_NAME
   ,M.START_DATE
   ,M.END_DATE
   ,M.DEL_FLAG
   ,M.REGISTERED
   ,M.MODIFIED
   ,M.MODIFIED_USER_ID
   ,U.LAST_NAME
   ,U.FIRST_NAME
   ,U.MIDDLE_NAME
FROM
    activity_members M 
    INNER JOIN users U ON M.USER_ID = U.ID 
    INNER JOIN roles R ON M.ROLE_ID = R.ID
WHERE
    M.ACTIVITY_ID = /*condition.activityId*/1
AND M.DEL_FLAG = '0'
ORDER BY
    M.ROLE_ID
   ,U.LAST_NAME
   ,U.FIRST_NAME
LIMIT  /*condition.limit*/20
OFFSET /*condition.offset*/0