--
-- tugboat.GTD PostgreSQL ver0.8.0 and 0.8.0-1 fix.
--
ALTER TABLE tasks 
  ALTER COLUMN START_DATE
  TYPE CHAR(8);

ALTER TABLE tasks
  ALTER COLUMN DEAD_LINE
  TYPE CHAR(8);

CREATE TABLE feed_tokens (
    ID             serial        NOT NULL
   ,TOKEN          char(20)      NOT NULL
   ,ACTIVITY_ID    integer       NOT NULL
   ,USER_ID        integer       NOT NULL
   ,DEL_FLAG       char(1)       NOT NULL
   ,CREATED_AT     char(14)      NOT NULL
);

ALTER TABLE feed_tokens
  ADD CONSTRAINT feed_tokens_pk
  PRIMARY KEY (ID);

ALTER TABLE feed_tokens 
  ADD FOREIGN KEY (ACTIVITY_ID) 
  REFERENCES activities(ID);
  
ALTER TABLE feed_tokens 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);
  
GRANT ALL ON feed_tokens                   TO tangerine;
GRANT ALL ON SEQUENCE feed_tokens_id_seq   TO tangerine;

COMMENT ON TABLE  feed_tokens              IS 'Feed tokens';
COMMENT ON COLUMN feed_tokens.ID           IS 'Id';
COMMENT ON COLUMN feed_tokens.TOKEN        IS 'Token';
COMMENT ON COLUMN feed_tokens.ACTIVITY_ID  IS 'User id';
COMMENT ON COLUMN feed_tokens.USER_ID      IS 'User id';
COMMENT ON COLUMN feed_tokens.DEL_FLAG     IS 'Role id';
COMMENT ON COLUMN feed_tokens.CREATED_AT   IS 'Created at';
