--
-- tugboat.GTD PostgreSQL ver0.7.3 fix.
--
CREATE TABLE task_mails (
    ID                      serial        NOT NULL
   ,MESSAGE_ID              varchar(256)  NOT NULL
   ,TASK_ID                 integer       NOT NULL
   ,SENT_AT                 char(14)      NOT NULL
   ,SENT_BY                 integer       NOT NULL
);

ALTER TABLE task_mails
  ADD CONSTRAINT task_mails_pk
  PRIMARY KEY (ID);

ALTER TABLE task_mails 
  ADD FOREIGN KEY (TASK_ID) 
  REFERENCES tasks(ID);

ALTER TABLE task_mails 
  ADD FOREIGN KEY (SENT_BY) 
  REFERENCES users(ID);

GRANT ALL ON task_mails                 TO tangerine;
GRANT ALL ON SEQUENCE task_mails_id_seq TO tangerine;

COMMENT ON TABLE  task_mails            IS 'Task mails';
COMMENT ON COLUMN task_mails.ID         IS 'Id';
COMMENT ON COLUMN task_mails.MESSAGE_ID IS 'Message id';
COMMENT ON COLUMN task_mails.TASK_ID    IS 'Task id';
COMMENT ON COLUMN task_mails.SENT_AT    IS 'Sent at';
COMMENT ON COLUMN task_mails.SENT_BY    IS 'Sent by';


CREATE TABLE meeting_mails (
    ID                      serial        NOT NULL
   ,MESSAGE_ID              varchar(256)  NOT NULL
   ,BASIC_ID                integer       NOT NULL
   ,SENT_AT                 char(14)      NOT NULL
   ,SENT_BY                 integer       NOT NULL
);

ALTER TABLE meeting_mails
  ADD CONSTRAINT meeting_mails_pk
  PRIMARY KEY (ID);

ALTER TABLE meeting_mails 
  ADD FOREIGN KEY (BASIC_ID) 
  REFERENCES meeting_basics(ID);

ALTER TABLE meeting_mails 
  ADD FOREIGN KEY (SENT_BY) 
  REFERENCES users(ID);

GRANT ALL ON meeting_mails                 TO tangerine;
GRANT ALL ON SEQUENCE meeting_mails_id_seq TO tangerine;

COMMENT ON TABLE  meeting_mails            IS 'Task mails';
COMMENT ON COLUMN meeting_mails.ID         IS 'Id';
COMMENT ON COLUMN meeting_mails.MESSAGE_ID IS 'Message id';
COMMENT ON COLUMN meeting_mails.BASIC_ID   IS 'Meeting Basic id';
COMMENT ON COLUMN meeting_mails.SENT_AT    IS 'Sent at';
COMMENT ON COLUMN meeting_mails.SENT_BY    IS 'Sent by';

-- tasks table. 
ALTER TABLE tasks DROP COLUMN "share";
ALTER TABLE tasks DROP COLUMN privacy;

-- activities table.
ALTER TABLE activities DROP COLUMN "type";
ALTER TABLE activities ADD COLUMN is_send_mail char(1) NOT NULL DEFAULT '0';

-- tags master. GTD context.
INSERT INTO tags (value) VALUES('@phone');
INSERT INTO tags (value) VALUES('@fax');
INSERT INTO tags (value) VALUES('@web');
INSERT INTO tags (value) VALUES('@home');
INSERT INTO tags (value) VALUES('@office');
INSERT INTO tags (value) VALUES('@starbucks');
INSERT INTO tags (value) VALUES('@blog');
INSERT INTO tags (value) VALUES('@sns');
INSERT INTO tags (value) VALUES('@skype');