--
-- tugboat.GTD PostgreSQL ver0.7.2 fix.
--
UPDATE task_select_views SET selected_tab_id = 0;

-- add user roles.
CREATE TABLE user_roles (
    ID                      serial        NOT NULL
   ,USER_ID                 integer       NOT NULL
   ,ROLE_ID                 integer       NOT NULL
);

ALTER TABLE user_roles
  ADD CONSTRAINT user_roles_pk
  PRIMARY KEY (ID);
  
ALTER TABLE user_roles 
  ADD FOREIGN KEY (USER_ID) 
  REFERENCES users(ID);
  
ALTER TABLE user_roles 
  ADD FOREIGN KEY (ROLE_ID) 
  REFERENCES roles(ID);
  
GRANT ALL ON user_roles                 TO tangerine;
GRANT ALL ON SEQUENCE user_roles_id_seq TO tangerine;

COMMENT ON TABLE  user_roles            IS 'User roles';
COMMENT ON COLUMN user_roles.ID         IS 'Id';
COMMENT ON COLUMN user_roles.USER_ID    IS 'User id';
COMMENT ON COLUMN user_roles.ROLE_ID    IS 'Role id';

INSERT INTO user_roles (
    USER_ID
   ,ROLE_ID
) SELECT id, 2 FROM users;

INSERT INTO users (
    ID
   ,LOGIN_ID
   ,PASSWORD
   ,EMAIL
   ,LAST_NAME
   ,MIDDLE_NAME
   ,FIRST_NAME
   ,PHOTO_IMG_URL
   ,DEL_FLAG
   ,REGISTERED
   ,MODIFIED
   ,MODIFIED_USER_ID
) SELECT 
    max(ID)+1
   ,'admin_user'
   ,'admin_user'
   ,'admin@mail.org'
   ,'admin'
   ,' '
   ,'Administrator'
   ,''
   ,'0'
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,max(ID)+1
FROM users;

INSERT INTO user_roles (
    USER_ID,
    ROLE_ID
) SELECT max(ID),1 FROM users;

INSERT INTO activities (
    ID
   ,NAME
   ,DESCRIPTION
   ,START_DATE
   ,END_DATE
   ,DEL_FLAG
   ,REGISTERED
   ,MODIFIED
   ,MODIFIED_USER_ID
) SELECT
    max(A.ID)+1
   ,'Test Project'
   ,'Description'
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDD')
   ,'99999999'
   ,'0'
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,max(U.ID)
FROM users U, activities A;

insert into activity_members (
    ACTIVITY_ID
   ,USER_ID 
   ,ROLE_ID
   ,START_DATE
   ,REGISTERED
   ,MODIFIED 
   ,MODIFIED_USER_ID
) SELECT
    max(A.ID)
   ,max(U.ID)
   ,1
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDD')
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,to_char(CURRENT_TIMESTAMP,'YYYYMMDDHH24MISS')
   ,max(U.ID)
FROM users U, activities A;

INSERT INTO activity_relations (
    ACTIVITY_ID
   ,COLOR_ID 
   ,USER_ID
) SELECT
    max(A.ID)
   ,1
   ,max(U.ID)
FROM users U, activities A;